/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2009- Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ppe_memmap.h
*
*   This file contains PPE register memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _PPE_MEMMAP_H
#define _PPE_MEMMAP_H

//==============================================================================
// PPE Register Memory Map
//==============================================================================
#define DREG_BASE (0x30D400)

//Register Addresses
#define DREG_AT_CFG0_ADDR           (0x080 + DREG_BASE)
#define DREG_AT_CFG1_ADDR           (0x084 + DREG_BASE)
#define DREG_AT_CELL0_ADDR          (0x090 + DREG_BASE)
#define DREG_AT_CELL1_ADDR          (0x094 + DREG_BASE)
#define DREG_AT_IDLE_CNT0_ADDR      (0x098 + DREG_BASE)
#define DREG_AT_IDLE_CNT1_ADDR      (0x09C + DREG_BASE)
#define DREG_AT_IDLE0_ADDR          (0x0A0 + DREG_BASE)
#define DREG_AT_IDLE1_ADDR          (0x0A4 + DREG_BASE)

#define DREG_AR_CFG0_ADDR           (0x180 + DREG_BASE)
#define DREG_AR_CFG1_ADDR           (0x184 + DREG_BASE)
#define DREG_AR_STAT0_ADDR          (0x198 + DREG_BASE)
#define DREG_AR_STAT1_ADDR          (0x19C + DREG_BASE)
#define DREG_AR_CELL0_ADDR          (0x1A0 + DREG_BASE)
#define DREG_AR_CELL1_ADDR          (0x1A4 + DREG_BASE)
#define DREG_AR_IDLE_CNT0_ADDR      (0x1A8 + DREG_BASE)
#define DREG_AR_IDLE_CNT1_ADDR      (0x1AC + DREG_BASE)
#define DREG_AR_AIIDLE_CNT0_ADDR    (0x1B0 + DREG_BASE)
#define DREG_AR_AIIDLE_CNT1_ADDR    (0x1B4 + DREG_BASE)
#define DREG_AR_BE_CNT0_ADDR        (0x1B8 + DREG_BASE)
#define DREG_AR_BE_CNT1_ADDR        (0x1BC + DREG_BASE)
#define DREG_AR_HEC_CNT0_ADDR       (0x1C0 + DREG_BASE)
#define DREG_AR_HEC_CNT1_ADDR       (0x1C4 + DREG_BASE)
#define DREG_AR_CD_CNT0_ADDR        (0x1C8 + DREG_BASE)
#define DREG_AR_CD_CNT1_ADDR        (0x1CC + DREG_BASE)
#define DREG_AR_IDLE0_ADDR          (0x1D0 + DREG_BASE)
#define DREG_AR_IDLE1_ADDR          (0x1D4 + DREG_BASE)
#define DREG_AR_DELIN0_ADDR         (0x1D8 + DREG_BASE)
#define DREG_AR_DELIN1_ADDR         (0x1DC + DREG_BASE)
#define DREG_AR_OVDROP_CNT0_ADDR    (0x260 + DREG_BASE)
#define DREG_AR_OVDROP_CNT1_ADDR    (0x264 + DREG_BASE)
#define DREG_AR_CERRN_CNT0_ADDR     (0x280 + DREG_BASE)
#define DREG_AR_CERRN_CNT1_ADDR     (0x284 + DREG_BASE)
#define DREG_AR_CERRNP_CNT0_ADDR    (0x288 + DREG_BASE)
#define DREG_AR_CERRNP_CNT1_ADDR    (0x28C + DREG_BASE)
#define DREG_AR_CVN_CNT0_ADDR       (0x290 + DREG_BASE)
#define DREG_AR_CVN_CNT1_ADDR       (0x294 + DREG_BASE)
#define DREG_AR_CVNP_CNT0_ADDR      (0x298 + DREG_BASE)
#define DREG_AR_CVNP_CNT1_ADDR      (0x29C + DREG_BASE)

#define DREG_B0_LADR_ADDR           (0x2A0 + DREG_BASE)
#define DREG_B1_LADR_ADDR           (0x2A4 + DREG_BASE)

//       DREG Register              Address from ARC          Address from PPE
#define DREG_MISCRAM0_ADDR          (0x300 + DREG_BASE)          // (0x7DC0)
#define DREG_MISCRAM1_ADDR          (0x304 + DREG_BASE)          // (0x7DC1)
#define DREG_MISCRAM2_ADDR          (0x308 + DREG_BASE)          // (0x7DC2)
#define DREG_MISCRAM3_ADDR          (0x30C + DREG_BASE)          // (0x7DC3)
#define DREG_MISCRAM4_ADDR          (0x310 + DREG_BASE)          // (0x7DC4)
#define DREG_MISCRAM5_ADDR          (0x314 + DREG_BASE)          // (0x7DC5)
#define DREG_MISCRAM6_ADDR          (0x318 + DREG_BASE)          // (0x7DC6)
#define DREG_MISCRAM7_ADDR          (0x31C + DREG_BASE)          // (0x7DC7)
#define DREG_MISCRAM8_ADDR          (0x320 + DREG_BASE)          // (0x7DC8)
#define DREG_MISCRAM9_ADDR          (0x324 + DREG_BASE)          // (0x7DC9)
#define DREG_MISCRAM10_ADDR         (0x328 + DREG_BASE)          // (0x7DCA)
#define DREG_MISCRAM11_ADDR         (0x32C + DREG_BASE)          // (0x7DCB)
#define DREG_MISCRAM12_ADDR         (0x330 + DREG_BASE)          // (0x7DCC)
#define DREG_MISCRAM13_ADDR         (0x334 + DREG_BASE)          // (0x7DCD)
#define DREG_MISCRAM14_ADDR         (0x338 + DREG_BASE)          // (0x7DCE)
#define DREG_MISCRAM15_ADDR         (0x33C + DREG_BASE)          // (0x7DCF)
#define DREG_MISCRAM16_ADDR         (0x340 + DREG_BASE)
#define DREG_MISCRAM17_ADDR         (0x344 + DREG_BASE)
#define DREG_MISCRAM18_ADDR         (0x348 + DREG_BASE)
#define DREG_MISCRAM19_ADDR         (0x34C + DREG_BASE)
#define DREG_MISCRAM20_ADDR         (0x350 + DREG_BASE)
#define DREG_MISCRAM21_ADDR         (0x354 + DREG_BASE)
#define DREG_MISCRAM22_ADDR         (0x358 + DREG_BASE)
#define DREG_MISCRAM23_ADDR         (0x35C + DREG_BASE)
#define DREG_MISCRAM24_ADDR         (0x360 + DREG_BASE)
#define DREG_MISCRAM25_ADDR         (0x364 + DREG_BASE)
#define DREG_MISCRAM26_ADDR         (0x368 + DREG_BASE)
#define DREG_MISCRAM27_ADDR         (0x36C + DREG_BASE)
#define DREG_MISCRAM28_ADDR         (0x370 + DREG_BASE)
#define DREG_MISCRAM29_ADDR         (0x374 + DREG_BASE)
#define DREG_MISCRAM30_ADDR         (0x378 + DREG_BASE)
#define DREG_MISCRAM31_ADDR         (0x37C + DREG_BASE)

#define DREG_MB0_P2D_ISRS_ADDR      (0x380 + DREG_BASE)
#define DREG_MB0_P2D_ISRC_ADDR      (0x384 + DREG_BASE)
#define DREG_MB0_P2D_ISR_ADDR       (0x388 + DREG_BASE)
#define DREG_MB0_P2D_IER_ADDR       (0x38C + DREG_BASE)
#define DREG_MB2_D2P_ISRS_ADDR      (0x390 + DREG_BASE)
#define DREG_MB2_D2P_ISRC_ADDR      (0x394 + DREG_BASE)
#define DREG_MB2_D2P_ISR_ADDR       (0x398 + DREG_BASE)
#define DREG_MB2_D2P_IER_ADDR       (0x39C + DREG_BASE)
#define DREG_BIN_SEM0_ADDR          (0x3A0 + DREG_BASE)
#define DREG_MB1_P2D_ISRS_ADDR      (0x3C0 + DREG_BASE)
#define DREG_MB1_P2D_ISRC_ADDR      (0x3C4 + DREG_BASE)
#define DREG_MB1_P2D_ISR_ADDR       (0x3C8 + DREG_BASE)
#define DREG_MB1_P2D_IER_ADDR       (0x3CC + DREG_BASE)
#define DREG_MB3_D2P_ISRS_ADDR      (0x3D0 + DREG_BASE)
#define DREG_MB3_D2P_ISRC_ADDR      (0x3D4 + DREG_BASE)
#define DREG_MB3_D2P_ISR_ADDR       (0x3D8 + DREG_BASE)
#define DREG_MB3_D2P_IER_ADDR       (0x3DC + DREG_BASE)
#define DREG_BIN_SEM1_ADDR          (0x3E0 + DREG_BASE)

void ConfigurePPETxPath(void);
void ConfigurePPERxPath(void);


#endif //#ifndef _PPE_MEMMAP_H
