/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: show_iof.h
*
*   Header file for show_iof.c
*
*-------------------------------------------------------------------------------
*/

#ifndef _SHOW_IOF_H
#define _SHOW_IOF_H

// Prototype functions
void StartTxDataPath(void);
void StartRxDataPath(void);

void ReadCRCErrors(int16 s_lp);
void ReadRSCorrections(int16 s_lp);

#ifdef CHECK_ILV_MEM_ERROR
   void CheckIlvMemErr(void);
#endif //CHECK_ILV_MEM_ERROR

void GetTxATMCellCnts(int16 s_abc);
void GetRxATMCellCnts(int16 s_lp, int16 s_abc);


void TxSuperFrameProcess(void);
void TxSuperFrameTaskPerPath(int16 s_lp);
void RxSuperFrameProcess(void);
void RxSuperFrameTaskPerPath(int16 s_lp);

void ReadRxFftOutput(void);
void ReadRxErrOutput(void);
void EnableTxResetPRBS(void);
void EnableRxResetPRBS(void);
void DisableRxPRBS(void);

// ddsnrfdq_io.c
void SetUpRTVForDDSnrFdqHandler(void);
void DisbleRxDescrambling(void);


void EnableFDQAdapt(void);
void DisableFDQAdapt(void);

// VDSL2 bitswap
void SwitchRxTableForBitswap(void);
void SwitchTxTableForBitswap(void);
void CopyRxBGT_ActiveToInactive(void);
void CopyTxBGT_ActiveToInactive(void);


// Synch frame processing
void SetUpRTVForRxSynchFrame(void);
void EnablePRBSForRxSynchFrame(void);
void ReadRxSynchFrame(void);
void EnableTxPmsProcessing(void);
void DisableTxPmsProcessing(void);
void Enable_TxPI_Latch(void);
void Disable_TxPI_Latch(void);

//#ifdef MTK_VECTORING_SUPPORT
void InitReverbPRBS(void);
void SetupRTV0ForRxSyncFrameVectoring(void);
void SetupRTV0ForRxNonSyncFrameVectoring(void);
void SetupCGforDataSymbol(void);
void SetupCGforSyncSymbol(void);
//#endif

void NoInvertPRBS(void);
void InvertPRBS(void);
void EnableTxShowGenRef(void);
void EnableTxDataMode(void);
void EnableRxGCDX(void);
void DisableRxGCDX(void);
void Enable_RxPI_Latch(void);
void ComputeTxTransferSize(void);
void DetectInvertedSynch(void);
void SavePRBSRegisters(void);
void RestorePRBSRegisters(void);
void EnableRxFcCascadeStart(void);
void DisableRxFcCascadeStart(void);
void EnableTxFcTimerStart(void);
void EnableTxXtc(void);
void EnableRxXtc(void);

void Update_TimeStamp_Register(void);

void Showtime_ERB_FCS32_Config(void);
void Disable_Showtime_ERB_FCS32_Config(void);

#ifdef TX_CRC_SCRAMBLE_DISABLE
int ComputeAZRunCount(void);
void RunAZ(void);
#endif

#ifdef RX_CRC_SCRAMBLE_DISABLE
void disable_crc_unscramble(uint32 ul_crc_location_addr);
void config_dt_size(void);
uint8 descrambleByte(uint8 uc_Byte);
void RxCrcScambleDisable_RXTC_QT_helper(void);
void RxCrcScambleDisable_RXTC_FC_helper(void);
#endif

#ifdef DEBUG_SHOWTIME
void LogTxBufAtTxQtTc(void);
void LogRxBufAtRxFcTc(void);
#endif

#ifdef QT_LATCH_LP_BITS
void EnableTxQtLpBitsLatch(void);
void DisableTxQtLpBitsLatch(void);
#endif

//Zephyr debug code
#ifdef ZEP_DEBUG_BLD
   void EnableTxFifo3Capture(void);
   void DisableTxFifo3Capture(void);
   void UpdateTxFifo3Stat(void);
   void EnableRxFifo3Capture(void);
   void DisableRxFifo3Capture(void);
   void UpdateRxFifo3Stat(void);
   void ReadFifo3Data(FlagT gft_TxRxFlag, int16 s_NumBytes, uint8 *puc_buf);
#endif //#ifdef ZEP_DEBUG_BLD

   void ReadMetricValue(void);
// Macros

#define TX_SEQP_DONE0_BIT  (0x0001)
#define TX_SEQP_DONE1_BIT  (0x0001)
#define RX_SEQP_DONE0_BIT  (0x0001)
#define RX_SEQP_DONE1_BIT  (0x0001)
#define TX_BAD_CRC_BIT     (0x0001)

#ifdef ZEP_DEBUG_BLD
   #define FIFO3_CAPTURE_DISABLE (0)
   #define FIFO3_CAPTURE_ENABLE  (1)
   #define FIFO3_CAPTURE_GETDATA (2)
   #define FIFO3_CAPTURE_ERROR      (3)
#endif //#ifdef ZEP_DEBUG_BLD


#endif // _SHOW_IOF_H
