/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_MEMMAP_CNFG_H
#define _ZEP_MEMMAP_CNFG_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_memmap_cnfg.h
 * DESCRIPTION:      Memory map definition
 *
 **********************************************************************/
// zep_memmap_cnfg.h
//
// History
//
// 19/07/2013 Kannan: Changes to set the Tx Data pump setup
//          Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//
// 18/10/2013 Palaksha: Added fix for Data memory corruption when both US/DS ReTx are enabled. The issue is
//                seen at short loops where DS/US rate are higher and memory reqt for US and DS Retx buffer is more
//                The fix includes considering only available memory (After allocating for US ReTx buffer)
//                while deciding DS ReTx QTX value
//            Grep for XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate
//
// 20/06/2014 Ram: Memory allocated to DS Lp0 block of DTB is 4000 bytes (DS ReTx mode) which
//                 can support 128 Mbps of line data rate. Since we don't expect overhead data rate
//                 (Lp0 in ReTx mode carries only overhead data) to reach such high rates, reducing
//                 the size of Lp0 block and increasing Lp1 block accordingly (to achieve higher NDR/ETR)
//                 Grep for XDSLRTFW-1829
//30/06/2014 Varun : Added new DTB settings for US ReTx only feature
//                   Observed link drop due to less allocation of memory for LP0 in DTB in US ReTx only mode.
//                   In US ReTx only mode, DS ==> 1 Latency path,LP0(overhead+data) and RRC received at LP2(chosen)
//                   US ==> 2 Latency path,LP0(overhead)+LP1(Data)
//                   Grep for XDSLRTFW-1881
// 18/09/2014  Palaksha:
//      The FW changes for "XDSLRTFW-1707 Bringup of DS/US Retransmission on 30a profile"
//      In general The changes involve
//      - Memory optimization (Need more memory to support 200Mbps DSNDR /100Mbps USNDR)
//            VRx318 platform : 86K + 12K+ 17K = 115K IlvDilv Memory
//               Moved ThreeGLP_Interface.c(used all the time) from CACHE_INIT_1PORT to ONE_PORT_MAIN_ISWAP
//               Also moved below files(used all the time) from CACHE_TRN_1PORT to ONE_PORT_MAIN_ISWAP
//                  main_hw.o(.text) snr_b.o(.text)    CalcShowtimeSnrMargin.o(.text)   QuickAverage.o(.text)
//                  CACHE_TRN_1PORT contains files which are used only till training ==> this place can be used in showtime as a overlay
//               This got around 12K+17K for ReTx buffer usage
//            VR9    platform : 86K           = 86K IlvDilv Memory
//            So only VRx318 platform can support 200Mpbs DSNDR + Additional 18K buffer 3-needle noise handling
//                     Vector friendly FW binary      Full Vector  FW binary
//                        -----------------         ---------------------
//                           VRx318   VR9              VRx318    VR9
//      Memory Section Name
//      Size in Bytes
//      ST_VECTORING_BUFFER   12800   12800            0         0
//      ONE_PORT_ILV_DILV_HW  88064   88064            88064     88064
//      CACHE_INIT_1PORT      12544   0                12544     0
//      CACHE_TRN_1PORT       22064   0                22064     0
//      Total Memory in Bytes 135472  100864           122672    88064
//      Total Memory in KB    132.30  98.50            119.80    86.00
//      on VRX 318, disabled DEBUG buffer functionality to get around 4k of data memory in addition to above
//      - Indicate Max delay Octet = 121K*2 for Vrx318 and 86K*2 for VR9 ("Field 10 : Octet 11-12-13 of  G.INP R-MSG2  message)
//      - ARC Mips optimization/HW Accelerator time change
//         Since in 30a profile frame rate is 8KHz and it has only 2 Time slots(32768 ARC cycles will be available),
//         less cycles for ARC/HW accelerators  available in a symbol period.
//         Changed Start time of  Tx FC,Tx QTP, Tx QT and Rx FC and these changes are under bit#6 of test 28 0 CMV and enabled by default
//      - rearranged some functions related to RTXus so that forward DTU function execute early in RXTC
//      - Restricted rate of transfer size to 3438 bytes instead of 4160 bytes on PPE-DSL interface to reduce PPE buffer overflow.TEST_Control3_Test28_Bit7Mask
//      -  RMSG2_UsNetDataRateMax = 100 mbps
//      - RTXds Framing modifications for 30 Mhz profile
//         So far framing generation tested only for up to 17a profile. For 30a there are additional framing combinations available
//         Need to evaluation these framing for 30a RTXds mode for HW accelerator time constraint(only 32768 cycles in a symbol).
//         More codewords in a symbol will result in more time to complete.
//         Restricting framing combinations(HQV) to have maximum of 7 CWs (HQV index from 15 to 25 are only selected)
//         Also overflow handling in fixed point implementation code in RTX framing generation is done
//      - RTXds parameter handling in 30Mhz profile
//         Roundtrip delay in symbols is double due to higher frame and Roundtrip delay in DTUs is to be taken as is(No doubling)
//      - Change the value "RX_LP_ORDER (Order of processing of Rx latency paths) field in IR_MISC register"
//         from 4 (Lp2 Lp1 Lp0) to 2(Lp0 Lp1 Lp2). With RX_LP_ORDER=4(Lp2 Lp1 Lp0), if the 1st bin in ToT is >8 bits, then even
//         if Lp2 is allocated 0 bits, but HW considers it as active LP and throws up HW Rx BAT error in CRI register.This is because
//         hardware supports encoding of two latency paths on the same tone. As of now RX_LP_ORDER=2(Lp0 Lp1 Lp2) is being used as an
//         interm solution DS RTX is enabled in 30a profile. If US RTX in 30a to be supported then RX_LP_ORDER=4(Lp2 Lp1 Lp0) setting is needed.
//         In that case we need to have the special handling of 1st tone in ToT. The same problem can also happen on tx path(TX_LP_ORDER) as well.
//         we decided not do change anything we shall use default (Lp2 Lp1 Lp0) ordering. So as a working around testing 30a RTX (us, ds or both)
//         we shall use  OH rate of minimum of 128 kbps (this ensures minimum 16 bits per symbol)
//
//   grep for XDSLRTFW-1707_30a_RTX_DsUs
//
// 29/10/2014 Anantha Ramu: Increased memory for microcode to accommodate for Intra DTU interleaver modifications.
//                          Grep for "XDSLRTFW-1617"
// ************************************************************************************************************
#include "zep_memmap.h"

//defined in zep_memmap.h
//*************************************************************
//#define ZEP_REG_TX_BASE_GLOBAL       (uint32)(0x20D800)
//#define ZEP_REG_RX_BASE_GLOBAL       (uint32)(0x20DC00)

//#define ZEP_RAM_RX_CW_ADDR           (uint32)(0x20C000)
//#define ZEP_RAM_RX_CW_SIZE              (2*512)

//#define ZEP_RAM_IIBRAM_ADDR          (uint32)(0x40000)
//#define ZEP_RAM_IIBRAM_SIZE          (2*84*1024)

// Data Transfer Buffer
//#define ZEP_ILV_RAM_DTB_ADDR         (uint32)(0x254000)   //Tx/Rx Data Transfer Buffer
//#define ZEP_ILV_RAM_DTB_SIZE         (4*2816)

////////////////////////////////////
//#define ZEP_ILV_RAM_DMET_ADDR        (uint32)(0x257000) // RX Deinterleave Metric RAM (byte access)
//#define ZEP_ILV_RAM_DMET_SIZE        (4*512)

//**************************************************************/

// ===== Define three sections of memory blocks that reside in IIBRAM =================
// ===== 1) PRAM registers, 2) Interleaver memory, 3)  MicroCode =====================

#define OHFIFO_SIZE        (32)     //size of each OH fifo in bytes
#define LP_MICROCODE_WORDS (70)     //maximum size of each micro-code block per latency path (for one direction) in 32-bit words
//XDSLRTFW-1830 (START_END)

//XDSLRTFW-1617 (Start_End)
//#define LP_MICROCODE_WORDS_LP1 (94)  //maximum size of micro-code block for latency path 1 (for one direction) in 32-bit words
#define LP_MICROCODE_WORDS_LP1   (145)

//Define the size of each memory block in bytes
//Note the total memmory available for the following four blocks should be (172032-32768-2096-8192) = 128976 bytes
#define ZEP_PRAM_BLOCK_SIZE         ((ZEP_REG_TX_PRAM_SIZE+ZEP_REG_RX_PRAM_SIZE+4)*2*4)      //=(260+4)*2*4 = 2112
                                             //note: +4 for extra gap, *2 for 2 LPs, *4 for words to byte conversion
#define ZEP_OHFIFO_BLOCK_SIZE    (OHFIFO_SIZE*16)     //=(16*32)=512, total of 16 fifos and each allocated 32 bytes
#define ZR_ILVB_RDPTR_TABLE_SIZE    16

// the following is for comments only - not used by the FW
//#define ZEP_MICRO_CODE_BLOCK_SIZE (LP_MICROCODE_WORDS*4*4) //=(70*4*4)=1120, 2 TX LPs, 2 RX LPs, the final *4 is for word to byte conversion
// with ReTX ucode, this has been changed to
//#define ZEP_MICRO_CODE_BLOCK_SIZE (LP_MICROCODE_WORDS*3*4 + 85) //=(70*4*4)=1120, 2 TX LPs, 2 RX LPs, the final *4 is for word to byte conversion
// XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (Start)
//XDSLRTFW-1707_30a_RTX_DsUs (Start)
#define  ST_VECTORING_BUFFER_SIZE_12800   (12800)  //Used
//Earlier ST_VECTORING_BUFFER    @0x48884 and TWO PORT SHOW ONLY  ADDR=0x4BA84
//Now    ST_VECTORING_BUFFER  @0x49B00 and TWO PORT SHOW ONLY  ADDR=0x49B00 Now ILV Buffer start Addr=0x49B00 instead of 0x4CD00

//#ifdef VECTORING_BUILD //DebugBufferTrace
   #define ZEP_ILV_DILV_BLOCK_SIZE     ((int32)__gla_NoiseMarginSepBufferStart - (int32)__gla_HwIlvDilvStart)
   #define ZEP_ILV_DILV_BLOCK_SIZE_30A    ((int32)__gla_DebugTracesBufferStart    - (int32)__gla_HwIlvDilvStart)

   #define ZEP_ILV_DILV_BLOCK_SIZE_30A_NODEBUGTRACE   ((int32)__gla_OnePortShowDataStart - (int32)__gla_HwIlvDilvStart)   // XDSLRTFW-2368
//#else
// #define ZEP_ILV_DILV_BLOCK_SIZE     ((int32)__gla_NoiseMarginSepBufferStart - (int32)__gla_ShowTimeVectoringBuffer -16)
// #define ZEP_ILV_DILV_BLOCK_SIZE_30A    ((int32)__gla_DebugTracesBufferStart    - (int32)__gla_ShowTimeVectoringBuffer -16)
// #define ZEP_ILV_DILV_BLOCK_SIZE_30A_NODEBUGTRACE      ((int32)__gla_OnePortShowDataStart - (int32)__gla_ShowTimeVectoringBuffer -16)    // XDSLRTFW-2368

//#endif
//XDSLRTFW-1707_30a_RTX_DsUs (End)

//XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10% (START_END)
//Minimum US RETX Queue memory size is reserved to 23K, 23K of memory can support upto 48Mbps.
//if more memory is required actual will be allocated. This reservation is done to
// take care of doing upshift when US ReTx + SRA is enabled.
#define ZEP_ILV_US_RETX_LP1_BLOCK_SIZE   (23*1024)  //Max memory is required to support US ReTX + SRA

//1K memory for LP1 path processing. Note that D=1 for LP1 path
//hence, with max codeword size of 255, the max memory used can be 2.5*255 ~= 638 bytes
#define DS_RETX_LP1_PROCESSING                (1024)

//XDSLRTFW-1353: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode_With_HigherNDR (Start_End)
//XDSLRTFW-1571 (Start_End)
#define DSRETX_MIN_DTUs_REQOVERQTX     (4)   //Additional DTUs required for Qrx on top of Qtx size

//XDSLRTFW-2590 (Start)
#define MAX_DTU_SIZE_US_PROFILE_8      (512)
#define MAX_DTU_SIZE_US_PROFILE_12     (1536)
#define MAX_DTU_SIZE_US_PROFILE_17     (1536)
#define MAX_DTU_SIZE_US_PROFILE_30     (3072)
#define MAX_DTU_SIZE_US_PROFILE_35     (3072)

#define MAX_DTU_SIZE_DS_PROFILE_8      (2048)
#define MAX_DTU_SIZE_DS_PROFILE_12     (2048)
#define MAX_DTU_SIZE_DS_PROFILE_17     (3072)
#define MAX_DTU_SIZE_DS_PROFILE_30     (3072)
#define MAX_DTU_SIZE_DS_PROFILE_35     (4096)

#define MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX_8x    (MAX_DTU_SIZE_DS_PROFILE_8*DSRETX_MIN_DTUs_REQOVERQTX)
#define MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX_12x   (MAX_DTU_SIZE_DS_PROFILE_12*DSRETX_MIN_DTUs_REQOVERQTX)
//XDSLRTFW-2590 (End)
// XDSLRTFW-1363 DSReTx_DS_Rate_Degration_by_10% (START_END)
//XDSLRTFW-1417 (Start_End)
//XDSLRTFW-1571 (Start_End)
//XDSLRTFW-3189 (Start)
#define MAX_R_WITH_DS_IDTU             (16)
#define MAX_US_VALID_H_WITH_IDTU       (47)
#define MAX_US_VALID_Q_WITH_IDTU       (32)
#define MAX_US_VALID_R_WITH_IDTU       (16)
#define MAX_DTU_SIZE_US_PROFILE_8_12_17_WITH_IDTU    (MAX_US_VALID_Q_WITH_IDTU*(MAX_US_VALID_H_WITH_IDTU + MAX_US_VALID_R_WITH_IDTU))  //US PING/PONG buffer Q * N
//Estimated required max US DTU size for 35B mode
#define MAX_DTU_SIZE_US_PROFILE_35B_WITH_IDTU        (MAX_DTU_SIZE_US_PROFILE_8_12_17_WITH_IDTU)


#define MAX_HQV_IDX_DS_PROFILE_8_12_17_WITHOUT_IDTU     (47)
//XDSLRTFW-3590 (Start)
//Max HQV index was set to 29 to use R as 16 for profiles <= 17a
//with HQV index 29, Max DS rate is limited to 120Mbps.
//To reach 150Mbps in DS, value of R is reduced from 16 to 8
//to reduce Zephyr MIPS and HQV table index is increased to 37
//Performed Loop Reach and SRA test, Not seeing any link drop.
#define MAX_HQV_IDX_DS_PROFILE_8_12_17_WITH_IDTU        (37)  //29 if R==16 and 37 if R == 8
//XDSLRTFW-3590 (End)
#define MAX_HQV_IDX_DS_PROFILE_30a_WITHOUT_IDTU         (26)  //Intra DTU interleaving is not supported for 30a
#define MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU            (44)  //XDSLRTFW-3322
#define MAX_HQV_IDX_DS_PROFILE_35b_WITHOUT_IDTU         (60)  //XDSLRTFW-3322
//XDSLRTFW-3189 (End)

//XDSLRTFW-3493 (Start)
#define MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R16        (44)
#define MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R14        (45)
#define MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R12        (46)
#define MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R10        (47)
#define MAX_HQV_IDX_DS_PROFILE_35b_WITH_IDTU_R08        (52)
//XDSLRTFW-3493 (End)

#define MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX       (MAX_DTU_SIZE_DS_PROFILE_17*DSRETX_MIN_DTUs_REQOVERQTX) //Max 18K mem can be reserved, to meet Amnd-2 requirements
// XDSLRTFW-2757 (Start_End)
#define MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX_35B   (MAX_DTU_SIZE_DS_PROFILE_35*DSRETX_MIN_DTUs_REQOVERQTX)
//SN  H  Q  V  "DTU Size((Q+H)+V+2)"
// 25 233   7  4  1637
// 26 242   7  2  1698 Max DTU size
////XDSLRTFW-1707_30a_RTX_DsUs (Start_End)
#define MEM_SIZE_DSRETX_MIN_DTUs_REQOVERQTX_30A   (1700*DSRETX_MIN_DTUs_REQOVERQTX) //Max size of 6 DTUs as buffer

//Available ILV/DILV memory which can be send
// 70K Memory is required to support 150 Mbps NDR,
// assuming CPE HRT (Rx) s_CPE = 6, d_CPE = 0; (Tx) s_CPE = 5, d_CPE = 0
// assuming CO HRT (Rx) s_CO = 7, d_CO = 0; (Tx) s_CO = 7, d_CO = 0
//In R-MSG2 as a part of Amend2 (US & DS) = 70K
//Note 1: CPE can indicate available ILV/DILV memory in R-MSG2 as  = 70*1024*2 = 143360

//XDSLRTFW-3189 (Start)
#define ILV_DILV_MEM_INDICATION_IN_R_MSG2 (ZEP_ILV_DILV_BLOCK_SIZE - DS_RETX_LP1_PROCESSING)
#define ILV_DILV_MEM_INDICATION_IN_R_MSG2_30A (ZEP_ILV_DILV_BLOCK_SIZE_30A - DS_RETX_LP1_PROCESSING)
#define ILV_DILV_MEM_INDICATION_IN_R_MSG2_30A_NODEBUGTRACE  (ZEP_ILV_DILV_BLOCK_SIZE_30A_NODEBUGTRACE - DS_RETX_LP1_PROCESSING) //XDSLRTFW-2368
#define ILV_DILV_MEM_INDICATION_IN_R_MSG2_35B (ZEP_ILV_DILV_BLOCK_SIZE - DS_RETX_LP1_PROCESSING)  //XDSLRFW-3322
//XDSLRTFW-3189 (End)

// XDSLRTFW-1329 BugFix_USDS_VDSL2_ALL_UsDsReTxMemCorruptHighDsUsRate (End)

//XDSLRTFW-3493 (Start)
#define BYTES_FOR_SID_TS_DTU_STATUS  (4)  //SID <7:0>, TS <15:8>, DTU_STATUS <23:16>  & DUMMY BYTE <31:24>
//XDSLRTFW-3493 (End)

//The following addresses are absolute values in bytes
   extern int32 __gla_ZepPramStart[];
   extern int32 __gla_ZepOvhdFifoStart[];
   extern int32 __gla_ZrIlvbRdPtrTable[];
   //XDSLRTFW-1571 (Start_End)
   extern uint32 __gula_ZrIlvbWrPtrTable[];
   extern int32 __gla_TwoPortShowDataStart[];
   extern int32 __gla_OnePortShowDataStart[];
   extern int32 __gla_ZepTxRxUcodeStart[];
   extern int32 __gla_NoiseMarginSepBufferStart[];
   extern int32 __gla_DebugTracesBufferStart[];
   extern int32 __gla_HwIlvDilvStart[];
   extern int32 __gla_ShowTimeVectoringBuffer[];

//All the following three addresses are the offset from the beginning of IIBRAM in bytes
#define ZEP_PRAM_BASE            ((int32)__gla_ZepPramStart - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_RAM_OHFIFO_BASE         ((int32)__gla_ZepOvhdFifoStart  - ZEP_RAM_IIBRAM_ADDR)
//XDSLRTFW-1707_30a_RTX_DsUs (Start)
//#define ZEP_RAM_ILV_DLIV_BASE     ((int32)__gla_HwIlvDilvStart  - ZEP_RAM_IIBRAM_ADDR)
//Now    ST_VECTORING_BUFFER  @0x49B00 and TWO PORT SHOW ONLY  ADDR=0x49B00 Now ILV Buffer start Addr=0x49B00 instead of 0x4CD00
//Start of ILV_DILV buffer is from ShowTimeVectoringBuffer
//#ifdef VECTORING_BUILD
   #define ZEP_RAM_ILV_DLIV_BASE    ((int32)__gla_HwIlvDilvStart  - ZEP_RAM_IIBRAM_ADDR)
   #define SHOWTIME_VECTOR_BUFFER_SIZE    (0)
//#else
// #define ZEP_RAM_ILV_DLIV_BASE    ((int32)__gla_ShowTimeVectoringBuffer - ZEP_RAM_IIBRAM_ADDR)

// #define SHOWTIME_VECTOR_BUFFER_SIZE    ((int32)__gla_HwIlvDilvStart - (int32)__gla_ShowTimeVectoringBuffer )
//#endif
//XDSLRTFW-1707_30a_RTX_DsUs (End)
#define ZEP_RAM_TX_RX_UCODE_BASE ((int32)__gla_ZepTxRxUcodeStart  - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_TWO_PORT_SHOW_DATA_BASE ((int32)__gla_TwoPortShowDataStart  - ZEP_RAM_IIBRAM_ADDR)
#define ZEP_ONE_PORT_SHOW_DATA_BASE ((int32)__gla_OnePortShowDataStart  - ZEP_RAM_IIBRAM_ADDR)

    //ILVB Read Pointer Table
    #define DTU_POINTERS_BASE_ADDR     ((int32)__gla_ZrIlvbRdPtrTable - ZEP_RAM_IIBRAM_ADDR)
    #define DTU_POINTERS_LW_BASE_ADDR  (DTU_POINTERS_BASE_ADDR >> 2)
    //Total 32 bytes allocated(Section: ZR_ILVB_RDPTR_TABLE), hence max 8 pointers/address are allowed
    //#define ILVB_RDPTR_TABLE_SIZE_LW      (8)
    #define ILVB_RDPTR_TABLE_SIZE_LW      (3)  //Restrict "Max Num DTUs to PPE" to 3, as ADMA max depth is 3
    //XDSLRTFW-1571 (Start)
    //ILVB Write Pointer Table
    #define DTU_WR_POINTERS_BASE_ADDR     ((int32)__gla_ZrIlvbWrPtrTable - ZEP_RAM_IIBRAM_ADDR)
    #define DTU_WR_POINTERS_LW_BASE_ADDR  (DTU_WR_POINTERS_BASE_ADDR >> 2)
    //Allocated 3 words (32 bits each)for WRPTR table
    //#define ILVB_WRPTR_TABLE_SIZE_LW      ((__gla_ZepTxRxUcodeStart - __gla_ZrIlvbWrPtrTable) >> 2)
    //Total 32 bytes allocated (Section: ZR_ILVB_WRPTR_TABLE), hence max 8 pointers/address are allowed
    #define ILVB_WRPTR_TABLE_SIZE_LW      (4)
    //XDSLRTFW-1571 (End)

//========= Configure DTB memory addresses (in 32-bit words) ==================================

#define ZEP_DTB_SIZE_WDS            (ZEP_ILV_RAM_DTB_SIZE/4)


      #define RETX_ZEP_DTB_SIZE_TX_WDS          (704)//TX DTB buffer size in 32-bit words
      #define RETX_ZEP_DTB_SIZE_RX_WDS          (ZEP_DTB_SIZE_WDS - RETX_ZEP_DTB_SIZE_TX_WDS)   //RX DTB buffer size in 32-bit words (2816-704=2112)

      #define RETX_ZEP_ILV_RAM_TXDTB_OFFSET     (uint32)(0)                //in 32-bit words
      #define RETX_ZEP_ILV_RAM_RXDTB_OFFSET     (uint32)(RETX_ZEP_ILV_RAM_TXDTB_OFFSET + RETX_ZEP_DTB_SIZE_TX_WDS)   //in 32-bit words

      #define RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE      (700)    //max US line data rate = 700*32*4000 = 89.6 Mbps
      #define RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE      (1)
      #define RETX_ZEP_ILV_RAM_TXDTB_LP1_SIZE      (RETX_ZEP_DTB_SIZE_TX_WDS - RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE - RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE) //max (LDR=2816/2-1000)*32*4000 ~= 52 Mbps
                                                  // 704 -700 -1 = 3

      //XDSLRTFW-1829: (Start)
      #define RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE      (100)    //max DS line data rate = 100*32*4000 = 12.8 Mbps
      #define RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE      (1)
      //max DS line data rate = 7168 - 704 = 6464; (6464 - 100 - 1)/2 = 3181 ; 3181*32*4000 = 407.168 Mbps
      #define RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE      ((RETX_ZEP_DTB_SIZE_RX_WDS - RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE - RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE) >> 1)

      //XDSLRTFW-1829: (End)
      //XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
      //US & DS supported ReTx DTB configurations
      #define US_DS_RETX_ZEP_DTB_SIZE_TX_WDS          (1000)//TX DTB buffer size in 32-bit words
      #define US_DS_RETX_ZEP_DTB_SIZE_RX_WDS          (ZEP_DTB_SIZE_WDS - US_DS_RETX_ZEP_DTB_SIZE_TX_WDS)   //RX DTB buffer size in 32-bit words (2816-800=2016)

      #define US_DS_RETX_ZEP_ILV_RAM_TXDTB_OFFSET     (uint32)(0)                //in 32-bit words
      #define US_DS_RETX_ZEP_ILV_RAM_RXDTB_OFFSET     (uint32)(US_DS_RETX_ZEP_ILV_RAM_TXDTB_OFFSET + US_DS_RETX_ZEP_DTB_SIZE_TX_WDS)   //in 32-bit words

      #define US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE      (100) //max US OH line data rate including vector = 100*32*4000 = 12.8 Mbps
      #define US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE      (1)      // Tx RRC (24 Bits)
      //max US line data rate = 1000 - 100 - 1 = 899; 899*32*4000 = 115.72 Mbps
      #define US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP1_SIZE      (US_DS_RETX_ZEP_DTB_SIZE_TX_WDS - US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE - US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE)

      //XDSLRTFW-1829: (Start)
      #define US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE      (100) //max DS OH line data rate = 100*32*4000 = 12.8 Mbps
      #define US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE      (1)
      //max DS line data rate = 7168 - 1000 = 6168; (6168 - 1 - 100)/2 = 3033 ; 3033*32*4000 = 388.224 Mbps
      #define US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE      ((US_DS_RETX_ZEP_DTB_SIZE_RX_WDS - US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE - US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE)>>1)
      //XDSLRTFW-1829: (End)
      //XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)                                                          // 2816 - 800 - 100 - 1 = 1915 => (1915*32*4000) = 245.12 Mbps

      //XDSLRTFW-1881(START)
      #define US_RETX_ONLY_ZEP_DTB_SIZE_TX_WDS        (1000)//TX DTB buffer size in 32-bit words
      #define US_RETX_ONLY_ZEP_DTB_SIZE_RX_WDS        (ZEP_DTB_SIZE_WDS - US_RETX_ONLY_ZEP_DTB_SIZE_TX_WDS) //RX DTB buff size in 32-bit words(2816-1000=1816)


      #define US_RETX_ONLY_ZEP_ILV_RAM_TXDTB_OFFSET   (uint32)(0)                //in 32-bit words
      #define US_RETX_ZEP_ILV_RAM_RXDTB_OFFSET        (uint32)(US_RETX_ONLY_ZEP_ILV_RAM_TXDTB_OFFSET + US_RETX_ONLY_ZEP_DTB_SIZE_TX_WDS) //in 32-bit words


      #define US_RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE      (100)    //max US line data rate = 100*32*4000 = 12.8 Mbps
      #define US_RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE      (1)      //max US line data rate = 1*32*4000   = 128 kbps
      //max US line data rate = 1000 - 100 - 1 = 899; 899*32*4000 = 115.72 Mbps
      #define US_RETX_ZEP_ILV_RAM_TXDTB_LP1_SIZE      (US_RETX_ONLY_ZEP_DTB_SIZE_TX_WDS - US_RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE - US_RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE)

      //max DS line data rate = 7168 - 1000 = 6168; (6168 - 2)/2 = 3083 ; 3083*32*4000 = 394.624 Mbps
      #define US_RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE      ((US_RETX_ONLY_ZEP_DTB_SIZE_RX_WDS - US_RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE - US_RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE) >> 1)
      #define US_RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE      (1)        //max US line data rate = 1*32*4000 = 128 kbps
      #define US_RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE      (1)
      //XDSLRTFW-1881(END)

   #define DEFAULT_ZEP_DTB_SIZE_TX_WDS             (800)                                  //TX DTB buffer size in 32-bit words
   #define DEFAULT_ZEP_DTB_SIZE_RX_WDS             (ZEP_DTB_SIZE_WDS - DEFAULT_ZEP_DTB_SIZE_TX_WDS)   //RX DTB buffer size in 32-bit words (7816-1000)

   #define DEFAULT_ZEP_ILV_RAM_TXDTB_OFFSET        (uint32)(0)                            //in 32-bit words
   #define DEFAULT_ZEP_ILV_RAM_RXDTB_OFFSET        (uint32)(DEFAULT_ZEP_ILV_RAM_TXDTB_OFFSET + DEFAULT_ZEP_DTB_SIZE_TX_WDS)   //in 32-bit words

   //max US line data rate = 798*32*4000 = 102.144 Mbps
   #define DEFAULT_ZEP_ILV_RAM_TXDTB_LP0_SIZE      (DEFAULT_ZEP_DTB_SIZE_TX_WDS - DEFAULT_ZEP_ILV_RAM_TXDTB_LP1_SIZE - DEFAULT_ZEP_ILV_RAM_TXDTB_LP2_SIZE)
   #define DEFAULT_ZEP_ILV_RAM_TXDTB_LP1_SIZE      (1)
   #define DEFAULT_ZEP_ILV_RAM_TXDTB_LP2_SIZE      (1)

   //max DS line data rate = (7168 - 800 - 2)/2 = 3183*32*4000 = 407.424 Mbps
   #define DEFAULT_ZEP_ILV_RAM_RXDTB_LP0_SIZE      ((DEFAULT_ZEP_DTB_SIZE_RX_WDS - DEFAULT_ZEP_ILV_RAM_RXDTB_LP1_SIZE - DEFAULT_ZEP_ILV_RAM_RXDTB_LP2_SIZE) >> 1)
   #define DEFAULT_ZEP_ILV_RAM_RXDTB_LP1_SIZE      (1)
   #define DEFAULT_ZEP_ILV_RAM_RXDTB_LP2_SIZE      (1)


#define ZEP_ILV_RAM_TXDTB_LP0_BASE           0
#define ZEP_ILV_RAM_TXDTB_LP2_BASE           (ZEP_ILV_RAM_TXDTB_LP0_BASE + gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE)
#define ZEP_ILV_RAM_TXDTB_LP1_BASE           (ZEP_ILV_RAM_TXDTB_LP2_BASE + gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE)

#define ZEP_ILV_RAM_RXDTB_LP0_BASE           0
#define ZEP_ILV_RAM_RXDTB_LP0_BASE_PONG      (ZEP_ILV_RAM_RXDTB_LP0_BASE + gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE)
#define ZEP_ILV_RAM_RXDTB_LP2_BASE           (ZEP_ILV_RAM_RXDTB_LP0_BASE_PONG + gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE)
#define ZEP_ILV_RAM_RXDTB_LP1_BASE           (ZEP_ILV_RAM_RXDTB_LP2_BASE + gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE)

#define ZEP_ILV_RAM_RXDTB_LP1_BASE_PONG      (ZEP_ILV_RAM_RXDTB_LP1_BASE + gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE)

//======= Configure the interleaver/deinterleaver memory address (in bytes) =================



#define ZEP_ILV_DILV_LP0_BLOCK_SIZE    (ZEP_ILV_DILV_BLOCK_SIZE - 4) //mei fixme: LP0 used almost all now
#define ZEP_ILV_DILV_LP1_BLOCK_SIZE    (4)
#define ZEP_ILV_LP0_BLOCK_SIZE         (ZEP_ILV_DILV_LP0_BLOCK_SIZE/2)
#define ZEP_DILV_LP0_BLOCK_SIZE        (ZEP_ILV_DILV_LP0_BLOCK_SIZE/2)
#define ZEP_ILV_LP1_BLOCK_SIZE         (ZEP_ILV_DILV_LP1_BLOCK_SIZE/2)
#define ZEP_DILV_LP1_BLOCK_SIZE        (ZEP_ILV_DILV_LP1_BLOCK_SIZE/2)

#define ZEP_ILV_LP0_BASE            (ZEP_RAM_ILV_DLIV_BASE)
#define ZEP_DILV_LP0_BASE           (ZEP_ILV_LP0_BASE + ZEP_ILV_LP0_BLOCK_SIZE)
#define ZEP_ILV_LP1_BASE            (ZEP_DILV_LP0_BASE + ZEP_DILV_LP0_BLOCK_SIZE)
#define ZEP_DILV_LP1_BASE           (ZEP_ILV_LP1_BASE + ZEP_ILV_LP1_BLOCK_SIZE)


    #define RETX_ZEP_ILV_DILV_LP0_BLOCK_SIZE    (ZEP_ILV_DILV_BLOCK_SIZE/2)   //mei fixme: LP0 used almost all now
    #define RETX_ZEP_ILV_DILV_LP1_BLOCK_SIZE    (ZEP_ILV_DILV_BLOCK_SIZE/2)   //mei fixme: LP0 used almost all now

    #define RETX_ZEP_ILV_LP0_BLOCK_SIZE            (RETX_ZEP_ILV_DILV_LP0_BLOCK_SIZE/2)
   #define RETX_ZEP_DILV_LP0_BLOCK_SIZE         (RETX_ZEP_ILV_DILV_LP0_BLOCK_SIZE/2) - 16384

   #define RETX_ZEP_DILV_LP1_BLOCK_SIZE         (RETX_ZEP_ILV_DILV_LP1_BLOCK_SIZE/2) + 16384
   #define RETX_ZEP_ILV_LP1_BLOCK_SIZE          (RETX_ZEP_ILV_DILV_LP1_BLOCK_SIZE/2)

    #define RETX_ZEP_ILV_LP0_BASE            (ZEP_RAM_ILV_DLIV_BASE)
    #define RETX_ZEP_DILV_LP0_BASE           (RETX_ZEP_ILV_LP0_BASE + RETX_ZEP_ILV_LP0_BLOCK_SIZE)
    #define RETX_ZEP_ILV_LP1_BASE            (RETX_ZEP_DILV_LP0_BASE + RETX_ZEP_DILV_LP0_BLOCK_SIZE)
    #define RETX_ZEP_DILV_LP1_BASE           (RETX_ZEP_ILV_LP1_BASE + RETX_ZEP_ILV_LP1_BLOCK_SIZE)



// for ReTX, reserve a block of DILV for deinterleaver. The rest of the memory can be used
// for ReTX DTU buffer
//#define DEFAULT_RETX_ZEP_DILV_LP1_BLOCK_SIZE  (256*4)             // should be good enough for D=1
//#define RETX_QUEUE_BASE_ADDR            (ZEP_DILV_LP1_BASE + DEFAULT_RETX_ZEP_DILV_LP1_BLOCK_SIZE)


//======= Configure the micro-code address (in bytes) =======================================

// TX_UCODE_ADDR is the same for both port-modes
//XDSLRTFW-1830 (START)
//Increased both LP0 & LP1 MICRO code size to 150 words on each latency path
//Tx LP1 & Rx LP1 each can use upto LP_MICROCODE_WORDS_LP1 (150 * 4) Bytes &
//Tx LP0 & Rx LP0 can use upto LP_MICROCODE_WORDS (150 * 4)
#define ZEP_RAM_TX_LP0_UCODE_ADDR      (uint32)(ZEP_RAM_TX_RX_UCODE_BASE)
#define ZEP_RAM_TX_LP1_UCODE_ADDR      (uint32)(ZEP_RAM_TX_LP0_UCODE_ADDR + (LP_MICROCODE_WORDS*4))

#define ZEP_RAM_RX_LP0_UCODE_ADDR      (uint32)(ZEP_RAM_TX_LP1_UCODE_ADDR + (LP_MICROCODE_WORDS_LP1*4))
#define ZEP_RAM_RX_LP1_UCODE_ADDR      (uint32)(ZEP_RAM_RX_LP0_UCODE_ADDR + (LP_MICROCODE_WORDS*4))
//XDSLRTFW-1830 (END)

#define ZEP_RAM_1PORT_RX_LP0_UCODE_ADDR   (uint32)(ZEP_RAM_RX_LP0_UCODE_ADDR)
#define ZEP_RAM_1PORT_RX_LP1_UCODE_ADDR   (uint32)(ZEP_RAM_RX_LP1_UCODE_ADDR)


//====== Configure OH FIFO addresses (in bytes)
//these sizes are in bytes.
#define ZEP_RAM_OHFIFO_SIZE_64         (uint32)(64)
#define ZEP_RAM_OHFIFO_SIZE_32         (uint32)(32)
#define ZEP_RAM_OHFIFO_SIZE_6          (uint32)(6)


//32*16 = 512 bytes for FIFO's
//ZEP_RAM_TX_LP0_OHFIFO0_OFFSET   =   0                 (64 Bytes)
//ZEP_RAM_RX_LP0_OHFIFO0_OFFSET   =  64  =    0 + 64    (64 Bytes)
//ZEP_RAM_TX_LP1_OHFIFO0_OFFSET   = 128  =   64 + 64    (32 Bytes)
//ZEP_RAM_RX_LP1_OHFIFO0_OFFSET   = 160  =  128 + 32    (32 Bytes)
//ZEP_RAM_RX_LP1_OHFIFO1_OFFSET   = 192  =  160 + 32    (32 Bytes)
//ZEP_RAM_USRETX_RDWR_PTRS_OFFSET = 224  =  192 + 32    (32 Bytes)
//ZEP_RAM_ERB_RD_PTRS_BASE_ADDR   = 240  =  224 + 16    (16 Bytes)
//ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET  = 272  =  240 + 32    (32 Bytes)
//ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET  = 376  =  272 + 104   (104 Bytes)
//ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET  = 496  =  376 + 120   (120 Bytes)
//ZEP_RAM_RX_OHFIFO3_DBG1_OFFSET  = 504  =  496 + 8     (8 Bytes)
//FIFO_END_OFFSET                 = 512  =  504 + 8     (8 Bytes)
#define  ZEP_RAM_TX_LP0_OHFIFO0_OFFSET    (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*0)       //64 bytes as ZEP_RAM_OHFIFO_SIZE_64 (0,1)
#define  ZEP_RAM_RX_LP0_OHFIFO0_OFFSET    (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*2)       //64 bytes as ZEP_RAM_OHFIFO_SIZE_64 (2,3)

#define  ZEP_RAM_TX_LP1_OHFIFO0_OFFSET    (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*4)       //32  bytes as ZEP_RAM_OHFIFO_SIZE_32
// these 2 used under ReTX
// FIFO0 is for normal OVHD
// FIFO1 is for DTU related OVHD
#define  ZEP_RAM_RX_LP1_OHFIFO0_OFFSET    (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*5)       //32  bytes as ZEP_RAM_OHFIFO_SIZE_32
#define  ZEP_RAM_RX_LP1_OHFIFO1_OFFSET    (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*6)       //32  bytes as ZEP_RAM_OHFIFO_SIZE_32
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
// US RETX using the 5th FIFO location US RETX Rd and Wr ptrs

   #define  ZEP_RAM_USRETX_RDWR_PTRS_OFFSET     (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*7) //16+16 bytes = 4 + 4 = 32bit words

   #define US_RETX_WR_POINTERS_BASE_ADDR     ((uint32) ZEP_RAM_USRETX_RDWR_PTRS_OFFSET )
   #define US_RETX_WR_POINTERS_LW_BASE_ADDR  (US_RETX_WR_POINTERS_BASE_ADDR >> 2)

   #define US_RETX_RD_POINTERS_BASE_ADDR     ((uint32) ZEP_RAM_USRETX_RDWR_PTRS_OFFSET + 16 )
   #define US_RETX_RD_POINTERS_LW_BASE_ADDR  (US_RETX_RD_POINTERS_BASE_ADDR >> 2)

// Ideally required is 8 bytes, but reserved 16 bytes for future use.
#define  ZEP_RAM_ERB_RD_PTRS_BASE_ADDR    (uint32)(ZEP_RAM_OHFIFO_BASE + OHFIFO_SIZE*8)
#define ZEP_RAM_ERB_RD_PTRS_SIZE          (16)
#define ZEP_RAM_ERB_RD_PTRS_LW_BASE_ADDR  (ZEP_RAM_ERB_RD_PTRS_BASE_ADDR >> 2)


//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)
//#ifdef ZEP_DEBUG_BLD
//Following FIFO3 configuration is for capturing the TX scrambler input and RX scrambler output data
#define ZEP_RAM_TX_OHFIFO3_DBG0_SIZE      (104)    //in byte, support the line rate of 64 mbps for US
#define ZEP_RAM_RX_OHFIFO3_DBG0_SIZE      (120)    //in byte, support the line rate of 128 Mbps for DS
#define  ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET      (uint32)(ZEP_RAM_ERB_RD_PTRS_BASE_ADDR+ ZEP_RAM_ERB_RD_PTRS_SIZE) ////XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START_END)
#define  ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET   (ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET + ZEP_RAM_TX_OHFIFO3_DBG0_SIZE)  //120 bytes as ZEP_RAM_RX_OHFIFO3_DBG0_SIZE
#define ZEP_RAM_TX_OHFIFO3_DBG0_ADDR      (ZEP_RAM_IIBRAM_ADDR + ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET)
#define ZEP_RAM_RX_OHFIFO3_DBG0_ADDR      (ZEP_RAM_IIBRAM_ADDR + ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET)

//The following FIFOs are dummy FIFOs for storing "don't care" data
#define ZEP_RAM_TX_OHFIFO3_DBG1_SIZE      (8)      //in byte
#define ZEP_RAM_RX_OHFIFO3_DBG1_SIZE      (8)      //in byte
#define  ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET      (uint32)(ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET + ZEP_RAM_RX_OHFIFO3_DBG0_SIZE)
#define  ZEP_RAM_RX_OHFIFO3_DBG1_OFFSET      (uint32)(ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET + ZEP_RAM_TX_OHFIFO3_DBG1_SIZE)

//#endif //#ifdef ZEP_DEBUG_BLD

/******************************************************************************************************
:  Possible PRAM Arrangement
:
:        ***Tx PRAM Start***
:  0x0000   Num_Latency_Paths = 0 or 1
:  0x0004   ZEP_TX_CFG_LP0_PTR (= 0xC)
:  0x0008   ZEP_TX_CFG_LP1_PTR (= 0x0xxx)
;
:        ***Tx PRAM Start***
:  0x000C   ZEP_PRAM_ZT_R0_LP0_ADDR (First register in Tx PRAM LP0)
:        ...
:  0x0xxx   ZEP_PRAM_ZT_R0_LP1_ADDR (First register in Tx PRAM LP1)
:        ...
:
:        ***Rx PRAM Start***
:  0x0000   Num_Latency_Paths = 0 or 1
:  0x0004   ZEP_RX_CFG_LP0_PTR
:  0x0008   ZEP_RX_CFG_LP1_PTR
:  0x000C   ZEP_PRAM_ZR_R0_LP0_ADDR (First register in Rx PRAM LP0)
:        ...
:  0x0xxx   ZEP_PRAM_ZR_R0_LP1_ADDR (First register in Rx PRAM LP1)
:        ...
********************************************************************************************************/

//================ Configure PRAM Zephyr register block ===========================================
#define ZEP_PRAM_TX_START_ADDR                  (uint32)(ZEP_PRAM_BASE)
#define ZEP_PRAM_RX_START_ADDR                  (uint32)(ZEP_PRAM_TX_START_ADDR + (4*ZEP_REG_TX_PRAM_SIZE)*2 + 0xC + 4)
#define ZEP_TX_CFG_LP0_PTR                   (uint32)(ZEP_PRAM_TX_START_ADDR + 0xC) //0xc
#define ZEP_TX_CFG_LP1_PTR                   (uint32)(ZEP_TX_CFG_LP0_PTR + (ZEP_REG_TX_PRAM_SIZE*4)) //0xc + 0x1d4 = 0x1e0
#define ZEP_RX_CFG_LP0_PTR                   (uint32)(ZEP_PRAM_RX_START_ADDR + 0xC) //0x1e0 + 0x1d4 = 0x3b4; 0x3b4 + 0xc = 0x3c0
#define ZEP_RX_CFG_LP1_PTR                   (uint32)(ZEP_RX_CFG_LP0_PTR + (ZEP_REG_RX_PRAM_SIZE*4)) //0x3c0 + 0x1f0 = 0x5b0

#define ZEP_PRAM_TX_LP0_START_ADDR              (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_TX_CFG_LP0_PTR)
#define ZEP_PRAM_TX_LP1_START_ADDR              (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_TX_CFG_LP1_PTR)

#define ZEP_PRAM_RX_LP0_START_ADDR              (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_RX_CFG_LP0_PTR)
#define ZEP_PRAM_RX_LP1_START_ADDR              (uint32)(ZEP_RAM_IIBRAM_ADDR + ZEP_RX_CFG_LP1_PTR)

// ----------- TX LP0 registers ----------------------

// Per LP Registers
#define ZEP_PRAM_ZT_R0_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R0_OFFSET      )
#define ZEP_PRAM_ZT_R4_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R4_OFFSET            )
#define ZEP_PRAM_ZT_R8_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R8_OFFSET            )
#define ZEP_PRAM_ZT_R12_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_R12_OFFSET           )
#define ZEP_PRAM_ZT_CODEWORD_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CODEWORD_OFFSET       )
#define ZEP_PRAM_ZT_VBC_SIZE_LP0_ADDR            (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_VBC_SIZE_OFFSET       )
#define ZEP_PRAM_ZT_FRAMING_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FRAMING_OFFSET    )
#define ZEP_PRAM_ZT_OHRATE_LP0_ADDR              (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_OHRATE_OFFSET         )
#define ZEP_PRAM_ZT_FLAG_CTRL0_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FLAG_CTRL0_OFFSET     )
#define ZEP_PRAM_ZT_FLAG_CTRL1_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FLAG_CTRL1_OFFSET     )
#define ZEP_PRAM_ZT_CRC0_LP0_ADDR                (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC0_OFFSET           )
#define ZEP_PRAM_ZT_CRC_POLY0_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_POLY0_OFFSET      )
#define ZEP_PRAM_ZT_CRC_CTRL0_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_CTRL0_OFFSET      )
#define ZEP_PRAM_ZT_CRC1_LP0_ADDR                (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC1_OFFSET           )
#define ZEP_PRAM_ZT_CRC_POLY1_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_POLY1_OFFSET      )
#define ZEP_PRAM_ZT_CRC_CTRL1_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_CRC_CTRL1_OFFSET      )
#define ZEP_PRAM_ZT_SCR_LP0_ADDR                 (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_OFFSET            )
#define ZEP_PRAM_ZT_SCR_POLY_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_POLY_OFFSET      )
#define ZEP_PRAM_ZT_SCR_CTRL_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_CTRL_OFFSET      )
#define ZEP_PRAM_ZT_SCR_STATE_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_SCR_STATE_OFFSET      )
#define ZEP_PRAM_ZT_DTB_CTRL_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_DTB_CTRL_OFFSET      )
#define ZEP_PRAM_ZT_DTB_PTRS_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_DTB_PTRS_OFFSET      )
#define ZEP_PRAM_ZT_ILVB_WRAD_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_WRAD_OFFSET      )
#define ZEP_PRAM_ZT_ILVB_RDAD_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDAD_OFFSET      )
#define ZEP_PRAM_ZT_ILVB_WRPTR_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_WRPTR_OFFSET     )
#define ZEP_PRAM_ZT_ILVB_RDPTR_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILVB_RDPTR_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE0_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE0_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS0_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS0_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST0_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST0_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE1_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE1_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS1_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS1_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST1_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST1_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE2_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE2_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS2_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS2_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST2_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST2_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE3_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_BASE3_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS3_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_PTRS3_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST3_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_FIFO_CNST3_OFFSET     )
#define ZEP_PRAM_ZT_DEPTH_LP0_ADDR               (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_DEPTH_OFFSET          )
#define ZEP_PRAM_ZT_ILV_PARAMS0_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR +  ZT_ILV_PARAMS0_OFFSET    )
#define ZEP_PRAM_ZT_ILV_BASE0_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_BASE0_OFFSET         )
#define ZEP_PRAM_ZT_ILV_SIZE0_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_SIZE0_OFFSET         )
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS0_LP0_ADDR   (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MAX_FULLNESS0_OFFSET )
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS0_LP0_ADDR   (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MIN_FULLNESS0_OFFSET )
#define ZEP_PRAM_ZT_ILV_FULLNESS0_LP0_ADDR       (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_FULLNESS0_OFFSET     )
#define ZEP_PRAM_ZT_ILV_CNTRS0_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_CNTRS0_OFFSET       )
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS0_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMS_CNTRS0_OFFSET    )
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS0_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMD_CNTRS0_OFFSET    )
#define ZEP_PRAM_ZT_ILV_PARAMS1_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PARAMS1_OFFSET       )
#define ZEP_PRAM_ZT_ILV_BASE1_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_BASE1_OFFSET         )
#define ZEP_PRAM_ZT_ILV_SIZE1_LP0_ADDR           (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_SIZE1_OFFSET         )
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS1_LP0_ADDR   (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MAX_FULLNESS1_OFFSET )
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS1_LP0_ADDR   (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_MIN_FULLNESS1_OFFSET )
#define ZEP_PRAM_ZT_ILV_FULLNESS1_LP0_ADDR       (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_FULLNESS1_OFFSET     )
#define ZEP_PRAM_ZT_ILV_CNTRS1_LP0_ADDR          (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_CNTRS1_OFFSET        )
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS1_LP0_ADDR        (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMS_CNTRS1_OFFSET    )
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS1_LP0_ADDR     (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_ILV_PMD_CNTRS1_OFFSET    )
#define ZEP_PRAM_ZT_CHECKBYTE0_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE0_OFFSET     )
#define ZEP_PRAM_ZT_CHECKBYTE1_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE1_OFFSET     )
#define ZEP_PRAM_ZT_CHECKBYTE2_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE2_OFFSET     )
#define ZEP_PRAM_ZT_CHECKBYTE3_LP0_ADDR         (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_CHECKBYTE3_OFFSET     )
#define ZEP_PRAM_ZT_TCSRC_STATE_LP0_ADDR     (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_TCSRC_STATE_OFFSET    )
#define ZEP_PRAM_ZT_UPROC_ENA_LP0_ADDR       (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC_ENA_OFFSET      )
#define ZEP_PRAM_ZT_UPROC01_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC01_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC23_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC23_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC45_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC45_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC67_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC67_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC89_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC89_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC_INT_LP0_ADDR       (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC_INT_OFFSET      )
#define ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC0_STATE0_OFFSET     )

#define ZEP_PRAM_ZT_UPROC0_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC0_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC0_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC0_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC1_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC1_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC1_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC1_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC2_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC2_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC2_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC2_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC3_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC3_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC3_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC3_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC4_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC4_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC4_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC4_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC5_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC5_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC5_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC5_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC6_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC6_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC6_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC7_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC7_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC7_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC8_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC8_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC8_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC8_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC9_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC9_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC9_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC9_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC_STATE5_LP0_ADDR    (uint32)(ZEP_PRAM_ZT_UPROC9_STATE4_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_STATE_LP0_ADDR          (uint32)(ZEP_PRAM_ZT_UPROC_STATE5_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR     (uint32)(ZEP_PRAM_ZT_ALU_STATE_LP0_ADDR + 0x4)

#define ZEP_PRAM_ZT_UPROC5_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0xC)
#define ZEP_PRAM_ZT_UPROC8_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP0_ADDR + 0x14)

// ----------- RX LP0 registers ----------------------

// Per Lp Registers
#define ZEP_PRAM_ZR_R0_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R0_OFFSET          )
#define ZEP_PRAM_ZR_R4_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R4_OFFSET          )
#define ZEP_PRAM_ZR_R8_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R8_OFFSET          )
#define ZEP_PRAM_ZR_R12_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_R12_OFFSET            )
#define ZEP_PRAM_ZR_CODEWORD_LP0_ADDR           (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CODEWORD_OFFSET         )
#define ZEP_PRAM_ZR_VBC_SIZE_LP0_ADDR           (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_VBC_SIZE_OFFSET         )
#define ZEP_PRAM_ZR_FRAMING_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FRAMING_OFFSET        )
#define ZEP_PRAM_ZR_OHRATE_LP0_ADDR             (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_OHRATE_OFFSET           )
#define ZEP_PRAM_ZR_FLAG_CTRL0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FLAG_CTRL0_OFFSET       )
#define ZEP_PRAM_ZR_FLAG_CTRL1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FLAG_CTRL1_OFFSET       )
#define ZEP_PRAM_ZR_CRC0_LP0_ADDR               (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC0_OFFSET             )
#define ZEP_PRAM_ZR_CRC_POLY0_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_POLY0_OFFSET        )
#define ZEP_PRAM_ZR_CRC_CTRL0_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_CTRL0_OFFSET        )
#define ZEP_PRAM_ZR_CRC1_LP0_ADDR               (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC1_OFFSET             )
#define ZEP_PRAM_ZR_CRC_POLY1_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_POLY1_OFFSET        )
#define ZEP_PRAM_ZR_CRC_CTRL1_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CRC_CTRL1_OFFSET        )
#define ZEP_PRAM_ZR_SCR_LP0_ADDR                (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_OFFSET              )
#define ZEP_PRAM_ZR_SCR_POLY_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_POLY_OFFSET    )
#define ZEP_PRAM_ZR_SCR_CTRL_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_CTRL_OFFSET    )
#define ZEP_PRAM_ZR_SCR_STATE_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_SCR_STATE_OFFSET        )
#define ZEP_PRAM_ZR_DTB_CTRL_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_DTB_CTRL_OFFSET    )
#define ZEP_PRAM_ZR_DTB_PTRS_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_DTB_PTRS_OFFSET    )
#define ZEP_PRAM_ZR_ILVB_WRAD_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_WRAD_OFFSET        )
#define ZEP_PRAM_ZR_ILVB_RDAD_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_RDAD_OFFSET        )
#define ZEP_PRAM_ZR_ILVB_WRPTR_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_WRPTR_OFFSET       )
#define ZEP_PRAM_ZR_ILVB_RDPTR_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILVB_RDPTR_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE0_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS0_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST0_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE1_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS1_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST1_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE2_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE2_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS2_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS2_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST2_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST2_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE3_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_BASE3_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS3_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_PTRS3_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST3_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FIFO_CNST3_OFFSET       )
#define ZEP_PRAM_ZR_DEPTH_LP0_ADDR              (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_DEPTH_OFFSET            )
#define ZEP_PRAM_ZR_ILV_PARAMS0_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PARAMS0_OFFSET      )
#define ZEP_PRAM_ZR_ILV_BASE0_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_BASE0_OFFSET        )
#define ZEP_PRAM_ZR_ILV_SIZE0_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_SIZE0_OFFSET        )
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS0_LP0_ADDR  (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS0_LP0_ADDR  (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS0_LP0_ADDR      (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_FULLNESS0_OFFSET    )
#define ZEP_PRAM_ZR_ILV_CNTRS0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_CNTRS0_OFFSET       )
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS0_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMS_CNTRS0_OFFSET   )
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS0_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMD_CNTRS0_OFFSET   )
#define ZEP_PRAM_ZR_ILV_PARAMS1_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PARAMS1_OFFSET      )
#define ZEP_PRAM_ZR_ILV_BASE1_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_BASE1_OFFSET        )
#define ZEP_PRAM_ZR_ILV_SIZE1_LP0_ADDR          (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_SIZE1_OFFSET        )
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS1_LP0_ADDR  (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS1_LP0_ADDR  (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS1_LP0_ADDR      (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_FULLNESS1_OFFSET    )
#define ZEP_PRAM_ZR_ILV_CNTRS1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_CNTRS1_OFFSET       )
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS1_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMS_CNTRS1_OFFSET   )
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS1_LP0_ADDR     (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_ILV_PMD_CNTRS1_OFFSET   )
#define ZEP_PRAM_ZIR_DL_REL0_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_DL_REL0_OFFSET    )
#define ZEP_PRAM_ZIR_NL_REL0_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_NL_REL0_OFFSET    )
#define ZEP_PRAM_ZIR_DMETRIC0_LP0_ADDR       (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_DMETRIC0_OFFSET      )
#define ZEP_PRAM_ZIR_DMETRIC_CTRL_LP0_ADDR      (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_DMETRIC_CTRL_OFFSET  )
#define ZEP_PRAM_ZIR_LPBITS_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZIR_LPBITS_OFFSET        )
#define ZEP_PRAM_ZR_CW_COUNT_LP0_ADDR        (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_CW_COUNT_OFFSET    )
#define ZEP_PRAM_ZR_FEC_CNT_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_FEC_CNT_OFFSET        )
#define ZEP_PRAM_ZR_UNCORR_CW0_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UNCORR_CW0_OFFSET     )
#define ZEP_PRAM_ZR_UNCORR_CW1_LP0_ADDR         (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UNCORR_CW1_OFFSET     )
#define ZEP_PRAM_ZR_WB_SCORE_CTL_LP0_ADDR    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_WB_SCORE_CTL_OFFSET   )
#define ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR       (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_WB_SCORE2_OFFSET      )
#define ZEP_PRAM_ZR_UPROC_ENA_LP0_ADDR       (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC_ENA_OFFSET      )
#define ZEP_PRAM_ZR_UPROC01_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC01_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC23_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC23_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC45_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC45_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC67_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC67_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC89_BASE_LP0_ADDR    (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC89_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC_INT_LP0_ADDR       (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC_INT_OFFSET      )
#define ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_RX_LP0_START_ADDR + ZR_UPROC0_STATE0_OFFSET  )

#define ZEP_PRAM_ZR_UPROC0_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC0_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC0_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC0_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC1_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC1_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC1_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC1_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC2_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC2_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC2_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC2_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC3_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC3_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC3_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC3_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC4_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC4_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC4_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC4_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC5_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC5_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC5_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC5_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC6_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC6_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC6_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC7_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC7_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC7_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC8_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC8_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC8_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC8_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP0_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC9_STATE1_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC9_STATE2_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC9_STATE3_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC9_STATE4_LP0_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC_STATE5_LP0_ADDR    (uint32)(ZEP_PRAM_ZR_UPROC9_STATE4_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_STATE_LP0_ADDR          (uint32)(ZEP_PRAM_ZR_UPROC_STATE5_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR        (uint32)(ZEP_PRAM_ZR_ALU_STATE_LP0_ADDR + 0x4)

#define ZEP_PRAM_ZR_UPROC5_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0xC)
#define ZEP_PRAM_ZR_UPROC8_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_BASE_LP0_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP0_ADDR + 0x14)

// ----------- TX LP1 registers ----------------------

// Per LP Registers
#define ZEP_PRAM_ZT_R0_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R0_OFFSET      )
#define ZEP_PRAM_ZT_R4_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R4_OFFSET            )
#define ZEP_PRAM_ZT_R8_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R8_OFFSET            )
#define ZEP_PRAM_ZT_R12_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_R12_OFFSET           )
#define ZEP_PRAM_ZT_CODEWORD_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CODEWORD_OFFSET       )
#define ZEP_PRAM_ZT_VBC_SIZE_LP1_ADDR            (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_VBC_SIZE_OFFSET       )
#define ZEP_PRAM_ZT_FRAMING_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FRAMING_OFFSET    )
#define ZEP_PRAM_ZT_OHRATE_LP1_ADDR              (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_OHRATE_OFFSET         )
#define ZEP_PRAM_ZT_FLAG_CTRL0_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FLAG_CTRL0_OFFSET     )
#define ZEP_PRAM_ZT_FLAG_CTRL1_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FLAG_CTRL1_OFFSET     )
#define ZEP_PRAM_ZT_CRC0_LP1_ADDR                (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC0_OFFSET           )
#define ZEP_PRAM_ZT_CRC_POLY0_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_POLY0_OFFSET      )
#define ZEP_PRAM_ZT_CRC_CTRL0_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_CTRL0_OFFSET      )
#define ZEP_PRAM_ZT_CRC1_LP1_ADDR                (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC1_OFFSET           )
#define ZEP_PRAM_ZT_CRC_POLY1_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_POLY1_OFFSET      )
#define ZEP_PRAM_ZT_CRC_CTRL1_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_CRC_CTRL1_OFFSET      )
#define ZEP_PRAM_ZT_SCR_LP1_ADDR                 (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_OFFSET            )
#define ZEP_PRAM_ZT_SCR_POLY_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_POLY_OFFSET      )
#define ZEP_PRAM_ZT_SCR_CTRL_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_CTRL_OFFSET      )
#define ZEP_PRAM_ZT_SCR_STATE_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_SCR_STATE_OFFSET      )
#define ZEP_PRAM_ZT_DTB_CTRL_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_DTB_CTRL_OFFSET      )
#define ZEP_PRAM_ZT_DTB_PTRS_LP1_ADDR        (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_DTB_PTRS_OFFSET      )
#define ZEP_PRAM_ZT_ILVB_WRAD_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_WRAD_OFFSET      )
#define ZEP_PRAM_ZT_ILVB_RDAD_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_RDAD_OFFSET      )
#define ZEP_PRAM_ZT_ILVB_WRPTR_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_WRPTR_OFFSET     )
#define ZEP_PRAM_ZT_ILVB_RDPTR_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILVB_RDPTR_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE0_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE0_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS0_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS0_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST0_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST0_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE1_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE1_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS1_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS1_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST1_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST1_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE2_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE2_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS2_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS2_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST2_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST2_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_BASE3_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_BASE3_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_PTRS3_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_PTRS3_OFFSET     )
#define ZEP_PRAM_ZT_FIFO_CNST3_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_FIFO_CNST3_OFFSET     )
#define ZEP_PRAM_ZT_DEPTH_LP1_ADDR               (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_DEPTH_OFFSET          )
#define ZEP_PRAM_ZT_ILV_PARAMS0_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR +  ZT_ILV_PARAMS0_OFFSET    )
#define ZEP_PRAM_ZT_ILV_BASE0_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_BASE0_OFFSET         )
#define ZEP_PRAM_ZT_ILV_SIZE0_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_SIZE0_OFFSET         )
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS0_LP1_ADDR   (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MAX_FULLNESS0_OFFSET )
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS0_LP1_ADDR   (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MIN_FULLNESS0_OFFSET )
#define ZEP_PRAM_ZT_ILV_FULLNESS0_LP1_ADDR       (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_FULLNESS0_OFFSET     )
#define ZEP_PRAM_ZT_ILV_CNTRS0_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_CNTRS0_OFFSET       )
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS0_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMS_CNTRS0_OFFSET    )
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS0_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMD_CNTRS0_OFFSET    )
#define ZEP_PRAM_ZT_ILV_PARAMS1_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PARAMS1_OFFSET       )
#define ZEP_PRAM_ZT_ILV_BASE1_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_BASE1_OFFSET         )
#define ZEP_PRAM_ZT_ILV_SIZE1_LP1_ADDR           (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_SIZE1_OFFSET         )
#define ZEP_PRAM_ZT_ILV_MAX_FULLNESS1_LP1_ADDR   (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MAX_FULLNESS1_OFFSET )
#define ZEP_PRAM_ZT_ILV_MIN_FULLNESS1_LP1_ADDR   (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_MIN_FULLNESS1_OFFSET )
#define ZEP_PRAM_ZT_ILV_FULLNESS1_LP1_ADDR       (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_FULLNESS1_OFFSET     )
#define ZEP_PRAM_ZT_ILV_CNTRS1_LP1_ADDR          (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_CNTRS1_OFFSET        )
#define ZEP_PRAM_ZT_ILV_PMS_CNTRS1_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMS_CNTRS1_OFFSET    )
#define ZEP_PRAM_ZT_ILV_PMD_CNTRS1_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_ILV_PMD_CNTRS1_OFFSET    )
#define ZEP_PRAM_ZT_CHECKBYTE0_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE0_OFFSET     )
#define ZEP_PRAM_ZT_CHECKBYTE1_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE1_OFFSET     )
#define ZEP_PRAM_ZT_CHECKBYTE2_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE2_OFFSET     )
#define ZEP_PRAM_ZT_CHECKBYTE3_LP1_ADDR         (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_CHECKBYTE3_OFFSET     )
#define ZEP_PRAM_ZT_TCSRC_STATE_LP1_ADDR     (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_TCSRC_STATE_OFFSET    )
#define ZEP_PRAM_ZT_UPROC_ENA_LP1_ADDR       (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC_ENA_OFFSET      )
#define ZEP_PRAM_ZT_UPROC01_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC01_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC23_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC23_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC45_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC45_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC67_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC67_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC89_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC89_BASE_OFFSET   )
#define ZEP_PRAM_ZT_UPROC_INT_LP1_ADDR       (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC_INT_OFFSET      )
#define ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_TX_LP1_START_ADDR + ZT_UPROC0_STATE0_OFFSET     )

#define ZEP_PRAM_ZT_UPROC0_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC0_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC0_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC0_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC0_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC1_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC1_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC1_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC1_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC1_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC2_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC2_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC2_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC2_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC2_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC3_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC3_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC3_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC3_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC3_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC4_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC4_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC4_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC4_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC4_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC5_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC5_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC5_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC5_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC5_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC6_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC6_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC6_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC6_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC7_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC7_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC7_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC7_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC8_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC8_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC8_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC8_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC8_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZT_UPROC9_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC9_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC9_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZT_UPROC9_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZT_UPROC9_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC_STATE5_LP1_ADDR    (uint32)(ZEP_PRAM_ZT_UPROC9_STATE4_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_STATE_LP1_ADDR          (uint32)(ZEP_PRAM_ZT_UPROC_STATE5_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR     (uint32)(ZEP_PRAM_ZT_ALU_STATE_LP1_ADDR + 0x4)

#define ZEP_PRAM_ZT_UPROC5_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZT_UPROC6_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZT_UPROC7_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0xC)
#define ZEP_PRAM_ZT_UPROC8_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZT_UPROC9_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZT_ALU_CLI_REQ_LP1_ADDR + 0x14)

// ----------- RX LP1 registers ----------------------

// Per Lp Registers
#define ZEP_PRAM_ZR_R0_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R0_OFFSET          )
#define ZEP_PRAM_ZR_R4_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R4_OFFSET          )
#define ZEP_PRAM_ZR_R8_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R8_OFFSET          )
#define ZEP_PRAM_ZR_R12_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_R12_OFFSET            )
    #define ZEP_PRAM_ZR_RETX_PARAM2_LP1_ADDR       ZEP_PRAM_ZR_R12_LP1_ADDR

#define ZEP_PRAM_ZR_CODEWORD_LP1_ADDR           (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CODEWORD_OFFSET         )
#define ZEP_PRAM_ZR_VBC_SIZE_LP1_ADDR           (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_VBC_SIZE_OFFSET         )
#define ZEP_PRAM_ZR_FRAMING_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FRAMING_OFFSET        )
    #define ZEP_PRAM_ZR_RETX_PARAM1_LP1_ADDR       ZEP_PRAM_ZR_FRAMING_LP1_ADDR

#define ZEP_PRAM_ZR_OHRATE_LP1_ADDR             (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_OHRATE_OFFSET           )
#define ZEP_PRAM_ZR_FLAG_CTRL0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FLAG_CTRL0_OFFSET       )
#define ZEP_PRAM_ZR_FLAG_CTRL1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FLAG_CTRL1_OFFSET       )
#define ZEP_PRAM_ZR_CRC0_LP1_ADDR               (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC0_OFFSET             )
    #define ZEP_PRAM_ZR_RETX_PARAM3_LP1_ADDR       ZEP_PRAM_ZR_CRC0_LP1_ADDR

#define ZEP_PRAM_ZR_CRC_POLY0_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_POLY0_OFFSET        )
#define ZEP_PRAM_ZR_CRC_CTRL0_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_CTRL0_OFFSET        )
#define ZEP_PRAM_ZR_CRC1_LP1_ADDR               (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC1_OFFSET             )
#define ZEP_PRAM_ZR_CRC_POLY1_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_POLY1_OFFSET        )
#define ZEP_PRAM_ZR_CRC_CTRL1_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CRC_CTRL1_OFFSET        )
#define ZEP_PRAM_ZR_SCR_LP1_ADDR                (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_OFFSET              )
#define ZEP_PRAM_ZR_SCR_POLY_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_POLY_OFFSET    )
#define ZEP_PRAM_ZR_SCR_CTRL_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_CTRL_OFFSET    )
#define ZEP_PRAM_ZR_SCR_STATE_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_SCR_STATE_OFFSET        )
#define ZEP_PRAM_ZR_DTB_CTRL_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_DTB_CTRL_OFFSET    )
#define ZEP_PRAM_ZR_DTB_PTRS_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_DTB_PTRS_OFFSET    )
#define ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_WRAD_OFFSET        )
#define ZEP_PRAM_ZR_ILVB_RDAD_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_RDAD_OFFSET        )
#define ZEP_PRAM_ZR_ILVB_WRPTR_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_WRPTR_OFFSET       )
#define ZEP_PRAM_ZR_ILVB_RDPTR_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILVB_RDPTR_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE0_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS0_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST0_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE1_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS1_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST1_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE2_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE2_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS2_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS2_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST2_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST2_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_BASE3_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_BASE3_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_PTRS3_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_PTRS3_OFFSET       )
#define ZEP_PRAM_ZR_FIFO_CNST3_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FIFO_CNST3_OFFSET       )
#define ZEP_PRAM_ZR_DEPTH_LP1_ADDR              (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_DEPTH_OFFSET            )
#define ZEP_PRAM_ZR_ILV_PARAMS0_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PARAMS0_OFFSET      )
#define ZEP_PRAM_ZR_ILV_BASE0_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_BASE0_OFFSET        )
#define ZEP_PRAM_ZR_ILV_SIZE0_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_SIZE0_OFFSET        )
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS0_LP1_ADDR  (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MAX_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS0_LP1_ADDR  (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MIN_FULLNESS0_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS0_LP1_ADDR      (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_FULLNESS0_OFFSET    )
#define ZEP_PRAM_ZR_ILV_CNTRS0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_CNTRS0_OFFSET       )
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS0_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMS_CNTRS0_OFFSET   )
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS0_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMD_CNTRS0_OFFSET   )
#define ZEP_PRAM_ZR_ILV_PARAMS1_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PARAMS1_OFFSET      )
#define ZEP_PRAM_ZR_ILV_BASE1_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_BASE1_OFFSET        )
#define ZEP_PRAM_ZR_ILV_SIZE1_LP1_ADDR          (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_SIZE1_OFFSET        )
#define ZEP_PRAM_ZR_ILV_MAX_FULLNESS1_LP1_ADDR  (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MAX_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_MIN_FULLNESS1_LP1_ADDR  (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_MIN_FULLNESS1_OFFSET)
#define ZEP_PRAM_ZR_ILV_FULLNESS1_LP1_ADDR      (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_FULLNESS1_OFFSET    )
#define ZEP_PRAM_ZR_ILV_CNTRS1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_CNTRS1_OFFSET       )
#define ZEP_PRAM_ZR_ILV_PMS_CNTRS1_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMS_CNTRS1_OFFSET   )
#define ZEP_PRAM_ZR_ILV_PMD_CNTRS1_LP1_ADDR     (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_ILV_PMD_CNTRS1_OFFSET   )
#define ZEP_PRAM_ZIR_DL_REL0_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_DL_REL0_OFFSET    )
#define ZEP_PRAM_ZIR_NL_REL0_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_NL_REL0_OFFSET    )
#define ZEP_PRAM_ZIR_DMETRIC0_LP1_ADDR       (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_DMETRIC0_OFFSET      )
#define ZEP_PRAM_ZIR_DMETRIC_CTRL_LP1_ADDR      (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_DMETRIC_CTRL_OFFSET  )
#define ZEP_PRAM_ZIR_LPBITS_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZIR_LPBITS_OFFSET        )
#define ZEP_PRAM_ZR_CW_COUNT_LP1_ADDR        (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_CW_COUNT_OFFSET    )
#define ZEP_PRAM_ZR_FEC_CNT_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_FEC_CNT_OFFSET        )
#define ZEP_PRAM_ZR_UNCORR_CW0_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UNCORR_CW0_OFFSET     )
#define ZEP_PRAM_ZR_UNCORR_CW1_LP1_ADDR         (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UNCORR_CW1_OFFSET     )
#define ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_WB_SCORE_CTL_OFFSET   )
#define ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR       (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_WB_SCORE2_OFFSET      )
#define ZEP_PRAM_ZR_UPROC_ENA_LP1_ADDR       (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC_ENA_OFFSET      )
#define ZEP_PRAM_ZR_UPROC01_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC01_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC23_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC23_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC45_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC45_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC67_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC67_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC89_BASE_LP1_ADDR    (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC89_BASE_OFFSET   )
#define ZEP_PRAM_ZR_UPROC_INT_LP1_ADDR       (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC_INT_OFFSET      )
#define ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_RX_LP1_START_ADDR + ZR_UPROC0_STATE0_OFFSET  )

#define ZEP_PRAM_ZR_UPROC0_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC0_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC0_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC0_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC0_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC1_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC1_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC1_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC1_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC1_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC2_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC2_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC2_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC2_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC2_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC3_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC3_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC3_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC3_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC3_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC4_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC4_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC4_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC4_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC4_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC5_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC5_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC5_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC5_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC5_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC6_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC6_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC6_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC6_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC7_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC7_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC7_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC7_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC8_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC8_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC8_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC8_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC8_STATE0_LP1_ADDR + 0x14)
#define ZEP_PRAM_ZR_UPROC9_STATE1_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC9_STATE2_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC9_STATE3_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0xc)
#define ZEP_PRAM_ZR_UPROC9_STATE4_LP1_ADDR      (uint32)(ZEP_PRAM_ZR_UPROC9_STATE0_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC_STATE5_LP1_ADDR    (uint32)(ZEP_PRAM_ZR_UPROC9_STATE4_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_STATE_LP1_ADDR          (uint32)(ZEP_PRAM_ZR_UPROC_STATE5_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR        (uint32)(ZEP_PRAM_ZR_ALU_STATE_LP1_ADDR + 0x4)

#define ZEP_PRAM_ZR_UPROC5_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x4)
#define ZEP_PRAM_ZR_UPROC6_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x8)
#define ZEP_PRAM_ZR_UPROC7_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0xC)
#define ZEP_PRAM_ZR_UPROC8_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x10)
#define ZEP_PRAM_ZR_UPROC9_BASE_LP1_35B_ADDR    (uint32)(ZEP_PRAM_ZR_ALU_CLI_REQ_LP1_ADDR + 0x14)


#endif //_ZEP_MEMMAP_CNFG_H   Do not add anything below this line.
