/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: show_iof_VDSL2.c
*
*   This file contains engine interface functions to used during VDSL2 showtime.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// show_iof_VDSL2.c
//
// History
// 09/09/2014 Kannan: Need to stop processing of TC layer data for sync symbol in the micro code, this is done
//            by clearing at "ZEP_PRAM_ZT_R12_LP1_ADDR <31:0>" and "ZEP_PRAM_ZT_FRAMING_LP1_ADDR <31:24>
//            Grep for "XDSLRTFW-1830"
//
// 26/11/2015 Anantha Ramu: Added modifications for SRA with DS Intra DTU Interleaving.
//                          Grep for "XDSLRTFW-2162".
// ************************************************************************************************************


#include <string.h>
#include "common.h"
#include "gdata.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "cri_iof.h"
#include "alp_memmap.h"
#include "cri_memmap.h"
#include "ft_memmap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"

#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "show_iof.h"
#include "OvhdMsg_IOf.h"
#include "IRI_IOf_mfdq.h"
#include "cmv.h"
#include "BitswapHandler.h"
#include "dsp_op.h"
#include "mtkernel.h"
#include "showtime.h"
#include "str_memmap.h"
#include "dsp_regs_62.h"
#include <stdlib.h>

extern ReTX_ShowtimeParams_t gt_ReTxShowtimeParams;



//--------------------------------------------------------------------------------
// ntr  variables. Use restricted to this file.
// Note these will be moved to a Show only page, after mechanism to init is finalized.

extern uint32 gul_TxRRC_corrupted_Cnt;

int32 gl_db_accNTRByte;
int32 gl_db_avgNTRByte;
int8 gc_ntrLogControl = 3; // bit0:Enable =1, bit1:NoRollOver = 1;
int16 gs_ntrLogPtr = 0;

#define NTRLOG_SIZE 8   //
//JGMERGE DATA_SHOW_ONLY_ONEPORT_BEGIN
//////////   /*DATA_SHOW_ONLY_BEGIN*/
int32 gl_ntrLogBuffer[NTRLOG_SIZE+4];
//JGMERGE DATA_MAP_END;

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void CopyRxBGT_ActiveToInactive(void)
*
*   This function copies the active BAT/GAIN/EGT table to the inactive ones
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*-------------------------------------------------------------------------------
*/

void CopyRxBGT_ActiveToInactive(void)
{
   //Note: the table copy range should be set
   //when copying from inactive to active so we should not need to set them again

   SetCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, (uint32)(1<<0));;   //enable table copy
   SetCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, (uint32)(1<<0));   //direction active to inactive

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void CopyTxBGT_ActiveToInactive(void)
*
*   This function copies the active BAT and GAIN table to the inactive ones
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void CopyTxBGT_ActiveToInactive(void)
{
   //Note: the table copy range should be set
   //when copying from inactive to active so we should not need to set them again

   SetCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, (uint32)(1<<0));   // table copy enable
   SetCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, (uint32)(1<<0)); // TC direction active to inactive

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SwitchTxTableForBitswap(void)
*
*   This function switches the bank of TX ping-pong table used by BAT, GST
*   It also updates the active/inactive pointers to BAT/GST
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


void SwitchTxTableForBitswap(void)
{
   uint32 ul_data;
   int16 s_TxNumTones;

   if (gs_RxNumTones > gs_TxNumTones)
      s_TxNumTones = gs_RxNumTones;
   else
      s_TxNumTones = gs_TxNumTones;
   //QTP_TXTC_CTRL
   ul_data = (uint32) ((gs_Tblcpy_Num0bit[TX] << 19)
         | (gs_Tblcpy_NumGT1bit[TX] << 6));
   //ul_data |= (0<<5);   //not disable TOT
   //ul_data |= (0<<2);   //segment 0
   //ul_data |= (0<<0);   //TC direction, inactive to active

   // enable TCM
   if (gft_TxTcmFlag)
   {
      ul_data |= MASK_BIT1;   //Enable 1bit reorder in QTP for TCM mode
   }

   WriteCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, ul_data);


    ul_data = ((uint32) (s_TxNumTones - gs_TxNumTonesUsed)) | ((uint32) (s_TxNumTones - 1) << 13);

   WriteCoreReg(IRI_QTP_REG_TXTC_TOT_ADDR, ul_data);

   // IT_TCM_CTRL
   if(gft_TxTcmFlag)
   {
      ul_data = (uint32) (((gus_Tx_Tcm_Num1bits >> 1) << 13)
            | (gs_TxNumTonesUsed - 1));
      ul_data |= (1 << 25); //enable TCM
      WriteCoreReg(IRI_QT_REG_TX_TCM_CTRL_ADDR, ul_data);
   }

   //set min and max tone range for active table

   //This register is used in QT
   ul_data = (gs_TxNumTonesUsed - 1) << 16;
   WriteCoreReg(IRI_QT_REG_TX_ACTIVE_ADDR, ul_data);

   ul_data = (gs_TxNumTonesUsed - 1) << 13;
   //This register is used in QTP
   WriteCoreReg(IRI_QTP_REG_TXTC_ACTIVE_ADDR, ul_data);

   //Enable TX table copy - it was auto cleared after copy
   SetCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, MASK_BIT0);

   //mei fixme: Following setting is needed for SRA only


   // Change the Lp value
   WriteCoreReg(IRI_QT_REG_TX_LP0_BITS_ADDR, gt_tx_config_v2.ul_Lp[LP0]);
   WriteCoreReg(IRI_QT_REG_TX_LP1_BITS_ADDR, gt_tx_config_v2.ul_Lp[LP1]);


} //void SwitchTxTableForBitswap(void)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SwitchRxTableForBitswap(void)
*
*   This function copies the inactive BAT, GST, TRT to the active ones.
*   It also update the TCM_CTRL, IR_TONES registers.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*-------------------------------------------------------------------------------
*/
void SwitchRxTableForBitswap(void)
{
   uint32 ul_data;

   //QTP_RXTC_CTRL
   ul_data = (uint32) ((gs_Tblcpy_Num0bit[RX] << 19)

         | (gs_Tblcpy_NumGT1bit[RX] << 6));
   //ul_data |= (0<<5);   //not disable TOT
   //ul_data |= (0<<2);   //segment 0
   //ul_data |= (0<<0);   //TC direction, inactive to active

   // enable TCM
   if (gft_RxTcmFlag)
   {
      ul_data |= MASK_BIT1;   //Enable 1bit reorder in QTP for TCM mode
   }

   WriteCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, ul_data);

   // QTP_RXTC_TOT_AD
   // Set the inactive TOT table range to be copied to the active BGT table
   // Inactive RX TRT lies at the beginning of Inactive TRT
   ul_data = (0) | (uint32) (gs_RxMaxTone << 13);
   WriteCoreReg(IRI_QTP_REG_RXTC_TOT_ADDR, ul_data);

   // QTP_RXTC_ACT_AD
   // Set min and max tone range in active table when the inactive table are copied to
   WriteCoreReg(IRI_QTP_REG_RXTC_ACTIVE_ADDR, ul_data);

   // IR_ACT_ADDR
   // set min and max range for active table in QT
   ul_data = ((uint32)gs_RxMinTone) | ((uint32)gs_RxMaxTone << 16);
   WriteCoreReg(IRI_QT_REG_RX_ACTIVE_ADDR, ul_data);

   // IR_TCM_CTRL
   if(gft_RxTcmFlag)
   {
      ul_data = (uint32) (((gus_Rx_Tcm_Num1bits >> 1) << 13)
            | gus_Rx_1Bit_Index);
      ul_data |= (1 << 25); //enable TCM
      WriteCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, ul_data);
   }

   //Enable RX table copy - it was auto cleared after copy
   SetCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, MASK_BIT0);

   //mei fixme: Following setting is needed for SRA only

   // Change the Lp value
   WriteCoreReg(IRI_QT_REG_RX_LP0_BITS_ADDR, gt_rx_config_v2.ul_Reconfig_Lp[LP0]);
   WriteCoreReg(IRI_QT_REG_RX_LP1_BITS_ADDR, gt_rx_config_v2.ul_Reconfig_Lp[LP1]);

   // Clear the active and inactive BGT unmatch bit
   gus_RxBitSwapStatus &= ~RX_BITSWAP_BGT_MISMATCH;

} //SwitchRxTableForBitswap(void)


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetUpRTVForRxSynchFrame(void)
*
*   This function sets up RTV buffer 1 for reading the Rx synch frame.
*   It was necessary to change for HW SNR mode, where we don't want to
*   overwrite the accumulated noise data. However it is simpler to also
*   change it for FW mode so it is consistent.
*
*   Iridia Registers: QT_REG_RX_MISC_ADDR , QT_REG_RX_FD_RNG0 , QT_REG_RX_FD_RNG1
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables: gs_RxSynchFrameNumTones
*
*-------------------------------------------------------------------------------
*/

void SetUpRTVForRxSynchFrame(void)
{

   uint32 ul_data;

   //Set RTV1 base address
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_BASE_ADDR, gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup);

   // Get the RTV1 offset
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, &ul_data);


   //Preserve the RTV offset
   ul_data &= RTV_OFFSET_MASK;

   ul_data |= (SFDQ_OUTPUT << 25) // write FFT output to RTV buffer 0
         | (0 << 28) // We need PRBS derotation to get correct sync symbol.
         | (1 << 29) // Quadrant count enable
         | (1 << 31); // enable RTV capture
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, ul_data);

    ul_data = (gs_RxSynchFrameNumTones - 1);
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_CNT_35B_ADDR, ul_data);

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Disable RTV0
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, (1<<31));

   // IR_DEROT_MISC
   ul_data = (10<<0)|(1<<6);
   /*
   In showtime sync frame, use 'initialization like' mapping for 01 and 10 constellations by default
   and 'showtime like' mapping only for backward compatibility.

   The mapping used by 01 and 10 constellations can be realised within QT in two ways:
   (a) PRBS scrambling settings in TX and DPRBS descrambling settings in RX.
   (b) INIT bit in TX_MISC register (NOTE: This does NOT work in RX, even though the QT spec says it does)

   Earlier implementation realised a 'showtime like' 01/10 mapping  as follows
   TX-- use 'initialization like' PRBS scrambling settings AND set the INIT bit to effectively invert
   the constellation mapping to 'showtime like'
   RX-- use 'showtime like' DPRBS scrambling settings.

   The current fix realises a 01/10 mapping as follows
   TX-- use 'initialization like' PRBS scrambling settings by default and 'showtime like' PRBS scrambling
   settings for backward compatibility reasons.
   TX-- use 'initialization like' DPRBS descrambling settings by default and 'showtime like' DPRBS descrambling
   settings for backward compatibility reasons */
   if (gul_dbgShowtimeControl & VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL)
   {
      ul_data |= ((0<<7)|(1<<9)|(2<<11)|(3<<13));
   }
   else
   {
      ul_data |= ((0<<7)|(2<<9)|(1<<11)|(3<<13));
   }

   WriteCoreReg(IRI_QT_REG_RX_DPRBS_MISC_ADDR, ul_data);

   //DSM_Vectoring_Debug:
   //if ( gs_PauseControl == 0x34)
   //Pause(gs_PauseControl);
}

//#ifdef MTK_VECTORING_SUPPORT
void SetupRTV0ForRxSyncFrameVectoring(void)
{
   uint32 ul_data;

   //IR_RXCG_x, x=0, 1, ..., 15
   // Rx Constellation Gain Table all contains CG for 2 bit constallation.
   WriteCoreReg( IRI_QT_REG_RX_CG0_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG1_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG2_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG3_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG4_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG5_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG6_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG7_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG8_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG9_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG10_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG11_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG12_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG13_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG14_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG15_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );

   // back up IR_TCM_CTRL register ( for trellis )
   ReadCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, &ul_data);
   gl_IR_TCM_CTRL_Shadow = ul_data;

   // Disable Trellis
   ul_data = 0x0;
   WriteCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, ul_data);


   // Configure QT RX Path ( QT IR_MISC )
   //-----------------------------
   // 1st back up QT IR_MISC
   ReadCoreReg( IRI_QT_REG_RX_MISC_ADDR, &ul_data);
   gul_RX_MISC_Shadow2 = ul_data;
   // 2nd write QT IR_MISC with new config
   ul_data = 0x0009a800;
   // set decimation factor
   ul_data |= ((uint32)gs_IR_NPR_DECIM <<26);       //0 = every, 1 = 2nd, 2 = 4th, 3 = 8th
   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);


   // Switch RTV data from NPR to IIBRAM.
   // Value = 0x80000000 | ((RTV0 showtime buffer offset from 0x40000)/4) since the value is in 32bit words!
   ul_data = (1<<31) | (((uint32)gsa_StVectoringBuffer - ZEP_RAM_IIBRAM_ADDR) >> 2);
   WriteCoreReg(IRI_QT_REG_RX_NPR_IIBRAM_ADDR, ul_data);

   // RTV1 Base
   // This value is always relative to RTV0 base, i.e. 32 bit word offset needs to be programmed
   // hence "RX_MAX_NUM_TONES/2" is programmed.
   // Note: RTV0 / RTV1 buffer have to be continuous, i.e.
   //       gsa_StVectoringBuffer[RX_MAX_NUM_TONES] - Buffer for capturing 2048 (VR9, VRx318) or 4096 (VRx518) Showtime constellation points
   //       gsa_SyncSymConstelForOlr[60]            - Buffer for capturing 30 showtime OLR related constellation points
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_BASE_ADDR, (RX_MAX_NUM_TONES >> 1));  // RTV0 uses 8192 or 16384 bytes data so that
                                                                            // we have to collect RTV1 data from 0x4a0b0 + 4* (0x800 or 0x1000)

   // setup RTV1 buffer for OLR tones
   // Get the RTV1 offset
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, &ul_data);

   //Preserve the RTV offset
   ul_data &= RTV_OFFSET_MASK;
   ul_data |= (SFDQ_OUTPUT << 25) // write FFT output to RTV buffer 0
              | (0 <<28)          // We don not need PRBS derotation to get correct sync symbol. (there are no PRBS)
              | (0 <<29)          // Quadrant count enable
              | (1 <<31);         // enable RTV capture

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, ul_data);

   ul_data =  (gs_RxSynchFrameNumTones-1);// # of tones to store - 1, starting at RTV_OFFSET0
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_CNT_35B_ADDR, ul_data);

   // Setup RTV0 for  noisy constallation data
   //ul_data = 0x983f0000;

   ul_data = 0x0;   // assume data always start form tone zero
   ul_data |= (gs_RTV0Probe << 25) // write FFT output to RTV buffer 0
              | (0 <<28)  // We need PRBS derotation to get correct sync symbol.
              | (0 <<29)  // Quadrant count enable
              | (1 <<31); // enable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);

   ul_data = gs_NoOfRTV0ToneToCapture-1; // # of tones to store - 1, starting at RTV_OFFSET0

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);

}



void SetupRTV0ForRxNonSyncFrameVectoring(void)
{

   uint32 ul_data;

   //IR_RXCG_x, x=0, 1, ..., 15
   // Rx Constellation Gain Table.
   WriteCoreReg( IRI_QT_REG_RX_CG0_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG1_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG2_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG3_ADDR , (0 << 16 ) |  0x376D );
   WriteCoreReg( IRI_QT_REG_RX_CG4_ADDR , (1 << 16 ) |  0x23C7 );
   WriteCoreReg( IRI_QT_REG_RX_CG5_ADDR , (1 << 16 ) |  0x3299 );
   WriteCoreReg( IRI_QT_REG_RX_CG6_ADDR , (2 << 16 ) |  0x24A9 );
   WriteCoreReg( IRI_QT_REG_RX_CG7_ADDR , (2 << 16 ) |  0x333A );
   WriteCoreReg( IRI_QT_REG_RX_CG8_ADDR , (3 << 16 ) |  0x24E1 );
   WriteCoreReg( IRI_QT_REG_RX_CG9_ADDR , (3 << 16 ) |  0x3362 );
   WriteCoreReg( IRI_QT_REG_RX_CG10_ADDR , (4 << 16 ) |  0x24EF );
   WriteCoreReg( IRI_QT_REG_RX_CG11_ADDR , (4 << 16 ) |  0x336B );
   WriteCoreReg( IRI_QT_REG_RX_CG12_ADDR , (5 << 16 ) |  0x24F2 );
   WriteCoreReg( IRI_QT_REG_RX_CG13_ADDR , (5 << 16 ) |  0x336E );
   WriteCoreReg( IRI_QT_REG_RX_CG14_ADDR , (6 << 16 ) |  0x24F3 );
   WriteCoreReg( IRI_QT_REG_RX_CG15_ADDR , (6 << 16 ) |  0x336F );


   // enable trellis
   ul_data = gl_IR_TCM_CTRL_Shadow;
   WriteCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, ul_data);

   // configure QT IR_MISC for non sync frame
   ul_data = gul_RX_MISC_Shadow2;
   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);

   //switch Data Dump back to NPR instead of IIBRAM
   ul_data = 0x0;
   WriteCoreReg(IRI_QT_REG_RX_NPR_IIBRAM_ADDR, ul_data);

}


void SetupCGforDataSymbol(void)
{
   //IR_RXCG_x, x=0, 1, ..., 15
   // Rx Constellation Gain Table.
   WriteCoreReg( IRI_QT_REG_RX_CG0_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG1_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG2_ADDR , (0 << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG3_ADDR , (0 << 16 ) |  0x376D );
   WriteCoreReg( IRI_QT_REG_RX_CG4_ADDR , (1 << 16 ) |  0x23C7 );
   WriteCoreReg( IRI_QT_REG_RX_CG5_ADDR , (1 << 16 ) |  0x3299 );
   WriteCoreReg( IRI_QT_REG_RX_CG6_ADDR , (2 << 16 ) |  0x24A9 );
   WriteCoreReg( IRI_QT_REG_RX_CG7_ADDR , (2 << 16 ) |  0x333A );
   WriteCoreReg( IRI_QT_REG_RX_CG8_ADDR , (3 << 16 ) |  0x24E1 );
   WriteCoreReg( IRI_QT_REG_RX_CG9_ADDR , (3 << 16 ) |  0x3362 );
   WriteCoreReg( IRI_QT_REG_RX_CG10_ADDR , (4 << 16 ) |  0x24EF );
   WriteCoreReg( IRI_QT_REG_RX_CG11_ADDR , (4 << 16 ) |  0x336B );
   WriteCoreReg( IRI_QT_REG_RX_CG12_ADDR , (5 << 16 ) |  0x24F2 );
   WriteCoreReg( IRI_QT_REG_RX_CG13_ADDR , (5 << 16 ) |  0x336E );
   WriteCoreReg( IRI_QT_REG_RX_CG14_ADDR , (6 << 16 ) |  0x24F3 );
   WriteCoreReg( IRI_QT_REG_RX_CG15_ADDR , (6 << 16 ) |  0x336F );
}

void SetupCGforSyncSymbol(void)
{
   //IR_RXCG_x, x=0, 1, ..., 15
   // Rx Constellation Gain Table all contains CG for 2 bit constallation.
   WriteCoreReg( IRI_QT_REG_RX_CG0_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG1_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG2_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG3_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG4_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG5_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG6_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG7_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG8_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG9_ADDR , (gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG10_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG11_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG12_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG13_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG14_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
   WriteCoreReg( IRI_QT_REG_RX_CG15_ADDR ,(gs_CGShiftFactor << 16 ) |  0x2000 );
}
//#endif

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ReadRxSynchFrame(void)
*
*   This function copies the Rx synch frame (FDQ output) from the RTV to a SW array.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*      gpsa_RxSynchFrame: pointer to SW array
*      gs_RxSynchFrameNumTones: # of tones to read from RTV buffer
*
*-------------------------------------------------------------------------------
*/
void ReadRxSynchFrame(void)
{
   //Read from RTV1
   ReadCoreBuf32((IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR+(gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup<<2)), gpsa_RxSynchFrame, (uint16)gs_RxSynchFrameNumTones);
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *      InitReverbPRBS
 *
 *   Prototype:
 *      void InitReverbPRBS(void);
 *
 *  Abstract:
 *      Initialize the Reverb PRBS generator.
 *
 *  Returns:
 *      None
 *
 *------------------------------------------------------------------------
 */
void InitReverbPRBS(void)
{
   //modified 2/5/08
   uint32 ul_RegData;

   // Set up TX PRBS registers.
   ul_RegData = (10<<4)|(1<<11)|(4<<12)|(1<<16)|(9<<17);
   /*
   In showtime sync frame, use 'initialization like' mapping for 01 and 10 constellations by default
   and 'showtime like' mapping only for backward compatibility.

   The mapping used by 01 and 10 constellations can be realised within QT in two ways:
   (a) PRBS scrambling settings in TX and DPRBS descrambling settings in RX.
   (b) INIT bit in TX_MISC register (NOTE: This does NOT work in RX, even though the QT spec says it does)

   Earlier implementation realised a 'showtime like' 01/10 mapping  as follows
   TX-- use 'initialization like' PRBS scrambling settings AND set the INIT bit to effectively invert
   the constellation mapping to 'showtime like'
   RX-- use 'showtime like' DPRBS scrambling settings.

   The current fix realises a 01/10 mapping as follows
   TX-- use 'initialization like' PRBS scrambling settings by default and 'showtime like' PRBS scrambling
   settings for backward compatibility reasons.
   TX-- use 'initialization like' DPRBS descrambling settings by default and 'showtime like' DPRBS descrambling
   settings for backward compatibility reasons */
   if (gul_dbgShowtimeControl & VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL)
   {
      ul_RegData |= ((0<<24)|(1<<26)|(2<<28)|(3<<30));
   }
   else
   {
      ul_RegData |= ((0<<24)|(2<<26)|(1<<28)|(3<<30));
   }

   WriteCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, ul_RegData);  //newly added for QTP
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_POLY_ADDR, (uint32)0x0100); // d[n] = d[n-9] xor d[n-11] for QTP
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_ADDR, (uint32)0x7FF); // initial PRBS LFSR state.//for QTP

//#ifdef MTK_VECTORING_SUPPORT
   ul_RegData = 0;            // // this pattern corresponds to Flag = 0, Probe = 1

   // XDSLRTFW-1696 (Start)
   if (gft_DSVectoringEnabled == TRUE /*gft_UsFDPSSupported*/)
   {

      int16 i;
      uint16 us_PilotSeqIndexWithCycShift;
      uint32 ul_SocTxDataForPrbs = 0;
      int16 s_RevSeg;


      for (i = 0 ; i < 8; i++)
      {
         // main array  : gpuca_FDPSActive size [8][64]
         // control 1 : gs_VecIndx_PilotSeq
         // control 2 : guca_IndexIndependentPSActive[8]
         // control 3 : guca_CyclicalShiftOfSeqActive[8]
         // control 4 : guc_SignOfSeqActive
         // modulo parameter : gs_VecNPilotLength_US bit field length



         //considing Cyclical Shift of the sequence
         us_PilotSeqIndexWithCycShift  = (uint16)(gs_VecIndx_PilotSeq + guca_CyclicalShiftOfSeqActive[i]*(gs_VecNPilotLength_US >>3));
         // modulo (s_PilotSeqIndexWithCycShift, gs_VecNPilotLength_US)
         while (us_PilotSeqIndexWithCycShift > gs_VecNPilotLength_US)
         {
            us_PilotSeqIndexWithCycShift -= gs_VecNPilotLength_US;
         }

         // get the bit considiring US super frame counter (gs_VecIndx_PilotSeq), cyclical shift and independent pilot sequence
         s_RevSeg = (*(gpuca_FDPSActive + guca_IndexIndependentPSActive[i]*64  + (us_PilotSeqIndexWithCycShift>>3)) >> (us_PilotSeqIndexWithCycShift & 0x7)) & 0x1; // XDSLRTFW-1321 Feature_US_Vec_VDSL2_USPS (start-end)

         // considereing sign bit
         if ((guc_SignOfSeqActive >> i) & 0x1)
         {
            s_RevSeg = (~s_RevSeg) & 0x1;
         }
         // Preparation of constallation points for tones 0,2,3,4,5,6,8 & 9
         if (s_RevSeg == 1)
         {
            ul_SocTxDataForPrbs |= (0x3 << 2*i);
         }
         else
         {
            ul_SocTxDataForPrbs |= (0x0 << 2*i);
         }
      }
      // add flag tones (tone 10n+1 and 10n+7) constallation to (0,0)
      ul_RegData = (ul_SocTxDataForPrbs & 0x3)| ((ul_SocTxDataForPrbs & 0xFFC) << 2) | ((ul_SocTxDataForPrbs & 0xF000) << 4);

      if (gs_TxSyncToneType == SEGUE)
         ul_RegData |= 0xC00C;
   }
   else
   {
      if (gs_TxSyncToneType == SEGUE)
         ul_RegData = 0xFFFFFFFF;
   }
   // XDSLRTFW-1696 (end)
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_DATA0_ADDR, ul_RegData);
//#endif

}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *      NoInvertPRBS
 *
 *   Prototype:
 *      void NoInvertPRBS(void);
 *
 *  Abstract:
 *      Do not invert PRBS output.
 *
 *
 *  Returns:
 *      None
 *
 *------------------------------------------------------------------------
 */
/*
void NoInvertPRBS(void)
{
   // Do not invert PRBS output (bit 10)
   ResetCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR, MASK_BIT10);
}
*/
/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *      InvertPRBS
 *
 *   Prototype:
 *      void InvertPRBS(void);
 *
 *  Abstract:
 *      Invert PRBS output.
 *
 *
 *  Returns:
 *      None
 *
 *------------------------------------------------------------------------
 */
void InvertPRBS(void)
{
   // Invert PRBS output (bit 10)
   SetCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, MASK_BIT10);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableTxShowGenRef(void)
*
*   This function sets Iridia QT registers to enable the PRBS generator
*   for generating sync symbol during showtime.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void EnableTxShowGenRef(void)
{
   // Initialize the PRBS generator to Reverb signal generator
   InitReverbPRBS();

   // Write to the Iridia QT core
   SetCoreReg(IRI_QT_REG_TX_MISC_ADDR, MASK_BIT5);   //PRBS_GEN (bit 5) in TX_MISC register
   SetCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, MASK_BIT1);  //PRBS_GEN in QTP
}

void SavePRBSRegisters(void)
{
   // Save current PRBS related registers - needed for modulating Medley PRBS on unused
   // tones (b_i=0 and g_i > 0) of data frames
   //modified 2/5/08
   //ReadCoreBuf32(IRI_QT_REG_TX_PRBS_ADDR, (void*)gusa_PrbsRegistersSav, (uint16)NUM_PRBS_SAVE_REGS_32BIT);
   ReadCoreBuf32(IRI_QTP_REG_TX_PRBS_ADDR, gusa_PrbsRegistersSav, (uint16)NUM_PRBS_SAVE_REGS_32BIT);
}

void RestorePRBSRegisters(void)
{
   // Restore current PRBS related registers - needed for modulating Medley PRBS on unused
   // tones (b_i=0 and g_i > 0) of data frames
   //modified 2/5/08
   //WriteCoreBuf32(IRI_QT_REG_TX_PRBS_ADDR, gusa_PrbsRegistersSav, (uint16)NUM_PRBS_SAVE_REGS_32BIT);

   //Since NUM_PRBS_SAVE_REGS_32BIT is only 3, no need to use DMA
   //(setting up the DMA transfer costs some cycles)
   WriteCoreBuf32NoDMA(IRI_QTP_REG_TX_PRBS_ADDR, (void*)gusa_PrbsRegistersSav, (uint16)NUM_PRBS_SAVE_REGS_32BIT);

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableTxDataMode(void)
*
*   This function sets Iridia QT registers to disable the PRBS generator
*   for generating sync symbol during showtime.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void EnableTxDataMode(void)
{
   //modified 2/5/08

   //  INIT (sense of 4-QAM, bit 6), PRBS_GEN (bit 5) in TX_MISC register and PRBS_GEN bit in QTP
   //Reset TRT_DIS in QTP

   //XDSLRTFW-1420
   //Dont reset PRBS at the end of every frame
   ResetCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR,(uint16)MASK_BIT11);


   //ResetCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, (uint16)(MASK_BIT5));
   //ResetCoreReg(IRI_QT_REG_TX_MISC_ADDR, (uint16)(MASK_BIT6 | MASK_BIT5));
   ResetCoreReg(IRI_QT_REG_TX_MISC_ADDR, (uint16)(MASK_BIT5) );
   ResetCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, (uint16)(MASK_BIT1) );
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableRxGCDX(void)
*
*   This function enables the QT Rx bit stuffer, GS and TRT.
*   It is used in sync frame handling in VDSL2 mode.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void EnableRxGCDX(void)
{
   uint32 ul_data;
   //modified 2/5/08

   // enable QT Rx bit stuffer, GS and TRT
   ul_data = MASK_BIT15 | MASK_BIT12 | MASK_BIT6;
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);
   ResetCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, MASK_BIT5);//disable TOT in QTP

   // enable TCM
   if (gft_RxTcmFlag)
   {
      SetCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, MASK_BIT25);
      SetCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, MASK_BIT1);    //Enable 1bit reorder in QTP for TCM mode
   }

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DisableRxGCDX(void)
*
*   This function disables the QT Rx bit stuffer, GS and TRT.
*   It is used in sync frame handling in VDSL2 mode.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/
void DisableRxGCDX(void)
{
   uint32 ul_data;
   //modified 2/5/08

   // disable QT Rx bit stuffer, GS and TRT.
   ul_data = MASK_BIT15 | MASK_BIT12 | MASK_BIT6;
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);
   //SetCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, MASK_BIT5);//enable TOT in QTP


   // disable TCM
   ResetCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, MASK_BIT25);
}

#ifndef QT_LATCH_LP_BITS

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeTxTransferSize(void)
*
*   This function computes the Tx DT size based on Lp and bits in fifo
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ComputeTxTransferSize(void)
{

   uint32 ul_data , ul_addr ;
#if MIPS_PROFILE_USRETX
   int32 l_RxTimer1, l_RxTimer2;
   int32 s_MIPS;
#endif
   // Disable the Zephyr for synch frame
   uint16 us_TransferSize[NUM_DATA_PATHS];

   // Disable the Zephyr for synch frame
   if ((gft_dbg_SkipTxSyncFrame == 0) && (gs_TxPMDFrameCount == (TX_DATA_SYMBOLS_PER_SUPERFRAME-1)))
   {
      // Clear Tx data transfer size
      WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR, 0); //Per port register
      WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR, 0);

      //Make length to zero for superframe processing for US ReTX
      //After data pump setup, this function will be called. Change to LP1 from LP0
      // ZEP_PRAM_ZT_OHRATE_LPx_ADDR
      WriteCoreReg(ZEP_PRAM_ZT_OHRATE_LP1_ADDR, 0);

      //31:16 ZT_R4 US ReTx Write Queue Length 2
      ul_addr = ZEP_PRAM_ZT_R4_LP1_ADDR;
      ReadCoreReg(ul_addr, &ul_data);
      ul_data &= 0x0000FFFF;
      //ul_data |= (uint32) ((0) << 16);
      WriteCoreReg(ul_addr, ul_data);

      //ZEP_PRAM_ZT_CRC0_LP0_ADDR
      WriteCoreReg(ZEP_PRAM_ZT_CRC1_LP1_ADDR, 0);
      //XDSLRTFW-1830 (START)
      //Stop processing TC layer data for sync symbol
      //Clear FP3 internal counter <31:24> and other bits of R12<23:0>
      WriteCoreReg(ZEP_PRAM_ZT_R12_LP1_ADDR, 0);

      //Clear FP4 internal counter <31:24>
      ResetCoreReg(ZEP_PRAM_ZT_FRAMING_LP1_ADDR, 0xFF000000);
      //XDSLRTFW-1830 (END)
      return;
   }

   // LP0 bit fifo
   us_TransferSize[LP0] = (uint16)((gt_tx_config_v2.ul_Lp[LP0] - ((gsa_TxBitsInFifo[LP0]>>8) & 0x7) + 7) >> 3);
   us_TransferSize[LP1] = (uint16)((gt_tx_config_v2.ul_Lp[LP1] - ((gsa_TxBitsInFifo[LP1]>>8) & 0x7) + 7) >> 3);

   ul_data = ((uint32)us_TransferSize[LP0] | (uint32)(us_TransferSize[LP1] << 16));
   WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR, ul_data); //Per port register
   WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR, ul_data);


   // round DTB_WAD address to next long word before each Zep run.
   ReadCoreReg(ZEP_PRAM_ZT_DTB_PTRS_LP0_ADDR, &ul_data);
   ul_data = (ul_data + (0x30000));
   ul_data &= 0xFFFCFFFF;
   WriteCoreReg(ZEP_PRAM_ZT_DTB_PTRS_LP0_ADDR, ul_data);

#if MIPS_PROFILE_USRETX
   //Read TX timer value
   ReadRxTimer(&l_RxTimer1);
#endif

   //XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start)
   if (gt_ReTXParams.uc_UsReTxStatus == US_RETX_IN_USE)
   {
      // round DTB_WAD address to next long word before each Zep run.
      ReadCoreReg(ZEP_PRAM_ZT_DTB_PTRS_LP1_ADDR, &ul_data);
      ul_data = (ul_data + (0x30000));
      ul_data &= 0xFFFCFFFF;
      WriteCoreReg(ZEP_PRAM_ZT_DTB_PTRS_LP1_ADDR, ul_data);

      //XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (Start_End)
      UsReTx_WrTCtoILV_RdILVtoDTB(us_TransferSize[LP1]);
   }

#if MIPS_PROFILE_USRETX
   ReadRxTimer(&l_RxTimer2);

   //Compute the MIPS for this task
   s_MIPS = (l_RxTimer2 - l_RxTimer1);

   if (s_MIPS < 0)
   {
      s_MIPS = (s_MIPS + gl_MaxRxTimerCnt);
   }

   if(s_MIPS > gl_mipsdebug2)
   {
      gl_mipsdebug2=s_MIPS;
   }
   gl_mipsdebug1= s_MIPS;
#endif

   //XDSLRTFW-1052 Feature_US_VDSL2_ALL_UsReTx_WrTCtoILV_RdILVtoDTB (End)


}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComputeRxDataTransferSize(void)
*
*   This function sets the data transfer size (in terms of bytes) for RX path
*   based on Lp and remaining bits in QT FIFO.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ComputeRxDataTransferSize(void)
{
   uint32 ul_data;
   uint16 us_TransferSize[NUM_DATA_PATHS];
//XDSLRTFW-2162 (Start)
   uint16 us_bytes;
   uint16 us_new_transfer;


   // compute the RX data transfer size = (Lp + fifo)/8
   us_TransferSize[LP0] = (uint16)((gt_rx_config_v2.ul_Lp[LP0] + ((gsa_RxBitsInFifo[LP0]>>8) & 0x7)) >> 3);
   us_TransferSize[LP1] = (uint16)((gt_rx_config_v2.ul_Lp[LP1] + ((gsa_RxBitsInFifo[LP1]>>8) & 0x7)) >> 3);

   ul_data = ((uint32)us_TransferSize[LP0] | (uint32)(us_TransferSize[LP1] << 16));
   WriteCoreReg(ZEP_REG_ZR_DT_SIZE_ADDR, ul_data); //Per port register
   WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, ul_data);



   if(gft_Intra_DTU_Ilv_DS == TRUE)
   {
      ReadCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR,&ul_data);
      if (gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME)
      {
         us_bytes = (ul_data & 0xFFFF0000) >> 16;
         us_bytes = us_bytes + gus_partial_DTU_bytes;
         gus_partial_DTU_bytes = us_bytes % gus_DTU_bytes;

         if ((gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt - 1   )) &&(gft_IDILV_DS_SRA_event == TRUE))
         {
            if(us_TransferSize[LP1] > gus_partial_DTU_bytes)
            {
               us_new_transfer = us_TransferSize[LP1] - gus_partial_DTU_bytes;
               WriteCoreReg(ZEP_REG_ZR_DT_SIZE_ADDR, ((ul_data & 0x0000FFFF)|(uint32)(us_new_transfer << 16)));
               WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, ((ul_data & 0x0000FFFF)|(uint32)(us_new_transfer << 16)));
               gus_partial_DTU_bytes = 0;
               gus_DTU_bytes = (uint16)(gt_ReTxShowtimeParams.s_Reconfig_Nfecp * gt_ReTxShowtimeParams.uc_CWsPerDtu_Q);
            }
            else
            {
               us_new_transfer = us_TransferSize[LP1] + gus_DTU_bytes - gus_partial_DTU_bytes;
               WriteCoreReg(ZEP_REG_ZR_DT_SIZE_ADDR, ((ul_data & 0x0000FFFF)|(uint32)(us_new_transfer << 16)));
               WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR,((ul_data & 0x0000FFFF)|(uint32)(us_new_transfer << 16)));
               gus_partial_DTU_bytes = 0;
               gus_DTU_bytes = (uint16)(gt_ReTxShowtimeParams.s_Reconfig_Nfecp * gt_ReTxShowtimeParams.uc_CWsPerDtu_Q);
            }
         }

      }
   }
//XDSLRTFW-2162 (End)
}


void CaptureTxBitsInFifo(void)
{
   int16 s_lp, s_ActBitsInFifo, s_ExpBitsInFifo, s_lp_x4;
   uint32 ul_data;

   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      s_lp_x4 = s_lp*4;

      if ((gft_dbg_SkipTxSyncFrame == 1) || (gs_TxPMDFrameCount != TX_DATA_SYMBOLS_PER_SUPERFRAME))
      {
         // read Lp and compute the expected # of bits in FIFO
         ReadCoreReg((uint32)(IRI_QT_REG_TX_LP0_BITS_ADDR + s_lp_x4), &ul_data);

         s_ExpBitsInFifo = 8 - (int16)(ul_data & 0x7);
      }
      else
      {
         // bit FIFO content shouldn't have been affected at sync frame
         s_ExpBitsInFifo = 0;
      }
      s_ExpBitsInFifo += (gsa_TxBitsInFifo[s_lp] >> 8) & 0x7;
      s_ExpBitsInFifo &= 0x7;

      // read the current bit FIFO content
      ReadCoreReg((uint32)(IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR + s_lp_x4), &ul_data);

      gsa_TxBitsInFifo[s_lp] = (int16)ul_data;
      s_ActBitsInFifo = (int16)(ul_data >> 8) & 0x7;

      // if does not match write bit FIFO with corrected value
      if (s_ActBitsInFifo != s_ExpBitsInFifo)
      {
         gs_txnumfailures++;

         // fix the number of bits left in FIFO, and keep the FIFO content as is
         gsa_TxBitsInFifo[s_lp] = (ul_data & 0xFF) | (s_ExpBitsInFifo << 8);

         // save PMD frame count & symbol count
         gs_dbg_TxPmdCnt_TxFifoErr = gs_TxPMDFrameCount;
         gl_dbg_TxSymCnt_TxFifoErr = gl_TxSymbolCount;
      }

      // write back the corrected value
      WriteCoreReg((uint32)(IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR + s_lp_x4), (uint32)gsa_TxBitsInFifo[s_lp]);

   } //for (s_lp=0;s_lp<NUM_DATA_PATHS;s_lp++)

} //void CaptureTxBitsInFifo(void)


void CaptureRxBitsInFifo(void)
{
   int16 s_lp, s_ActBitsInFifo, s_ExpBitsInFifo, s_lp_x4;
   uint32 ul_data;

   for (s_lp=0; s_lp<NUM_DATA_PATHS; s_lp++)
   {
      s_lp_x4 = s_lp*4;

      if ((gft_dbg_SkipRxSyncFrame == 1) || (gs_RxPMDFrameCount != RX_DATA_SYMBOLS_PER_SUPERFRAME))
      {
         // read Lp and compute the expected # of bits in FIFO
         ReadCoreReg((uint32)(IRI_QT_REG_RX_LP0_BITS_ADDR + s_lp_x4), &ul_data);

         s_ExpBitsInFifo = (int16)(ul_data & 0x7);
      }
      else
      {
         // bit FIFO content shouldn't have been affected at sync frame
         s_ExpBitsInFifo = 0;
      }
      s_ExpBitsInFifo += (gsa_RxBitsInFifo[s_lp] >> 8) & 0x7;
      s_ExpBitsInFifo &= 0x7;

      // read the current bit FIFO content
      ReadCoreReg((uint32)(IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR + s_lp_x4), &ul_data);

      gsa_RxBitsInFifo[s_lp] = (int16)ul_data;
      s_ActBitsInFifo = (int16)(ul_data >> 8) & 0x7;

      // if does not match write bit FIFO with corrected value
      if (s_ActBitsInFifo != s_ExpBitsInFifo)
      {
         gs_rxnumfailures++;

         // fix the number of bits left in FIFO, and keep the FIFO content as is
         gsa_RxBitsInFifo[s_lp] = (ul_data & 0xFF) | (s_ExpBitsInFifo << 8);

         // save PMD frame count & symbol count
         gs_dbg_RxPmdCnt_RxFifoErr = gs_RxPMDFrameCount;
         gl_dbg_RxSymCnt_RxFifoErr = gl_RxSymbolCount;
      }

      // write back the corrected value
      // for a sync frame, write back the previous value since bit FIFO content shouldn't have been affected
      WriteCoreReg((uint32)(IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR + s_lp_x4), (uint32)gsa_RxBitsInFifo[s_lp]);

   } //for (s_lp=0;s_lp<NUM_DATA_PATHS;s_lp++)
//XDSLRTFW-2162 (Start)
   if ((gs_RxPMDFrameCount == (gt_RxOLRPMVars.s_ReconfigSymCnt - 1   )) &&(gft_IDILV_DS_SRA_event == TRUE))
   {
      ReadCoreReg(IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR,&ul_data);
      WriteCoreReg(IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR, (ul_data & 0xFFFFF800));
      gsa_RxBitsInFifo[LP1] &= 0xFFFFF800;
   }
//XDSLRTFW-2162 (End)
} //void CaptureRxBitsInFifo(void)

#endif //#ifndef QT_LATCH_LP_BITS

/****************************************************************************
; Name: void UpdateNTR(void)

;
; Prototype:
;   void UpdateNTR(void)

;
; Description:
;   This function updates the NTR related registers based on received NTR byte
;   to help CPE lock with the CO NTR signal
;   The frequency offset derived from the NTR SRC register is given by
;   delta f = NTR offset/512
;   In other words, we get a shift in CPE generated NTR signal freq by 1 Hz when the NTR
;   SRC register value is offset by a value of 512
; Arguments:
;   N/A
;
; Return Value:
;   N/A
;
; Globals:
;
*****************************************************************************/


//MANT * 2^EXP = 4000 * 256 * 4/(414 * 257)
#define NRT_OFFSET_SCALE_MANT   (39421)
#define NRT_OFFSET_SCALE_EXP   (-10)


extern int16 gs_enable_ntr_drift_correction;
extern int32 gl_ntr_drift_correction_amount;
extern int32 gl_stu_count_212clocks;
extern int32 gl_ntr_drift_metric;

void NtrInterruptHandler(void);

extern int32 gl_rx_timer_val;

void UpdateNTR(void)
{

   uint32 ul_data;
   int32 l_data, l_data1;
   int16 s_RxByte;
   int16 s_exp, s_exp_num;
   int32 l_first_ntr_period;

   // Note for VR9 the functionality for reading the HW can be called
   // directly, rather than needing to be on a separate interrupt.
   // However kept the same name (for now)
   NtrInterruptHandler();

   // Do the sign extension for the signed NTR byte
   s_RxByte = (int16)( (signed char) guc_RxNTRByte );

   // Compliant systems uses NTR units of 35.328Mz or 70 MHz for 30a
   // However if we interoperate with our old system using 212 MHz clocks.
   // We would set the flag to true and can skip the scale adjust.
   if (gft_NTR_use_212_Clock_units == 0)
   {
      s_RxByte = s_RxByte * 3;
      if (gs_frame_rate_is_8khz==0)
      {
         s_RxByte = s_RxByte * 2 ;   // mul by 6 for 4 kHz frame rate.
      }
   }


   {
      // DEBUG Code
      if (gc_ntrLogControl & 1)
      {
         int32 l_NtrPhase ;
         ReadCoreReg(CRI_NTR_PHASE_ADDR, &l_NtrPhase);
         if (l_NtrPhase > 4416)
         {
            l_NtrPhase = l_NtrPhase - 4416;
         }

//Mei: prevent writing out of buffer
         if((gs_ntrLogPtr + 6) < (NTRLOG_SIZE+4))
         {
            gl_ntrLogBuffer[gs_ntrLogPtr++] = (s_RxByte <<8 | 0x00);
            gl_ntrLogBuffer[gs_ntrLogPtr++] = gl_stu_count_212clocks ;
            gl_ntrLogBuffer[gs_ntrLogPtr++] = gl_rx_timer_val;

            gl_ntrLogBuffer[gs_ntrLogPtr++] = gl_ntr_drift_metric;

            gl_ntrLogBuffer[gs_ntrLogPtr++] = l_NtrPhase ;
            gl_ntrLogBuffer[gs_ntrLogPtr++] = gl_db_accNTRByte;
         }
         if (gs_ntrLogPtr > NTRLOG_SIZE-1-6)
         {
            if (gc_ntrLogControl & 2 ) // No Rollover
            {
               gc_ntrLogControl = 2;   // clear lsb to disable.
            }
            else
            {
               gs_ntrLogPtr = 0;
            }
         }
      } //if
   } // local


   //Update the count of 212 MHz clocks with one frames worth of clocks.
   gl_stu_count_212clocks += ((6*(gs_RxFftLength+gs_RxCELength))>>gs_frame_rate_is_8khz); //6*(8192+16*40);

   //Period of first ntr cycle this frame, which will be a function of the
   //ntr ibits byte, if an ibits message was received this frame.
   l_first_ntr_period = 6*4416;

   if (gft_NTR_Rcvd == TRUE)
   {
      l_first_ntr_period += (int32)s_RxByte;
   }

   //Reduce the 212 MHz clocks count to reflect the first ntr cycle of this frame.
   if ((gft_NTR_Rcvd == TRUE)||(gl_stu_count_212clocks>=l_first_ntr_period))
   {
      gl_stu_count_212clocks -= l_first_ntr_period;
   }
   //Do the same for any additional ntr cycles that would occur this frame.
   //These cycles would always have period 6*4416.
   //The final value of gl_stu_count_212clocks will be the number of clocks that should
   //remain in the symbol, following the ntr clock edge, based on the NTR ibits messages.
   while (gl_stu_count_212clocks>=(6*4416))
   {
      gl_stu_count_212clocks -= (6*4416);
   }

   // Update NTR count every time a new NTR byte received
   if (gft_NTR_Rcvd == TRUE)
   {
      // Monitor statistics of the incoming NTR information.
      gl_db_accNTRByte += s_RxByte;
      gl_db_avgNTRByte -= gl_db_avgNTRByte >> 6;
      gl_db_avgNTRByte += s_RxByte << 6;

      // The frequency offset in Hz described by the received IBITS value is
      // given by
      // delta f = IBITS * 8000          IBITS * 8000 * Lp * fs
      //         -----------------   = ----------------------------------
      //           PERp * LTR freq      8 * PERBp * 211.968 * 10^6


      // Hence the freq offset needed to implement this on the CPE end is given by
      // NTR offset = delta f * (512 + correction), where correcton is decided
      // experimentally.

      // This can be simplified to the following relation
      //
      // NTR offset =   IBITS * Lp * fs * 512           IBITS * Lp * fs
      //              ----------------------------  = -------------------
      //                PERBp * 211.968 * 10^3        PERBp * 414
      //

      //In the following, we compute NTR offset multiplied by 4 to match
      //the precision of V_SRCFR_ADDR resgister
      //
      // NTR offset =   IBITS * Lp * fs * 4
      //              ----------------------
      //                PERBp * 414
      //
      // Since we currently only support fs = 4000*256/257 or 8000*256/257
      // we substitue fs (at 4khz) above to the equation and get
      //
      // NTR offset =   IBITS * Lp * 4000 * 256 * 4   IBITS * Lp * MANT * 2^EXP
      //               ---------------------------- = --------------------------
      //                 PERBp * 414 * 257            PERBp
      //
      // where MANT * (2^EXP) = 4000 * 256 * 4/(414 * 257) and they can be precomputed

      //Compute IBITS*MANT -----------------
      l_data = s_RxByte*(uint16)(NRT_OFFSET_SCALE_MANT+gs_correct);

      //normalize l_data
      s_exp = norm_l(l_data);
      l_data <<= s_exp;

      //compute the exponent of numerator
      s_exp_num = (int16)NRT_OFFSET_SCALE_EXP - s_exp;

      //for 8 kHz, increase the numeratory by factor of 2
      if(gs_frame_rate_is_8khz)
      {
         s_exp_num++;
      }

      //Decide how to down shift l_data to get the maximum precision

      //Compute the number of bits which can be used to represent l_data above
      //Note that the maximum number of bits used for Lp is 16 so the minimum
      //number of bits used by l_data is 15 (not include sign bit)
      //if Lp uses less than 16 bits, we can put more to l_data
      //In the following s_exp represents the number of bits that can be used
      //for l_data (not include sign bit)
      s_exp = norm_l((int32)gt_rx_config_v2.ul_Lp[0]);

      //Scale down l_data such that l_data*Lp will exactly use 31 bits (the maximum prevision)
      s_exp = 31-s_exp;
      l_data += 1<<(s_exp-1);
      l_data >>= s_exp;

      //Update the exponent of numerator
      s_exp_num += s_exp;

      //compute IBITS * Lp * MANT
      l_data = l_data * gt_rx_config_v2.ul_Lp[0];

      //Compute (Lp*IBITS*MANT)/PERBp
      l_data1 = l_data/gt_rx_config_v2.l_PERBp[0];

      if(s_exp_num >= 0)
      {
         l_data1 <<= s_exp_num;
      }
      else
      {
         //perform rounding
         s_exp_num = - s_exp_num;
         l_data1 += (1<<(s_exp_num-1));
         l_data1 >>= s_exp_num;
      }

      gl_NTR_Offset = l_data1;

      // clear flag to initiate RX NTR processing
      gft_NTR_Rcvd = FALSE;

   }
   else  //NOT (gus_ShowtimeControl & MASK_RX_NTR_PROC)
   {
   }

   // Read the SRCFR value (24 bits register)
   ReadCoreReg(V_SRCFR_ADDR, &ul_data);

   // ZR_NTRSRCFR
   l_data = -(int32)ul_data;

   l_data = l_data - gl_NTR_Offset;

   //Add the rounding error
   l_data += gl_NTRSRC_residual;

   //If NTR drift correction is enabled, adjust the NTRSRC frequency control
   //in the opposite direction of the drift, by the amount gl_ntr_drift_correction_amount.
   if ((gl_RxSymbolCount>1000) && (gs_enable_ntr_drift_correction==1))
   {
      if (gl_ntr_drift_metric>0)
      {
         l_data -= gl_ntr_drift_correction_amount;
      }
      else if (gl_ntr_drift_metric<0)
      {
         l_data += gl_ntr_drift_correction_amount;
      }
   }

   l_data1 = l_data;

   //Perform rounding
   l_data += 2;
   l_data >>= 2;

   //Update the rounding error
   gl_NTRSRC_residual = l_data1 - (l_data<<2);

   ul_data = (uint32)l_data;

   //This register is 22bits
   WriteCoreReg(CRI_NTR_SRCFR_ADDR, ul_data);

}




#include "zep_memmap_cnfg.h"

// we only support LP0/LP1 and 4 FIFO instances

#define FIFO_READY_MASK             (1 << 11)
#define FIFO_UPDATE_STATUS_MASK     (1 << 16)
#define FIFO_WRITE_MASK             (1 << 10)

#define FIFO_VALID_BYTES_MASK       ((2<<(29 - 17 + 1)) - 1)

extern volatile uint32 gul_ZrFifoSetupWait;
extern volatile uint32 gul_ZrFifoReadWait;
extern uint32 gul_ZrFifoValidBytes;

// this function will set up the access to the ZepRx FIFO_n
// it will return the number of valid bytes currently in the FIFO; this returned value
// is relavent if the access setup is for a FIFO READ.
uint32 SetUpZrFifo(int32 l_Fifo_n, int32 l_LP_n)
{
   int32 l_ZrFifoAccess;


   l_ZrFifoAccess = ((l_Fifo_n & 0x3) << 8) | ((l_LP_n & 0x1) << 12);

   // send UPDATE_STATUS command
   WriteCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, l_ZrFifoAccess | FIFO_UPDATE_STATUS_MASK);

   do
   {
      gul_ZrFifoSetupWait++;
      ReadCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, &l_ZrFifoAccess);
   }
   while (!(l_ZrFifoAccess & FIFO_READY_MASK));

   return(gul_ZrFifoValidBytes = (l_ZrFifoAccess >> 17) & FIFO_VALID_BYTES_MASK);
}


// SetUpZrFifo() must have been called prior to this function to make sure FIFO was ready for access
// and that there's at least one data byte in the FIFO.

uint32 ReadZRFifo(int32 l_Fifo_n, int32 l_LP_n, uint8 *puc_DataByte)
{
   int32 l_ZrFifoAccess;

   l_ZrFifoAccess = ((l_Fifo_n & 0x3) << 8) | ((l_LP_n & 0x1) << 12);

   // send READ command
   WriteCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, l_ZrFifoAccess);

   do
   {
      gul_ZrFifoReadWait++;
      ReadCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, &l_ZrFifoAccess);
   }
   while (!(l_ZrFifoAccess & FIFO_READY_MASK));

   *puc_DataByte = (uint8)(l_ZrFifoAccess & 0xFF);

   return(gul_ZrFifoValidBytes = (l_ZrFifoAccess >> 17) & FIFO_VALID_BYTES_MASK);
}


void SetUpDtuForwarding(void)
{
   WriteCoreReg(ZEP_PRAM_ZR_RETX_PARAM2_LP1_ADDR, gt_ReTXParams.Un_UcodeReTXParam2.l_ReTXParam2);

   // reset ILVB_RDPTR
   WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDPTR_LP1_ADDR, DTU_POINTERS_LW_BASE_ADDR);
}



void WriteRrcToLp2TxDTB(uint32 ul_PrevRrc)
{
   uint32 ul_data;
   WriteCoreReg((uint32)(ZEP_ILV_RAM_DTB_ADDR + (ZEP_ILV_RAM_TXDTB_LP2_BASE << 2)), ul_PrevRrc);
#if 1
   ReadCoreReg((uint32)(ZEP_ILV_RAM_DTB_ADDR + (ZEP_ILV_RAM_TXDTB_LP2_BASE << 2)), &ul_data);
   if (ul_data != ul_PrevRrc)
   {
      gul_TxRRC_corrupted_Cnt++;
   }

#endif
}
//#ifdef VR9_ERASURE
void ReadMetricValue(void)
{
   ReadCoreReg (IRI_QT_REG_RX_RMETRIC_VAL_ADDR, &gul_metric_value);
}
//#endif //VR9_ERASURE

//XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx(START)
/*
*-------------------------------------------------------------------------------
*
*   Prototype: void Update_TimeStamp_Register(void)
*
*   This function copies the  timestamp value or (number of Tx symbols)%255 to Register
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*-------------------------------------------------------------------------------
*/

void Update_TimeStamp_Register(void)
{
   uint32 ul_data;

   // read the register and copy the 32 bit data to ul_data
   ReadCoreReg(ZEP_PRAM_ZT_R4_LP1_ADDR, &ul_data);

   //modify only last 8 bit or timestamp byte
   ul_data = (ul_data & 0xFFFFFF00)| guc_TS_byte_Retx;      // 7:0  Time Stamp

   //update the  timestamp(TS) byte(last 8 bit or lsb) in the Register
   WriteCoreReg(ZEP_PRAM_ZT_R4_LP1_ADDR, ul_data);


}
//XDSLRTFW-1047 Feature_US_VDSL2_ALL_UsReTx(END)

// ERB computation
void Showtime_ERB_FCS32_Config(void)
{
   uint32 ul_data;

   ul_data = ZEP_RAM_ERB_RD_PTRS_LW_BASE_ADDR;
   WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDPTR_LP0_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZR_R4_LP0_ADDR, gus_ByteCounter_For_Reversing);  //No of bytes to be moved for CRC1 engine.

   //set the ERB data buffer starting address within IIBRAM excluding 0x40000, i.e subtract 0x40000 from actual IIBRAM
   //address, For Eg if ERB is at 0x70000, set as 0x30000
   //Init ERB read pointer table
   // REVIEW_STEFAN: mem alloc of gsa_ERBPartx
   // Which physical address range is allowed to be used for mem allocation of following variables?
   // gsa_ERB_Part0 / gsa_ERB_Part1
   // E.g. if their address is 0x20000 (still part of the IIBRAM) code will not work!
   // Why do we substract 0x40000?
   if (gft_ERB_Buffer_Selector == TRUE)
   {
      ul_data = (uint32)&gsa_ERB_Part0 - ZEP_RAM_IIBRAM_ADDR;
   }
   else
   {
      ul_data = (uint32)&gsa_ERB_Part1 - ZEP_RAM_IIBRAM_ADDR;
   }

   WriteCoreReg((ZEP_RAM_IIBRAM_ADDR + ZEP_RAM_ERB_RD_PTRS_BASE_ADDR), ul_data);
   WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDAD_LP0_ADDR, ul_data);
}

void Disable_Showtime_ERB_FCS32_Config(void)
{
   uint32 ul_data;

   ul_data = ZEP_RAM_ERB_RD_PTRS_LW_BASE_ADDR;
   WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDPTR_LP0_ADDR, ul_data);
   WriteCoreReg(ZEP_PRAM_ZR_R4_LP0_ADDR, 0); //No of bytes to be moved for CRC1 engine.
}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 CheckForLowPower(void)
*
*      Poll HW voltage monitor to detect LPR condition.  This is a
*   dummy function in Cocomo, though the gft_ForceLPR flag can be
*   used to force the LPR condition.
*
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*         0: Power OK
*         1: Low Power Indicator
*
*   Global Variables:
*
*-------------------------------------------------------------------------------


int16 CheckForLowPower(void)
{

#ifndef TARGET_COCOMO
   uint16 us_lowpower;
   uint32 ul_data;

   // Bit 15 of GPIO is a Low Power (LPR) Indicator (active low).
   // convert indicator to active high and return value.
   // Active high indicator is returned if LPR is present or,
   // for testing purposes, if ForceLPR flag is set.
   ul_data =GetDspReg(DSP_GPIO_CTRL);

   // Bit15 Controls direction of each individual GPIO pin. When a bit is '0', the corresponding GPIO pin is configured as an input
   ul_data &= ~(1<<15);
    //program Bit15 in the ctrl register
   SetDspReg(DSP_GPIO_CTRL, ul_data);

   //returns the state of the  GPIO pin 15 for low power mode.
   ul_data =GetDspReg(DSP_GPIO_DATA);
   us_lowpower = (ul_data &(1<<15))>>15;

   if ((us_lowpower == gus_LowPowerSetting ) || (gus_ForceLPR > 0) || (gus_SetLPR == 1) )
#else
    if (gus_ForceLPR > 0)

#endif //TARGET_COCOMO
   {
      if ( (gus_ForceLPR > 0) && (gus_ForceLPR < 0x7FFF))
      {
         gus_ForceLPR--;
      }
      return(1);
   }
   else
   {
      return(0);
   }

}

*/

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void TxSuperFrameProcess(void)
*
*   This function processes a Tx super frame.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------

void TxSuperFrameProcess(void)
{
    uint32 ul_data;

    // check if this frame is the end of superframe for INLV path
    ReadCoreReg((uint32)ZEP_REG_ZT_LP0_CFG_ADDR, &ul_data);
    if (ul_data & TX_SEQP_DONE0_BIT)
    {
        // perform superframe task for a given path
        TxSuperFrameTaskPerPath(INLV);
        // clear superframe done bit
        ResetCoreReg((uint32)ZEP_REG_ZT_LP0_CFG_ADDR, (uint32)TX_SEQP_DONE0_BIT);
    }

    // check if this frame is the end of superframe for FAST path
    ReadCoreReg((uint32)ZEP_REG_ZT_LP1_CFG_ADDR, &ul_data);
    if (ul_data & TX_SEQP_DONE1_BIT)
    {
        // perform superframe task for a given path
        TxSuperFrameTaskPerPath(FAST);
        // clear superframe done bit
        ResetCoreReg((uint32)ZEP_REG_ZT_LP1_CFG_ADDR, (uint32)TX_SEQP_DONE1_BIT);
    }
}
*/
