/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: show_lpbk_iof.c
*
*   This file contains engine interface functions used during showtime only
*   loopback tests.
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "cri_iof.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "ft_memmap.h"
#include "ftb_memmap.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "zep_ilv_memmap.h"
#include "show_lpbk_iof.h"
#include "cmv.h"
#include "profile.h"

#include <stdio.h>


#ifdef ENABLE_SHOW_LPBK

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ShowtimeLoopbackTC(void)
*
*   This function is used as time critical (TC) task for looping back data.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ShowtimeLoopbackTC(void)
{
#ifdef PROFILE_TASKS
   int16 s_Timer;
   //Record the TX TC task start time based on the RX timer
   s_Timer = LogTaskProfile(TX_SHOWTIME_TXTIMER_TC_START,0);
#endif //PROFILE_TASKS

   if (TESTArray[TEST_LoopbackMode] == TEST_LpbkAtDTB)
   {
      LoopbackAtDTB();
   }

   if ((TESTArray[TEST_LoopbackMode] == TEST_LpbkAtFFT) || (TESTArray[TEST_LoopbackMode] == TEST_LpbkAtQT))
   {
      LoopbackAtFFT();
   }

#ifdef PROFILE_TASKS
   //Record the TX TC task start time based on the RX timer
   LogTaskProfile(TX_SHOWTIME_TXTIMER_TC_END,s_Timer);
#endif //PROFILE_TASKS
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoopbackAtDTB(void)
*
*   This function loops back data from TxDTB to RxDTB.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


void LoopbackAtDTB(void)
{
} //void LoopbackAtDTB(void)

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void LoopbackAtFFT(void)
*
*   This function loops back data from IFFT to FFT.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void LoopbackAtFFT(void)
{
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetTxHwForLoopback(void)
*
*   This function disables TX buffer swap and IFFT engine for FFT loopback test.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void SetTxHwForLoopback(void)
{
   // disable IFFT
   ResetCoreReg(IRI_FT_REG_TX_CTRL_ADDR, MASK_BIT0);
   ResetCoreReg(IRI_FT_REG_TX_CTRL_A_ADDR, MASK_BIT0);

}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void SetRxHwForLoopback(void)
*
*   This function disables RX buffer swap and FFT engine for FFT loopback test.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void SetRxHwForLoopback(void)
{
   // disable RX buffer swap
//   SetCoreReg(IRI_FT_REG_RX_CTRL_ADDR, MASK_BIT8);
   // disable FFT
   ResetCoreReg(IRI_FT_REG_RX_CTRL_ADDR, (MASK_BIT0|MASK_BIT1));
   ResetCoreReg(IRI_FT_REG_RX_CTRL_A_ADDR, (MASK_BIT0|MASK_BIT1));

}


#endif // ENABLE_SHOW_LPBK
