/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: show_test_iof.c
*
*   This file contains engine interface functions used to test showtime
*   functionality.
*
*      Enable/DisableCorruptCRC
*
*-------------------------------------------------------------------------------
*/

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "IRI_Iof.h"
#include "LL_IOf.h"
#include "cri_iof.h"
#include "alp_memmap.h"
#include "cri_memmap.h"
#include "qt_memmap.h"
#include "zep_ilv_memmap.h"
#include "zep_memmap.h"
#include "zep_memmap_cnfg.h"
#include "show_iof.h"


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void EnableCorruptCRC(void)
*
*      This function programs the zephyr to send corrupt (inverted) CRCs
*   on both latency paths.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void EnableCorruptCRC(void)
{
   // Set BAD_CRC bits of ZT_R12_LPx_ADDR register
   SetCoreReg(ZEP_PRAM_ZT_R8_LP0_ADDR, TX_BAD_CRC_BIT);
   SetCoreReg(ZEP_PRAM_ZT_R8_LP1_ADDR, TX_BAD_CRC_BIT);
}

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void DisableCorruptCRC(void)
*
*      This function disables the corrupt CRC function, i.e. programs the zephyr to send
*   correct CRCs on both latency paths.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DisableCorruptCRC(void)
{
   // Set BAD_CRC bits of ZT_R12_LPx_ADDR register
   ResetCoreReg(ZEP_PRAM_ZT_R8_LP0_ADDR, TX_BAD_CRC_BIT);
   ResetCoreReg(ZEP_PRAM_ZT_R8_LP1_ADDR, TX_BAD_CRC_BIT);
}
