/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: sleep_iof.c
*
*   This file contains engine interface functions to used in sleep state.
*
*-------------------------------------------------------------------------------
*/


#include "common.h"
#include "gdata.h"
#include "qtp_memmap.h"
#include "str_memmap.h"
#include "ft_memmap.h"
#include "ftb_memmap.h"
#include "LL_IOf.h"


/****************************************************************************
; Name: SetUpTrainingSignal
;
; Prototype:
;   void SetUpTrainingSignal(void)
;
; Description:
;   This function sets up the hardware for generation of the TRAIN signal:
;
;      1. Place TX FT in Cascade Mode (trigger on QT done).
;      2. Set Copy Bit to copy over new GST
;      3. Set PRBS to reset after each frame.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
*****************************************************************************/

void SetUpTrainingSignal(void)
{
   uint32 ul_RegData;

   //QTP_TX_PRBS_MISC
   ul_RegData  = (10 << 4)   // d[n] = d[n-9] xor d[n-11] -> LFSR length = 11-1 = 10
                 | ( 0 << 9)   // do not rotate pilot tone
                 | ( 0 << 10)  // do not invert output of PRBS
                 | ( 1 << 11)  // Resets PRBS generator each frame.
                 | ( 4 << 12)  // Skip 4 bits at end of each symbol.
                 | ( 1 << 16)  // Pick PRBS output from head of LFSR
                 | ( 9 << 17)  // 1 less than the modulo number (=10) of tones for each tone set.
                 | ( 0 << 24)  // PRBS scrambling when 2 bit PRBS output is "00"
                 | ( 2 << 26)  // PRBS scrambling when 2 bit PRBS output is "01"
                 | ( 1 << 28)  // PRBS scrambling when 2 bit PRBS output is "10"
                 | ( 3 << 30); // PRBS scrambling when 2 bit PRBS output is "11"

   if(gft_ReverbSegue == SEGUE)
   {
      ul_RegData |= (1<<10);   //revert output of PEBS
   }

   SetCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, ul_RegData);

   // initialize PRBS state
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_ADDR, (uint32)0x7FF); // initial PRBS LFSR state
   WriteCoreReg(IRI_QTP_REG_TX_PRBS_POLY_ADDR, (uint32)0x0100); // d[n] = d[n-9] xor d[n-11] for QTP
}


/****************************************************************************
; Name: SetUpMedleySignal
;
; Prototype:
;   void SetUpMedleySignal(void)
;
; Description:
;   This function sets up the hardware for generation of the TRAIN signal:
;
;      1. Place TX FT in Cascade Mode (trigger on QT done).
;      2. Set Copy Bit to copy over new GST
;      3. Set PRBS to NOT reset after each frame.
;
; Arguments:
;   N/A
;
; Return Value:
;   N/A
*****************************************************************************/

void SetUpMedleySignal(void)
{
   gft_ReverbSegue = REVERB;
   SetUpTrainingSignal();

   // do not reset TX PRBS generator each frame.
   ResetCoreReg(IRI_QTP_REG_TX_PRBS_MISC_ADDR, (0x1 << 11)); // Do NOT reset TX PRBS generator each frame.

}

/*******************************************************************************
*
*   Prototype: void EnableTxToRxLoopback(void)
*
*   This function enables the loopback (TX to RX) at the Strymon and AFE interface.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

void EnableTxToRxLoopback(void)
{
   //Set the LPBK_TX_RX bit in the V_CONTROL_Register
   SetCoreReg((uint32)V_CONTROL_ADDR, (1<<19));
}

void DisableTxToRxLoopback(void)
{
   //Reset the LPBK_TX_RX bit in the V_CONTROL_Register
   ResetCoreReg((uint32)V_CONTROL_ADDR, (1<<19));
}

void EnableSerDesLoopback(void)
{
   //Set the LPBK_TX_RX bit in the V_CONTROL_Register
   SetCoreReg((uint32)V_SERDES_XBAR_ADDR, (1<<8));
}

void DisableSerDesLoopback(void)
{
   //Reset the LPBK_TX_RX bit in the V_CONTROL_Register
   ResetCoreReg((uint32)V_SERDES_XBAR_ADDR, (1<<8));
}

#ifdef BIT_PATTERN_TEST


void Disable_IFFT(void)
{
   //FT_TX_CTRL and FT_TX_CTRL register
   ResetCoreReg((uint32)IRI_FT_REG_TX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

   //FT_TX_CTRL_A and FT_TX_CTRL register
   ResetCoreReg((uint32)IRI_FT_REG_TX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

   //Disable IFFT_Reordering at QT interface
   SetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT17);
}

void Disable_FFT(void)
{
   // write inactive register
   ResetCoreReg((uint32)IRI_FT_REG_RX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

   //Disable FFT - write to active register
   ResetCoreReg((uint32)IRI_FT_REG_RX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

   //Disable FFT Reordering at strymon interface
   SetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT7);
}

void Enable_IFFT(void)
{
   //FT_TX_CTRL and FT_TX_CTRL register
   SetCoreReg((uint32)IRI_FT_REG_TX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

   //FT_TX_CTRL_A and FT_TX_CTRL register
   SetCoreReg((uint32)IRI_FT_REG_TX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

   //Enable IFFT_Reordering at QT interface
   ResetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT17);
}


void Enable_FFT(void)
{
   //Enable FFT
   SetCoreReg((uint32)IRI_FT_REG_RX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

   //Enable FFT
   SetCoreReg((uint32)IRI_FT_REG_RX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

   //Enable FFT Reordering at strymon interface
   ResetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT7);
}



void LoadBitPatternToIfftBuf(void)
{
   uint32 ul_regData, ul_offset, ul_data;
   int16 i;
   uint16 us_toneNumber, us_dci_starting_addr, us_dci_ending_addr;
   uint16 us_real =0, us_imag =0;

   //Put the DCI after the TX tone
   us_dci_starting_addr = gs_TxNumTonesUsed+2;


   ul_offset = IRI_QT_RAM_ACTIVE_BGTN_ADDR + ((gs_TxAbgtOffset+us_dci_starting_addr)<<2)-4;

   for(i=0; i<512; i++)
   {

      if (gus_BitPatternIndex == 1) //send ramp to find the path delay
      {
         us_real= i*2+1;
         us_imag = i*2+2;
      }
      else if (gus_BitPatternIndex == 2) //send a triangle
      {
         us_real = i*2 - 512;
         us_imag = i*2 + 1- 512;
      }
      else if (gus_BitPatternIndex == 3) //send a constant value
      {
         us_real = gus_BitPatternVal;
         us_imag = gus_BitPatternVal;
      }
      else if (gus_BitPatternIndex == 4) //send a single pulse
      {
         if(i == 0)
         {
            us_real = gus_BitPatternVal;
            us_imag = 0;
         }
         else
         {
            us_real = 0;
            us_imag = 0;
         }
      }

      ul_data = (us_imag<<16)|us_real;

      us_toneNumber = gs_BitPatternToneOffset + i;  //Get tone number first.

      //Start & end tone is the same because we only write to a single tone.
      ul_offset += 4;
      WriteCoreReg(ul_offset, (uint32) (us_toneNumber << 16 | us_toneNumber) );

      //Write a complex number to QT.
      ul_offset += 4;

      //Since this only writes one word, it's not need to use DMA
      //(Setting up DMA costs some overhead cycles)
      WriteCoreBuf32NoDMA(ul_offset, (int16 *)(void *)&ul_data, 1);
   }

   us_dci_ending_addr = ((ul_offset - IRI_QT_RAM_ACTIVE_BGTN_ADDR)>>2) - gs_TxAbgtOffset;

   ul_regData = ((us_dci_ending_addr<<13) | (us_dci_starting_addr<<1) | (1<<0));
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, ul_regData ); //Enable Direct Copy to IFFT in QT.

}


void DisableRxPRBS(void)
{
   WriteCoreReg(IRI_QT_REG_RX_DPRBS_MISC_ADDR, 0);
}
#endif  //BIT_PATTERN_TEST
