/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: zep_trn_iof.c
*
*   This file contains engine interface functions to used during training.
*
*-------------------------------------------------------------------------------
*/
//  zep_trn_iof.c
//
// History
//
//19/07/2013 Kannan: Changes to set the Tx Data pump setup
//Grep for "XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx"
//30/06/2014 Varun : Added suitable DTB settings function for US ReTx only feature
//                   Observed link drop due to less allocation of memory for LP0 in DTB in US ReTx only mode
//                   Grep for XDSLRTFW-1881
// ************************************************************************************************************

#include "common.h"
#include "gdata.h"
#include "zep_memmap_cnfg.h"


// these functions are in cache and will be called during OTPS processing.
void ReinitZepIlvHwVariablesForReTX(void)
{

   //Init. the base address of interleave/deinterleaver buffer
   // when ReTX selected, LP1 ILV-DILV size is bigger than LP0 ILV-DILV size
   // therefore, the base address of LP1 ILV-DILV will have to be changed.

   gula_txILVBaseAddr[LP0] = RETX_ZEP_ILV_LP0_BASE;
   gula_rxILVBaseAddr[LP0] = RETX_ZEP_DILV_LP0_BASE;
   gula_txILVBaseAddr[LP1] = RETX_ZEP_ILV_LP1_BASE;
   gula_rxILVBaseAddr[LP1] = RETX_ZEP_DILV_LP1_BASE;

   if(gft_NE_IlvDilvMemType == SEPARATE_ILV)
   {
      gul_HW_ILV_MEM_SIZE[LP0] = RETX_ZEP_ILV_LP0_BLOCK_SIZE;   // the maximum HW interleaver memory allowed to use
      gul_HW_DILV_MEM_SIZE[LP0] = RETX_ZEP_DILV_LP0_BLOCK_SIZE;// the maximum HW deinterleaver memory allowed to use
      gul_HW_ILV_MEM_SIZE[LP1] = RETX_ZEP_ILV_LP1_BLOCK_SIZE;   // the maximum HW interleaver memory allowed to use
      gul_HW_DILV_MEM_SIZE[LP1] = RETX_ZEP_DILV_LP1_BLOCK_SIZE;// the maximum HW deinterleaver memory allowed to use
   }
   else
   {
      gul_HW_ILV_MEM_SIZE[LP0] = RETX_ZEP_ILV_LP0_BLOCK_SIZE + RETX_ZEP_DILV_LP0_BLOCK_SIZE;
      gul_HW_DILV_MEM_SIZE[LP0] = gul_HW_ILV_MEM_SIZE[LP0];
      gul_HW_ILV_MEM_SIZE[LP1] = RETX_ZEP_ILV_LP1_BLOCK_SIZE + RETX_ZEP_DILV_LP1_BLOCK_SIZE;
      gul_HW_DILV_MEM_SIZE[LP1] = gul_HW_ILV_MEM_SIZE[LP1];
   }
}

void SetupDTBForReTX(void)
{
   gs_ZEP_DTB_SIZE_TX_WDS = RETX_ZEP_DTB_SIZE_TX_WDS;
   gs_ZEP_DTB_SIZE_RX_WDS = RETX_ZEP_DTB_SIZE_RX_WDS;

   gs_ZEP_ILV_RAM_TXDTB_OFFSET = RETX_ZEP_ILV_RAM_TXDTB_OFFSET;
   gs_ZEP_ILV_RAM_RXDTB_OFFSET = RETX_ZEP_ILV_RAM_RXDTB_OFFSET;

   gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE = RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE = RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE = RETX_ZEP_ILV_RAM_TXDTB_LP1_SIZE;

   //For DS Only ReTx case, DS LP1 carries the data channel, hence DTB Ping & Pong is done at LP1
   gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE = RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE = 0;
   gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE = RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE = RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE;
}

//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(START)
void SetupDTBForUsDsReTX(void)
{
   gs_ZEP_DTB_SIZE_TX_WDS = US_DS_RETX_ZEP_DTB_SIZE_TX_WDS;
   gs_ZEP_DTB_SIZE_RX_WDS = US_DS_RETX_ZEP_DTB_SIZE_RX_WDS;

   gs_ZEP_ILV_RAM_TXDTB_OFFSET = US_DS_RETX_ZEP_ILV_RAM_TXDTB_OFFSET;
   gs_ZEP_ILV_RAM_RXDTB_OFFSET = US_DS_RETX_ZEP_ILV_RAM_RXDTB_OFFSET;

   gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE = US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE = US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE = US_DS_RETX_ZEP_ILV_RAM_TXDTB_LP1_SIZE;

   //For US & DS ReTx case, DS LP1 carries the data channel, hence DTB Ping & Pong is done at LP1
   gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE = US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE = 0;
   gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE = US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE = US_DS_RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE;
}
//XDSLRTFW-1079 Feature_US_VDSL2_ALL_UsReTx(END)

//XDSLRTFW-1881(START)
void SetupDTBForUsReTxOnly(void)
{
   gs_ZEP_DTB_SIZE_TX_WDS = US_RETX_ONLY_ZEP_DTB_SIZE_TX_WDS;
   gs_ZEP_DTB_SIZE_RX_WDS = US_RETX_ONLY_ZEP_DTB_SIZE_RX_WDS;

   gs_ZEP_ILV_RAM_TXDTB_OFFSET = US_RETX_ONLY_ZEP_ILV_RAM_TXDTB_OFFSET;
   gs_ZEP_ILV_RAM_RXDTB_OFFSET = US_RETX_ZEP_ILV_RAM_RXDTB_OFFSET;

   gs_ZEP_ILV_RAM_TXDTB_LP0_SIZE = US_RETX_ZEP_ILV_RAM_TXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP2_SIZE = US_RETX_ZEP_ILV_RAM_TXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_TXDTB_LP1_SIZE = US_RETX_ZEP_ILV_RAM_TXDTB_LP1_SIZE;

   //DTB Ping Pong will be done in Rx LP0 path only, since LP0 alone carries both Data & OH data
   gs_ZEP_ILV_RAM_RXDTB_LP0_SIZE = US_RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP0_PONG_SIZE = US_RETX_ZEP_ILV_RAM_RXDTB_LP0_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP2_SIZE = US_RETX_ZEP_ILV_RAM_RXDTB_LP2_SIZE;
   gs_ZEP_ILV_RAM_RXDTB_LP1_SIZE = US_RETX_ZEP_ILV_RAM_RXDTB_LP1_SIZE ;
}
//XDSLRTFW-1881(END)

