/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   modem_hw.C
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "mtkernel.h"
#include "LL_IOf.h"
#include "cri_memmap.h"



int16 gs_InterruptSource;
int16 gs_InterruptEnableSource;
int16 gs_rxFrameInt, gs_txFrameInt;

/*****************************************************************************/
/* The following TCB_INDEX_xxx definitions specify the index         */
/* to index the Task Control Block (TCB) table.                     */
/*****************************************************************************/

#define NUMBER_OF_INTERRUPTS   24

#define TCB_INDEX_TX_BCR_DONE             0
#define TCB_INDEX_TX_FC_DONE               1
#define TCB_INDEX_TX_QT_DONE               2
#define TCB_INDEX_TX_FT_PREPROC_DONE       3
#define TCB_INDEX_TX_FT_IFFT_DONE          4
#define TCB_INDEX_TX_FT_PARR_DONE          5
#define TCB_INDEX_TX_FT_TXFRAME_DONE       6
#define TCB_INDEX_TX_CRI_TIMER             7
#define TCB_INDEX_TX_AAI_CELL_AVAILABLE    8
#define TCB_INDEX_TX_AAI_STATUS            9
#define TCB_INDEX_TX_QT_TXBAT_ERROR       10

/* RX interrupt mask constants */
#define TCB_INDEX_RX_FT_RXFRAME_DONE      11
#define TCB_INDEX_RX_FT_FFT_DONE          12
#define TCB_INDEX_RX_FT_POSTPROC_DONE     13
#define TCB_INDEX_RX_QT_DONE              14
#define TCB_INDEX_RX_FC_DONE              15
#define TCB_INDEX_RX_BCR_DONE             16
#define TCB_INDEX_RX_CRI_TIMER            17
#define TCB_INDEX_RX_AAI_CELL_AVAILABLE   18
#define TCB_INDEX_RX_AAI_STATUS           19
#define TCB_INDEX_RX_FC_NTR               20
#define TCB_INDEX_RX_QT_RXBAT_ERROR       21
#define TCB_INDEX_RX_FDF_DEC_DONE         22
#define TCB_INDEX_RX_FDF_AFE_BUSY         23

/*****************************************************************************
;   Prototype:  int16 DetectInterrupts(void)
;
;   This function detects interrupts generated by the HW cores.
;
;   Input Arguments: none
;
;   Output Arguments: none
;
;   Return:
;      0      no interrupts detected
;      1      interrupt detected
;
;   Global Variables:
;      gs_InterruptSource
;      gt_Iridia_Output
;
;****************************************************************************/
int32 sl_IntPriority[NUMBER_OF_INTERRUPTS*3] =
{


   /* Use the Socrates interrupt definitions for now until we update CRI and mtkernel */
   /* TX interrupts */
   1, (int32)CRI_MASK_RX_FC_NTR               ,(int32)(1 << RX_FC_NTR)               ,

   0, (int32)CRI_MASK_TX_BCR_DONE             ,(int32)TCB_INDEX_TX_BCR_DONE         ,
/////////      0, (int32)CRI_MASK_TX_FC_DONE              ,(int32)TCB_INDEX_TX_FC_DONE      ,
   0, (int32)CRI_MASK_TX_FC_DONE              ,(int32)(1 << TX_FC_DONE)            ,
   0, (int32)CRI_MASK_TX_QT_DONE              ,(int32)(1 << TX_QT_DONE)         ,
   0, (int32)CRI_MASK_TX_FT_PREPROC_DONE      ,(int32)TCB_INDEX_TX_FT_PREPROC_DONE      ,
/////////      0, (int32)CRI_MASK_TX_FT_IFFT_DONE         ,(int32)TCB_INDEX_TX_FT_IFFT_DONE         ,
   0, (int32)CRI_MASK_TX_FT_IFFT_DONE         ,(int32)(1 << TX_IFFT_DONE)            ,
   0, (int32)CRI_MASK_TX_FT_PARR_DONE         ,(int32)(1 << TX_PARR_DONE)       ,
/////////      0, (int32)CRI_MASK_TX_FT_TXFRAME_DONE      ,(int32)TCB_INDEX_TX_FT_TXFRAME_DONE      ,
   0, (int32)CRI_MASK_TX_FT_TXFRAME_DONE      ,(int32)(1 << TX_FRAME_START)         ,
/////////      0, (int32)CRI_MASK_TX_CRI_TIMER            ,(int32)TCB_INDEX_TX_CRI_TIMER            ,
   0, (int32)CRI_MASK_TX_CRI_TIMER            ,(int32)(1 << TX_TIMER_DONE)            ,
   0, (int32)CRI_MASK_TX_AAI_CELL_AVAILABLE   ,(int32)TCB_INDEX_TX_AAI_CELL_AVAILABLE  ,
   0, (int32)CRI_MASK_TX_AAI_STATUS           ,(int32)TCB_INDEX_TX_AAI_STATUS         ,
   0, (int32)CRI_MASK_TX_QT_TXBAT_ERROR       ,(int32)TCB_INDEX_TX_QT_TXBAT_ERROR      ,


   /* RX interrupts */
/////////      1, (int32)CRI_MASK_RX_FT_FFT_DONE          ,(int32)TCB_INDEX_RX_FT_FFT_DONE          ,
   1, (int32)CRI_MASK_RX_FT_RXFRAME_DONE      ,(int32)(1 << RX_FRAME_START)      ,
   1, (int32)CRI_MASK_RX_FT_FFT_DONE          ,(int32)TCB_INDEX_RX_FT_FFT_DONE         ,
/////////      1, (int32)CRI_MASK_RX_FT_POSTPROC_DONE     ,(int32)TCB_INDEX_RX_FT_POSTPROC_DONE     ,
   1, (int32)CRI_MASK_RX_FT_POSTPROC_DONE     ,(int32)(1 << RX_FFT_DONE)     ,
/////////      1, (int32)CRI_MASK_RX_QT_DONE              ,(int32)TCB_INDEX_RX_QT_DONE              ,
   1, (int32)CRI_MASK_RX_QT_DONE              ,(int32)(1 << RX_QT_DONE)              ,
/////////      1, (int32)CRI_MASK_RX_FC_DONE              ,(int32)TCB_INDEX_RX_FC_DONE              ,
   1, (int32)CRI_MASK_RX_FC_DONE              ,(int32)(1 << RX_FC_DONE),
   1, (int32)CRI_MASK_RX_BCR_DONE             ,(int32)TCB_INDEX_RX_BCR_DONE             ,
/////////      1, (int32)CRI_MASK_RX_CRI_TIMER            ,(int32)TCB_INDEX_RX_CRI_TIMER            ,
   1, (int32)CRI_MASK_RX_CRI_TIMER            ,(int32)(1 << RX_TIMER_DONE),
/////////      1, (int32)CRI_MASK_RX_AAI_CELL_AVAILABLE   ,(int32)TCB_INDEX_RX_AAI_CELL_AVAILABLE   ,
   1, (int32)CRI_MASK_RX_AAI_CELL_AVAILABLE   ,(int32)TCB_INDEX_RX_AAI_CELL_AVAILABLE,
   1, (int32)CRI_MASK_RX_AAI_STATUS           ,(int32)TCB_INDEX_RX_AAI_STATUS           ,
//      1, (int32)CRI_MASK_RX_FC_NTR               ,(int32)TCB_INDEX_RX_FC_NTR               ,
   1, (int32)CRI_MASK_RX_QT_RXBAT_ERROR       ,(int32)TCB_INDEX_RX_QT_RXBAT_ERROR       ,
   1, (int32)CRI_MASK_RX_FDF_DEC_DONE         ,(int32)TCB_INDEX_RX_FDF_DEC_DONE         ,
   1, (int32)CRI_MASK_RX_FDF_AFE_BUSY         ,(int32)TCB_INDEX_RX_FDF_AFE_BUSY


};


int16 DetectInterrupts(void)
{
   int16 i;
   int32 l_CriStatus0;

   /************************************************/
   /* Read CRI to get interrupt status            */
   /************************************************/

   ReadCoreReg(CRI_STATUS0_ADDR, &l_CriStatus0);

   gs_InterruptSource = 0;

   /* detect interrupt */
   for (i = 0; i < (NUMBER_OF_INTERRUPTS*3); i+=3)
   {
      int32 s_temp = sl_IntPriority[i];
      if ((l_CriStatus0 & sl_IntPriority[i+1])!=0)
      {
         gs_InterruptSource |= sl_IntPriority[i+2];
         if (s_temp == 0)
         {
            gs_rxFrameInt=1;
         }
         else
         {
            gs_txFrameInt=1;
         }
         /* clear interrupt */
         WriteCoreReg(CRI_STATUS0_ADDR, sl_IntPriority[i+1]);
         break;
      }
   }

#ifdef POLLING_CORE_INTERRUPTS
   // used for FD conn test
   gs_FDInterruptSource = gs_InterruptSource;
#endif

   return((int16) (gs_InterruptSource != 0));
}




/*****************************************************************************
;   Prototype:  DisableADSLInterrupts
;
;
;****************************************************************************/

void DisableADSLInterrupts()
{}

