/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;    Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;    Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;    File Name: hercules_memrymap.h
;
;    Header file for simext cocomo interface.
;   Note that all addresses are byte addresses!!!
;
*****************************************************************************/


//#ifndef TARGET_COCOMO
#ifndef _HERCULES_MP_H
#define _HERCULES_MP_H

#define HMP_VERSION                       0x1

#define HMP_HEADER_SIZE                   (4)        /* hercules MP header */
#define HMP_DESC_SIZE                     (4)        /* each descriptor is 4 32-bit words */
#define NUM_OF_HMP_DESC                   (1)

#define HMP_MBOX_HEADER_SIZE              (6)      // 16-bit words
#define HMP_MBOX_PAYLOAD_SIZE             (128)    // 16-bit words
#define HMP_MAX_FASTREAD_REQUEST          (HMP_MBOX_PAYLOAD_SIZE/3)
#define HMP_MBOX_SIZE                     (HMP_MBOX_HEADER_SIZE + HMP_MBOX_PAYLOAD_SIZE)

// mailbox code literals
#define QUERY_N_RESPONSE                (0x00)
#define AUTONOMOUS_MSG_NOTIFICATION    (0x01)
#define AUTONOMOUS_MSG_EVENT        (0x02)
#define AUTONOMOUS_MSG_ALARM        (0x04)
#define AUTONOMOUS_MSG_DEBUG        (0x08)
#define CODE_SWAP_REQUEST               (0x10)
#define FAST_READ_REQUEST           (0x20)

// autonomous message queue
#define AUTO_MSG_QUEUE_LENGTH          8

#define AUTO_MSG_QUEUE_OPERATION_SUCCESS  1
#define AUTO_MSG_QUEUE_FULL               2
#define AUTO_MSG_QUEUE_EMPTY           3



// buffer size for logging CW's issued by API; only available in 1-port mode due to memory usage.
#define HMP_LOG_BUF_SIZE        128

#endif /* _HERCULES_MP_H */
//#endif /* TARGET_COCOMO */
