/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       MP.H
*
*       Messaage Protocol Defines and Prototypes
*
*-------------------------------------------------------------------
*/

#ifndef NMP_H
#define NMP_H
#include "typedef.h"
#include <stdio.h>
#include "hmp_data.h"

/*****                               *****/
/*****                               *****/
/*****        constant definitions   *****/
/*****                               *****/
/*****                               *****/

//==============================================================================
// Function OP code definition
//==============================================================================

// Host-to-DSP messages (CMV mode)
#define H2D_CMV_READ                            0x00 /* 0000 0000b */
#define H2D_CMV_WRITE                           0x04 /* 0000 0100b */
#define H2D_CMV_INDICATE_REPLY                  0x10 /* 0001 0000b */

#define H2D_ERROR_OPCODE_UNKNOWN                0x20 /* 0010 0000b */
#define H2D_ERROR_CMV_UNKNOWN                   0x30 /* 0011 0000b */

// DSP-to-Host messages (CMV mode)
#define D2H_CMV_READ_REPLY                      0x01 /* 0000 0001b */
#define D2H_CMV_WRITE_REPLY                     0x05 /* 0000 0101b */
#define D2H_CMV_INDICATE                        0x11 /* 0001 0001b */

#define D2H_ERROR_OPCODE_UNKNOWN                0x21 /* 0010 0001b */
#define D2H_ERROR_CMV_UNKNOWN                   0x31 /* 0011 0001b */
#define D2H_ERROR_CMV_READ_NOT_AVAILABLE        0x41 /* 0100 0001b */
#define D2H_ERROR_CMV_WRITE_ONLY                0x51 /* 0101 0001b */
#define D2H_ERROR_CMV_READ_ONLY                 0x61 /* 0110 0001b */
#define D2H_ERROR_CMV_UNINITIALIZED_ENTRY       0x71 /* 0111 0001b */
#define D2H_ERROR_ILLEGAL_PAYLOAD_SIZE          0x81 /* 1000 0001b */
#define D2H_ERROR_OPERATION_TEMPORARILY_UNAVAIL 0x91 /* 1001 0001b */
#define D2H_ERROR_MBOXCODE_UNKNOWN              0xA1 /* 1010 0001b */
#define D2H_ERROR_RESOURCE_OCCUPIED             0xE5

// Host-to-DSP messages (Debug mode)
#define H2D_DEBUG_READ_DM                       0x02 /* 0000 0010b */
#define H2D_DEBUG_READ_PM                       0x06 /* 0000 0110b */
#define H2D_DEBUG_WRITE_DM                      0x0A /* 0000 1010b */
#define H2D_DEBUG_WRITE_PM                      0x0E /* 0000 1110b */
#define H2D_DEBUG_READ_EXT_DM                   0x12 /* 0001 0010b */
#define H2D_DEBUG_READ_EXT_PM                   0x16 /* 0001 0110b */
#define H2D_DEBUG_WRITE_EXT_DM                  0x1A /* 0001 1010b */
#define H2D_DEBUG_WRITE_EXT_PM                  0x1E /* 0001 1110b */

// DSP-to-Host messages (Debug mode)
#define D2H_DEBUG_READ_DM_REPLY                 0x03 /* 0000 0011b */
#define D2H_DEBUG_READ_PM_REPLY                 0x07 /* 0000 0111b */
#define D2H_DEBUG_WRITE_DM_REPLY                0x0B /* 0000 1011b */
#define D2H_DEBUG_WRITE_PM_REPLY                0x0F /* 0000 1111b */
#define D2H_DEBUG_READ_EXT_DM_REPLY             0x13 /* 0001 0011b */
#define D2H_DEBUG_READ_EXT_PM_REPLY             0x17 /* 0001 0111b */
#define D2H_DEBUG_WRITE_EXT_DM_REPLY            0x1B /* 0001 1011b */
#define D2H_DEBUG_WRITE_EXT_PM_REPLY            0x1F /* 0001 1111b */

#define D2H_ERROR_ADDR_UNKNOWN                  0x33 /* 0011 0011b */

#define D2H_CS_REQUEST                          0xEA
#define H2D_CS_COMPLETE                         0xEC
#define D2H_CS_COMPLETE                         0xED

#define BOOT_COMMAND_MASK                       0x0000FFF0
#define PAYLOAD_LEN_MASK                        0x0000000F

/* Our repertoire of commands...
*/
#define H2D_CS_PM_WR                            0xef
#define H2D_CS_PM_RD                            0xef
#define H2D_CS_DM_WR                            0xee
#define H2D_CS_DM_RD                            0xee

#define READ_MASK                               0xa000

#define READ_WRITE_ACCESS                       0
#define READ_ACCESS                             1
#define WRITE_ACCESS                            2
#define UNKNOWN_ADDRESS                         0x1

#define CNTLGroup                 1
#define STATGroup                 2
#define iNFOGroup                 3
#define TESTGroup                 4
#define OPTNGroup                 5
#define RATEGroup                 6
#define PLAMGroup                 7
#define CNFGGroup                 8
#define MONIGroup                 9
#define CNTRGroup                 10
#define ALGSGroup                 11
#define SELTGroup                 32
#define DSLGroup                  34


// an indirect CMV type should be masked with INDIRECT_CMV_TYPE_MASK
#define INDIRECT_CMV_TYPE_MASK    0x4000
#define NewCNTLType               0
#define NewSTAT_0_TypeI           ((int16)(INDIRECT_CMV_TYPE_MASK | 1))
#define NewSTAT_1_TypeI           ((int16)(INDIRECT_CMV_TYPE_MASK | 2))
#define NewSTAT_5_TypeI           ((int16)(INDIRECT_CMV_TYPE_MASK | 3))
#define NewSTATType               4
#define NewINFOTypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 5))
#define NewINFO2TypeI             ((int16)(INDIRECT_CMV_TYPE_MASK | 6))
#define NewTEST_25_TypeI          ((int16)(INDIRECT_CMV_TYPE_MASK | 7))
#define NewTESTType               8
#define NewOPTN_0_TypeI           ((int16)(INDIRECT_CMV_TYPE_MASK | 9))
#define NewOPTN_2_TypeI           ((int16)(INDIRECT_CMV_TYPE_MASK | 10))
#define NewOPTN_4_TypeI           ((int16)(INDIRECT_CMV_TYPE_MASK | 11))
#define NewOPTN_28_TypeI          ((int16)(INDIRECT_CMV_TYPE_MASK | 12))
#define NewOPTN_29_TypeI         ((int16)(INDIRECT_CMV_TYPE_MASK | 13))
#define NewOPTNType               14
#define NewRATETypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 15))
#define NewPLAMTypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 16))
#define NewCNFGTypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 17))
#define NewMONITypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 18))
#define NewCNTRTypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 19))
#define NewALGSTypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 20))
#define NewSELTTypeI              ((int16)(INDIRECT_CMV_TYPE_MASK | 21))
#define NewDSL_4_TypeI            ((int16)(INDIRECT_CMV_TYPE_MASK | 22))                 //XDSLRTFW-3705 (Start_End)
#define NewDSLTypeI               ((int16)(INDIRECT_CMV_TYPE_MASK | 23))

#define LAST_CMV_GROUP            (23)   // need changed when adding more CMV groups      //XDSLRTFW-3705 (Start_End)
                                         // was 19 =>19+1
//#define CUST_FIRST              0x10
//#define CUST_LAST               0x3F
// bit mask indicating if the cmv group is for customer use
#define CUST_CMV_GROUP_BIT_MASK   0x10

#define NEW_DICT_ENTRY_LENGTH     7
#define NEW_NUM_DICT_ENTRIES      (LAST_CMV_GROUP + 1)

#define NEW_DICT_SIZE             NEW_DICT_ENTRY_LENGTH * NEW_NUM_DICT_ENTRIES

//#ifdef TARGET_COCOMO
// NewMP message format
#define NEWMP_SIZE                (16)
//#endif

#define NEWMP_PAYLOAD_SIZE        (12)


/* Message Types */

typedef struct {
   int16 FunctionOpcodeAndSize;
   int16 GroupField;
   int16 AddrField;
   int16 IndexField;
   int16 PayLoad[NEWMP_PAYLOAD_SIZE];
} NewMPStruct;

/*****                              *****/
/*****                              *****/
/*****        function prototypes   *****/
/*****                              *****/
/*****                              *****/

int16 NewDecodeCMVBlockName(uint16 *, uint16 *, uint16 *);
int16 NewMPCheckMessage(void);
int16 NewMPInitialize(void);
void  NewMPSendMessage(int16, int16);
void  NewMPSetupReadyMessage(void);
int16 NewMPHandleMessage(void);
void  SendCodeSwapRequest(void);
int16 TxMailBoxPending(void);
void  ProcessTxMailbox(void);
void  CustomerHandleMessage(void);

/// Handle host mailbox in the background
/**
    If the DSP to host mailbox is available the next pending messages will be processed by it's priority. Priorities are:

    * Debug messages

    @param ptStatics pointer to port's persistent data structure
    @param Event the event that caused the background handler to be called

    @return A non zero value will tell the background thread to schedule the service again.
 */
void NMP_BgService(void);


/// Test for pending debug message
uint16 NMP_IsDebugMsgPending(void);

/// Set a debug message chunk to be sent asap.
/**
    All information is stored locally until the message could be sent

    @param StreamId     the stream id (1st payload word)
    @param SymCount     the global symbol counter value when registering the stream
    @param Crc16        a CRC16 over the stream data
    @param StreamStatus the stream's status field (2nd payload word)
    @param Length       debug stream message length in number of bytes
    @param pPayload     pointer to debug stream message payload data

    @return The function will return 0 if the message could be scheduled for transmission. A value < 0 idicates an error.
 */
int32 NMP_SendDebugMsg(uint16 StreamId, uint32 SymCount, uint16 Crc16, uint16 StreamStatus, uint16 Length, uint16 * pPayload);

void NMP_HandleDebugMsg( void );


// Allowed values for datatype/"bitsize" field of MP word 0.
#define HMP_RW_BYTE_DATA          0x0      // Read/write bytes.
#define HMP_RW_WORD_DATA          0x1      // Read/write 16-bit words.
#define HMP_RW_DWORD_DATA         0x2      // Read/write 32-bit doublewords.

//---------------------------------------
// Modem Ready Autonomous Message header
//---------------------------------------
#define MODEM_READY_HEADER_0      ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define MODEM_READY_HEADER_1      1
#define MODEM_READY_HEADER_2      ((0xFF << 8)|STATGroup)
#define MODEM_READY_HEADER_3      0
#define MODEM_READY_HEADER_4      1

//---------------------------------------
// Certain Autonomous Messages are in the
// format of unsolicited CMV reads.
// the following elements are part of
// their header.
//---------------------------------------
#define AUTO_MSG_CR_HEADER_0      ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_CR_HEADER_3      0

//---------------------------------------
// STAT0, STAT5 Autonomous Message headers:
//  The STAT 0 message may be sent on
//  selected macro state transitions.
//  If the macro state is FAIL, then
//  the STATE 5 message is also sent.
//---------------------------------------

// XDSLRTFw-3513 (Start)
#define AUTO_MSG_STAT0_HEADER_1     STAT_0_SIZE       /* size of CMV */
#define AUTO_MSG_STAT0_HEADER_2     (STATGroup)
#define AUTO_MSG_STAT0_HEADER_4     STAT_0_SIZE       /* length = size of CMV */
// XDSLRTFw-3513 (End)

#define AUTO_MSG_STAT5_HEADER_1      (10)      /* limit size to value published in API  */
#define AUTO_MSG_STAT5_HEADER_2      ((5 << 8)|STATGroup)
#define AUTO_MSG_STAT5_HEADER_4      (10)      /* limit size to value published in API */

//---------------------------------------
// PLAM0, PLAM1 Autonomous Message headers:
//  The PLAM 0,1 messages may be sent on
//  selected near-end,far-end showtime
//  failure conditions, e.g. LOS, LOM, etc.
//---------------------------------------
#define AUTO_MSG_PLAM0_HEADER_1      1      /* size of CMV */
#define AUTO_MSG_PLAM0_HEADER_2      (PLAMGroup)
#define AUTO_MSG_PLAM0_HEADER_4      1      /* length = size of CMV */

#define AUTO_MSG_PLAM1_HEADER_1      1      /* size of CMV */
#define AUTO_MSG_PLAM1_HEADER_2      ((1 << 8) | PLAMGroup)
#define AUTO_MSG_PLAM1_HEADER_4      1      /* length = size of CMV */

//---------------------------------------
// TR1 Rollover Autonomous Message header
//  like the Modem Ready message,
//  put this message in the form of
//  the STAT CMV read reply.
//---------------------------------------
#define AUTO_MSG_TR1_ROLLOVER_HEADER_0      ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_TR1_ROLLOVER_HEADER_1      1
#define AUTO_MSG_TR1_ROLLOVER_HEADER_2      ((0x80 << 8)|STATGroup)
#define AUTO_MSG_TR1_ROLLOVER_HEADER_3      0
#define AUTO_MSG_TR1_ROLLOVER_HEADER_4      1

//---------------------------------------
// PLAM2 Autonomous Message headers:
//  The PLAM 2 message may be sent on
//  selected near-end,far-end TR1
//  alarms (threshold exceeded).
//---------------------------------------

#define AUTO_MSG_PLAM2_HEADER_1      2      /* size of CMV */
#define AUTO_MSG_PLAM2_HEADER_2      ((2 << 8) | PLAMGroup)
#define AUTO_MSG_PLAM2_HEADER_4      2      /* length = size of CMV */
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [Start]
//---------------------------------------
// PLAM3, PLAM4 Autonomous Message headers:
//  The PLAM 3,4 messages may be sent on
//  selected OLR events for upstream and
//  downstream respectively
//---------------------------------------
#define AUTO_MSG_PLAM3_HEADER_1      1      /* size of CMV */
#define AUTO_MSG_PLAM3_HEADER_2      ((3 << 8) | PLAMGroup)
#define AUTO_MSG_PLAM3_HEADER_4      1      /* length = size of CMV */

#define AUTO_MSG_PLAM4_HEADER_1      1      /* size of CMV */
#define AUTO_MSG_PLAM4_HEADER_2      ((4 << 8) | PLAMGroup)
#define AUTO_MSG_PLAM4_HEADER_4      1      /* length = size of CMV */
// XDSRTFW-442: Feature_All_All_All_All_Vdsl2Sra [End]
//-----------------------------------------------
// MONI Autonomous Message headers:
//  The message may be sent when
//  retrieval of FE data is complete.
// INFO_FEDATA is the CMV address
//-----------------------------------------------
#define AUTO_MSG_INFO88_HEADER_2    ((INFO_FEDATA << 8) | iNFOGroup)

// Autonomous indication for overflow of Debug Stream Queue
#define AUTO_MSG_INF117_HEADER_0    ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_INF117_HEADER_1    4    // size of CMV
#define AUTO_MSG_INF117_HEADER_2    ((INFO_EVT_DBG_BUFFER_OVERFLOW << 8) | iNFOGroup)
#define AUTO_MSG_INF117_HEADER_3    0
#define AUTO_MSG_INF117_HEADER_4    4

// Autonomous Message containing Debug Stream content
#define AUTO_MSG_INF118_HEADER_0    ((HMP_RW_WORD_DATA << 14) | (D2H_CMV_READ_REPLY << 4))
#define AUTO_MSG_INF118_HEADER_2    ((INFO_EVT_DBG_DEBUG_STREAM << 8) | iNFOGroup)
#define AUTO_MSG_INF118_HEADER_3    0




//-----------------------------------------------
//  The message may be sent when the Clear Eoc msg
//  is transmitted or received or there is an error.
//  MONI_CLEAREOC_STATUS is the CMV address
//-----------------------------------------------
/* size of CMV in words */
#define AUTO_MSG_MONI11_HEADER_1    (sizeof(gt_MONI_CEocStat) / sizeof(uint16))
#define AUTO_MSG_MONI11_HEADER_2    ((MONI_CLEAREOC_STATUS << 8) | MONIGroup)
/* length = size of CMV */
#define AUTO_MSG_MONI11_HEADER_4    (sizeof(gt_MONI_CEocStat) / sizeof(uint16))

//L2_Back_Channel
/* size of CMV in words */
#define AUTO_MSG_MONI17_HEADER_1    (sizeof(gt_MONI_ErbMsg) / sizeof(uint16))
#define AUTO_MSG_MONI17_HEADER_2    ((MONI_EVT_DSM_ERRORVECTORREADY << 8) | MONIGroup)
/* length = size of CMV */
#define AUTO_MSG_MONI17_HEADER_4    (sizeof(gt_MONI_ErbMsg) / sizeof(uint16))

//-----------------------------------------------
//  The message may be sent when the Clear msg payload
//  is available
//-----------------------------------------------
#define AUTO_MSG_INFO82_HEADER_2    ((INFO_ME_HDLC_RxBuffer << 8) | iNFOGroup)

//---------------------------------------
//To send Bonding and TC type information
//---------------------------------------
#define AUTO_MSG_DSL14_HEADER_1     (sizeof(gus_DSL_TC_Status) / sizeof(uint16))
#define AUTO_MSG_DSL14_HEADER_2     ((14<<8 ) | DSLGroup )
#define AUTO_MSG_DSL14_HEADER_4     (sizeof(gus_DSL_TC_Status) / sizeof(uint16))

//---------------------------------------
// External Declarations
//---------------------------------------

extern HerculesMPStruct_t HMP_RxBuffer;
extern HerculesMPStruct_t HMP_TxBuffer;
extern HerculesMPStruct_t HMP_AutoBuffer;
extern HerculesMPStruct_t HMP_FastReadBuffer;
extern HerculesMPStruct_t HMP_CustomerMsgBuffer;

extern HMP_AutoMsgQueue_t gt_AutoMsgQueue;

extern HMP_DebugStreamMsg_t gt_DebugStreamMsg;

int16 SubmitAutoMsg(AutoMsgPayLoadEntry_t *pt_PayLoadEntry, uint16 us_MailboxCode, uint16 us_MsgWord0, uint16 us_MsgWord1, uint16 us_MsgWord2, uint16 us_MsgWord3, uint16 us_MsgWord4);
int16 GetNextAutoMsgQueueEntry(AutoMsgQueueEntry_t *pt_NewAutoMsg);
void NewMPSendAutoMessage(AutoMsgQueueEntry_t *pt_AutoMsg);

extern int16 *NewCMVBlockNamePtr[];

extern int16 gs_MPReturnOpcode;

#endif
