/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitModem_PowerUp.c
*
*   This file contains modem initialization for initial power up.
*
*-------------------------------------------------------------------------------
*/

// ***********************************************************************************************************
// InitModem_PowerUp.c
//
// History
//
// 01/02/2012 Kannan: Clear Bearer Channel selection, Link status and Rx data status bits
//                    before giving modem ready message.
//                    Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
//
// ************************************************************************************************************

#include "common.h"
#include "stateini.h"
#include "gdata.h"
#include "string.h"
#include "LL_IOF.h"
#include "CustomerTasks.h"
#include "eoc.h"
#include "str_memmap.h"

#include "AFED_Functions.h"
#include "vcpe_swap_index.h"
#include "cri_iof.h"    //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)

#include "xdma.h"
#include "aux_regs.h"
#include "dsp_regs_62.h"


void CustomerSetSwapEngineType(void);




void ClearDataPage(int32 l_PageIndex)
{
   int32 l_WordIndex;
   int32 *pl_Int32Ptr;

   pl_Int32Ptr = (int32 *)(__gta_SwapTable[l_PageIndex].l_FinalDestinationAddress);
   for (l_WordIndex = (__gta_SwapTable[l_PageIndex].l_SwapPageSizeInLong & 0x7FFFFFFF) - 1;
         l_WordIndex >= 0; l_WordIndex--)
   {
      pl_Int32Ptr[l_WordIndex] = 0;
   }
}

void InitDataPages(void)
{
   //zero out the following pages
   ClearDataPage(VDSL_ILVB_DM_ZBOOTPAGE);
   ClearDataPage(VDSL_AWRE_IBRAM_DM_ZBOOTPAGE );
   ClearDataPage(VDSL_X_RAM_DM_ZBOOTPAGE);
   ClearDataPage(VDSL_Y_RAM_DM_ZBOOTPAGE);
   ClearDataPage(VDSL_LOCAL_LD_ST_DM_ZBOOTPAGE);

   //load the following pages located within
   //memory regions not accessible to either the MEI DMA or XDMA engine
}

/*******************************************************************************
*
*   Prototype: void InitCodeSwap(void)
*
*   This function initializes variables used for codeswap.
*   It must be called prior to any codeswap activity or prior to
*   enabling interrupts.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*       gt_SwapControl
*
*******************************************************************************/
void InitCodeSwap(void)
{
   memset((void*)gt_SwapRequestQueue, 0, MAX_SWAP_REQUESTS*sizeof(SwapRequest_t));

   gt_SwapControl.uc_ActiveTransferIndex = 0;
   gt_SwapControl.uc_HwStatus = SWAP_HW_IDLE;

   // Call the function to select the SwapEngineType
   CustomerSetSwapEngineType();

   ReleaseXdmaLock();
}


void CommonInits(void)
{
   // init codeswap engine
   InitCodeSwap();
}



/*
*-------------------------------------------------------------------------------
*
*   Prototype: int16 InitModem_PowerUp(void)
*
*   This function initializes the modem after power up.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*      SUCCEED/FAIL
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/


int16 InitModem_PowerUp(void)
{
   gul_Afe_flowtest |=1;

   //Reset DFI BLOCK should be before AFE init. The reason is after AFE Config we are not suppose reset this
   //only RX.FIFO_RSTN should be done later
   //0x30C78C  V_DFI_BLOCK_RSTN_35B       DFI Block Reset Register      0x00000000  0x00000000  0x00000000  0x00000000
   //0x30C78C  V_DFI_BLOCK_RSTN_35B       DFI Block Reset Register      0x00070007  0x00070007  0x00070007  0x00070007
   WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00000000);
   //WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00070007);
   WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00070007);

   AFED_AnalogRegistersInit();
   gul_Afe_flowtest |=0x20;
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   //Need to initialize the PPE registers before sending modem ready message
   DFE_PPE_Shared_PPE_Reg_Init();
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

   InitModemTasks_PowerUp();


#ifdef CUSTOMER_TASKS
   InitCustomer_PowerUp();
#endif //CUSTOMER_TASKS

   //---------------------------------------------------------
   // Set G994.1 vendor information
   //---------------------------------------------------------

   /* CountryCode */
   gt_ne_VendorInformation.uca_CountryCode[1] = (uint8)gus_ne_CountryCode;
   gt_ne_VendorInformation.uca_CountryCode[0] = (uint8)(gus_ne_CountryCode >> 8);
   /* VendorID */
   gt_ne_VendorInformation.uca_VendorId[3] = (uint8)gul_ne_G994VendorID;
   gt_ne_VendorInformation.uca_VendorId[2] = (uint8)(gul_ne_G994VendorID >> 8);
   gt_ne_VendorInformation.uca_VendorId[1] = (uint8)(gul_ne_G994VendorID >> 16);
   gt_ne_VendorInformation.uca_VendorId[0] = (uint8)(gul_ne_G994VendorID >> 24);
   /* Vendor Specific Information */
   gt_ne_VendorInformation.uca_VendorSpecific[1] = (uint8)gus_ne_G994VendorSpecific;
   gt_ne_VendorInformation.uca_VendorSpecific[0] = (uint8)(gus_ne_G994VendorSpecific >> 8);

   //---------------------------------------------------------
   // Set G997.1 system vendor information
   //---------------------------------------------------------
   /* CountryCode */
   guca_ne_SystemVendorID[1] = (uint8)gus_ne_CountryCode;
   guca_ne_SystemVendorID[0] = (uint8)(gus_ne_CountryCode >> 8);
   /* VendorID */
   guca_ne_SystemVendorID[5] = (uint8)gul_ne_G994VendorID;
   guca_ne_SystemVendorID[4] = (uint8)(gul_ne_G994VendorID >> 8);
   guca_ne_SystemVendorID[3] = (uint8)(gul_ne_G994VendorID >> 16);
   guca_ne_SystemVendorID[2] = (uint8)(gul_ne_G994VendorID >> 24);
   /* Vendor Specific Information */
   guca_ne_SystemVendorID[7] = (uint8)gus_ne_G994VendorSpecific;
   guca_ne_SystemVendorID[6] = (uint8)(gus_ne_G994VendorSpecific >> 8);

   return (int16)SUCCEED;
}


