/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: InitModem_PreHandshake.c
*
*   This file contains modem initialization required for every link.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "codeswap.h"
#include "stateini.h"
#include "InitEngine_PreHandshake.h"
#include "cri_iof.h"
#include "CustomerTasks.h"
#include "cmv.h"
#include "mp.h"
#include "nmp.h"
#include "ModemMonitor.h"
#include "cnfg_task.h"

extern void SwapInPage(uint8 uc_SwapPageNum);
extern void ProcessCNTL00(void);
extern void ProcessWinHostConfigMsgs(void);

extern int16 gs_ExitConfigMsgs;
#ifdef DEBUG_FLOW_TEST
extern uint32 gul_dbg_flowtest;
#endif

void InitModem_PreHandshake(void)
{
   // Load xTC Reset-Page
   SwapInPage(VDSL_CUST_RESET_PM_BOOTPAGE);
   /* CUST_2 page is here loaded again for the case that the TEST state    */
   /* (DMT scope) is left by a soft reset and the xtc must be configured   */
   /* again afterwards. In the "normal" flow CUST_2 was already loaded     */
   /* in InitCustomer_PowerUp.                                             */
   SwapInPage(VDSL_CUST_2_PM_BOOTPAGE);

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x10000;
#endif
   /* ======================================================================= */
   /* Initialize Modem */
   /* ======================================================================= */

   // Initialize the task layer for the next connection
   InitModemTasks_PreHandshake();
#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x20000;
#endif

   // In case power down option is enabled, power down the AFE and DFE cores
   // to conserve standby power
   if (gft_PowerDownON != 0)
   {

      // Soft reset all the HW cores via CRI RST
      SoftResetCores();
#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x40000;
#endif
      // Call to InitEngine_PreHandshake(); will happen later after the ME has
      // configured the modem.
   }
   else
   {
      // Soft reset all the HW cores via CRI RST
      SoftResetCores();
#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x80000;
#endif
      // Initialize hardware (AFE and DFE cores)
      // Mei: this intialization is unnecessary for the HW test (at least for IFX)
      // However, it caused the problem in COCOMO test vdsl2_lpbk2_cpeshow.bat
      //InitEngine_PreHandshake();
   }


   // Swap in SRC coeffs to DILV buffer only after SoftResetCores() is called.
   // Otherwise, SoftResetCores() may reset the DILV buffer content.
   SwapInPage(VDSL_DILVB_DM_SWAPPAGE);

   // Swap in Hyb settings into QT Inactive fine gain memory.
   // The required hybrid settings will be saved once the
   // profile is known after handshake, Others will be ignored.
   SwapInPage(VDSL_HYB_COEFS_DM_SWAPPAGE);

   // for VDSL_62, this page contains some data needed for AFE initialization
   // these data used to be located in DILVB_DM_SWAPPAGE and were separated
   // into this page because their life span is over before SHOW_INIT
   SwapInPage(VDSL_XILVB_B4_SHOW_INIT_DM_SWAPPAGE);

   // for VDSL_62, this page contains STR_IIR_COEFS and ZEP_RXTX_UCODE
   // this page will be always available until early training
   // and will only available during SHOW_INIT if not in diag-link mode.
   SwapInPage(VDSL_IIR_COEFS_DM_SWAPPAGE);

#ifdef CUSTOMER_TASKS
   InitCustomer_PreHandshake();
#endif //CUSTOMER_TASKS

   {
      // Setup "Modem Reset" Message
      SetupResetMessage();
   }

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x100000;
#endif
   // no CNTL00 message handling before this point
   gft_AllowSoftReset = 1; // allow reset from this point on
   gft_IssueSoftReset = 0;
   gft_LinkInitiated = 0; // signal to enable CNTL_0_0_not0
   gft_RunPostGhsInit = 0; // force to run post GHS initialization at link start (for special mode)

   // =======================================================================
   // If gs_MONI_AutoRestart is off, or this point was reached following a
   // soft reset, then scan for MP messages to configure modem and
   // wait for 'Start' command
   // Note: the 'Start' command must be the last MP command processed.
   // =======================================================================
   if (((gs_MONI_AutoRestart & 0x1) == 0) || ((CNTLArray[0] & 0x000F) == 0))
   {
      {
         gs_ExitConfigMsgs = 0;
         while (gs_ExitConfigMsgs == 0)
         {
            ProcessWinHostConfigMsgs();
            ModemMonitor();

         }
      }
   }
   else
   {
      // Update CNTL 0 0 CMV when auto restart enabled
      // gs_prev_CNTL00 is set to either 2 (link start) or 8 (sleep mode)
      // the first time ProcessCNTL00 is called.
      CNTLArray[0] = gs_prev_CNTL00;

      ProcessCNTL00();
   }

   //need to be revisited



   ConfigureHwTest();

   /* ======================================================================= */
   /* Print trail file headers */
   /* ======================================================================= */

#ifdef CUSTOMER_TASKS
   if (gt_WatchdogTimerEnable)
   {
      /* Start the watchdog timer for soft reset in case of Firmware stuck . The watchdog is reset with every QT Done interrupt */
      WatchdogTimerStart();
   }
#endif //CUSTOMER_TASKS
}
