/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   LinkStart.c
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include <stdio.h>
#include <stdlib.h>
#include "cmv.h"
#include "cmv_data.h"
#include "cnfg_task.h"
#include "cri_ini.h"
#include "cri_iof.h"
#include "vdsl_state.h"
#include "codeswap.h"
#include "mtkernel.h"
#include "fifo.h"
#include "V_STR_IOf.h"   //XDSLRTFW-2794 (start - end)

#include "VR9_memorymap.h"

#include "vcpe_swap_index.h"

#include "InitEngine_PreHandshake.h"
void EnableCores_ForLinkStart(void);

/*^^^
*-------------------------------------------------------------------
*
*  void EnableInitialInterrupts(void)
*
*  Description:
*
*      This function enables the TX_QT_DONE and RX_QT_DONE
*       interrupts.
*
*-------------------------------------------------------------------
*^^^
*/


void InitCRI_ForLinkStart(void);
void EnableStrymon(void);

void EnableCores_ForLinkStart(void)
{
   if ((TESTArray[TEST_InitState] != TEST_GhsInitState) &&
       ((gs_frame_rate_is_8khz) || (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)))
   {
      Reconfig_CRI();
   }
   else
   {
      //Enable cores through CRI registers
      InitCRI_ForLinkStart();
   }

   //Take Strymon out of reset mode
   EnableStrymon();

   //XDSLRTFW-2794 (start)
   //This is required for Sleep state tests and COCOMO emulation, if 35B is enabled.
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, CfgSRCCTL);
   }
   //XDSLRTFW-2794 (end)

} //EnableCores_ForLinkStart()



/*^^^
*-------------------------------------------------------------------
*
*  void LinkStart(void)
*
*  Description:
*
*      This function uses the CMV's to configure the modem when
*   CNTL is used to start a link and G.HS IS the initial state
*   (i.e. during the normal modem mode of operation).
*
*
*-------------------------------------------------------------------
*^^^
*/
void LinkStart(void)
{

   // there's no compiler ifdef's around this, so that on we can run some test
   // on the real target hw.



   //Enable all the cores

   // For 6.2 build, hw_reset_isr() will enable time slot control by calling EnableTSC()
   // which will configure all cores  but doesn't start them.
   // The last thing to do is to enable the cores.
   //AddFunctionToFifo(gp_RxLoadingFunctionFifo, EnableCores_ForLinkStart);

   guc_PortActive = 2;



}


