/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   RunModem.sc
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "states.h"
#include "stateini.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "fifo.h"
#include "mtkernel.h"
#include "LL_IOf.h"
#include "vdsl_state.h"
#include "CustomerTasks.h"
#include "eoc.h"
#include "showtime.h"
#include "nmp.h"
#include "AFED_ReadWriteModify.h"

int16 gsa_BgTaskTimeHistogram[16+1];         // 0: 0-5 frames
// 1: 16-31 frames
// ...
// 16: 240-255 frames
// 17: 256+ frames
int32 gla_BgTaskFunctionHistogram[16+1];

#define BG_TASK_PROFILE_BELOW_256_FRAMES        0x000000F0
#define BG_TASK_PROFILE_ABOVE_256_FRAMES        0x7FFFFF00
#define ABOVE_256_FRAMES_INDEX                  16

PtrToFunc gpFa_BgTaskLogArray[TASK_LOG_ARRAY_SIZE];
int16 gs_BgTaskLogIdx = 0;

void UpdateBgProfile(int32 l_StartTime, int32 l_BgFunc)
{
   int32 l_ElapsedTime;

   // log BG task for debug purpose
   if (gs_BgTaskLogIdx < TASK_LOG_ARRAY_SIZE)
   {
      gpFa_BgTaskLogArray[gs_BgTaskLogIdx++] = (PtrToFunc)l_BgFunc;
      gs_BgTaskLogIdx &= (int16)(TASK_LOG_ARRAY_SIZE-1);
   }

   l_ElapsedTime = gl_RxSymbolCount - l_StartTime;
   if (l_ElapsedTime > 0)
   {
      if (l_ElapsedTime & BG_TASK_PROFILE_ABOVE_256_FRAMES)
      {
         gsa_BgTaskTimeHistogram[ABOVE_256_FRAMES_INDEX]++;
         gla_BgTaskFunctionHistogram[ABOVE_256_FRAMES_INDEX] = l_BgFunc;
      }
      else
      {
         gsa_BgTaskTimeHistogram[(l_ElapsedTime & BG_TASK_PROFILE_ABOVE_256_FRAMES) >> 4]++;
         gla_BgTaskFunctionHistogram[(l_ElapsedTime & BG_TASK_PROFILE_ABOVE_256_FRAMES) >> 4] = l_BgFunc;
      }
   }
   // else some RxSymbolCount has been reset while BG task was running.
}


/*****************************************************************************
;   Prototype:  int16 RunModem(void)
;
;   This subroutine is called to service interrupts (time-critical and
;   non-time-critical tasks) and to run background tasks. The state
;   machine is run as a non-time-critical task. Background tasks are
;   initiated by the state machine.
;
;   Input Arguments: none
;
;   Output Arguments: none
;
;   Return:
;      SUCCEED            - continue
;      FAIL            - stop/exit
;
;   Global Variables:
;      gs_RxState         - (I) current RX state
;      gs_RxDoneState      - (I) RX done state
;      gs_RxStopState      - (I) TX stop state
;      gs_RxNextState      - (I) RX next state
;      gs_TxState         - (I) current TX state
;      gs_TxDoneState      - (I) TX done state
;      gs_TxStopState      - (I) TX stop state
;      gs_RxNextState      - (I) TX next state
;
;****************************************************************************/

int16 RunModem(void)
{
   int32 l_StartTime;

   gs_BgDbgCnt1++;

#ifdef POLLING_CORE_INTERRUPTS
   /* ================================================================================ */
   /* Service interrupts and run state machine.                              */
   /* ================================================================================ */
   MasterIntHandler();

   // VDSL_62 MasterIntHandler will execute the ForeGround directly.
#endif


   /* =============================================================================== */
   /*  BackgroundTask processing */
   /* =============================================================================== */

   // If there are pending Background processes, run them here

#ifdef CUSTOMER_TASKS
   CustomerBgTaskManager();
#endif // CUSTOMER_TASKS

   while(RemoveFunctionFromBkgdFifo(gp_BGTaskFifo, &gpF_BgTask))
   {
      l_StartTime = gl_RxSymbolCount;
      gs_BGStateID = BG_TASK_START;
      (*gpF_BgTask)();
      gs_BGStateID = BG_TASK_END;
      UpdateBgProfile(l_StartTime, (int32)gpF_BgTask);
      ClearLpEndReg;                  // do this after each BG Task to make sure that
      // hardware loop usage resets
      gs_BgDbgCnt2++;
   }


   // VDSL2 EOC Processing
   if ((gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2) &&
         !(gul_dbgShowtimeControl & DISABLE_EOC_OVHD_MESSAGING))
   {
      // Rx Overhead Processing - after both Tx and Rx are in showtime
      if (gus_ShowtimeControl & MASK_TX_RX_SHOWTIME)
      {
         AddFunctionToBkgdFifo((PtrToFunc)RxOvhdProcessor);
      }

      // Tx Overhead Processing - after SHOW2 page is brought in
      if (gus_ShowtimeControl & MASK_SHOW_2_PAGE_LOADED)
      {
         AddFunctionToBkgdFifo((PtrToFunc)TxOvhdProcessor);
      }
   }

   //only execute when debug streaming is enabled
   if((gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK) == TRUE)
   {
      // XDSLRTFW-2701 Make sure we leave sufficient space in BGTaskFifo and do not flood it with debug stream tasks to avoid E_CODE_BKGD_FIFO_ADD_EXCEPTION
      // 5 was the BGTaskFifio size before debug streams were implemented, so make sure this space is always reserved
      if (gp_BGTaskFifo->PendingFunctionCount < (NUM_BG_BUFFERS-5))
      {
         if (gus_RequeueBGFunction & DSH_REQUEUE_DSH_BG_SERVICE)
         {
            gus_RequeueBGFunction &= ~DSH_REQUEUE_DSH_BG_SERVICE;
            AddFunctionToBkgdFifo((PtrToFunc)DSH_BgService);
         }
         if (gus_RequeueBGFunction & DSH_REQUEUE_NMP_BG_SERVICE)
         {
            gus_RequeueBGFunction &= ~DSH_REQUEUE_NMP_BG_SERVICE;
            AddFunctionToBkgdFifo((PtrToFunc)NMP_BgService);
         }
      }
      else
      {
         // we ran out of space, keep track of this event
         gus_Dbg_DSH_skip_BGF_add++;
      }
   }

   return 1;
}


