/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2004 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       One Oak Park, Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       cnfg_Dfe.c
*
*       Configure Task Layer
*
*-------------------------------------------------------------------
*/


/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "gdata.h"
#include "mul.h"
#include "cmv.h"
#include "V_STR_IOf.h"

/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void ConfigDfeParam(int16 s_n)
*
*   Description:
*
*      This function initializes the Digital Front End (DFE) parameters
*   such as FFT/IFFT size, TX/RX number of tones, windowing related parameters etc.
*
*   Global Variables:
*      gs_TxLog2IfftLength    - (I) log2 of TX IFFT size
*      gs_RxLog2FftLength     - (I) log2 of RX FFT size
*      gs_TxNumTones          - (O) no. of TX tones
*      gs_TxIfftLength        - (O) TX IFFT size
*      gs_RxNumTones          - (O) no. of RX tones
*      gs_RxIfftLength        - (O) RX FFT size
*      gs_TxCELength          - (O) length of TX cyclic extension
*      gs_RxCELength          - (O) length of RX cyclic extension
*      gs_TxCPLength          - (O) length of TX cyclic prefix
*      gs_RxCPLength          - (O) length of RX cyclic prefix
*      gs_TxCSLength          - (O) length of TX cyclic suffix
*      gs_RxCSLength          - (O) length of RX cyclic suffix
*      gs_TxBetaLength        - (O) length of the TX overlapped sample window
*      gs_RxBetaLength        - (O) length of the RX overlapped sample window
*-------------------------------------------------------------------
*^^^
*/
void ConfigDfeParam(void)
{
   int16 s_temp;
   int32 l_Acc;

   //==============================================
   //Set TX parameters (Upstream)
   //==============================================
   gs_TxIfftLength = 1<<gs_TxLog2IfftLength;
   gs_TxNumTones = gs_TxIfftLength>>1;

   // Compute CELength = m*N/32
   s_temp = gs_TxNumTones>>5;
   MULS16(l_Acc, gs_m, s_temp);
   gs_TxCELength = (int16)l_Acc;

   // Compute BetaLength
   // Tx beta length shall be the same length as windowing length
   {
      s_temp = TX_WINDOW_LENGTH;                       //= 240
      // XDSLRTFW-2489
      if(gs_DbgRecnfgCpCsBeta & TX_CP_CS_BETA_BDCM_EN)
      {
         s_temp = TX_WINDOW_LENGTH_BDCM;               //=128;
         memcpy(&gsa_WindowCoeffs[0], &gsa_WindowCoeffsBrcm[0], sizeof(uint16)*TX_WINDOW_LENGTH_8K_IFFT_BDCM/2);
      }
      if (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192)
      {
         // Belongs to GHS / O-PRM CO reported IFFT value, which is at end equal to RX FFT used.
         s_temp <<= 1;                      // = 480 = TX_WINDOW_LENGTH_8K_FFT
                                            // = 256 = TX_WINDOW_LENGTH_8K_FFT_BDCM
      }
      gs_TxWindowLength = s_temp;

      if(gft_DisableTxWin == TRUE)
      {
         gs_TxWindowLength = 0;
      }

      // Write Coeffs according to gs_TxWindowLength to HW
      WriteWindowingCoefficients(TX,gs_TxWindowLength);

      // beta (overlap in samples) shall be equal to the receive windowing length
      gs_TxBetaLength = gs_TxWindowLength;
   }

   //Compute CPLength = (CELength + Beta)/2
   {
      s_temp = gs_TxCELength + gs_TxBetaLength;
      gs_TxCPLength = s_temp >> 1;
      // XDSLRTFW-2489
      if(gs_DbgRecnfgCpCsBeta & TX_CP_CS_BETA_BDCM_EN)
      {
         gs_TxCPLength -= gs_TxBetaLength;
      }
   }

   //For test purpose, CP and Beta can be configured externally
//   if(gs_DbgRecnfgCpCsBeta & TX_CYCLIC_EXTENSION_DBG_EN)
   {
      //must less than 240
      if(gs_DbgTxBetaLength >= 0)
      {
         gs_TxBetaLength = gs_DbgTxBetaLength;
      }
      if(gs_DbgTxCPLength >= 0)
      {
         gs_TxCPLength = gs_DbgTxCPLength;
      }
      if(gs_DbgTxCSLength >= 0)
      {
         gs_TxCSLength = gs_DbgTxCSLength;
         gs_TxCELength = gs_TxCPLength + gs_TxCSLength - gs_TxBetaLength;
      }
   }

   gs_TxCSLength = gs_TxCELength - gs_TxCPLength + gs_TxBetaLength;

   //==============================================
   //Set RX parameters (Downstream)
   //==============================================
   gs_RxFftLength = 1<<gs_RxLog2FftLength;
   gs_RxNumTones = gs_RxFftLength>>1;

   //Compute CELength = m*N/32
   s_temp = gs_RxNumTones>>5;
   MULS16(l_Acc, gs_m, s_temp);
   gs_RxCELength = (int16)l_Acc;

   // Compute Rx "beta" overlap.
   // This needs to fit to the CO "Tx window length" (beta).
   // - beta < L_CP
   // - beta > L_CS
   // - The maximum value of beta should be
   //     = min(N/16, 255)= min(2N/32, 255) for VDSL2
   //     = min(N/16, 510)= min(2N/32, 510) for VDSL2,AnxQ (35b)
   {
      gs_RxBetaLength = gs_RxFftLength >> 5;

      s_temp = 255;
      if (gs_RxLog2FftLength > DS_LOG2_FFT_LENGTH_8192)
      {
         s_temp <<= 1;
      }
      if (gs_RxBetaLength > s_temp)
      {
         gs_RxBetaLength = s_temp;
      }

      // Add this check is because the length of message fields for beta is only 1 byte
      // only can send the maximum value of 255 or new coding of 1byte for 35b of 510.
      // Also, the TX windowing coefficient table we used is only 240/480 entries
      // Pick 240 for Beta length is mainly to match to our CO's setting
      // In practice, CO and CPE do not have to use the same beta length.
      s_temp = RX_WINDOW_LENGTH;              //= 240
      // XDSLRTFW-2489
      if(gs_DbgRecnfgCpCsBeta & RX_CP_CS_BETA_BDCM_EN)
      {
         s_temp = RX_WINDOW_LENGTH_BDCM;     //= 128;
      }
      if (gs_RxLog2FftLength > DS_LOG2_FFT_LENGTH_8192)
      {
         // Belongs to GHS / O-PRM CO reported IFFT value, which is at end equal to RX FFT used.
         s_temp <<= 1;                      // = 480 = RX_WINDOW_LENGTH_8K_FFT
                                            // = 256 = RX_WINDOW_LENGTH_8K_FFT_BDCM
      }

      // beta min-operation (see above)
      if(gs_RxBetaLength > s_temp)
      {
         gs_RxBetaLength = s_temp;
      }
   }

   //Compute CP length = (CELength + Beta)/2
   {
      s_temp = gs_RxCELength + gs_RxBetaLength;
      gs_RxCPLength = s_temp >> 1;

      // XDSLRTFW-2489
      if(gs_DbgRecnfgCpCsBeta & RX_CP_CS_BETA_BDCM_EN)
      {
         gs_RxCPLength -= gs_RxBetaLength;
      }
   }

   // For test purpose, CP and Beta can be configured externally
//   if(gs_DbgRecnfgCpCsBeta & RX_CYCLIC_EXTENSION_DBG_EN)
   {
      //must less than 240
      if(gs_DbgRxBetaLength >= 0)
      {
         gs_RxBetaLength = gs_DbgRxBetaLength;
      }
      if(gs_DbgRxCPLength >= 0)
      {
         gs_RxCPLength = gs_DbgRxCPLength;
      }
      if(gs_DbgRxCSLength >= 0)
      {
         gs_RxCSLength = gs_DbgRxCSLength;
         gs_RxCELength = gs_RxCPLength + gs_RxCSLength - gs_RxBetaLength;
      }
   }

   gs_RxCSLength = gs_RxCELength - gs_RxCPLength + gs_RxBetaLength;


   // RX windowing for RFI
   // !!! Note: This is not equal Rx "beta" overlap, which is for the symbol length!!!!
   // ----------------
   s_temp = RX_WINDOW_LENGTH;             // = 240
   // XDSLRTFW-2489
   if(gs_DbgRecnfgCpCsBeta & TX_CP_CS_BETA_BDCM_EN)
   {
      s_temp = RX_WINDOW_LENGTH_BDCM;
   }
   if (gs_RxLog2FftLength > DS_LOG2_FFT_LENGTH_8192)
   {
      //For 8K FFT we use 480 samples Rx windowing length (double sample rate compared to 4K FFT)
      s_temp <<= 1;                      //= 480 = RX_WINDOW_LENGTH_8K_FFT
                                         //= 256 = RX_WINDOW_LENGTH_8K_FFT_BDCM
   }
   gs_RxWindowLength = s_temp;


   if(gs_DbgRxWindowLength > 0)
   {
      //For test purpose, CP and Beta can be configured externally
      gs_RxWindowLength = gs_DbgRxWindowLength;
   }
   else if(gft_DisableRxWin == TRUE)
   {
      gs_RxWindowLength = 0;
   }
   else
   {
      // XDSLRTFW-2489
      if(gft_ReduceChDiscoveryRxWindowLength == TRUE)
      {
         gs_RxWindowLength = gs_RxWindowLength>>1;
      }
   }
   // Write Coeffs according to gs_RxWindowLength to HW
   WriteWindowingCoefficients(RX,gs_RxWindowLength);
}
