/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;   File Name: cnfg_task_postGhs.c
;
;   Configures Task Layer post-handshake.
;
*****************************************************************************/
//*****************************************************************************
// cnfg_task_postGhs.c
//
// History
//
//   XDSLRTFW-475 PERF_DS_ALL_ALL_CEILING_OPT_17A
//     Controlled by CMV INFO 232 1 Bit 0x0002
//     Enabling the Ceiling Optimization only for Short Loops where issue was seen
//
// 18/2/2013 Vinjam: Corrected enabling of upstream & downstream bitswaps as per VRx Msg Spec using "CMV OPTN 15"
//           Grep for XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl
// 11/10/2013 SNV: Fix for RFI band above 4K tones
//            Grep for XDSLRTFW-1113 : BUG_DS_ALL_ALL_RFI_BAND_MEMORY_CORRUPTION
// 08/01/2014 Fuss: Corrected the number of 30MHz profile hybrids
//            Grep for XDSLRTFW-1465
// 15/01/2014 Kannan: Added test cmv TEST 28 0 0x0800 to disable US ReTx & to indicate the extended ILV mem size
//                    for 30Mhz profiles. it is enabled by default
//                    This is applicable if 30Mhz, IFX CO's.
//                    Grep for XDSLRTFW-1495
// 03/02/2014 Fuss: Low DS-rate on long loops for vectoring compared to non-vectoring
//            Grep for XDSLRTFW-1542
// 24/02/2014 Kannan: Changed US0 switching point for 12a oISDN
//                    Grep for XDSLRTFW-1536
// 21/03/2014 Kannan: Changed related to XDSLRTFW-1536 is reverted since
//                    HLOG & LATN measurement is corrected for 12A oISDN profile.
// 11/08/2014 Fuss: Hybrid setting Clean-up and integrated HybridGain to the Hybrid setting tables
//            Grep for XDSLRTFW-1488
// 11/08/2014 Fuss: calibration of BJ Hybrid and oPOTS config
//            Grep for XDSLRTFW-1898
//
// 12/09/2017 Hanyu Ported Bhadra's code: Dsiabled IMPROVED ATTNDR METHOD Amd2 for CNXT CO vendor ID to avoid training failure against EVLT-F/CNXT.
//            Grep for: XDSLRTFW-3470 XDSLRTFW-2724 IOP_A_DS_VDSL2ReTx_EVLT_F_ATTNDR_Amd2
//
// 12/09/2017 Hanyu Ported Bhadra's code: Disabled PILOT_SWITCH_IN_SHOWTIME for EVLT-F/CNXT DSLAM to avoid link drop in Showtime.
//            Grep for: XDSLRTFW-3470 XDSLRTFW-2723 IOP_A_DS_VDSL2_CNXT_ShowTimePilotSwitch
//
// 14/09/2017 Hanyu: IOP fixes against EVLT-F/CNXT in A8D profile
//   1. IOP adjustment to reduce estimated KL0 from loop length ~2800ft to ~3800ft to connect to showtime.
//   2. Switched to US0 band if KL0 is greater than 25.8dB (~3700ft) to fix the no sync issue.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft
//
//   3. Added 0.6dB to final KL0 to reduce UPBO and boost US power by ~0.5dB to get comparable US data rate with BRCM CPE.
//      Grep for XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_USdatarate
//
//11/07/2017 Abu Rahman : XDSLRTFW-3554 DS datarate exceeds configured max datarate
//           - Enabled Min-Max Rate check for IKNS and CNXT DSLAMs
//           - Forced LP to the round(Multiple of 8) and then re-compute the rate for IKNS and CNXT DSLAM
//           - Added debug variable to debug framing generation algorithm
//           Grep for XDSLRTFW-3554
//
// 28/07/2018 Stefan: Added two new hybrid coefs for 8MHz and 17MHz modes for OTE setup
//            Increase the number of tested hybrid settings from 7 to 9 for BRCM-based DSLAMs
//            Due to missing testing time this fix is enabled only for BRCM
//            The default settings were not matching due to an impedance mismatch of their linesimulator
//            XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
//
//*****************************************************************************

/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "cmv.h"
#include "cmv_data.h"
#include "gdata.h"
#include "vdsl_state.h"
#include "vdsl_const.h"
#include "states.h"
#include "ORTrainingRxF.h"
#include "OTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "RTrainingTxF.h"
#include "SocMsgInit.h"
#include "preshow.h"
#include "show_test_iof.h"
#include "cri_iof.h"
#include "afeif_iof.h"
#include "ghs.h"
#include "ghs_cpe.h"
#include "cnfg_task.h"
#include "cri_ini.h"
#include "IRI_Ini.h"
#include "TxPSDControl.h"
#include "fifo.h"
#include "IRI_Iof.h"
#include "V_STR_IOf.h"
#include "TimingAdvanceHandler.h"
#include "V_STR_Ini_PostGhs.h"
#include "V_STR_SRC_Ini.h"
#include "V_STR_IIR_IOf.h"
#include "ToneReorder.h"
#include "g997.h"
#include "eoc.h"
#include "showtime.h"
#include "SharedFuncs.h"
#include "ll_iof.h"
#include "eoc.h"
#include "FdqHandler.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"


//Mei debug
extern uint8 guc_DetectOffset;
extern int32 gl_fc_pofi_lp_kHz_temp;
#ifdef INCLUDE_NON_CACHE_FUNCTIONS
/*^^^
*-------------------------------------------------------------------
*
*  void ConfigEngineForPostGhs(void)
*
*  Description:
*
*
*-------------------------------------------------------------------
*^^^
*/
void ConfigEngineForPostGhs(void)
{
   //QT_RAM_INACTIVE_GAIN_SCALE memory was used to get the Hybrid settings tables
   //from the External Data Memory Image, The required profile hybrid settings will be
   //copied to "gusa_HybridsForProfileSelected" after handshake is completed,
   //Hence QT inactive gain buffer may be restored back with known values.
   InitIridiaQT_InactiveGain();

   //==============================================================================
   //Queue up HW loading function.
   //==============================================================================
   if (gsa_Optn4_FilterControl[OPTN_4_IDX1_FILTER_CTRL] & OPTN_Tx_Filter_Auto_Reconfig)
   {
      // In case of auto-reconfig the TX IIR filter was selected based on the Ghs handshake tone set.
      // To avoid a double reconfiguration the default full band Tx IIR filter gets configured at the begin of training!
      if ((gs_TxIIRFilterSelect == OPTN_POTS_LP_Filter_Select) ||
          (gs_TxIIRFilterSelect == OPTN_POTS_DOUBLE_LP_Filter_Select) ||
          (gs_TxIIRFilterSelect == OPTN_POTS_QUAD_LP_Filter_Select))
      {
         gs_TxIIRFilterSelect = OPTN_POTS_Filter_Select;
      }
      else //if (gs_TxIIRFilterSelect == OPTN_ISDN_LP_Filter_Select)
      {
         gs_TxIIRFilterSelect = OPTN_ISDN_Filter_Select;
      }
   }
   else
   {
      // Note: This code is needed, when "XDSLRTFW-3292" gets be common and not under "OPTN_Tx_Filter_Auto_Reconfig"!
      //       In this case variable "gs_TxIIRFilterSelect" was changed already for handshake.
      //       Reconfig the host setting!
      gs_TxIIRFilterSelect = (gsa_Optn4_FilterControl[OPTN_4_IDX0_FILTER_CONF] & OPTN_TX_MASK_Filter_Select);
   }

   if ((gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_35B_MASK | CNFG_V2_PROFILE_30A_MASK)))
   {
      //In the next function, the strymon will be held at reset mode
      //so QT will always stall. During this period, we still want to
      //run the foreground task, so we disable QT stall check
      gft_SkipRxQtStallCheck = 1;
      gft_SkipTxQtStallCheck = 1;

      if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
      {
         ReconfigVStrymonFor8kHzTraining();
      }
      else if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         ReconfigVStrymonFor35bTraining();
      }
   }
   else if (gft_Debug35bHwConfig17aModeEnable == TRUE)
   {
      //In the next function, the strymon will be held at reset mode
      //so QT will always stall. During this period, we still want to
      //run the foreground task, so we disable QT stall check
      gft_SkipRxQtStallCheck = 1;
      gft_SkipTxQtStallCheck = 1;

      //When Tx in 35B mode, TXSRC and RX SRC shall be in 2x mode
      //This require in RX path
      //RX SRC input shall 144 Msps and ouput will be 72 Msps
      //FOr this we have to do follwoing in Rx
      //1.Rx FIR Decim1 = Bypass (From Decim by 2 mode)
      //gs_STR_DbgCntl |= STR_DBG_CNTL_DISABLE_RXDEC;
      //>>Instead of Rx FIR Decim1(Bypassing this gave bad ds rate), the Rx WDF DEC1 is used
      //So in the RX path After [ADC Adjust] -> [Rx WDF DEC1] -> [Rx SRC in 144/72 mode] -> [Rx IIR in 72/35 mode]
      //.Rx FIR Decim1 = Bypass (From Decim by 2 mode)
      //2.Rx IIR/Decim =  Decim by 2 mode(from bypass mode)
      gs_STR_DbgCntl &= ~(STR_DBG_CNTL_DISABLE_RXIIR); //Enable Rx IIR in Decim by 2 mode

      //select 35B TXIIR VDSL filter now, later in RMSG1 final filter will be selected
      gs_TxIIRFilterSelect = OPTN_35B_VDSL_Filter_Select; //XDSLRTFW-3582

      //Reconfigure the Strymon
      ReconfigVStrymonFor4kHzTraining();
   }

   // Reconfig fct. are not executing an IIR filter loading anymore.
   // This is now the common place!
   LoadTxIIR();
   LoadRxIIR();

   // Update CMV
   gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] = (gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] & (~OPTN_TX_MASK_Filter_Select));
   gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] |= gs_TxIIRFilterSelect;
   gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] = (gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] & (~OPTN_RX_MASK_Filter_Select));
   gsa_Optn4_FilterControl[OPTN_4_IDX4_FILTER_CD] |= (gs_RxIIRFilterSelect << OPTN_RX_Filter_Select_POS);

} //ConfigEngineForPostGhs()



void LinkStart_ForPostGhs(void)
{
   // if test mode is enabled, call HW IO function directly here to avoid possible FW crash
   if (gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_35B_MASK | CNFG_V2_PROFILE_30A_MASK))
   {
      Reconfig_CRI();

      //Take Strymon out of reset mode
      EnableStrymon();

// Note: It is not allowed to clear the variable for 35b with cascade mode, because a stuck on Tx side will occur!
//       Reason is that the ForegroundHandler() is executing first Rx (1st), Tx (2nd) TC-task (time critical)
//       and then TX (1st), Rx (2nd) NTC-task (non-time critical). This function is executed in RxFG NTC-task.
//       Therefore the Tx must be completed, before the varible gets be reset.
//       In cascade mode the ForegroundHandler() will not be executed any more afterwards!
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
      {
         // The strymon is enabled in the above function
         // so we turn on QT stall check
         gft_SkipRxQtStallCheck = 0;
         gft_SkipTxQtStallCheck = 0;
      }
   }
   else if (gft_Debug35bHwConfig17aModeEnable == TRUE)
   {
      //Take Strymon out of reset mode
      EnableStrymon();

      // The strymon is enabled in the above function
      // so we turn on QT stall check
      gft_SkipRxQtStallCheck = 0;
      gft_SkipTxQtStallCheck = 0;
   }
}


void ReconfigAFE_ForPostGhs(void)
{
   if(gft_SkipInitAfeHSExit == 0)
   {

      //DFE-AFE Startup Sequence as in Page 101 of Strymon-VFDF_xDSL_CPE_bonded_v3.1 04
      //The startup handshake between the DFE and AFE needs to follow a proper sequence otherwise the expected behaviour
      //cannot be ensured. The sequence below details the order in which the various modules are enabled. The sequence is for
      //the data path and should only be done after the power sequence. There maybe other steps or configurations between
      //each step, but the following sequence needs to be adhered to.
      //1. Put Strymon in reset state by setting RESET_STATEN=0
      //2. Configure Strymon/DFI for both Tx and Rx. This step setup the time domain modules to the desried data rate
      //and profiles.
      //3. Configure AFE for both Tx and Rx via the FCSI-D interface for data rate that matched to the DFE side,
      //4. Only after both DFE and AFE are setup correctly and enabled, then DFE-AFE interface FIFO can be
      //enabled.No read/write of the FIFO can happen before it is enabled. Any read attempt will return 0 and write
      //attempt is ignored.
      //5. Put Strymon out of reset by setting RESET_STATEN=1
      gul_Afe_flowtest |=0x10000;

      //Call this to populate vars gus_AFE_TxMode/gus_AFE_RxMode based on ProfileSelected
      AFED_GetProfileSelected(gt_ProfileAct.us_ProfileSelected);

      {
         //Later if someone wants to try other than 17a before GHS
         gs_AGC1_Gain_Set = gsa_gain_pga_dB[gus_AFE_RxMode];
         gs_AGC2_Gain_Set = gsa_gain_prefi_dB[gus_AFE_RxMode];
      }

      if (gft_Debug35bHwConfig17aModeEnable == TRUE)
      {
         gus_TxSRC_InRate = VRX518_SRC_INRATE_70MHZ;
         gus_TxSRC_UpsamplingFactor = 1;
         gus_TxSRC_OutRate = (gus_TxSRC_InRate << gus_TxSRC_UpsamplingFactor);
      }
      //For 8M AFE mode ADC @576MHz. Since before handshake AFE ran in 17M mode and when switching from 17M to 8M requires
      // all clocks to be in 8M mode. At oresent LLAPIs do not have that option. As a workaround, we have to do AFE-DSL reset and
      // go for 8M configuration
      if (gus_AFE_RxMode == VDSL8_CPE)
      {
         AFED_ResetAfeDslOnly();
      }

      if( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_17A_MASK) || (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_12xALL_MASK))

      {
         gft_DfiConfig = 0;
      }

      if ( (gft_EnableDfiReconfigAlways) || (gft_Debug35bHwConfig17aModeEnable == TRUE) ) //for Debug purpose : To force DFI reset and reconfig
      {
         gft_DfiConfig = 1;
      }

      if (gft_DfiConfig)
      {
         AFED_ModeConfig();
      }

      gs_Hyb_Hsk_QlnHlog = 2; //QLn/HLOG hybrid setting  VRX518AFE_OPEN
      AFED_HskQlnHlogSetHybrid();
      gul_Afe_flowtest |=0x20000;

#ifdef DEBUG_VRX518_AFE  //0x5102
         if(gs_PauseControl == 0x5102)
         Pause(gs_PauseControl);
#endif

      gs_Hyb_Hsk_QlnHlog = 0; //Profile based index 0 hybrid setting  VRX518AFE_OPEN
   }
}

#endif //#ifdef INCLUDE_NON_CACHE_FUNCTIONS




#ifdef INCLUDE_CACHE_FUNCTIONS
/*^^^
*-------------------------------------------------------------------
*
*   Prototype: int16 ConfigTaskLayerForPostGhs(void)
*
*   Description:
*
*      Initializes Task Layer variables after G.handshake is completed.
*
*   Arguments:
*      none
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
int16 ConfigTaskLayerForPostGhs(void)
{
   // XDSLRTFW-1488 (Start)
   int16 i, j;
   int16 k;
   int16 s_PlatformType, s_FeatureSet;
   int16 s_FeatureSet_rev2;
   uint16 *pus_HybridsForProfileSelected = NULL;

   gs_VecSSyncAlignIdx = 0;
   gs_HybTrIndex = 0;
   gl_HybTrSymcnt_start = 0;
   gs_HybTrFinishUp = 0;
   gs_frame_rate_is_8khz = 0;

   // Reverted SNR_THRESH_FOR_HIGHEST_TONE back to the old value of 8dB. For 35b and non-vectoring (vectoring this criteria was not seen so far).
   // The change avoids XDSLRTFW-3025 : Link drop with ECODE - E_CODE_RX_SYNCHRO6_DETECT_FAIL and also an IOP topic with BDCM.
   // This has a positive effect to the ChannelDiscovery fail, when the showtime link drop doesn't occur.
   //
   // Note: A nice side effect is seen, i.e. improved Data Rates on longer loops.
   //       Due to the double train the PSD for DS1 and DS2 gets be boosted, but this leads to the effected mentioned by Stefan:
   //            DS performance drops dramatically if DS1 band gets boosted by 3dB
   //            i.  We cannot use this gain for performance improvement of DS1 (even without boost 15bit are loaded on all tones)
   //            ii. DS2 and DS3 performance drops because of 3-dB lower AGC settings => 3dB higher ADC noise
   if (!(gus_VectoringOptionsEnabled & (VEC_OPTIONS_FULL_FRIENDLY_MASK | VEC_OPTIONS_DS_MASK)))
   {
      gs_MIN_BAND_METRIC = MIN_BAND_METRIC_NO_VECTORING;
      gs_MIN_BAND_METRIC_START = MIN_BAND_METRIC_NO_VECTORING_BAND_START;
   }


#ifdef VRX518_SINGAPORE_BRINGUP
   //TODO: check why VRX518_SINGAPORE_BRINGUP definition still in use?
   //gt_NoiseMarginChange.s_NM_Ctrl = 0;  // Disable NoiseMargin
   //     if (gul_35bLiteConfig & EN_RESTRICT_MAX_IDX_HQV_TO_54)
   //     {
   //        gs_HQV_MaxIdx = 60; //40;
   //     }
#endif // VRX518_SIGNAPORE_BRINGUP

   // Select 8kHz mode in VDSL2 if 30a bandplan is chosen in GHS
   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
   {
       // In 30MHz mode kl0 estimation is always done according to ELE-M1 (the alternative method).
       // ELE-M0 (the default method using the slope based Aware-algorithm) does not work for DPBO and bridge-tap loops
       // in 30MHz mode
       // TBD:
       // Use also for 8/12/17 and 35b profiles the ELE-M1 mode instead of slope-algo.
         gus_kl0_estimation_method = ELE_M1_METHOD_PERCENTILE_ALGO; // XDSLRTFW-4052(Start_End)
      //Set the flag to indicate this is 8Khz frame rate
      gs_frame_rate_is_8khz = 1;

      //XDSLRTFW-3020 (Start)
      if (gus_ReTxOptionsEnabled & DS_INTRA_DTU_ILV_CAPABLE)
      {
         gus_ReTxOptionsEnabled = gus_ReTxOptionsEnabled & (~DS_INTRA_DTU_ILV_CAPABLE); //Disable DS Intra DTU ILV capability
         // Setting Bit 9 in INFO 229 to indicate that DS INTRA DTU is disabled forcefully for 30a profile
         // to reduce Zephyr MIPS consumption. Decision is taken after consultation with SE.
         gus_DsUsReTxStatus = gus_DsUsReTxStatus | FORCE_DISABLE_DS_INTRA_DTU_ILV_30a;
      }
      //XDSLRTFW-3020 (End)

      TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_30M;
      pus_HybridsForProfileSelected= &gusa_HybridSettingV2_30M_VRX518[0][0];

      gl_afe_fixed_gain = gl_afe_fixed_gain + (3<<8); // The frame rate is embedded within gl_afe_fixed_gain and this empirical value is calibrated for 4kHz frame rate

      // Initialize Failure structures for Line and ATM Failures
      // When Initial setup is done frame rate information is not avaialble.
      // Default value of 4KHz is used. At this point, if the link is identified
      // as 8kHz re-initilize the failure structures.
      InitLineFailureStruct(&gt_g997_FailureState_NE);
      InitLineFailureStruct(&gt_g997_FailureState_FE);
      InitAtmFailureStruct(&gt_g997_AtmFailure_NE);
      InitAtmFailureStruct(&gt_g997_AtmFailure_FE);
      // Some elements of the gt_G997_Cntrl are modified after initial setup.
      // Only the element which uses frame rate is updated here.
      gt_G997_Cntrl.s_HighSymCount = VDSL1_8KHZ_FRAMES_PER_100MS;
   }
   //for non-30a profile
   else //if((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK) == 0)
   {
      if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
         // Note: This is a secure code since more bits can be set!
         //       Normally this should be checked in fct. PostGhsConfigVDSL2().
         gt_ProfileAct.us_ProfileSelected &= CNFG_V2_PROFILE_35B_MASK;

         //XDSLRTFW-2168 (Start)
         //Enable cascaded mode for 35B mandatory
         gul_35bLiteConfig |= EN_CASCADED_MODE;

         //Enabling of HRT 5,0 is optional, Do enable if HRT 5,0 test CMV is enabled.
         if (TESTArray[TEST_Control4] & TEST_Control4_HRT_5_0_Scheduling_35b_Bit7_Mask)
         {
            gul_35bLiteConfig |= EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE;

            if (TESTArray[TEST_Control4] & TEST_Control4_HRT_5_0_LimitDsRate_35b_Bit8_Mask)
            {
               //Limit DS Rate to 320 Mbps for HRT 5,0 Scheduling
               //Limiting of DS rate is done to have stable showtime, beyond 320Mbps seeing 20 to 30 bad Dtu's/sec
               //debug in progress.
               gta_DsBearerChannel[0].ta_TpsTcType[0].ul_MaxNetDataRate = 0x13880; //80000 * 4 = 320000 Kbps
            }
         }
         else
         {
            //1 symbol early configuration is required for 35B cascaded mode HRT 7,0 scheduling
            //because FFT runs on "n" symbol data and QT runs on "n-1" symbol data simultaneously.
            //but for the HRT 5,0 scheduling QT starts using the same symbol data.
            gs_HandleRxCE_PeriodicStateStart_StartSym_Offset = -1;
            gs_HandleRxCE_PeriodicStateStart_EndSym_Offset = -1;
            gs_HandleRxCE_Periodic2StateStart_StartSym_Offset = -1;
            gs_HandleRxCE_Periodic2StateStart_EndSym_Offset = -1;
         }
         //XDSLRTFW-2168 (End)

#if defined(VRX518_SINGAPORE_BRINGUP)
         if (!(TESTArray[TEST_35B_CONTROL] & TEST_35B_HALFROUNDTRIP_RX))
         {
            gt_ReTXParams.uc_RMSG2_CpeRxHalfRoundTripDelays = 0x07;   // 0x36 gives slightly higher rates.
         }
#endif // VRX518_SINGAPORE_BRINGUP

         //XDSLRTFW-2168 (Start)
         if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
         {
            gt_ReTXParams.uc_RMSG2_CpeRxHalfRoundTripDelays = 5;   //To reach 350 Mbps
            if (gft_DSVectoringEnabled)
            {
               guc_DetectOffset = 5; //Tx & Rx Sync symbol offset, enable it for vectoring with 35B mode , cascaded HRT 5,0
            }
         }
         //XDSLRTFW-2168 (End)
         //XDSLRTFW-3096 (Start)
#if defined(VRX518_SINGAPORE_BRINGUP)
         if((TESTArray[TEST_Control3] & TEST_EnableTxDelayMin))
         {
            gt_UsReTx_ConfigVar.s_TxHalfRoundTripInDTUs = 1;
            gt_UsReTx_ConfigVar.s_TxHalfRoundTripInSymbols = 6;
         }
         else
         {
            //XDSLRTFW-3148 (Start)
            if (gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE)
            {
               //US HRT 5,0 with new 35b scheduling
               //This value is as per new 35b scheduling diagram (for US HRT 5,0)
               gt_UsReTx_ConfigVar.s_TxHalfRoundTripInDTUs = 0;
               gt_UsReTx_ConfigVar.s_TxHalfRoundTripInSymbols = 5;
            }
            else
            {
               //As per current version of 35b scheduling US HRT should be 7,0
               //Note:Value to be changed after implementing new 35b scheduling diagram (for US HRT 5,0)
               gt_UsReTx_ConfigVar.s_TxHalfRoundTripInDTUs = 0;
               gt_UsReTx_ConfigVar.s_TxHalfRoundTripInSymbols = 7;
            }
            //XDSLRTFW-3148 (End)
         }
#endif // VRX518_SINGAPORE_BRINGUP

         //XDSLRTFW-3096 (Start)
         {

            // This specifies the settel time/delay until the HW change gets be visible for the FW.
            // The delay is based on the time taken by HW and it is schedule. For cascaded mode with 8K tones FFT
            // a delay of 4 symbols and for 4K tones FFT of 3 symbols should be used.
            // It is mainly scheduling dependent and therefore a variable must be used!
            // Note: 35b Scheduling: AFE-Strymon-FFT-QT
            gs_HwSettleTime = AFE_TO_QT_LATENCY_35B;
            gs_RTVxCfgLatency = RTV0_CFG_LATENCY_35B;

            // For VRx518 the RTV is twice, i.e. for 1024 tones.
            // Note: Initialization is done for 17a, 12x and 8x profiles to save code!
            gs_NumChannelsPerGroup = MAX_NUM_CHANNELS_PER_GROUP;
            gs_NumChannelsPerGroupSave = MAX_NUM_CHANNELS_PER_GROUP;
            //gs_MaxFAOffset_at_convergence = 256;

            //if (gs_RxState == SLEEP_RX)
            //XDSLRTFW-2918:VDSL FW sleep mode Rx capture not working.VRX518 has 4KB X memory and with gs_NumChannelsPerGroup =1024 leads to the size of 8KB.
            //Accessing X memory >4KB is undefined memory
            if ((CNTLArray[0] & 0x000F) == 8)
            {
               gs_NumChannelsPerGroup = NUM_CHANNELS_PER_GROUP_512;
               gs_NumChannelsPerGroupSave = NUM_CHANNELS_PER_GROUP_512;
               //gs_MaxFAOffset_at_convergence = 128;
            }

            // bypass TxIIR filter only for 35B mode with 8K IFFT tones.
            if (TX_LOG2_MAX_FFT_LENGTH > US_LOG2_FFT_LENGTH_8192)
            {
               gs_STR_DbgCntl |= (STR_DBG_CNTL_DISABLE_TXIIR);
            }
         }

         if (gul_35bLiteConfig & EN_CASCADED_MODE)
         {
            guc_CasMode_enable = 1;
         }

         //XDSLRTFW-3362 (Start)
         #ifdef PROFILE_TASKS_35B
         //35B MIPS profiling
         if (TESTArray[TEST_Control] & TEST_TaskProfileControl)
         {
            gft_EnableTaskProfile = TRUE;
         }
         #endif //#ifdef PROFILE_TASKS_35B
         //XDSLRTFW-3362 (End)

         TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_35M;
         pus_HybridsForProfileSelected = &gusa_HybridSettingV2_35M_VRX518[0][0];
      }

      if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_17A_MASK)
      {
         // Note: This is a secure code since more bits can be set!
         //       Normally this should be checked in fct. PostGhsConfigVDSL2().
         gt_ProfileAct.us_ProfileSelected &= CNFG_V2_PROFILE_17A_MASK;

         // XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
         // use 9 hybrid settings only for BRCM COs
         //Before enabling this fix also for non-BRCM devices we need to show that there is no timing issue
         if ((gul_fe_G994VendorID == BRCM_VENDOR_ID) || ((gt_Reconf_Hybrid_Coeff.s_control & ENABLE_ALL_HYB_FOR_NON_BRCM)==ENABLE_ALL_HYB_FOR_NON_BRCM))
         {
            TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_17M;
         }
         else
         {
            TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_17M_NONBRCM;
         }
         pus_HybridsForProfileSelected = &gusa_HybridSettingV2_17M_VRX518[0][0];
      }

      if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_12xALL_MASK)
      {
         // Note: This is a secure code since more bits can be set!
         //       Normally this should be checked in fct. PostGhsConfigVDSL2().
         gt_ProfileAct.us_ProfileSelected &= CNFG_V2_PROFILE_12xALL_MASK;

         // XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
         // use 9 hybrid settings only for BRCM COs
         //Before enabling this fix also for non-BRCM devices we need to show that there is no timing issue
         if ((gul_fe_G994VendorID == BRCM_VENDOR_ID) || ((gt_Reconf_Hybrid_Coeff.s_control & ENABLE_ALL_HYB_FOR_NON_BRCM)==ENABLE_ALL_HYB_FOR_NON_BRCM))
         {
            TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_12M;
         }
         else
         {
            TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_12M_NONBRCM;
         }
         pus_HybridsForProfileSelected= &gusa_HybridSettingV2_12M_VRX518[0][0];
      }

      if((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK) ||
         (gus_UseUS0OnlyCntrl & TX_US0_ONLY_CONF_RX_HYB))
      {
         // Note: Here is really only profile 8MHz selected, i.e. no other bit was set.
         //       -> The secure code is not needed and would be wrong too.
         //          !!! In US0 case the profile would wrongly changed!!!!!!!!!
         // gt_ProfileAct.us_ProfileSelected &= CNFG_V2_PROFILE_8xALL_MASK;
         // XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
         // use 9 hybrid settings only for BRCM COs
         //Before enabling this fix also for non-BRCM devices we need to show that there is no timing issue
         if ((gul_fe_G994VendorID == BRCM_VENDOR_ID) || ((gt_Reconf_Hybrid_Coeff.s_control & ENABLE_ALL_HYB_FOR_NON_BRCM)==ENABLE_ALL_HYB_FOR_NON_BRCM))
         {
            TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_8M;
         }
         else
         {
            TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_ABJ_NUM_HYBS_8M_NONBRCM;
         }
         pus_HybridsForProfileSelected = &gusa_HybridSettingV2_8M_VRX518[0][0];
      }

      // Normally also for 17a or 12x profile it is possible to drop to US0 only
      // Handshake indication is ignored, if USO is supported for 12x or 17a!
      if (gus_UseUS0OnlyCntrl & TX_US0_ONLY_CONF_RX_HYB)
      {
         if ((gt_ProfileAct.ul_AnxAUS0PsdSelected & (~(CNFG_V2_ANXA_US0_IN_12B_MASK|CNFG_V2_ANXA_US0_IN_17A_MASK))) ||
             (gt_ProfileAct.us_AnxBUS0PsdSelected & (CNFG_V2_ANXB_US0_25_138_MASK | CNFG_V2_ANXB_US0_25_276_MASK | CNFG_V2_ANXB_US0_120_276_MASK)))
//                (gt_ProfileAct.us_AnxCUS0PsdSelected & CNFG_V2_ANXC_US0_ALL_MASK))
         {
            if (gt_ProfileAct.us_AnxBUS0PsdSelected & CNFG_V2_ANXB_US0_120_276_MASK)
            {
               // ISDN Hybrid
               TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_BJ_NUM_HYBS_US0;
               pus_HybridsForProfileSelected = &gusa_HybridSettingV2_US0_VRX518[0][0];
            }
            else
            {
               // POTS Hybrid
               // It must be used when ECHO is in area 25-138kHz, i.e. all AnnexA EU, ADLU masks and AnnexB masks below 120kHz.
               TESTArray[TEST_MaxNumHybrSettings] = VRX_ANX_A_NUM_HYBS_US0;
               pus_HybridsForProfileSelected = &gusa_HybridSettingV2_US0_A_VRX518[0][0];
            }
         }
      }
   } //if((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK) == 0) else

   if (gft_Debug35bHwConfig17aModeEnable == TRUE)
   {
      if (gul_35bLiteConfig & EN_TXIIR_17MHZ_35B)
      {
         gs_STR_DbgCntl &= ~(STR_DBG_CNTL_DISABLE_TXIIR);
      }
   }

   // If no of hybrids were forced, choose the forced one.
   if ((guc_ForceNumHybrid > 0) && (guc_ForceNumHybrid < TESTArray[TEST_MaxNumHybrSettings]))
   {
      TESTArray[TEST_MaxNumHybrSettings] = guc_ForceNumHybrid;
   }
   // Selected profile hybrid coefficients shall be copied to "gpus_HybridsForProfileSelected"
   // Other profile hybrid settings will not be valid after channel discovery since
   // Inactive gain memory will be initialized with unity gain.
   if (pus_HybridsForProfileSelected != NULL)
   {
      gpus_HybridsForProfileSelected = &gusa_HybridsForProfileSelected[0][0];
      memcpy(gpus_HybridsForProfileSelected, pus_HybridsForProfileSelected, sizeof(uint16)*TESTArray[TEST_MaxNumHybrSettings]*VRX_HYB_NUM_SETTINGS);
   }
   // XDSLRTFW-3897(Start)
   if(gt_Reconf_Hybrid_Coeff.s_control & RECONF_HYB_FORCE_HYBRID_SETTING)
   {
      // overwrite 1st hybrid setting with cmv ...
      pus_HybridsForProfileSelected = &gt_Reconf_Hybrid_Coeff.usa_hyb_coeff_idx[0];
      memcpy(gpus_HybridsForProfileSelected, pus_HybridsForProfileSelected, sizeof(uint16)*VRX_HYB_NUM_SETTINGS);
      // Force FW to use the first hybrid setting
      // TESTArray[TEST_SetHybrid_Index] = 0;
      gs_HybTrIndexDbg = 0;
   }

   // If CAP search is disabled FW will still execute the CAP search to keep the timing as it is by default.
   // But as the step size is forced now to be '0' the same CAP value will be used multiple times
   if(gt_Reconf_Hybrid_Coeff.s_control & RECONF_HYB_DISABLE_CPB_SEARCH)
   {
      uint16 i;
      for (i=0; i<VRX_NUM_CAP_CPB_SEARCH; i++)
      {
         gsa_CapCpb_delta[i] = 0;
      }
   }
   // If CAP search is disabled FW will still execute the CAP search to keep the timing as it is by default.
   // But as the step size is forced now to be '0' the same CAP value will be used multiple times
   if(gt_Reconf_Hybrid_Coeff.s_control & RECONF_HYB_DISABLE_CPC_SEARCH)
   {
      uint16 i;
      for (i=0; i<VRX_NUM_CAP_CPC_SEARCH; i++)
      {
         gsa_CapCpc_delta[i] = 0;
      }
   }
      // XDSLRTFW-3897(End)
   // Identify the Tx tones first and set the direction bit
   // in the ExtGain table (EGT)
   for(i=0; i<gs_NumOfTxBands; i++)
   {
      for (j = gsa_TxBandLeftChannel[i]; j <= gsa_TxBandRightChannel[i]; j++)
      {
         // Set EGT direction bit to Tx
         *(ghpuca_TxExtGains_Inactive+j) = 0x10;
      }
   }

   //The VDSL2 spec. requires that sub-carrier spacing is represented in 4.3125 kHz
   //for the US, DS and RFI band information
   //In our implementation, 30a bandplan assumes the sub-carrier spacing is 2*4.3125.
   //Thus, we need to make this coversion before using these bands
   if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
   {
      uint16 us_platform, us_feature;

      us_platform = (gus_fe_G994VendorSpecific >> 12) & 0x000F;
      us_feature = (gus_fe_G994VendorSpecific >> 7) & 0x001F;

      //To be backward compatible with our previous releases,
      //we do not do this scale for all the previous release up to and include 9.7
      if(!((gul_fe_G994VendorID == IFX_VENDOR_ID) && (us_platform == 9) &&
            ((us_feature >= 4) && (us_feature <= 7))))
      {

         for(k=0; k<gs_NumOfRFIBands; k++)
         {
            gsa_RFIBandLeftChannel[k] >>= 1;
            gsa_RFIBandRightChannel[k] >>= 1;
         }

         for(k=0; k<gs_NumOfEstRxBands; k++)
         {
            gsa_EstRxBandLeftChannel[k] >>= 1;
            gsa_EstRxBandRightChannel[k] >>= 1;
         }
      }

   } //if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)


   //Disable loading GHS tone bit, and register start IFFT bit
   gs_LoadGhsToneFlag = 0;

   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (Start)
   if((TESTArray[TEST_Control3] & TEST_EnableImprovedATTNDR))
   {
      gft_EnableImprovedATTNDR = TRUE; //1
   }
   else
   {
      gft_EnableImprovedATTNDR = FALSE; //0;
   }
   // XDSLRTFW-1877 : VDSL2 IFEC ATTNDR (End)

   // CPE does not have this info...
   // Initialize to indicate all tones are in Rx supported set until we get O-Signatture
   {
      if (gs_NumOfEstRxBands == 0)
      {
         gs_NumOfEstRxBands = 1;
         gsa_EstRxBandLeftChannel[0] = 33;
         gsa_EstRxBandRightChannel[0] = 1972;
      }
      else
      {
         gs_HighestAllowedRxTone = gsa_EstRxBandRightChannel[gs_NumOfEstRxBands-1];
      }

      // Copy Handshake bandplan info to arrays used during training
      for (i=0; i<gs_NumOfEstRxBands; i++)
      {
         gsa_RxBandLeftChannel[i] = gsa_EstRxBandLeftChannel[i];
         gsa_RxBandRightChannel[i] = gsa_EstRxBandRightChannel[i];
      }
      gs_NumOfRxBands = gs_NumOfEstRxBands;

      // Fill band control information for status CMVs!
      VDSL2_BandControlGet((BAND_CONTROL_UPDATE_RFI|BAND_CONTROL_UPDATE_US|BAND_CONTROL_UPDATE_DS));

      // Fake DS band plan and RFI bands
      // Note: This is a secure code for profiles < 35b profile, if the common handshake bandplan is
      //       for 35b and 17a, 12x or 8x is selected afterwards!
      LimitBandPlanToHighestTone(&gsa_RxBandLeftChannel[0], &gsa_RxBandRightChannel[0], &gs_NumOfRxBands, (gs_RxNumTones-1));
      gs_HighestAllowedRxTone = gsa_RxBandRightChannel[gs_NumOfRxBands-1];
      LimitBandPlanToHighestTone(&gsa_RFIBandLeftChannel[0], &gsa_RFIBandRightChannel[0], &gs_NumOfRFIBands, (gs_RxNumTones-1));

      ReconfigBandPlan();
   }

   //==================================================
   //Initialize flags and indicators
   //==================================================
   gs_RxToneOffset = 0;
   gs_TxNumBytesPerSymbol = 1;
   gs_RxNumBytesPerSymbol = 1;


   //indicate not in RX medley state yet
   gs_RxMedleyStateFlag = FALSE;

   gs_FDQTrainTypeCntrlFlag = FDQ_TRAIN_TYPE_DEFAULT;

   InitSocMsgs();


   // All CPE TX bandplans have ATP <= 14.5 dBm
   // If the CO proposes a ceiling giving ATP higher than gt_PwrConfigParam.s_Up_MaxNomAggrPwr,
   // the CPE will not use it.
   gt_PwrConfigParam.s_Up_MaxNomAggrPwr = 145;

   /* Profile specific settings */
   {
      int16 s_Dmax;
      uint8 uc_DsOneOverSmax;
      uint8 uc_UsOneOverSmax;

      //Decide the profile dependent parameters according to Table 6-1/G.993.2
      //...and Table 9-7/G.993.2 in case of optional extended S_Max
      uc_DsOneOverSmax = (64 >> gs_frame_rate_is_8khz);
      if (gsa_Optn2_AlgControl[2] & OPTN_DSExtSMaxDisable)
      {
         uc_DsOneOverSmax = 48;
         if(gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_12xALL_MASK|CNFG_V2_PROFILE_8xALL_MASK))
         {
            uc_DsOneOverSmax >>= 1;          // 24
         }
         else if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
         {
            uc_DsOneOverSmax = 28;
         }
      }

      uc_UsOneOverSmax = 64;
      if(gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_30A_MASK|CNFG_V2_PROFILE_8xALL_MASK))
      {
         uc_UsOneOverSmax >>= 1;             // 32
      }
      if (gsa_Optn2_AlgControl[2] & OPTN_USExtSMaxDisable)
      {
         uc_UsOneOverSmax = 24;
         if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_8xALL_MASK)
         {
            uc_UsOneOverSmax >>= 1;          // 12
         }
         else if(gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
         {
            uc_UsOneOverSmax = 28;
         }
      }
      guc_DsOneOverSmax = (uint8)(MIN(uc_DsOneOverSmax, guc_DsOneOverSmax));
      guc_UsOneOverSmax = (uint8)(MIN(uc_UsOneOverSmax, guc_UsOneOverSmax));


      s_Dmax = (2048 << gs_frame_rate_is_8khz);
      if(gt_ProfileAct.us_ProfileSelected & (CNFG_V2_PROFILE_35B_MASK|CNFG_V2_PROFILE_17A_MASK))
      {
         s_Dmax = 3072;
      }
      gta_DsLatencyPath[INLV].s_MaxD = s_Dmax;
      gta_UsLatencyPath[INLV].s_MaxD = s_Dmax;
   }

   // enable ILV_TRT if this feature is enabled & TCM is enabled & MFDQ disabled
   if ((gft_EnableRxIlvTrt) && (gft_RxTcmFlag) && (!gft_EnableMfdq))
   {
      gs_TxToneOrderType = ILV_TONE_ORDER;
      gs_RxToneOrderType = ILV_TONE_ORDER;
   }
   else
   {
      gs_TxToneOrderType = NO_TONE_ORDER;
      gs_RxToneOrderType = NO_TONE_ORDER;
   }


   //==================================================
   // VDSL2 variables
   //==================================================
   gs_WhichOPPilotState = 0;

   // Set the timing advance parameters
   // Note: gs_TimingAdvance, gs_TimingAdvanceFixedDelay and gs_TargetTimingAdvance
   //       are defined based on 4096 tone IFDT size.
   gs_TimingAdvance = 0;

   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK)
   {
      gs_TimingAdvanceFixedDelay = TIMING_ADVANCE_TX_RX_PATH_DELAY_8KHZ;
      gs_TargetTimingAdvance = TIMING_ADVANCE_CHANNEL_DELAY_8KHZ;
   }
   else if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      gs_TimingAdvanceFixedDelay = TIMING_ADVANCE_TX_RX_PATH_DELAY_4KHZ_35B_8K16K_FFT;
      gs_TargetTimingAdvance = TIMING_ADVANCE_CHANNEL_DELAY_4KHZ_35B_8K16K_FFT;
   }
   else
   {
      gs_TimingAdvanceFixedDelay = TIMING_ADVANCE_TX_RX_PATH_DELAY_4KHZ;
      gs_TargetTimingAdvance = TIMING_ADVANCE_CHANNEL_DELAY_4KHZ;
   }

   if ((gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK) &&
       (gs_TxLog2IfftLength > US_LOG2_FFT_LENGTH_8192))                             // US_LOG2_FFT_LENGTH_8192 = 13
   {
      // ANXQ_SUPPORT - For AnxQ only even values can be transmitted in the SOC messages!
      // Note: TimingAdvance delay is checked when it gets applied in fct. "CalcTxRxFrameOffset()".
      gs_TargetTimingAdvance = (TIMING_ADVANCE_CHANNEL_DELAY_4KHZ & 0xFFFE);
   }

   // Change gs_TargetTimingAdvance based on the US IDFT size according to the spec
   if(gs_TxLog2IfftLength < TX_LOG2_MAX_FFT_LENGTH)
   {
      i = TX_LOG2_MAX_FFT_LENGTH - gs_TxLog2IfftLength;
      gs_TargetTimingAdvance >>= i;
   }

   // Debug code
   {
      //Change the target timing advance value for test purpose
      if(gs_DbgTargetTimingAdvance >= 0)
      {
         gs_TargetTimingAdvance = gs_DbgTargetTimingAdvance;
      }
   }

   //Clear all the VDSL2 status bits
   gus_VdslStatusFlag = 0;

   gs_SendAckSegFlag = FALSE;
   gs_RevAckSegFlag = RECEIVE_ACK_SEG_IDLE;

   if (gs_frame_rate_is_8khz == 1)
   {
      // Default initialization was for 4 KHz frame rate working
      gs_MaxSwapDuration = (gs_MaxSwapDuration << 1);

      gl_MaxTimePerFrame = MAX_TIME_PER_FRAME_8K;

#ifdef PROFILE_TASKS_VR9
      gus_MaxRxTcTime = CRI_TSC_CTRL_NUM_CLKS>>2;
#endif

      gt_DDSnrFdqConfig.s_DDSnrFdqNumChannelsPerGroup = 64;

      // XDSLRTFW-4065 for 30a profile due to MIPS constraint, restricted NUM_CHANNELS_PER_GROUP to 256
      //By deafult it 1024 by 2 =512, because of this MIPS peaking happnes
      //So restored to 256 channels per group
      //gs_NumChannelsPerGroup >>= 1;                  // NUM_CHANNELS_PER_GROUP_256
      gs_NumChannelsPerGroup     = NUM_CHANNELS_PER_GROUP_256;                  // NUM_CHANNELS_PER_GROUP_256
      gs_NumChannelsPerGroupSave = NUM_CHANNELS_PER_GROUP_256;                  // NUM_CHANNELS_PER_GROUP_256
      gt_FdqConfig.s_NumChannelsPerGroup = gs_NumChannelsPerGroup;
      gt_SnrConfig.s_NumChannelsPerGroup = gs_NumChannelsPerGroup;
      gt_FrameAlignConfig.s_NumChannelsPerGroup = gs_NumChannelsPerGroup;
      gt_PsdConfig.s_NumChannelsPerGroup = gs_NumChannelsPerGroup;

      // XDSLRTFW-3015 (Start)
      gs_Kp_Slow = 0x200;
      gs_Ki_Slow = 0x4;
      // XDSLRTFW-3015 (End)
      gs_Kp_Fast = 0x1000;
      gs_Ki_Fast = 0x20;



      //Increase this length from 512 to 750 to let the 30a train work.
      //The better way for fixing this is to reduce the PGAHandler and PSDHandler processing time
      gs_MinOPQuiet1StateLength = 750;

   } //if (gs_frame_rate_is_8khz == 1)


   //-------------------------------------------------------
   // Ceiling optimization is enabled by both a globalon a band plan basis
   //-------------------------------------------------------
   if (gt_ProfileAct.us_ProfileSelected & gs_CeilingOptBandPlanEnable)
   {
      gft_EnableProposedCeilingOpt = 1;
   }

   //--------------------------------------------------------------------------
   // To address INTEROP issues
   //--------------------------------------------------------------------------

   //--------------------------------------------------------------------------
   // Ikanos Interop issues
   //--------------------------------------------------------------------------
   if (gul_fe_G994VendorID == IKNS_VENDOR_ID) // IKNS
   {
      // For Ikanos CO4 solutions on the field, we workaround the fact that the
      // IFFT size sent is incorrect
      if (gs_FeModemLog2IfftSize < 12)
      {
         gs_FeModemLog2IfftSize = 12;
         // This CO4 solution also requires a minimum constellation size of 2
         gt_ModemConfig.s_DsMinConstSize = RX_MIN_BITS_PER_TONE_2;
      }

      gft_dbgSkipLastTwoOPSynchro = 1;
      gs_dbgDelayRPSynchro6 = 30;


      //Force Lp to be the multiple of 8
      gul_dbgMiscControl |= (FORCE_MULTIPLE_OF_8_L_ADAPTIVE_RATE_BITLOAD);

      // XDSLRTFW-3554 : DS datarate exceeds configured max datarate
      gul_dbgMiscControl |= ROUND_LP_TO_32KBPS;



      //Disable both DS/US bitswaps
      {
         extern FlagT gft_DisBitswap_ForIKAN;
         if(gft_DisBitswap_ForIKAN)
         {
            //XDSLRTFW-720 Bug_All_VDSL2_All_FixBitSwapApiControl (Start_End)
            OPTNArray[OPTN_OLRControl] &= ~((OPTN_TxBitSwapEnable | OPTN_RxBitSwapEnable));
            gft_EnableRxBitSwap = 0;
            gft_EnableTxBitSwap = 0;
         }
      }

      //Disable the porposed ceiling calcualtion
      //since the PSD breakpoints sent from IKAN CO may not relect its real TX PSD levels
      gft_EnableProposedCeiling = 0;
      gft_EnableProposedCeilingOpt = 0;

      // Using only 1 byte per symbol in exchange phase results in Ikanos failing
      // in medley before OMsg1 transmission. Hence, fix this to 2
      guc_ExchangePhaseRxNumBytesPerSymbol = 2;
   }

   //--------------------------------------------------------------------------
   // Conexant Interop issues
   //--------------------------------------------------------------------------
   if (gul_fe_G994VendorID == CNXT_VENDOR_ID)
   {
      // Force Lp to be the multiple of 8
      // Enable the workarond to limit Sp to less than 1 for CNXT CO. Otherwise DS CRCs are observed against FG3.5.01
      gul_dbgMiscControl |= (FORCE_MULTIPLE_OF_8_L_ADAPTIVE_RATE_BITLOAD | FORCE_D1_FOR_MAXDELAY0 | FORCE_Sp_LESS_THAN_1);

      // Force pilot tone to be integer multiple of 64 during ChDis.
      gul_dbgMiscControl |= FORCE_MULTIPLE_OF_64_PILOTTONE;

      // Disabel periodic transition on RX side only. Otherwise, the VR9 doe not go past R-Periodic1.
      // Note: Do not disable periodic transition on TX side against CNXT.
      gul_dbgMiscControl |= DISABLE_RX_PERIODIC_TRANSITION;

      // XDSLRTFW-3554 : DS datarate exceeds configured max datarate
      gul_dbgMiscControl |= ROUND_LP_TO_32KBPS;



      // Limit the max SEQp to 255 since larger values result in CRCs with this far end
      gus_dbgMaxSEQp = 255; //XDSLRTFW-3226 (Start_End)

      gs_dbgMaxOHR = 96 ; // Limit the DS msgp max to 96 Kbps against Connexant
      // as otherwise high overhead rate causes DS CRCs with 3.5

      // XDSLRTFW-2035 : Disable BS for CXSY Chipset
      gft_EnableRxBitSwap = FALSE;

      //XDSLRTFW-3470 XDSLRTFW-2723 IOP_A_DS_VDSL2_CNXT_ShowTimePilotSwitch (START_END)
      gft_EnableShowPllToneSwitch = FALSE; // Disable multi-pilot-tones feature for CNXT


      //XDSLRTFW-3470 (START)
      if ( (gt_Dsl_Operator_Select.us_Operator_Select == AT_T) || (gt_Dsl_Operator_Select.us_Operator_Select == CTL) )
      {
         //XDSLRTFW-3470 XDSLRTFW-735 IOP_A_US_VDSL2_EVLT_F_CNXT_NoSync3200ft (START_END)
         gft_EVLT_IOPtuning = 1;

           //XDSLRTFW-3470 XDSLRTFW-2724 IOP_A_DS_VDSL2ReTx_EVLT_F_ATTNDR_Amd2 (START_END)
         gft_EnableImprovedATTNDR = FALSE; // Dsiabled IMPROVED ATTNDR METHOD Amd2
       }
      //XDSLRTFW-3470 (END)
   }


   //--------------------------------------------------------------------------
   // Broadcom Interop issues
   //--------------------------------------------------------------------------

   // DS-Performance (margin/rate) boost with BRCM-CO in 17MHz on long loops
   // CPE forced DS-PSD ceiling will be disabled
   // special value 0x1000 indicates that CPE is setting no limit on the downstream PSD ceiling level
   if (gul_fe_G994VendorID == BRCM_VENDOR_ID)
   {
      // DS-Performance (margin/rate) boost with BRCM-CO in 17MHz on long loops
      gft_TestParam_Req = VEC_BLOCK_READ_CMD;
      // XDSLRTFW-3737 (Start_End)
      // Note: For BDCM 35b an addational offset is needed!
      //       Tests performed:
      //         0m-loop: InitialTimingAdvance = 266 -> TimingAdvanceCorrection in O-UPDATE should be -266, but BDCM sends -245
      //                  -> with the correction of 21 (=42) BDCM sends -266.
      //       750m-loop: InitialTimingAdvance = 266 -> TimingAdvanceCorrection in O-UPDATE should be -133, but BDCM sends -112
      //                  -> with the correction of 21 (=42) BDCM sends -133.
      //      1500m-loop: InitialTimingAdvance = 266 -> TimingAdvanceCorrection in O-UPDATE should be    0, but BDCM sends -28
      //                  -> with the correction of 21 (=42) BDCM sends -49.
      //                  -> That means the offset is wrong for long loops and should not be applied. Even a correction of -28 (=-56) is needed.
      if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
      {
          gs_TimingAdvanceFixedDelay += 42;
      }
      //XDSLRTFW-3916
      // BDCM CPE US0 switch observed around 4400ft to 4500ft (XDSLRTFW-3916)
      // Co configures US0 only from 4700ft. Changing TxFilter from 4700ft will not solve US
      // Rate dip issue at 4500ft. So LATN based US0 switching is required around 4400ft/4500ft
      // fine tune US0 switch logic to match BDCM CPE performance.
      if (((gt_Dsl_Operator_Select.us_Operator_Select == AT_T) || (gt_Dsl_Operator_Select.us_Operator_Select == CTL))
         &&(!(gus_DebugControlVRX518 & ENA_KL0_BASED_SWITCHING))
         )
      {
         // 27.3dB - around 4350ft onwards VDSL ANSI
         gusa_SwitchingThreshTxBands[SWITCH_TO_1BAND_IDX0] = LATN_TRESH_SWITCH_TO_1BAND_CTL;
      }
      // XDSLRTFW-4196: CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (BRCM based DSLAMs) (Start)
      if (gt_Dsl_Operator_Select.us_Operator_Select == CTL)
      {
         gus_DebugControlVRX518 |= CEILING_PER_LAST_TONE_EN;
      }
      // XDSLRTFW-4196: CTL, VDSL: Downstream low perf in mid range loops from 2000ft to 3000ft (BRCM based DSLAMs) (End)


   }


   //--------------------------------------------------------------------------
   // To maintain the backward compatibility when INTEROP against IFX versions
   //--------------------------------------------------------------------------
   if (gul_fe_G994VendorID == IFX_VENDOR_ID)
   {
      s_PlatformType = (gus_fe_G994VendorSpecific >> 12) & 0x000F;
      s_FeatureSet = (gus_fe_G994VendorSpecific >> 7) & 0x001F;
      s_FeatureSet_rev2 = (gus_fe_G994VendorSpecific >> 6) & 0x003F;

      if(s_PlatformType < AVINAX_PLATFORM)
      {
         // XDSLRTFW-2518
         // We need to disable the multi-pilot tone feature for Non AVINAX_PLATFORM, since they don't support multiple pilot tones and get stuck
         gft_EnableShowPllToneSwitch = FALSE;
      }

      //XDSLRTFW-2351 : For Vinax 1.3 Platforms do not transmit extra octets
      if(s_PlatformType < VINAX_REV_2_M_PLATFORM)
      {
         gft_EnableImprovedATTNDR = FALSE; //0;
      }


      // IFX 9.x (Rev1.3)
      if (s_PlatformType == 9)
      {
         gft_FE_IlvDilvMemType = SEPARATE_ILV; // indicates ILV/DILV memory type
         gul_FE_HW_ILV_MEM_SIZE = VINAX_REV1_HW_ILV_MEM_SIZE; // the maximum HW interleaver memory allowed to use
         gul_FE_HW_DILV_MEM_SIZE = VINAX_REV1_HW_DILV_MEM_SIZE; // the maximum HW deinterleaver memory allowed to use

         // FS4 (9.4.x)
         if (s_FeatureSet == 4)
         {
            gft_SNRM_MODE_workaround = TRUE;
            gft_IfxAtmPtmFix = TRUE;
            gft_AccurateFrameRateEnable = FALSE;
            gs_EnableTaBugFix = FALSE;
            gs_MedleyFrameSynchEnableFlag &= (~EN_MEDLEY_SNR_FRAMEALIGNMENT);
            gft_EnableTxBitSwap = FALSE;
            gft_EnableRxBitSwap = FALSE;
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS5 (9.5.x)
         else if (s_FeatureSet == 5)
         {
            gft_SNRM_MODE_workaround = TRUE;
            gft_IfxAtmPtmFix = TRUE;
            gft_AccurateFrameRateEnable = FALSE;
            gs_EnableTaBugFix = FALSE;
            gs_MedleyFrameSynchEnableFlag &= (~EN_MEDLEY_SNR_FRAMEALIGNMENT);
            gft_EnableTxBitSwap = FALSE;
            gft_EnableRxBitSwap = FALSE;
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS6 (9.6.x)
         else if (s_FeatureSet == 6)
         {
            gft_EnableTxBitSwap = FALSE;
            gft_EnableRxBitSwap = FALSE;
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS7 (9.7.x)
         else if (s_FeatureSet == 7)
         {
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_NTR_use_212_Clock_units = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS8 (9.8.x)
         else if (s_FeatureSet == 8)
         {
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS9 (9.9.x)
         else if (s_FeatureSet == 9)
         {
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
      }

      // IFX 10.x (Rev1.4)
      if (s_PlatformType == 10)
      {
         gft_FE_IlvDilvMemType = SEPARATE_ILV; // indicates ILV/DILV memory type
         gul_FE_HW_ILV_MEM_SIZE = VINAX_REV1_HW_ILV_MEM_SIZE; // the maximum HW interleaver memory allowed to use
         gul_FE_HW_DILV_MEM_SIZE = VINAX_REV1_HW_DILV_MEM_SIZE; // the maximum HW deinterleaver memory allowed to use

         // Channel Discovery timeout time is increased to 16 sec from 13 sec
         gl_SynchroTimeoutCnt = (10+6)*TIMEOUT_CNT_1_SECONDS; // XDSLRTFW-2098

         // FS6 (10.6.x)
         if (s_FeatureSet == 6)
         {
            gft_EnableTxBitSwap = FALSE;
            gft_EnableRxBitSwap = FALSE;
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS8 (10.8.x)
         else if (s_FeatureSet == 8)
         {
            gft_disable_tx_tssi = TRUE;
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
         // FS9 (10.9.x)
         else if (s_FeatureSet == 9)
         {
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
      }
      // IFX 11.x (Rev2M)
      if (s_PlatformType == 11)
      {
         gft_FE_IlvDilvMemType = SHARED_ILV; // indicates ILV/DILV memory type
         gul_FE_HW_ILV_MEM_SIZE = VINAX_REV2_HW_ILV_MEM_SIZE; // the maximum HW interleaver memory allowed to use
         gul_FE_HW_DILV_MEM_SIZE = VINAX_REV2_HW_DILV_MEM_SIZE; // the maximum HW deinterleaver memory allowed to use

         if ((s_FeatureSet_rev2 == 9) || (s_FeatureSet_rev2 == 1))
         {
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
      }
      // IFX 12.x (Rev2L)
      if (s_PlatformType == 12)
      {
         gft_FE_IlvDilvMemType = SHARED_ILV; // indicates ILV/DILV memory type
         gul_FE_HW_ILV_MEM_SIZE = VINAX_REV2_HW_ILV_MEM_SIZE; // the maximum HW interleaver memory allowed to use
         gul_FE_HW_DILV_MEM_SIZE = VINAX_REV2_HW_DILV_MEM_SIZE; // the maximum HW deinterleaver memory allowed to use

         if ((s_FeatureSet_rev2 == 9) || (s_FeatureSet_rev2 == 1))
         {
            gul_dbgShowtimeControl |= (VDSL2_START_WITH_REVERB_FOR_SYNC_SYMBOL | VDSL2_USE_SHOWTIME_LIKE_CONST_MAP_FOR_SYNC_SYMBOL);
            guc_MULT_READ = MULT_READ_BACKWARD_COMPATIBILITY;
            guc_BLOCK_READ = BLOCK_READ_BACKWARD_COMPATIBILITY;
            gft_OldVNPsdFormat = TRUE;
            gft_EnableFixedPofiCorner = FALSE;
         }
      }
   }

   if (TESTArray[TEST_TX_PSD_CONTROL] & TEST_TX_PSD_DISABLE_TX_TSSI)
   {
      gft_disable_tx_tssi = TRUE;
   }
   //XDSLRTFW-2117 (Start)
   if ((gul_fe_G994VendorID == METANOIA_VENDOR_ID) || (gul_fe_G994VendorID == METANOIA_VENDOR_ID2))
   {
      gft_EnableImprovedATTNDR = FALSE;
   }
   //XDSLRTFW-2117 (End)

#if (defined(PROFILE_TASKS) || defined(PROFILE_TASKS_VR9))
   if (gs_RxTimerRollOverFlag == 0)
   {
      gl_MaxRxTimerCnt = gl_MaxTimePerFrame;
   }
   else
   {
      gl_MaxRxTimerCnt = RX_TIMER_MAX_CNT;
   }
#endif //#if (defined(PROFILE_TASKS) || defined(PROFILE_TASKS_VR9))

   //For diagnostic mode
   if(gul_OperationModeStatus_VDSL2 & V2_LOOP_DIAG)
   {
      //Diag. mode uses a differnt length for O-P-Quiet1 state
      gs_MinOPQuiet1StateLength = VDSL2_DIAG_MIN_O_QUIET_TX_LENGTH;
      gs_MaxOPQuiet1StateLength = VDSL2_DIAG_MAX_O_QUIET_TX_LENGTH;
      gs_Log2NumSymbolsToMeasureQln = LOG2SYMBOLCNT_MEASURE_QLN_DIAG;

      //Disable timeout check
      gs_EnableTimeoutCheckFlag = FALSE;

      // bytes per symbol in exchange phase
      guc_ExchangePhaseTxNumBytesPerSymbol = 1;
      guc_ExchangePhaseRxNumBytesPerSymbol = 1;

      //Disable MFDQ so we can use the SFDQ to compute the Hlin
      gft_EnableMfdq = 0;

      //Disable Medley state frame synch
      //otherwise there won't be enough time for modem to finish
      //all the test in Medley state in the diagnostic mode
      gs_MedleyFrameSynchEnableFlag &= (~EN_MEDLEY_SNR_FRAMEALIGNMENT);
   }

   //Set the timeout count based on the frame rate
   gus_EocFramesPer100ms = gs_frame_rate_is_8khz ? VDSL1_8KHZ_FRAMES_PER_100MS : VDSL1_4KHZ_FRAMES_PER_100MS;

   // XDSLRTFW-3212 : Upstream performance dip on short loops
   // initialize US PSD boost array for Channel Discovery
   // Initialization for Channel Discovery is a debug option which can be used to manipulate
   // the US PSD.
   gt_TxPsdControl.s_US_PSD_Boost_0dB1[0] = gt_TxPsdControl.s_US_PSD_Boost_CD_0dB1[0];    // US PSD boost for US0 [0.1dB] => 8 means 0.8dB
   gt_TxPsdControl.s_US_PSD_Boost_0dB1[1] = gt_TxPsdControl.s_US_PSD_Boost_CD_0dB1[1];    // US PSD boost for US1 [0.1dB] => 8 means 0.8dB
   gt_TxPsdControl.s_US_PSD_Boost_0dB1[2] = gt_TxPsdControl.s_US_PSD_Boost_CD_0dB1[2];    // US PSD boost for US2 [0.1dB] => 8 means 0.8dB
   gt_TxPsdControl.s_US_PSD_Boost_0dB1[3] = gt_TxPsdControl.s_US_PSD_Boost_CD_0dB1[3];    // US PSD boost for US3 [0.1dB] => 8 means 0.8dB
   gt_TxPsdControl.s_US_PSD_Boost_0dB1[4] = gt_TxPsdControl.s_US_PSD_Boost_CD_0dB1[4];    // US PSD boost for US4 [0.1dB] => 8 means 0.8dB

   return 1;

} //int16 ConfigTaskLayerForPostGhs(void)


/*****************************************************************************
;   Prototype: void InitModem_PostHandshake(void)
;
;   This subroutine initializes the modem variables after GHS.
;
;   Input Arguments: none
;
;   Output Arguments: none
;
;   Return:
;      SUCCEED               - Initialization is done successfully
;      FAIL                   - Initialization fails
;
;****************************************************************************/
void BgInitModem_PostHandshake(void)
{
   InitModem_PostHandshake();

   gs_RxBkgdProcessFlag = TRAINING_DONE;
}

void InitModem_PostHandshake(void)
{
   //XDSLRTFW-2999 Start
   if (TESTArray[TEST_Control4] & TEST_Control4_35bHwConfigIn17a_Bit6_Mask)
   {
      //If this flag is set means, Tx path is Debug 35b mode
      gft_Debug35bHwConfig17aModeEnable = TRUE;
   }
   //XDSLRTFW-2999 End

   //XDSLRTFW-3463  Start
   //During Handshake Pofi Fc should be 80KHz/320KHz, Post handshake restore Fc value
   gla_fc_pofi_lp_kHz[gus_AFE_TxMode] = gl_fc_pofi_lp_kHz_temp;
   //Enable Rx IIR in Handshake phase, after handshake enable it again
   gs_STR_DbgCntl |= STR_DBG_CNTL_DISABLE_RXIIR;
   //XDSLRTFW-3463 End
   //If the initial state is not G.hsinitialize parameters
   //configured after mode select
   if (TESTArray[TEST_InitState] != TEST_GhsInitState)
   {
      //Set the modem operation mode
      if(gsa_Optn0_ModeControl[1] & OPTN_ConfigMode_G993_2)
      {
         gus_ModemOperationMode_Status = MODEM_OPERATION_MODE_VDSL2;
         gsa_Stat1_Mode[1] = STAT_ConfigMode_G993_2;

         //Since the remote modem FFT size is not known, so we need to set it here
         if (gs_ModemHwMode == ADSL_PLUS_PLUS_MODE)
         {
            gs_FeModemLog2IfftSize = 11;   //for 1024 DS tones
         }
         else if(gs_ModemHwMode == ADSL_PLUS_MODE)
         {
            gs_FeModemLog2IfftSize = 10;   //for 512 DS tones
         }

         //Set the selected profiles to the preferer profile
         gt_ProfileAct.us_ProfileSelected = gt_ProfileControl.us_ProfilePreferred;
         gt_ProfileAct.ul_AnxAUS0PsdSelected = gt_ProfileControl.ul_AnxAUS0PsdPreferred;
         gt_ProfileAct.us_AnxBUS0PsdSelected = gt_ProfileControl.us_AnxBUS0PsdPreferred;
         gt_ProfileAct.us_AnxCUS0PsdSelected = gt_ProfileControl.us_AnxCUS0PsdPreferred;
      }

      //Set the loop diagnostic mode if applicable
      if (gs_MONI_AutoRestart & MONI_EnableDiagMode)
      {
         gul_OperationModeStatus_VDSL2 |= V2_LOOP_DIAG;
      }
      else
      {
         gul_OperationModeStatus_VDSL2 &= ~V2_LOOP_DIAG;
      }
   }

   //XDSLRTFW-2288 (Start)
#ifdef GHS_TN_DBG
   //DebugCode Only Disable setting of ADSL/HP2(AGC2) setting.
   if(TESTArray[TEST_GHS_LOG]&TEST_GHS_HP2_ADSL_Set)
   {
      TESTArray[TEST_GHS_LOG] &= ~TEST_GHS_HP2_ADSL_Set;
   }
#endif
   //XDSLRTFW-2288 (End)


   if (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_35B_MASK)
   {
      gs_RxLog2FftLength = DS_LOG2_FFT_LENGTH_16384;

      //Note: "gs_RxNumTones" get updated in "ConfigDfeParam()"
      //gt_PsdConfig.s_LastChannel = gs_RxNumTones;

//    Moved to task layer functions configuration
//      //If DS HRT 5,0 is disabled then do the configuration 1 symbol early.
//      if (!(gul_35bLiteConfig & EN_HRT_5_0_SCHEDULING_FOR_CASCADED_MODE))
//      {
//         gs_HandleRxCE_PeriodicStateStart_StartSym_Offset = -1;
//         gs_HandleRxCE_PeriodicStateStart_EndSym_Offset = -1;
//         gs_HandleRxCE_Periodic2StateStart_StartSym_Offset = -1;
//         gs_HandleRxCE_Periodic2StateStart_EndSym_Offset = -1;zuku
//      }
   }


   // Normally Interop related settings are done in ConfigTaskLayerForPostGhs(). But ConfigDfeParam needs the vendor specific windowing
   // setting and ConfigTaskLayerForPostGhs() needs the input of ConfigDfeParam(), so need to set this here
   if (gul_fe_G994VendorID == BRCM_VENDOR_ID)
   {
      // XDSLRTFW-2409: Broadcom uses a short TX Cyclic Prefix of 256 (compared to 440 of Avinx). In order to not apply Rx Windowing on ISI disturbed
      // Cyclic Prefix values we need to shorten the RX windowing coefficients.
      gft_ReduceChDiscoveryRxWindowLength = TRUE;
      if(gs_DbgRecnfgCpCsBeta & RX_WINOWING_BDCM_FIX_DIS)
      {
         gft_ReduceChDiscoveryRxWindowLength = FALSE;
      }

      if((gs_DbgRecnfgCpCsBeta & RX_CP_CS_BETA_BDCM_FIX_DIS) == 0)
      {
         gs_DbgRecnfgCpCsBeta |= RX_CP_CS_BETA_BDCM_EN;
      }
      if((gs_DbgRecnfgCpCsBeta & TX_CP_CS_BETA_BDCM_FIX_DIS) == 0)
      {
         gs_DbgRecnfgCpCsBeta |= TX_CP_CS_BETA_BDCM_EN;
      }
  }

   //Compute various IFFT/FFT related parameters
   ConfigDfeParam();

   //gs_RxNumTones is updated in "ConfigDfeParam()"
   gt_PsdConfig.s_LastChannel = gs_RxNumTones;

   // ConfigTaskLayerForPostGhs() should be called first to set variables
   // and then ConfigEngineForPostGhs() should be called to configure HW
   // Note: ghpuca_RxExtGains_Inactive/ghpuca_TxExtGains_Inactive is used, but it is set at ConfigModemForLinkStart()
   //       in fct. InitEngine_PreHandshake()/InitIridiaQT().
   ConfigTaskLayerForPostGhs();
   //gs_RxNumTones is updated in "ConfigDfeParam()"
   gt_PsdConfig.s_LastChannel = gs_RxNumTones;

   // In a test mode such as sleep state, ConfigEngineForPostGhs() is executed inside ProcessCNTL00() where interrupt is disabled.
   // TC loading functions are not executed unless interrupt is enabled again.
   // At link initiation, interrupt is enabled at LinkStart(), but swap page is overwritten before LinkStart(), which can lead to FW crash.
   // if test mode is enabled, call HW IO function directly here to avoid possible FW crash

//   if (gs_PauseControl == 0x32fe)
//   {
//      Pause(0x32fe);
//   }
   //This is the background function
   ConfigEngineForPostGhs();

   //Reconfigure AFE in background task for
   // - test mode
   // - after GHS
   ReconfigAFE_ForPostGhs();
   if (gus_DebugControlVRX518 & LD_POWER_DOWN_QUIET)
   {
      // Setting LD mode
      // Note: The Line Driver mode gets only be changed, if it differs from
      // the previous mode read out of the HW!
      AFED_SetLdMode(LD_PDN);
   }
   CalculateAfeDfeGains(); //XDSLRTFW-3441

   gta_StrymonRegDump[20][1]=3;           // update state
   gta_StrymonRegDump[21][1]=gt_ProfileAct.us_ProfileSelected;   //update mode

   for(int idx=0;idx<SIZE_STRYMON_REG_DUMP-2;idx++)
   {
      ReadCoreReg(gta_StrymonRegDump[idx][0], &gta_StrymonRegDump[idx][1]);
   }
   // Send the Strymon pre-ghs configuration as debug stream
   DSH_SendStream(STRYMON_CONF,2*SIZE_STRYMON_REG_DUMP*sizeof(uint32),&gta_StrymonRegDump[0][0]);

   //XDSLRTFW-1887 (Start)
   if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_R_P_PERIODIC_1)
   {
      //Freeze CPE Tx in state: R-P-PERIODIC-1
      gs_TxStateJumpFrom = VDSL2_R_P_SYNCHRO2_TX;
      gs_RxStateJumpFrom = VDSL2_R_O_P_SYNCHRO2_RX;

      //Disable timeout check
      gs_EnableTimeoutCheckFlag = FALSE;
   }
   else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_R_P_CHANNEL_DISCOVERY_2)
   {
      //Freeze CPE Tx in state: R-P-CHANNEL-DISCOVERY-2
      gs_TxStateJumpFrom = VDSL2_R_P_SYNCHRO3_TX;
      gs_RxStateJumpFrom = VDSL2_R_O_P_SYNCHRO3_RX;

      //Disable timeout check
      gs_EnableTimeoutCheckFlag = FALSE;
   }
   else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_R_P_MEDLEY)
   {
      //Freeze CPE Tx in state: R-P-MEDLEY
      gs_TxStateJumpFrom = VDSL2_R_MSG2_TX;
      gs_RxStateJumpFrom = VDSL2_R_O_TPS_RX;

      //Disable timeout check
      gs_EnableTimeoutCheckFlag = FALSE;
   }
   else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_SHOWTIME)
   {
      //Freeze CPE Tx in Showtime with CO defined fine gains
      gsa_MONI_ShowFailure_NE[0] = 0;
      gsa_MONI_ShowFailure_NE[1] = 0;
   }
   else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_SHOWTIME_UNITY_GAIN)
   {
      //Freeze CPE Tx in Showtime with unity fine gains
      gsa_MONI_ShowFailure_NE[0] = 0;
      gsa_MONI_ShowFailure_NE[1] = 0;

      TESTArray[TEST_Control3] |= TEST_ForceUpStreamFineGainsToUnity;
   }
   //XDSLRTFW-1887 (End)

} //InitModem_PostHandshake()
#endif //#ifdef INCLUDE_CACHE_FUNCTIONS
