/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: cnfg_task_preGhs.c
*
*   This file contains functions to configure Task Layer before GHS.
*
*-------------------------------------------------------------------------------
*/
// ***********************************************************************************************************
// cnfg_task_preGhs.c
//
// History
//
// 31/01/2018  Abu Rahman
//             XDSLRTFW-3688:Control of GPIO14 to indicate dying gasp for VDSL
//
//             In case of Dying Gasp set VRX518 GPIO pin 14 from high to low.
//             This feature is CMV controlled
//             CMV CNFG 58 bit CMV CNFG 58 Bit 8 (LSB = Bit0) = 1 Enable this feature
//             CMV CNFG 58 bit CMV CNFG 58 Bit 8 (LSB = Bit0) = 0 Disable this feature (default configuration)
//             Preferable configuration method for Enabling this feature: "dmms 3A48 0 1 0100 0100" at "wait for link activation" state
//
//             To control GPIO 14 first below mentioned registers need to be programmed
//             Register GPIO PAD PORTMUXC14(VRX518 address 0x24038) = 0
//             Register GPIO_FUNC DIRSET_0(VRX518 address 0x20048) bit14 value = 1
//             Register GPIO_FUNC OUTSET_0(VRX518 address 0x20040) bit14 value = 1
//
//             After detecting Dying Gasp
//             Register GPIO_FUNC OUTCLR_0(VRX518 address 0x20044) bit14 value = 1 will set
//             GPIO pin 14 voltage level low.
//             Check Jira for more information about register spec
//
//             Note: BAR registers can access only up to 64k from it's base address so that special care needed
//             to be taken while using BAR register to access data.
//
//             Grep pattern:  XDSLRTFW-3688
//
// 29/11/2018  Abu Rahman
//             XDSLRTFW-4050: Disable Autonomous State Event Messaging in VDSL mode
//             Autonomous State Event messaging was introduced with XDSLRTFW-3513. This functionality required special
//             message handling capability in SW which was introduced in UGW 8.1.1. It looks like concept were not adequate
//             to meet all the corner cases. This new feature often leads instabilities ( ie No TC Sync reporting in VDSL
//             mode, link drop in ADSL mode etc.) Due to these consequences the feature is decided to be disabled in FW
//             by default. If API tries to enable this feature then FW reports an exception (i.e E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION)
//
//             To enable or disable Autonomous state events handling in FW "test 46 0"  bit mask 0x0800 cmv is used
//             Enable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 1 (dmms 2E44 0 1 0800 0800)
//             Disable Autonomous Message Handling : test 46 0  bit mask 0x0800 value 0 (dmms 2E44 0 1 0800 0000) default configuration.
//             Grep pattern:  XDSLRTFW-4050
// ************************************************************************************************************


/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include <string.h>
#include "common.h"
#include "cmv.h"
#include "gdata.h"
#include "vdsl_state.h"
#include "states.h"
#include "ORTrainingRxF.h"
#include "OTrainingTxF.h"
#include "ROTrainingRxF.h"
#include "RTrainingTxF.h"
#include "sleep.h"
#include "preshow.h"
#include "show_lpbk_iof.h"
#include "ghs.h"
#include "codeswap.h"
#include "InitGlobalVars.h"
#include "V_STR_ini.h"
#include "V_STR_SRC_Ini.h"
#include "IRI_IOf.h"
#include "nmp.h"
#include "IRI_Ini.h"
#include "cri_ini.h"
#include "afe.h"
#include "LL_IOf.h"
#include "InitEngine_PreHandshake.h"
#include "V_STR_IOf.h"
#include "A_STR_IOf.h"
#include "CheckForUS0Enable.h"
#include "dsp_regs_62.h"
#include "codeswap.h"

void Read_LPR_Setting(void);

uint16 VR9_AFEWarmInit(void);
void InitGlobalVarsInDecMemoryAtLinkStart(void);
void EraseSRAMVarsAtLinkStart(void);
void CheckBARConfiguration(void); //XDSLRTFW-3255 (Start_End)
void CheckReTXAPIConfig(void); // XDSLRTFW-2998 (Start_End)
void CheckModemMonitor0Config(void);

#ifdef DEBUG_FLOW_TEST
extern uint32 gul_dbg_flowtest;
#endif

/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void SetupResetMessage(void)
*
*   Description:
*
*      if the MODEM MONITOR CMV is configured for Autonomous Messaging on
*   the RESET Macro State, then   this function queues up the Message.
*
*   Arguments:
*      none
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
AutoMsgPayLoadEntry_t gt_ModemResetPayLoad;
uint16 gus_ModemResetCode[2];

void SetupResetMessage(void)
{
   //If the Autonomous Message on Macro State RESET is enabled
   if (gusa_MONI_ModemStat_Status[0] & gusa_MONI_ModemStat[0])
   {
      gul_Pre_MONI_ModemStat_Status = (gusa_MONI_ModemStat_Status[0] & gusa_MONI_ModemStat[0]) | ((gusa_MONI_ModemStat_Status[1] & gusa_MONI_ModemStat[1]) << 16);
      gsa_PrevStat[0] = gsa_IndirectStat0[0];

      gus_ModemResetCode[0] = gsa_IndirectStat0[0];
      //gus_ModemResetCode[1] = gs_MONI_ModemStat_Status; this needs to be updated!!

      // set up and submit message
      gt_ModemResetPayLoad.uc_PayLoadLength = 1;
      gt_ModemResetPayLoad.uc_PayLoadSent = 0;
      gt_ModemResetPayLoad.pus_PayLoad= &gus_ModemResetCode[0];

      SubmitAutoMsg(&gt_ModemResetPayLoad, AUTONOMOUS_MSG_NOTIFICATION, AUTO_MSG_CR_HEADER_0, AUTO_MSG_STAT0_HEADER_1,
                    AUTO_MSG_STAT0_HEADER_2, AUTO_MSG_CR_HEADER_3, AUTO_MSG_STAT0_HEADER_4);
   }
   // For debug streams we want to report every modem macro state change if debug streams are enabled
   if((gt_debugStreamControl.Parameter0 & CMV_INFO115_CONTROL_MASK) != 0)
   {
         gs_DSH_PrevFsmState = gusa_MONI_ModemStat_Status[0];
         gpt_DSH_ModemFsmState->ul_FsmState =  gusa_MONI_ModemStat_Status[0];
         gpt_DSH_ModemFsmState->gsa_IndirectStat0 =  gsa_IndirectStat0[0];
         DSH_SendStream(DSH_FSM_STATE, sizeof(DSH_ModemFsmState), (void *)gpt_DSH_ModemFsmState);
   }
}

/*^^^
*-------------------------------------------------------------------
*
*   Prototype: int16 ConfigTaskLayerForLinkStart(void)
*
*   Description:
*
*      Initializes Task Layer variables, based on CMV settings,
*   at start of link initiation.  Currently this includes setting
*   the NextState variables based on the link mode (e.g. T1.413 vs.
*   DMT).
*
*   Arguments:
*      none
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
int16 ConfigTaskLayerForLinkStart(void)
{
   int16 i;

   // Latch certain CMV values by copying them to internal variables
   CMVLatchAtLinkStart();

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x10000000;
#endif
   // initialize global variables based on change of modem start-up settings
   // should be called after CMVLatchAtLinkStart()
   InitGlobalVarsAtLinkStart();

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x20000000;
#endif
   if (TESTArray[TEST_InitState] == TEST_GhsInitState)
   {
      //Set to the idle link state (the beginning of GHS)
      gs_TxNextState = R_SILENT0_TX;
      gs_RxNextState = R_C_SILENT1_RX;
      gpF_TxStateFunc = (PtrToFunc)RSilent0TxF;
      gpF_RxStateFunc = (PtrToFunc)RCSilent1RxF;
      guc_InitialPage = VDSL_GHS_1_PM_SWAPPAGE;
      gs_TxRxMessaging = PRE_GHS_CODESWAP_READY;   //Reset gs_TxRxMessaging used during GHS codeswap

      gsa_IndirectStat0[0] = STAT_ReadyState;
      gusa_MONI_ModemStat_Status[0] = MONI_STAT_READY;

#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x40000000;
#endif
   }
   else if (TESTArray[TEST_InitState] == TEST_TrainInitState)
   {
      //Set the initial training state
      //Set the initial training state
      gs_TxNextState = R_P_QUITE1_TX;   //R_MSG1_TX
      gs_RxNextState = R_O_P_QUITE1_RX;  //R_O_TRAIN_RX

      //gpF_TxStateFunc = (PtrToFunc)RSleepTxF;

      if (gsa_Optn0_ModeControl[1] & OPTN_ConfigMode_G993_2)
      {
         gpF_TxStateFunc = (PtrToFunc)RMsg1TxF_VDSL2;
         gpF_RxStateFunc = (PtrToFunc)ROTrainRxF_VDSL2;
         guc_InitialPage = VDSL_CHDIS_1_V2_PM_SWAPPAGE;
      }

      gsa_IndirectStat0[0] = STAT_FullInitState;
      gusa_MONI_ModemStat_Status[0] = MONI_STAT_FULL_INIT;
   }
   else if (TESTArray[TEST_InitState] == TEST_TestInitState)
   {
      //Set the initial training state
      gs_TxNextState = SLEEP_TX;
      gs_RxNextState = SLEEP_RX;
      gpF_TxStateFunc = (PtrToFunc)RSleepTxF;
      gpF_RxStateFunc = (PtrToFunc)RSleepRxF;
      guc_InitialPage = VDSL_SLEEP_PM_SWAPPAGE;
      gsa_IndirectStat0[0] = STAT_TestState;
      gusa_MONI_ModemStat_Status[0] = MONI_TEST_STATE;    // XDSLRTFW-3513 (Start_End)
   }
   else if (TESTArray[TEST_InitState] == TEST_ShowtimeInitState)
   {
      gs_TxNextState = R_PRE_SHOWTIME_TX;
      gs_RxNextState = R_O_PRE_SHOWTIME_RX;

      guc_InitialPage = VDSL_PRESHOW_PM_SWAPPAGE;

      //For showtime connectivity test, using different preshow functions
      if(TESTArray[TEST_LoopbackMode] == TEST_LpbkDisabled)
      {
      }
      //For loopback test, using the old preshow functions
      else
      {
         //gpF_TxStateFunc = (PtrToFunc)PreShowtimeTxF;
         //gpF_RxStateFunc = (PtrToFunc)PreShowtimeRxF;
      }
#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x80000000;
#endif
   }

   //In Test mode, or showtime connectivity test, initialize the band plan at CPE side
   //since this information is not passed from CO to CPE
   if((TESTArray[TEST_InitState] == TEST_TestInitState) || (TESTArray[TEST_InitState] == TEST_ShowtimeInitState))
   {
      // Mask out the US0 band bit
      gs_NumOfTxBands = (gt_TxBandControl.us_NumberOfBands & 0xFF);

      gs_TxNumTonesUsed = 0;
      for (i=0; i<gs_NumOfTxBands; i++)
      {
         gsa_TxBandLeftChannel[i] = gt_TxBandControl.ut_BandRecord[i].us_FirstTone;
         gsa_TxBandRightChannel[i] = gt_TxBandControl.ut_BandRecord[i].us_LastTone;
         gs_TxNumTonesUsed += gsa_TxBandRightChannel[i] - gsa_TxBandLeftChannel[i] + 1;
      }

      // Mask out the US0 band bit
      gs_NumOfRxBands = (gt_RxBandControl.us_NumberOfBands & 0xFF);

      gs_RxNumTonesUsed = 0;
      for (i=0; i<gs_NumOfRxBands; i++)
      {
         gsa_RxBandLeftChannel[i] = gt_RxBandControl.ut_BandRecord[i].us_FirstTone;
         gsa_RxBandRightChannel[i] = gt_RxBandControl.ut_BandRecord[i].us_LastTone;
         gs_RxNumTonesUsed += gsa_RxBandRightChannel[i] - gsa_RxBandLeftChannel[i] + 1;
      }

      gs_NumOfRFIBands = gt_RFIBandControl.us_NumberOfBands;
      for (i=0; i<gs_NumOfRFIBands; i++)
      {
         gsa_RFIBandLeftChannel[i] = gt_RFIBandControl.ut_BandRecord[i].us_FirstTone;
         gsa_RFIBandRightChannel[i] = gt_RFIBandControl.ut_BandRecord[i].us_LastTone;
      }

      // check if US0 is enabled
      gft_US0BandUsed = CheckForUS0Enable();

   } //if((TESTArray[TEST_InitState] == TEST_TestInitState) || (TESTArray[TEST_InitState] == TEST_ShowtimeInitState))

   return 1;
}

// XDSLRTFW-3688 :Control of GPIO14 to indicate dying gasp (Start)
/*******************************************************************************
*
*   Prototype: void InitVRX518Regs_for_Gpio14(void)
*
*   This function initializes variables used for controlling VRX518 GPIO14 pin
*
*   To initialize VRX518 GPIO14 pin below mentioned VRX518 registers need be programmed
*   Register GPIO PAD PORTMUXC14(VRX518 address 0x24038) = 0
*   Register GPIO_FUNC DIRSET_0(VRX518 address 0x20048) bit14 value = 1
*   Register GPIO_FUNC OUTSET_0(VRX518 address 0x20040) bit14 value = 1
*
*   With present implementation all these registers are accessible via BAR18 register since BAR18 is
*   pointing to CHIPID_EFUSE register(0x18000) register space.
*
*   Please check Jira for the VRx518 Register spec for more information
*
*   Note: BAR registers can access only up to 64k from it's base address so that special care
*   needed to be taken while using BAR register to access data.
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Returns: none
*
*   Global Variables: none
*
*
*******************************************************************************/


void InitVRX518Regs_for_Gpio14(void)
{
   FlagT ft_AddressInRange = TRUE;

   uint32 ul_data;
   volatile uint32 ul_RegAddress;

   int32 l_GPIO_PAD_PORTMUXC14_AddressOffset;
   int32 l_GPIO_FUNC_DIRSET_0_AddressOffset;
   int32 l_GPIO_FUNC_OUTSET_0_AddressOffset;
   int32 l_GPIO_FUNC_OUTCLR_0_AddressOffset;

   uint32 ul_AddressPointedByBAR18;


   // VRX518 CHIPID_EFUSE (relative) base address which is stored in first 20 bits of DSP_XMEM_BAR18
   // address location. 12 MS bits are used for PCIe_BaseAddress
   // all the address access via BAR18 register must be located within 64K byte address range from it's base address

   ul_AddressPointedByBAR18 = *((volatile uint32 *)DSP_XMEM_BAR18) & 0xFFFFF;

   l_GPIO_PAD_PORTMUXC14_AddressOffset = VRX518_GPIO_PAD_PORTMUXC14_ADDRESS - ul_AddressPointedByBAR18;
   l_GPIO_FUNC_DIRSET_0_AddressOffset = VRX518_GPIO_FUNC_DIRSET_0_ADDRESS - ul_AddressPointedByBAR18;
   l_GPIO_FUNC_OUTSET_0_AddressOffset = VRX518_GPIO_FUNC_OUTSET_0_ADDRESS - ul_AddressPointedByBAR18;
   l_GPIO_FUNC_OUTCLR_0_AddressOffset = VRX518_GPIO_FUNC_OUTCLR_0_ADDRESS - ul_AddressPointedByBAR18;

   // BAR register can access only 64k address space from it's base address
   if ((l_GPIO_PAD_PORTMUXC14_AddressOffset < 0) || (l_GPIO_PAD_PORTMUXC14_AddressOffset > 65535))
   {
      ft_AddressInRange = FALSE;
   }

   if ((l_GPIO_FUNC_DIRSET_0_AddressOffset < 0) || (l_GPIO_FUNC_DIRSET_0_AddressOffset > 65535))
   {
      ft_AddressInRange = FALSE;
   }

   if ((l_GPIO_FUNC_OUTSET_0_AddressOffset < 0) || (l_GPIO_FUNC_OUTSET_0_AddressOffset > 65535))
   {
      ft_AddressInRange = FALSE;
   }
   if ((l_GPIO_FUNC_OUTCLR_0_AddressOffset < 0) || (l_GPIO_FUNC_OUTCLR_0_AddressOffset > 65535))
   {
      ft_AddressInRange = FALSE;
      // note: this check is done in initialization but the register access is done in showtime code at show_iof.c file
   }



   if (ft_AddressInRange)
   {
      // note: all the memory locations below are located outside ARC memory region. According to coding guideline
      // these memory locations must be accessed via DMA! Since this function is called before the link start
      // and there are no code swap happening during this time, we can access theses location via direct access.
      // !! These memory accesses are exception!!

      // Initialize GPIO PAD register for GPIO 14
      //set register PORTMUXC14 value to 0
      ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)l_GPIO_PAD_PORTMUXC14_AddressOffset;
      ul_data = 0;
      *(volatile uint32 *)ul_RegAddress = ul_data;

      // Initialize GPIO_FUNC register for GPIO 14
      // set register DIRSET_0 bit 14 value to 1(b)
      ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)l_GPIO_FUNC_DIRSET_0_AddressOffset;
      ul_data = *(volatile uint32 *)ul_RegAddress;
      ul_data |= 0x4000;  // set bit 14 to 1
      *(volatile uint32 *)ul_RegAddress = ul_data;

      // set register OUTSET_0 bit 14 value to 1(b)
      ul_RegAddress = (uint32)(&__StartOfSramBAR18) + (uint32)l_GPIO_FUNC_OUTSET_0_AddressOffset;
      ul_data = *(volatile uint32 *)ul_RegAddress;
      ul_data |= 0x4000; // set bit 14 to 1
      *(volatile uint32 *)ul_RegAddress = ul_data;
   }
   else
   {
      EnterFailStates(E_CODE_BAD_MEM_ACCESS);
   }
}
// XDSLRTFW-3688 :Control of GPIO14 to indicate dying gasp (End)


/*^^^
*-------------------------------------------------------------------
*
*   Prototype: int16 ConfigEngineForLinkStart(void)
*
*   Description:
*
*      Initializes HW settings, based on CMV and variable conifigurations,
*   at start of link initiation.
*
*   Arguments:
*      none
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void ConfigEngineForLinkStart(void)
{
   gl_ld_line_gain_db = LD_TO_LINE_GAIN_DB_HYB_TYPE_1;

   //=========================================================================
   // Set HW control based on CMV settings
   //=========================================================================
   Read_LPR_Setting();

   // Initialize strymon for VDSL
   V_Str_Init();

   // XDSLRTFW-3688 :Control of GPIO14 to indicate dying gasp (Start)
   if (gsa_Cnfg_Misc[0] & CNFG_MISC_VRX518_ENABLE_GPIO14_FOR_DYING_GASP)
   {
      InitVRX518Regs_for_Gpio14();
   }
   // XDSLRTFW-3688 :Control of GPIO14 to indicate dying gasp (End)

   // Reconfig CRI block
#ifdef DISTRIBUTE_TX_RX_PROCESS
   if (gft_DistributeTxRxProcess)
   {
      InitCRI();
   }
#endif

   if(gs_RxLog2FftLength == DS_LOG2_FFT_LENGTH_8192)
   {
      ModifyMedleyPrbsSkipBits(RX, guc_dbgMedleyRxPrbsSkipBits);
   }
   if(gs_TxLog2IfftLength == US_LOG2_FFT_LENGTH_8192)            // US_LOG2_FFT_LENGTH_8192 = 13
   {
      ModifyMedleyPrbsSkipBits(TX, guc_dbgMedleyTxPrbsSkipBits);
   }

   gta_StrymonRegDump[0][0]=V_CONTROL_ADDR;
   gta_StrymonRegDump[1][0]=V_OVERFLOW_ADDR;
   gta_StrymonRegDump[2][0]=V_TX_EXTEN_35B_ADDR;
   gta_StrymonRegDump[3][0]=V_TX_BETA_35B_ADDR;
   gta_StrymonRegDump[4][0]=V_LBK_35B_ADDR;
   gta_StrymonRegDump[5][0]=V_TX_FSIZE_35B_ADDR;
   gta_StrymonRegDump[6][0]=V_TX_VARGAIN_ADDR;
   gta_StrymonRegDump[7][0]=V_TXIIR1_CFG_ADDR;
   gta_StrymonRegDump[8][0]=V_TXIIR2_CFG_ADDR;
   gta_StrymonRegDump[9][0]=V_SRCFR_ADDR;
   gta_StrymonRegDump[10][0]=V_SRC_CFG_ADDR;
   gta_StrymonRegDump[11][0]=V_INTERP_CFG_ADDR;
   gta_StrymonRegDump[12][0]=V_HBFILT_CFG_ADDR;
   gta_StrymonRegDump[13][0]=V_TX_WDF_INT1_CTRL_35B_ADDR;
   gta_StrymonRegDump[14][0]=V_TX_WDF_INT1_COEF_35B_ADDR;
   gta_StrymonRegDump[15][0]=V_DFI_TX_WDF_INT2_CTRL_35B_ADDR;
   gta_StrymonRegDump[16][0]=V_DFI_TX_WDF_INT2_COEF_35B_ADDR;
   gta_StrymonRegDump[17][0]=V_DFI_TX_NS_CTRL_35B_ADDR;
   gta_StrymonRegDump[18][0]=V_DFI_TX_NS_COEF_35B_ADDR;
   gta_StrymonRegDump[19][0]=V_RX_FSIZE_35B_ADDR;

   gta_StrymonRegDump[20][0]=0x12345678;  // Fake register address to indicate state
   gta_StrymonRegDump[20][1]=0;           // holds state
   gta_StrymonRegDump[21][0]=0x87654321;  // Fake register address to indicate mode
   gta_StrymonRegDump[21][1]=-1;          // holds mode (-1 no mode selected)

   for(int idx=0;idx<SIZE_STRYMON_REG_DUMP-2;idx++)
   {
      ReadCoreReg(gta_StrymonRegDump[idx][0], &gta_StrymonRegDump[idx][1]);
   }
   // Send the Strymon pre-ghs configuration as debug stream
   DSH_SendStream(STRYMON_CONF,2*SIZE_STRYMON_REG_DUMP*sizeof(uint32),&gta_StrymonRegDump[0][0]);
}


/*^^^
*-------------------------------------------------------------------
*
*   Prototype: void ConfigModemForLinkStart(void)
*
*   Description:
*
*      Initializes task layer and HW, based on CMV and variable conifigurations,
*   at start of link initiation.
*
*   Arguments:
*      none
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void ConfigModemForLinkStart(void)
{
#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x1000000;
#endif
   // initialize Task Layer
   // - CMVLatchAtLinkStart();       // Latch certain CMV values by copying them to internal variables
   // - InitGlobalVarsAtLinkStart(); // initialize global variables based on change of modem start-up settings
                                     // should be called after CMVLatchAtLinkStart()
   ConfigTaskLayerForLinkStart();

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x2000000;
#endif
   InitEngine_PreHandshake();

   // initialize hardware
   ConfigEngineForLinkStart();
#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x8000000;
#endif
   //XDSLRTFW-2096: sleep state operation(Start_End)
   InitGlobalVarsInDecMemoryAtLinkStart();

   EraseSRAMVarsAtLinkStart();

   ConfigVrx518Afe_VersionSpecific();

   CheckReTXAPIConfig();   //XDSLRTFW-2998 (Start_End)
   CheckModemMonitor0Config(); // XDSLRTFW-4050: Disable Autonomous State Event Messaging in VDSL mode


}

/***************************************
;  Prototype: void InitGlobalVarsInDecMemoryAtLinkStart(void)
;
;  Description: Initialize all the variables present in DEC memory in this function.
;               ConfigEngineForLinkStart() initializes the DEC memory to zero,
;               Hence, this function has to be called after ConfigEngineForLinkStart().
;
;  Arguments: None
;  Global variables:
;
*************************************/
//XDSLRTFW-2096: sleep state operation(Start)
void InitGlobalVarsInDecMemoryAtLinkStart(void)
{
   int16 i;
   if((TESTArray[TEST_InitState] == TEST_TestInitState) || (TESTArray[TEST_InitState] == TEST_ShowtimeInitState))
   {
      //Mask out the US0 band bit
      gs_NumOfTxBands = (gt_TxBandControl.us_NumberOfBands & 0xFF);

      gs_TxNumTonesUsed = 0;
      for (i=0; i<gs_NumOfTxBands; i++)
      {
         gsa_TxBandLeftChannel[i] = gt_TxBandControl.ut_BandRecord[i].us_FirstTone;
         gsa_TxBandRightChannel[i] = gt_TxBandControl.ut_BandRecord[i].us_LastTone;
         gs_TxNumTonesUsed += gsa_TxBandRightChannel[i] - gsa_TxBandLeftChannel[i] + 1;
      }

      //Mask out the US0 band bit
      gs_NumOfRxBands = (gt_RxBandControl.us_NumberOfBands & 0xFF);

      gs_RxNumTonesUsed = 0;
      for (i=0; i<gs_NumOfRxBands; i++)
      {
         gsa_RxBandLeftChannel[i] = gt_RxBandControl.ut_BandRecord[i].us_FirstTone;
         gsa_RxBandRightChannel[i] = gt_RxBandControl.ut_BandRecord[i].us_LastTone;
         gs_RxNumTonesUsed += gsa_RxBandRightChannel[i] - gsa_RxBandLeftChannel[i] + 1;
      }

      gs_NumOfRFIBands = gt_RFIBandControl.us_NumberOfBands;
      for (i=0; i<gs_NumOfRFIBands; i++)
      {
         gsa_RFIBandLeftChannel[i] = gt_RFIBandControl.ut_BandRecord[i].us_FirstTone;
         gsa_RFIBandRightChannel[i] = gt_RFIBandControl.ut_BandRecord[i].us_LastTone;
      }

      //check if US0 is enabled
      gft_US0BandUsed = CheckForUS0Enable();

   }//if((TESTArray[TEST_InitState] == TEST_TestInitState) || (TESTArray[TEST_InitState] == TEST_ShowtimeInitState))
}
//XDSLRTFW-2096: sleep state operation(End)

//XDSLRTFW-3255 (Start)
// We are checking for the BAR register configuration before using the data from EFUSE or configuring the PPE32 clock frequency.
// BAR 18 is used to point the EFUSE registers (CHIPID_EFUSE with an offset 0x18000)
// BAR 19 is used to point the PPE32 clock frequency memory space(CGU with an offset 0x0000)
void CheckBARConfiguration(void)
{
   uint32 ul_BAR15, ul_BAR16, ul_BAR18;

   //API command to see the configured BAR values:
   //Port-0 or Single Line: cat /proc/driver/mei_cpe/meminfo/00
   //Port-1: cat /proc/driver/mei_cpe/meminfo/01

   ul_BAR15 = *(uint32 *)(DSP_XMEM_BAR15); //Points to SDRAM page containing DSL FW variables
   ul_BAR16 = *(uint32 *)(DSP_XMEM_BAR16); //Points to SDRAM page containing DSL FW variables
   ul_BAR18 = *(uint32 *)(DSP_XMEM_BAR18); //Points to CHIPID_EFUSE registers

   if ((ul_BAR15 == 0) || (ul_BAR16 == 0) || ((ul_BAR18 & BAR_REGISTER_OFFSET) != BAR18_REGISTER_OFFSET))
   {
      gft_BAR_Not_Configured = TRUE;
   }
}

// XDSLRTFW-2998 (Start)
void CheckReTXAPIConfig(void)
{
   uint16 us_temp;
   us_temp = gt_ReTXParams.t_ReTXConfigCMV.us_DsUsReTxCapable;
/*
    Value     Description
      0      ReTx not Supported (IFEC)
      1      DS ReTx Supported
      2      US and DS ReTx Supported
      3      Incorrect configuration by API

*/
   if ((us_temp & 0x3) == 3)
   {
      EnterFailStates(E_CODE_RETX_API_INCORRECT_CONFIG);
   }
}
// XDSLRTFW-2998 (End)
// XDSLRTFW-4050: Disable Autonomous State Event Messaging in VDSL mode (Start)
/*
*-------------------------------------------------------------------
*
*   Prototype: void CheckModemMonitor0Config(void)
*
*   Description:
*
*   This function set exception code if API tries to enable Autonomous State Event Messaging
*
*   Note:
*   In General Autonomous State Event Polling mode is forbidden. For test purpose this mode
*   can be enabled via cmv test 46 bit mask 0x0800
*
*   Arguments:
*      none
*
*   Global Variables:
*     gusa_MONI_ModemStat[]: Autonomous message event reporter controller variable.
*-------------------------------------------------------------------
*/
void CheckModemMonitor0Config(void)
{
   uint32 ul_ErrorCode = 0;

   // non zero value of gusa_MONI_ModemStat[] means Autonomous message is configured which is not a valid configuration
   if ((gusa_MONI_ModemStat[0] != 0) || (gusa_MONI_ModemStat[1] != 0))
   {
      // Test 46 bit mask 0x0800 is FW internal bit to enable Autonomous message for test purpose. If this bit is not enabled then
      // go for exception if API enables the Autonomous message
      if((TESTArray[TEST_Control4] & TEST_Control4_Autonomous_State_Event_Msg_Bit11_Mask) != TEST_Control4_Autonomous_State_Event_Msg_Bit11_Mask)
      {
         ul_ErrorCode = E_CODE_MODEM_FSM_EVENT_NOT_ALLOWED_CONFIGURATION;

      }
      else // if the Autonomous message is enabled by FW
      {
         // According to VRX51x_xDSL_Firmware_UM_PR_Rev3.1.2_Int.pdf document restriction applied in bit field 4,5,and 9 of Modem_Monitor 0 CMV variable
         // Bit field 9 (STEADY_STATE_TC_SYNC_FIRSTTIME) and bit filed 4 (STEADY_STATE_TC_NOSYNC) shall be mutually exclusive
         // Bit field 9 (STEADY_STATE_TC_SYNC_FIRSTTIME) and bit filed 5 (STEADY_STATE_TC_SYNC) shall be mutually exclusive
         if ((gusa_MONI_ModemStat[0] & MONI_STAT_SHOW_TCSYNC_FIRSTTIME) == MONI_STAT_SHOW_TCSYNC_FIRSTTIME)
         {
            if (((gusa_MONI_ModemStat[0] & MONI_STAT_SHOW_TC_NOSYNC) == MONI_STAT_SHOW_TC_NOSYNC) || ((gusa_MONI_ModemStat[0] & MONI_STAT_SHOW_TCSYNC) == MONI_STAT_SHOW_TCSYNC))
            {
               ul_ErrorCode = E_CODE_MODEM_FSM_EVENT_CONFIGURATION_ERROR;
            }
         }
      }
   }

   if(ul_ErrorCode != 0 )
   {
      EnterFailStates(ul_ErrorCode);
   }
}
// XDSLRTFW-4050: Disable Autonomous State Event Messaging in VDSL mode (End)

void EraseSRAMVarsAtLinkStart(void)
{
   if (gus_DSL_FW_InternalControl & DSL_ERASE_SRAM_VARS)
   {
      memset(&__StartOfSramBAR15,0,(64*1024)); //Erase BAR-15 page, size of page = 64KB
      memset(&__StartOfSramBAR16,0,(512*1024)); //Erase BAR-16 page, size of page = 512KB
   }
}
//XDSLRTFW-3255 (End)

/***************************************************************************************
;   Subroutine Name: Read_LPR_Setting
;
;   Description:
;      This function reads the default value of GPIO dying gasp pin .
;       and initialize the low power setting
;
;   Prototype:
;      void Read_LPR_Setting(void)
;
;   Input Arguments:
;      none
;   Output Arguments:
;      none
;   Return Value:
;      none
;
;**********************************************************************************************/
void Read_LPR_Setting(void)
{
   uint32 ul_data;
   uint16 us_temp;

   ul_data = GetDspReg(DSP_GPIO_DATA);
   us_temp = (ul_data & MASK_BIT15)>>15;
   if (us_temp == 1)
   {
      gus_LowPowerSetting = 0;
   }
   else
   {
      gus_LowPowerSetting = 1;
   }
}

