/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1994-2011 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   main_hw.c
 *
 *   Exec for Bit true models
 *
 *----------------------------------------------------------------------------
 */

// ***********************************************************************************************************
// main_hw.c
//
// History
//
// 16/05/2012 Vinjam: Code Pointers connected to Downstream Virtual Noise feature
//    Hardcoded enabling of downstream virtual noise for testing purpose
//    as UGW5.1 software is not setting it bydefault. Vinjam - 21 May 2012
//      Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 29/8/2012 Vinjam: Duisabled Hardcoded enabling of "Downstream" virtual noise feature
//      Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 22/01/2013 Kannan: Call Exception handler if AFE initialization fails if DSL 24 0 0x1
//                   CMV is enabled.
//      Grep for: "XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication"
// 30/1/2013 Vinjam: Added code under a compiler switch "VECTORING_BUILD". This helps to create
//      a VR9 VDSL2 Vector firmware with version number x.x.x.x.x.7
//      Grep for XDSLRTFW-696 Feature_ALL_VDSL2_ALL_SpecialFirmwareForVector
//
// 05/02/2013 Kannan: Byte offset 9 of portmode control structure "uc_AfePowerUp" bits b4-2 are used to
//                   detect the Hybrid module detection, But port mode control sturcture is over written with
//                   AFE init status. This is common for both VR9 & VRX318. it is corrected now.
//                   Grep for: "XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus"
//
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//                       added the delta freq offset in DSL 25 to gl_constant_SRCFR_offset
//                       Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
//
// 05/03/2013 Vinjam: Removed "Hardcoded" enabling of AELEM feature. Firmware must honour the API setting to enable/disable AELEM.
//                    By default, AELEM feature is enabled by default (as per Vrx Msg Spec 1.2)
//                    Grep for XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
//
// 24/01/2014 Vinjam: Relocated Toggle ChipID for VRx318 based on a CMV
//            Added new IOP bit to toggle the Firmware version (first digit, chip ID) string sent in G.Hs
//            CMV allotted: CMV INFO 232 3 Bit#1, default set to "0" (i.e. sends FW version as 7.x.x.x).
//            Reason for this: (i) Old deployed Avinax/Vinax Firmware supports VDSL2 ReTx for VR9 FW (5.x.x.x.x.x) only. So
//            to bring up VDSL2 ReTx with old Avinax/Vinax DSLAM, send VRx318 FW version as 5.x.x.x (instead of 7.x.x.x) in G.Hs.
//            (ii) VRx318 FW sends FW version as 7.x.x.x with new Avinax firmware for VDSL2 ReTx.
//            grep for XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString
// 04/02/2014 Varun:  Added test cmv TEST 28 0 0x0200 to Enable indication Tx dalay with Delay in DTUs=0 and Symbols=5
//                    This is disabled by default i.e CPE indicates Delay in DTU=1 and Symbol=6 by default
//                     Grep for XDSLRTFW-1439
//
// 05/02/2014 Prashant: Default setting for TxDelay is changed to DTUs=1 and Symbols=5.
//                      To make DTU=1 and Symbol=6, use dmms 0x1c44 0 1 0x200 0x200
//                      Grep for XDSLRTFW-1539 (corrected from the previous)
//
// ************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"
#include "PrintTrail.h"
#include "gdata.h"
#include "linkstart.h"
#include "RunCores.h"
#include "RunModem.h"
#include "InitModem_PowerUp.h"
#include "InitModem_PreHandshake.h"
#include "InitEngine_PreHandshake.h"
#include "cmv.h"
#include "mp.h"
#include "nmp.h"
#include "states.h"
#include "vdsl_state.h"
#include "stateini.h"
#include "sleep.h"
#include "InitBMf.h"
#include "cnfg_task.h"
#include "afeif_iof.h"
#include "AllocateDataBuffers.h"
#include "DetectInterrupts.h"
#include "codeswap.h"
#include "vdsl_xception.h"
#include "LL_IOf.h"
#include "cri_iof.h"
#include "CustomerTasks.h"
#include "V_STR_IOf.h"
#include "ModemMonitor.h"
#include "dsp_op.h"
#include "Delay.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "Ll_Iof.h"
#include "Dsp_regs_62.h"
#include "ppe_memmap.h"
#include "hercules_memrymap.h"


#include "aux_regs.h"
void _exit_halt(void);

void ExitProgram(int);
void ProcessCNTL00(void);
void ProcessWinHostConfigMsgs(void);
void SwapInPage(uint8 uc_SwapPageNum);
void Init_SystemVendor_VersionInfo(void);
/*-------------------------------------------------------------------
*
*  void main(int argc, char *argv[])
*
*  Description: This is the main program for running the modem simulation.
*
*  Command line arguments:
*
*   main tx_infile tx_outfile rx_infile rx_outfile initial_state [tx_conf rx_conf]
*     tx_infile      - input to tx process (binary unsigned byte file)
*     tx_outfile     - output from tx process (binary int16 file)
*     rx_infile      - input to rx process (binary int16 file)
*     rx_outfile     - output from rx process (binary unsiged byte file)
*     intial_state   - tx state to kick off processing with, current options are
*        GHS            (start in G.handshake state)
*        TRAIN       (proceed directly to trainsceiver training)
*        SHOWTIME    (proceed directly to showtime)
*        RETRAIN        (proceed directly to fast retrain)
*
*     tx_conf:    - optional TX configuration number, determines which set
*                   of (R, S, D, FrameSize, BAT) values are used (see config.c)
*                   default is 0
*     rx_conf:    - optional RX configuration number, determines which set
*                   of (R, S, D, FrameSize, BAT) values are used (see config.c)
*                   default is 0
*
*
*-------------------------------------------------------------------
*^^^
*/


DATA_LOCAL_LD_ST_BEGIN
int16 gs_ExitMainLoop;
int16 gs_ExitConfigMsgs;
int16 gs_ExitSims;
int16 gs_WaitForQTDoneFlag;
int16 gs_ImageType;
DATA_MAP_END;

void ProcessCNTL10(void);

void CommonInits(void);



#ifdef DEBUG_FLOW_TEST
uint32 gul_dbg_flowtest = 0;
#endif

volatile int32 gl_MainLoopCnt;

void main(int argc, char *argv[])
{
   uint32 ul_data, ul_addr;

//Please do not remove!
#ifdef TEST_CODE
   CocomoTestFunction();
#endif



#if defined(VR9_SHOW_LPBK_TEST)
   //*((int32 *)SIMEXT_CLOCK_CORE_MODE)=  gus_ClockCoreMode;
   *((int32 *)SIMEXT_CLOCK_CORE_MODE)=  CLOCK_CORES_OVERRIDE;
#endif

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x1;
#endif
   // the first thing do is to clear data pages
   InitDataPages();
#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x2;
#endif
   //XDSLRTFW-542: Platform_VR9_VRX318_AFE_InitStatus (START_END)
   gt_PortModeControl.uc_AfePowerUp = (uint8)((gt_PortModeControl.uc_AfePowerUp & (~AFE_POWERUP_MASK)) | AFE_COLD_START);

   gs_FirstLink = 1;
   gs_WaitForQTDoneFlag = 0;


   // =======================================================================
   // set image type variable/CMV
   // =======================================================================
   gs_ImageType = 0x01;

   // InitBMs, InitCodeSwap, InitHW
   CommonInits();

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x4;
#endif
#ifdef CUSTOMER_TASKS
   Customer_HwSetUp();
#endif // CUSTOMER_TASKS


   // =======================================================================
   // Initialize MEI and Codeswap interface
   // =======================================================================
   NewMPInitialize();            // MPDLL exists; init MP mailboxes.

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x8;
#endif

   InitModem_PowerUp();

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x10;
#endif

   // XDSLRTFW-3711 (Start)
   // Making sure that the DREG registers are cleared before modem ready. This is
   // essential if the CPE has crashed (or could not do a graceful shutdown) on the
   // previous run. Also, now the for PPE Frequency scaling, we are relying on the bits
   // of the DREG register (DREG_FRAMER_REQUEST_ENABLE --> 0x7DC7). Refer the PPE_DSL_Notification
   // document for further bit definitions.

   // Bit defintion of DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF

   // 0x7DC6 (DREG_MISCRAM6_ADDR)
   //  Bit 0      --> Set by PPE driver when Framer can be turned ON and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by PPE driver when dynamic frequency scaling is supported and cleared by DSL FW when showtime is left

   // 0x7DC7 (DREG_MISCRAM7_ADDR)
   //  Bit 0      --> Set by DSL FW when Framer request is turned OFF. Cleared by PPE FW after triggering an interrupt to PPE driver

   // Resetting of DREG_BC0_LINK_STATUS --> 0x7DC0
   ul_addr = DREG_MISCRAM0_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data & (MASK_BIT0 | MASK_BIT1))
   {
      ul_data &= (~(MASK_BIT0 | MASK_BIT1));
      WritePpeReg(ul_addr,ul_data);

      // This code is added here just to make sure that DSL FW clears this bit incase of a crash.
      // DSL FW needs to set Bit 0 of DREG7 to inform PPE that Framer Request is turned off. This bit is cleared by PPE FW.
      // Please refer the document "PPE DSL Notifications" for more information.
      // Bit definition of 0x7DC7 (DREG_MISCRAM7_ADDR)
      //  Bit 0     --> Framer Request Stopped (Set by DSL FW and cleared by PPE FW)
      ul_addr = DREG_MISCRAM7_ADDR;
      ReadPpeReg(ul_addr, &ul_data);
      ul_data |= MASK_BIT0;
      WritePpeReg(ul_addr,ul_data);
   }

   // Resetting of DREG_FRAMER_REQUEST_ENABLE --> 0x7DC6
   // Bit definition of 0X7DC6 (DREG_MISCRAM6_ADDR):
   //  Bit 0      --> Framer Request Enable (Set by the PPE driver and cleared by DSL FW)
   //  Bit 1      --> Dynamic Frequency supported (Set by the PPE driver and cleared by DSL FW)
   //  Bit 2      --> To indicate whether ERB descriptors are reset (Set by the PPE driver and cleared by DSL FW)
   ul_addr = DREG_MISCRAM6_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data & (MASK_BIT0 | MASK_BIT1 | MASK_BIT2))
   {
      ul_data &= ~(MASK_BIT0 | MASK_BIT1 | MASK_BIT2);
      WritePpeReg(ul_addr,ul_data);
   }
   // XDSLRTFW-3711 (End)

   //Setup "Modem Ready" Message
   NewMPSetupReadyMessage();

#ifdef DEBUG_FLOW_TEST
   gul_dbg_flowtest |= 0x20;
#endif
   /* ============================================================================ */
   /* Stay in loop forever except in simulations where we can exit by */
   /* setting gs_ExitSims to non-zero.*/
   /* ============================================================================ */

   // XDSLRTFW-3255 (Start)
   if (gft_BAR_Not_Configured == TRUE)
   {
      EnterFailStates(E_CODE_BAR_NOT_CONFIGURED);
   }
   // XDSLRTFW-3255 (End)

   gs_ExitSims = 0;

   while (gs_ExitSims == 0)
   {
#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x40;
#endif
      guc_InitialPage = VDSL_INIT_2_PM_SWAPPAGE;
      SwapInPage(guc_InitialPage);

      /* ======================================================================= */
      /* Initialize Modem for connection start*/
      /* ======================================================================= */
      InitModem_PreHandshake();

#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x80;
#endif
      // if post GHS initialization is necessary
      if (gft_RunPostGhsInit == 1)
      {
         // load post GHS swap page
         SwapInPage(VDSL_GHS_1_PM_SWAPPAGE);
         SwapInPage(VDSL_GHS_2_PM_SWAPPAGE);
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x2000;
#endif
         // run post GHS initialization
         InitModem_PostHandshake();
      }

      /* Load DMTscope page */
      if(gsa_IndirectStat0[0] == STAT_TestState)
      {
         SwapInPage(VDSL_CUST_TEST_PM_SWAPPAGE);
      }

      // Load xTC Steady-Page
      SwapInPage(VDSL_CUST_STEADY_PM_SWAPPAGE);

      // guc_InitialPage is set inside ConfigModemForLinkStart()
      SwapInPage(guc_InitialPage);

      // on VR9 system, interrupts always enabled on both ports by the booloader_62

      // Enable interrupts
      LinkStart();

#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x100;
#endif
      /* ======================================================================= */
      /* Run Modem: main loop */
      /* ======================================================================= */
      gs_ExitMainLoop = 0;
      while (gs_ExitMainLoop == 0)
      {

#ifdef POLLING_CORE_INTERRUPTS
         /* =================================================================== */
         /* FFT Connectivity Mode: if FFT Connectivity Mode is selected then */
         /* we need to transfer one frames worth of data from the Dli.dll to    */
         /* the FFT output buffer for each QT DONE interrupt.   */
         /* Since the interrupt is received after the QT processing, the transfer  */
         /* must occur before the ClockCores function.  The flag TBD is used    */
         /* to insure only one frame of data is transfered for each interrupt.  */
         /* this flag is set when the data is transferred and cleared following */
         /* an QT DONE interrupt.                                   */
         /* Note also that the FFT and QT blocks are in cascade mode.  For      */
         /* FFT Connectivity Mode, the FFT is disabled so that the data       */
         /* transferred in from the Dli.dll is not overwritten.              */
         /* =================================================================== */
         if (TESTArray[TEST_Control] & TEST_ConnControl)
         {
            if ((gs_WaitForQTDoneFlag == 0) &&
               (((TESTArray[TEST_Mode] & 0x000F) != STANDARD_STRYMON_CONNECT)) &&
                    ((TESTArray[TEST_Mode] & 0x000F) != FFT_TIME_DOMAIN_CONNECT) &&
                     ((TESTArray[TEST_Mode] & 0x000F) != FFT_TIME_DOMAIN_CONNECT8192))
            {

               // s_WaitForQTDoneFlag limits data transfer to once per QT Done interrupt
               gs_WaitForQTDoneFlag = 1;

               if(((TESTArray[TEST_Mode] & 0x000F) == ST_FREQ_DOMAIN_CONNECT8192) || ((TESTArray[TEST_Mode] & 0x000F) == FFT_FREQ_DOMAIN_CONNECT8192))
               {
                  FreqDomainConnRxTrigger(8192<<1, 1);
               }
               else
               {
                  FreqDomainConnRxTrigger(4096<<1, 1);
               }

            }
         } //if (TESTArray[TEST_Control] & TEST_ConnControl)

         /* =================================================================== */
         /* Process data with the cores. Also read and write i/o data files. */
         /* =================================================================== */
         if (RunCores() == 0)
         {
            gs_ExitSims = 1;
            break;
         }
#endif // POLLING_CORE_INTERRUPTS


         // ===================================================================
         // For TARGET_COCOMO and TARGET_SIM
         // Service interrupts: run time-critical and non time-critical tasks.
         // For all TARGET_X, run background tasks.
         // ===================================================================
         if(RunModem() == 0)
         {
            gs_ExitSims = 1;
            break;
         }

#ifdef POLLING_CORE_INTERRUPTS
         // s_WaitForQTDoneFlag limits data transfer to once per QT Done interrupt
         // gs_FDInterruptSource is a duplicate of gs_InterruptSource
         if (gs_FDInterruptSource & (1 << RX_QT_DONE))
         {
            gs_WaitForQTDoneFlag = 0;
         }

         /* =================================================================== */
         /* FFT Connectivity Mode: if FFT Connectivity Mode is selected and   */
         /* a TX_QT_DONE interrupt is present, then transmit IFFT input data */
         /* directly to the Connectivity DLI via the AFEIF interface.        */
         /* =================================================================== */

         if (TESTArray[TEST_Control] & TEST_ConnControl)
         {
            if ((gs_FDInterruptSource & (1 << TX_QT_DONE)) &&
               ((TESTArray[TEST_Mode] & 0x000F) != STANDARD_STRYMON_CONNECT ) &&
               ((TESTArray[TEST_Mode] & 0x000F) != FFT_TIME_DOMAIN_CONNECT) &&
               ((TESTArray[TEST_Mode] & 0x000F) != FFT_TIME_DOMAIN_CONNECT8192))
            {
               //Read the HW TX var gain value
               int16 s_TxVarGain;
               ReadTxVarGain(&s_TxVarGain);

               //Always pass the maximum tones (regardless of FFT size is chosen)
               //to since CPE only uses the maximum number of tones
               if(((TESTArray[TEST_Mode] & 0x000F) == ST_FREQ_DOMAIN_CONNECT8192) || ((TESTArray[TEST_Mode] & 0x000F) == FFT_FREQ_DOMAIN_CONNECT8192))
               {
                  FreqDomainConnTxTrigger(8192<<1, s_TxVarGain);
               }
               else
               {
                  FreqDomainConnTxTrigger(4096<<1, s_TxVarGain);
               }
            }
         } //if (TESTArray[TEST_Control] & TEST_ConnControl)

#endif // POLLING_CORE_INTERRUPTS


//MAHESHGHS1
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x200;
#endif
         ProcessWinHostConfigMsgs();
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x400;
#endif

         gl_MainLoopCnt++;
      } // while (gs_ExitMainLoop == 0)


      gs_FirstLink = 0;




      guc_PortActive = 0;

   } // while (gs_ExitSims == 0)

   /* ==================================================================== */
   /* Shut down modem */
   /* ==================================================================== */



   ExitProgram(0);

}

volatile int32 gl_SwapInPageCnt;

void SwapInPage(uint8 uc_SwapPageNum)
{

   uint8 uc_SwapStatus;

   if ((guc_PrimPageHandle = RequestSwap1(uc_SwapPageNum, SWAP_TIMING_OFF)) == INVALID_CODESWAP_HANDLE)
   {
      EnterFailStates(E_CODE_CODESWAP_ERR);
      return;
   }

   while(1)
   {
      // NewMPCheckMessage();         // commented out to avoid receiving un-wanted configuration messages


      uc_SwapStatus = GetRequestStatus(guc_PrimPageHandle);
      if (uc_SwapStatus == SWAP_DONE)
      {
         break;
      }
      else if (uc_SwapStatus == SWAP_ERROR)
      {
         EnterFailStates(E_CODE_CODESWAP_ERR);
         break;
      }

      gl_SwapInPageCnt++;
   }

   // no matter success or erro, free the handle
   FreeSwapHandle(&guc_PrimPageHandle);
   return;
}

#include "xdma.h"

void hw_reset(void);


#define BOOT_PAGE_MASK              0x80000000

typedef struct
{
   int32 l_ImageSize;
   int32 l_ImageCheckSum;
   int32 l_NumOfSwaps;
} ImageHeader_t;

ImageHeader_t gt_ImageHeader;

typedef struct
{
   int32 l_PmSrcOffset;
   int32 l_PmDestAddr;
   int32 l_PmSize;

   int32 l_DmSrcOffset;
   int32 l_DmDestAddr;
   int32 l_DmSize;
} SwapPageHeader_t;
SwapPageHeader_t gt_SwapHeader;

int32 gl_ModemID = 0xBD51;

void LoadBootLoader62(void)
{
   int32 l_SwapHeaderOffset, l_Page, l_PageSrcAddr, l_PageSize, l_SramOffset;

   guc_xdma_reg_offset = 0;
   guc_ch_id = 0;

   // set xdma fields in PORT_SEL register
   // the macro DSP_PORT_0_SEL_MASK already contains correct XDMA setting for either ports.
   SetDspReg(DSP_PORT_SEL, DSP_PORT_0_SEL_MASK);


   // set SramOffset to zero for bootloader image
   l_SramOffset = 0;

   // read XDSL image header
   ReadXdmaBlock(l_SramOffset, (int32)&gt_ImageHeader, sizeof(ImageHeader_t));
   l_SwapHeaderOffset = l_SramOffset + sizeof(ImageHeader_t);


   // bring in boot page for the bootloader
   for (l_Page = 0; l_Page < gt_ImageHeader.l_NumOfSwaps; l_Page++)
   {
      // the swap header
      ReadXdmaBlock(l_SwapHeaderOffset, (int32)&gt_SwapHeader,  sizeof(SwapPageHeader_t));

      // after toggle the MSB, the boot page size should be > 0
      if ((l_PageSize = gt_SwapHeader.l_PmSize ^ BOOT_PAGE_MASK) > 0)
      {
         l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_PmSrcOffset;

         ReadXdmaBlock(l_PageSrcAddr, gt_SwapHeader.l_PmDestAddr, l_PageSize << 2);
      }

      if ((l_PageSize = gt_SwapHeader.l_DmSize ^ BOOT_PAGE_MASK) > 0)
      {
         l_PageSrcAddr = l_SramOffset + gt_SwapHeader.l_DmSrcOffset;

         ReadXdmaBlock(l_PageSrcAddr, gt_SwapHeader.l_DmDestAddr, l_PageSize << 2);
      }

      l_SwapHeaderOffset += sizeof(SwapPageHeader_t);
   }

}

void ProcessCNTL10(void)
{
   uint8 uc_XdslMode;
   uint8 uc_PortMode;

   // effectively halt the other port
   _disable1();

   // validate mode-switch request and set desired modes
   switch (CNTLArray[CNTL_ModemModeSwitch])
   {
   case ONE_PORT_ADSL:
      uc_XdslMode = ADSL_PORT_MODE;
      uc_PortMode = SINGLE_PORT_MODE;
      break;

   case ONE_PORT_VDSL:
      uc_XdslMode = VDSL_PORT_MODE;
      uc_PortMode = SINGLE_PORT_MODE;
      break;

   case TWO_PORT_ADSL:
      uc_XdslMode = ADSL_PORT_MODE;
      uc_PortMode = DUAL_PORT_MODE;
      break;

   case TWO_PORT_VDSL:
      uc_XdslMode = VDSL_PORT_MODE;
      uc_PortMode = DUAL_PORT_MODE;
      break;

   case MODESWITCH_SOFT_RESET:
      uc_XdslMode = gt_PortModeControl.uc_XdslModeCurrent;
      uc_PortMode = gt_PortModeControl.uc_DualPortModeCurrent;
      break;

   default:
      // invalid mode requested; just resume modem operation
      _enable1();
      return;
   }

   gt_PortModeControl.uc_XdslModeCurrent = uc_XdslMode;
   gt_PortModeControl.uc_DualPortModeCurrent = uc_PortMode;

   // Note that ModeSwitching is happing in the BG so all ADMA transfers have
   // been finished.

   // terminate all XDMA transfers
   SetDspReg(DSP_XDMA0_CTRL, 0);
   SetDspReg(DSP_XDMA1_CTRL, 0);

   // Bring in bootable pages for BootLoader
   LoadBootLoader62();

   // transition to Bootloader
   hw_reset();
}



void ProcessWinHostConfigMsgs(void)
{
   /* ==================================================================== */
   /* process WINHOST MP message */
   /* ==================================================================== */
   if (gs_ModemOperationRequiredShadow == 1)
   {
      gs_ModemOperationRequiredShadow = 0;
      gs_ModemOperationRequired = 0;
      ProcessCNTL00();
   }
   else if (gs_ModemOperationRequiredShadow == 2)
   {
      gs_ModemOperationRequiredShadow = 0;
      gs_ModemOperationRequired = 0;

      // to prevent "junk" messages to the host when we switch from VDSL to ADSL
      // wait for ME to read the mailbox before exiting
//      while(TxMailBoxPending()) // (l_TimeCount++ < 0x1000) &&
      while(guc_MPMsgRespReq || TxMailBoxPending())
      {
      }

      ProcessCNTL10();
   }
}


void ExitProgram(int exit_code)
{
   _exit_halt();
}





extern int16 gs_ExitMainLoop;
extern int16 gs_ExitConfigMsgs;
extern int16 gs_ExitSims;
extern int16 gs_WaitForQTDoneFlag;
extern int16 gs_ImageType;


void ProcessCNTL00(void)
{
   uint32 ul_data;

   switch(CNTLArray[0] & 0x000F)
   {
   case CNTL_ModemReset:  // Soft Reset
      // soft-reset can only performed if the modem has passed the
      // link initiation setup (meaning it already enters into one of
      // the train states).
      // ignore soft-reset message if it's already in reset state
      if ((gft_AllowSoftReset == 1) && (gs_ExitConfigMsgs != 0))
      {
         EnterFailStates(E_CODE_MODEM_RESET);      // Force modem reset
         gft_IssueSoftReset = 1;
      }
      break;

   case CNTL_ModemStart:     // Link Start
#ifdef DEBUG_FLOW_TEST
      gul_dbg_flowtest |= 0x200000;
#endif
      //Hardcoded enabling of downstream virtual noise for testing purpose
      //as UGW5.1 software is not setting it bydefault. Vinjam - 21 May 2012
      //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
      //gus_FeaturesControl |= DSL_EnableDSVirtualNoise;

      // XDSLRTFW-487_VR9_VRX318_VDSL2_All_AELEM_Support
      //Hardcoded enabling of AELEM support for testing purpose. Removed to honour the API setting.
      //gus_FeaturesControl |= DSL_EnableAELEM;

      //Relocated as it is not honouring the CMV setting
      //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (Start)
      if(gt_CustomerIopBits.us_Generic_IOP_Fixes & GENERIC_TOGGLE_CHIP_ID_IN_GHS_VERSION)
      {
         Init_SystemVendor_VersionInfo();
         /* Vendor Specific Information */
         gt_ne_VendorInformation.uca_VendorSpecific[1] = (uint8)gus_ne_G994VendorSpecific;
         gt_ne_VendorInformation.uca_VendorSpecific[0] = (uint8)(gus_ne_G994VendorSpecific >> 8);
      }
      //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (End)


      //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [Start]
      gl_constant_SRCFR_offset = gl_constant_SRCFR_offset + (int32)(gs_InitFreqOffsetDelta * (-16));
      //XDSLRTFW-561 Enhancement_All_All_All_FreqOffset [End]

      //XDSLRTFW-696 Feature_ALL_VDSL2_ALL_SpecialFirmwareForVector (Start)
#ifndef VECTORING_BUILD
      gus_DsmCtrlCmv &= ~G9935_FULL_VECTORING_SUPPORT;
#endif
      //XDSLRTFW-696 Feature_ALL_VDSL2_ALL_SpecialFirmwareForVector (End)

      // XDSLRTFW-3170 (Start)
      // The register ID_CFG - Chip Configuration register, consists of details about the profiles supported by VRx518/VRx517 system.
      // The bits 15:13 is used to indicated the support of DSL profiles. And these values are mapped to the Bit 8, 6 and 5 of ARC GPIO
      // register which can be read from the ARC. The value and its interpretation is as below:

      //  |  Value  | Profile Supported
      //  |    0    |  All profiles
      //  |    1    |  Disable 35B support and retain till 30a       ==> VRx517 Chip
      //  |    2    |  Disable 35B,30a support and retain till 17a
      //  |    3    |  Disable 35B,30a,17a support and retain till 12x
      //  |    4    |  Disable 35B,30a,17a,12x support and retain till 8x

      ul_data = GetDspReg(DSP_GPIO_DATA);
      ul_data = (((ul_data & 0x100) >> 6) | ((ul_data & 0x60) >> 5));

      if (ul_data == 1)
      {
         gt_ProfileControl.us_ProfileSupported &= ~(CNFG_V2_PROFILE_35B_MASK);
      }
      else if (ul_data == 2)
      {
         gt_ProfileControl.us_ProfileSupported &= ~(CNFG_V2_PROFILE_35B_MASK | CNFG_V2_PROFILE_30A_MASK);
      }
      else if (ul_data == 3)
      {
         gt_ProfileControl.us_ProfileSupported &= ~(CNFG_V2_PROFILE_35B_MASK | CNFG_V2_PROFILE_30A_MASK | CNFG_V2_PROFILE_17A_MASK);
      }
      else if (ul_data == 4)
      {
         gt_ProfileControl.us_ProfileSupported &= ~(CNFG_V2_PROFILE_35B_MASK | CNFG_V2_PROFILE_30A_MASK | CNFG_V2_PROFILE_17A_MASK | CNFG_V2_PROFILE_12xALL_MASK);
      }
      // XDSLRTFW-3170 (End)

      // AFE ARX208 Support (JIRA - XDSLRTFW-279) - START
      if (gft_NoVDSLIndication == 1)
      {
         EnterFailStates(E_CODE_VR9_NO_VDSL_MODE);
         gsa_IndirectStat0[0] = STAT_FailState;
         gusa_MONI_ModemStat_Status[0] = MONI_STAT_FAIL;
      }
      else
         // AFE ARX208 Support (JIRA - XDSLRTFW-279) - END
      {
         if (gft_LinkInitiated == 1)
         {
            break;
         }

         gft_LinkInitiated = 1;

#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x400000;
#endif
         //Configure modem for link start
         ConfigModemForLinkStart();
#ifdef DEBUG_FLOW_TEST
         gul_dbg_flowtest |= 0x800000;
#endif
         //if(gs_PauseControl == 0x32c3)
         //{
         //    Pause(0x32c3);
         //}
         //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START)
         if ((gul_ExceptionCode != E_CODE_NO_ERROR) &&
               (gus_DSL_FW_InternalControl & DSL_VR9_VRX318_AFE_INIT_FAIL_ENABLE))
         {
            EnterFailStates(gul_ExceptionCode);
            gsa_IndirectStat0[0] = STAT_FailState;
            gusa_MONI_ModemStat_Status[0] = MONI_STAT_FAIL;
         }
         //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (END)


         //If the initial state is not G.hs, call the following functions to perform post-GHS configuration
         //(otherwise, these functions should be called at the end of Ghs)
         // these functions currently reside in the INIT page.
         if (TESTArray[TEST_InitState] != TEST_GhsInitState)
         {
            gft_RunPostGhsInit = 1;
         }

         gs_ExitConfigMsgs = 1; // exit msg processing loop

         // Update previous CNTL 0 0 CMV
         gs_prev_CNTL00 = CNTLArray[0] & 0x000F;
         gft_AllowSoftReset = 1;
      }
      //XDSLRTFW-1539(START)
      //if 0x200 ==> if 10th bit is set then make delay in DTUs=1 and symbols=6
      if((TESTArray[TEST_Control3] & TEST_EnableTxDelayMin))
      {
         gt_UsReTx_ConfigVar.s_TxHalfRoundTripInDTUs = 1;
         gt_UsReTx_ConfigVar.s_TxHalfRoundTripInSymbols = 6;

      }
      else
      {

         gt_UsReTx_ConfigVar.s_TxHalfRoundTripInDTUs = 0;
         gt_UsReTx_ConfigVar.s_TxHalfRoundTripInSymbols = 5;

      }
      //XDSLRTFW-1539(END)
      break;

   case 5:     // support jump to sleep mode from done state
      // swap in sleep page and jump to sleep state
      // but don't reset any HW or FW
      TESTArray[TEST_InitState] = TEST_TestInitState;

      guc_InitialPage = VDSL_SLEEP_PM_SWAPPAGE;
      SwapInPage(guc_InitialPage);

      gs_TxNextState = SLEEP_TX;
      gs_RxNextState = SLEEP_RX;
      gpF_TxStateFunc = (PtrToFunc)RSleepTxF;
      gpF_RxStateFunc = (PtrToFunc)RSleepRxF;

      // init substates to "do nothting"
      TESTArray[TEST_TxSubState] = -1;
      TESTArray[TEST_RxSubState] = -1;

      gsa_IndirectStat0[0] = STAT_TestState;
      gusa_MONI_ModemStat_Status[0] = MONI_TEST_STATE;    // XDSLRTFW-3513 (Start_End)

      // Update previous CNTL 0 0 CMV
      gs_prev_CNTL00 = CNTLArray[0] & 0x000F;

      break;

   case CNTL_ModemSleep:     // sleep mode

      if (gft_LinkInitiated == 1)
      {
         break;
      }

      gft_LinkInitiated = 1;

      TESTArray[TEST_InitState] = TEST_TestInitState;

      //Configure modem for link start
      ConfigModemForLinkStart();

      //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START)
      if ((gul_ExceptionCode != E_CODE_NO_ERROR) &&
            (gus_DSL_FW_InternalControl & DSL_VR9_VRX318_AFE_INIT_FAIL_ENABLE))
      {
         EnterFailStates(gul_ExceptionCode);
         gsa_IndirectStat0[0] = STAT_FailState;
         gusa_MONI_ModemStat_Status[0] = MONI_STAT_FAIL;
      }
      //XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (END)

      gft_RunPostGhsInit = 1;

      gs_ExitConfigMsgs = 1; // exit msg processing loop

      // Update previous CNTL 0 0 CMV
      gs_prev_CNTL00 = CNTLArray[0] & 0x000F;
      gft_AllowSoftReset = 1;

      break;

   // XDSLRTFW-3647 (Start)
   case CNTL_LD_POWERDOWN:     /* Line Driver Mode -> Power down*/
      gsa_IndirectStat0[0] = STAT_DSL_POWER_DOWN_STATE;
      gusa_MONI_ModemStat_Status[1] = MONI_DSL_POWER_DOWN;
      AFED_SetLdMode(LD_PDN);
      WriteCoreReg((uint32)(V_FCSI_CMD_D_35B_ADDR), FCSI_CMD_RST_CONTROLLER_BUSREGS);  //V_FCSI_CMD_C_35B_ADDR = 0x4000 means 010B  --> RST
      delay(50);
      WriteCoreReg((uint32)(V_FCSI_CMD_C_35B_ADDR), FCSI_CMD_RST_CONTROLLER_BUSREGS);  //V_FCSI_CMD_C_35B_ADDR = 0x4000 means 010B  --> RST
      delay(50);
      break;
      // XDSLRTFW-3647 (End)

   case CNTL_ModemStop:     // Teardown mode

      // Force modem failure
      if((gs_RxNextState != FAIL_RX) && (gs_TxNextState != FAIL_TX))
      {
         EnterFailStates(E_CODE_MODEM_FAIL);
      }

      break;

   }

   _enable1();
}

