/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CustomerTasks.c
*
*
*-------------------------------------------------------------------------------
*/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "cmv.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "PrintTrail.h"
#include "nmp.h"
#include "profile.h"
#include "g997.h"
#include "vdsl_state.h"
#include "LL_IOf.h"
#include "profile.h"
#include "CustomerTasks.h"
#include "xTC_CmvDefinitions.h"
#include "DmtScope_MsgHandler.h"
#include "xTC_VersionInfo_Init.h"

extern int32 gl_SRAMImageOffset;

/*******************************************************************************
*
*   Prototype: void Customer_HwSetUp(void)
*
*   This function provides customer access to the initial HW setup.
*   called once at the top of main() function.
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/
void Customer_HwSetUp(void)
{
}



void InitCustomer_PowerUp(void)
{

   /* By default XTC has been selected */
   FlagT gft_AlphaeusSel = FALSE;

   /* watchdog timer is disabled due to bus arbitration problems */
   gt_WatchdogTimerEnable = 0;

   /* Set version information */
   Init_SystemVendor_VersionInfo();
}

/*******************************************************************************
*
*   Prototype: void InitCustomer_PreHandshake(void)
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

void InitCustomer_PreHandshake(void)
{

}

uint16 GetMsgOpcodeForResponse(uint8 xTCMsgExecuted, uint16 MsgOpcode);
uint16 GetCorrectMsgIDForResponse(uint16 MsgID, uint16 MsgOpcode);

DATA_CUST_IBRAM_BEGIN
HerculesMPStruct_t HMP_BgRxBuffer;
AutoMsgPayLoadEntry_t   DefPayloadStruct, NFCPayloadStruct;
uint16 MailboxCode, HeaderWord0, HeaderWord1, HeaderWord2, HeaderWord3, HeaderWord4;
uint16 gus_MailboxCode;     // for other CMV handler to pass Mbox code to the generation of auto msg.
uint8 state_CustBgCmvResponse;
uint8  guc_xTCMsgExecuted;
FlagT gft_CustBlockSlowMsg;
FlagT flag_CmvBkgdDirectAcknowledge;
DATA_MAP_END;

void CmvBkgdHandlerCreatePayload(uint16 SendPayloadSize, uint16 NewMailboxCode,
                                 uint16 MsgID, uint16 xTCMsgExecuted)
{
   uint16 MsgOpcode;

   /* Create MailboxCode */
   MailboxCode = NewMailboxCode;

   /* Create HeaderWord0 */
   MsgOpcode = (HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) &
               HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;
   HeaderWord0 = (HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord0 & HMP_WORD0_BITSIZE_MASK_B4_SHIFT) |
                 (GetMsgOpcodeForResponse(xTCMsgExecuted, MsgOpcode) << HMP_WORD0_OPCODE_SHIFT);

   /* Create HeaderWord1 */
   HeaderWord1 = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord1 & CLEAN_PAYLOADSIZE_IN_HEADER;
   HeaderWord1 = HeaderWord1 | SendPayloadSize;

   /* Create HeaderWord2 */
   HeaderWord2 = GetCorrectMsgIDForResponse(MsgID, MsgOpcode);

   /* Create HeaderWord3 */
   HeaderWord3 = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord3;

   /* Create HeaderWord4 */
   HeaderWord4 = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord4;

   /* Fill PayLoad structure depends from payload size */
   DefPayloadStruct.pus_PayLoad = &HMP_BgRxBuffer.usa_HmpPayLoad[0];
   DefPayloadStruct.uc_PayLoadLength = SendPayloadSize;
   DefPayloadStruct.uc_PayLoadSent = 0;

}


void CustSlowCmvSendsAutoMsg(void)
{
   uint16 PayLoadSize, MsgID;


   switch(state_CustBgCmvResponse)
   {
   case CUST_SLOW_CMV_IDLE:
      break;

   case CUST_SLOW_CMV_CREATE_AUTO_MSG:
      /* Get information from header */
      PayLoadSize = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;
      MsgID = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord2;

      CmvBkgdHandlerCreatePayload(PayLoadSize, gus_MailboxCode, MsgID, guc_xTCMsgExecuted);

      state_CustBgCmvResponse = CUST_SLOW_CMV_SEND_AUTO_MSG;
      // intentionally drop thru next case !!!
      /* no break */

   case CUST_SLOW_CMV_SEND_AUTO_MSG:

      if (AUTO_MSG_QUEUE_OPERATION_SUCCESS == SubmitAutoMsg(&DefPayloadStruct, MailboxCode,
            HeaderWord0, HeaderWord1, HeaderWord2, HeaderWord3, HeaderWord4))
      {
         state_CustBgCmvResponse = CUST_SLOW_CMV_WAIT_FOR_AUTO_MSG_SENT;
      }
      break;

   case CUST_SLOW_CMV_WAIT_FOR_AUTO_MSG_SENT:
      /* Check send flag from AutoMessageQueue */
      if (DefPayloadStruct.uc_PayLoadSent == 1)
      {
         state_CustBgCmvResponse = CUST_SLOW_CMV_IDLE;
         gft_CustBlockSlowMsg = FALSE;
      }
      break;
   }
}

/*******************************************************************************
*
*   Prototype: void CustomerBgTaskManager(void)
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/
void CustomerBgTaskManager(void)
{
   CustSlowCmvSendsAutoMsg();
}

/*******************************************************************************
*
*   Prototype: void CustomerSetSwapEngineType(void)
*
*      This function is called from InitCodeSwap to select the
*   desired code swap method, either thru ME or XDMA interface.
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*
*******************************************************************************/
void CustomerSetSwapEngineType(void)
{
   gl_SRAMImageOffset = gt_PortModeControl.l_SRAMImageOffset;

}


/*
*-------------------------------------------------------------------------------
*
*   Prototype: void Customer_1sec_Task(void)
*
*   This function performs customer specific G997 1 sec task.
*
*   Input Arguments:
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*
*-------------------------------------------------------------------------------
*/

void Customer_1sec_Task(void)
{
}
