/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: CustomerBgTasks.c
*
*-------------------------------------------------------------------------------
*/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "states.h"
#include "fifo.h"
#include "cmv.h"
#ifdef DEBUG_TRAIL
#include "LeaveStatesTrail.h"
#endif //DEBUG_TRAIL
#include "PrintTrail.h"
#include "nmp.h"
#include "profile.h"
#include "g997.h"
#include "vdsl_state.h"
#include "LL_IOf.h"
#include "profile.h"
#include "CustomerTasks.h"
#include "xTC_CmvDefinitions.h"
#include "DmtScope_MsgHandler.h"
#include "BaseTypes.h"
#include "xTC_VersionInfo.h"
#include "xTC_DebugMsgHandler.h"
FlagT gft_AlphaeusSel = FALSE;

uint8 guca_Customer_g997_TCSync_Flag[NUM_DATA_PATHS];
uint8 guca_Customer_g997_OutOfSync_Failure_NE[NUM_DATA_PATHS];



/*******************************************************************************
*
*   Prototype: void CustomerTxForeground
*
*   This function provides customer access to the Tx Foreground processing.  It is
*   called each TX interrupt from the TxForeground function.
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

void CustomerTxForeground(void)
{


}

/*******************************************************************************
*
*   Prototype: void CustomerRxForeground
*
*   This function provides customer access to the Rx Foreground processing.  It is
*   called each Rx interrupt from the RxForeground function.
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

void CustomerRxForeground(void)
{

}


/*******************************************************************************
*
*   Prototype: void InitCustomer_PostHandshake(void)
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/

void InitCustomer_PostHandshake(void)
{

}

uint16 GetMsgOpcodeForResponse(uint8 MsgExecuted, uint16 MsgOpcode)
{

   uint16  MsgRetOpcode = MsgOpcode;

   /*
   ** Set new function opcode depends from execution result
   */
   switch (MsgExecuted)
   {

      /*
      ** CMV executed successfully
      ** In case of a slow execution, send a fast acknowledge
      */
   case RC_POSITIVE:
      /* Return function opcode (Last bit = 1)*/
      MsgRetOpcode = MsgOpcode ^ 1;
      break;

      /*
      ** Command not allowed
      */
   case RC_DENIED:
      MsgRetOpcode = D2H_ERROR_CMD_NOT_ALLOWED;
      break;

      /*
      ** Parameter out of range
      ** Parameter not allowed for current configuration
      */
   case RC_PARAM_RANGE:
   case RC_PARAM_CONFIG:
      MsgRetOpcode = D2H_ERROR_PARAMETER_WRONG;
      break;

      /*
      ** Invalid payload length
      */
   case RC_PAYLOAD_LEN:
      MsgRetOpcode = D2H_ERROR_ILLEGAL_PAYLOAD_SIZE;
      break;

      /*
      ** Resource occupied
      */
   case RC_RES_OCC:
      MsgRetOpcode = D2H_ERROR_RESOURCE_OCCUPIED;
      break;

      /*
      ** CMV with unallowed bitsize
      ** CMV with unknown Message ID
      ** CMV unknown
      */
   case UNALLOWED_BITSIZE:
      MsgRetOpcode = D2H_ERROR_CMV_UNKNOWN;
      break;

      /*
      ** CMV with wrong PHY- or MMD-Address
      ** CMV with wrong device
      */
   case MDIO_WRONG_PHY_ADDRESS:
      MsgRetOpcode = D2H_ERROR_CMV_READ_NOT_AVAILABLE;
      break;

      /*
      ** CMV with read-only MDIO-Address
      */
   case MDIO_ADDRESS_READ_ONLY:
      MsgRetOpcode = D2H_ERROR_CMV_READ_ONLY;
      break;

      /*
      ** Unknown function opcode
      */
   case CMV_WRONG_FCT_OPCODE:
      MsgRetOpcode = D2H_ERROR_OPCODE_UNKNOWN;
      break;

      /*
      ** Background task is needed but a task is waiting
      */
   case CMV_BKGD_TASK_WAITING:
      MsgRetOpcode = D2H_ERROR_BKGD_TASK_WAITING;
      break;

      /*
      ** Debug Visibility Port is running
      */
   case CMV_DVP_RUNNING:
      MsgRetOpcode = D2H_DBG_VISP_RUNNING;
      break;

      /*
      ** Debug Visibility Port is stopped
      */
   case CMV_DVP_STOPPED:
      MsgRetOpcode = D2H_DBG_VISP_STOPPED;
      break;

      /*
      ** If return value is unknown and all other errors which are not listed above
      */
   default:
      MsgRetOpcode = D2H_ERROR_GENERAL_FAILURE;
      break;

   }

   return MsgRetOpcode;
}

uint16 GetCorrectMsgIDForResponse(uint16 MsgID, uint16 MsgOpcode)
{

   /*
   ** Change bit 6 when the command is a CMV_Write
   */
   if(MsgOpcode == H2D_CMV_WRITE)
   {
      MsgID = MsgID ^ 64;
   }

   return MsgID;
}


extern HerculesMPStruct_t HMP_BgRxBuffer;
extern FlagT gft_CustBlockSlowMsg;
extern FlagT flag_CmvBkgdDirectAcknowledge;
void Bg_DmtScope_MsgHandler(void);

void CreateCMVMsgResponse(uint8 MsgExecuted, uint16 PayLoadSize, uint16 MsgID)
{

   uint16 MsgOpcode;

   /* Get MsgOpcode from Message Header */
   MsgOpcode = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) &
               HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;

   /*
   ** Set new PayLoadSize in Message Header
   */
   HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 =
      HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 & CLEAN_PAYLOADSIZE_IN_HEADER;
   HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 =
      HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 | PayLoadSize;

   /* Set NewMsgID for response message */
   HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2 = GetCorrectMsgIDForResponse(MsgID, MsgOpcode);

   /* Set function opcode for response message */
   gs_MPReturnOpcode = GetMsgOpcodeForResponse(MsgExecuted, MsgOpcode);

   /* Set message response flag for TX-Mailbox */
   guc_MPMsgRespReq = 1;
}

/*******************************************************************************
*
*   Prototype: void CustomerHandleMessage(void)
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/


void CustomerHandleMessage(void)
{
//   xTC_CustomerHandleMessage();

   uint16 MsgOpcode, PayLoadSize, MsgID;
   uint8  MsgExecuted, uc_Length;

   /* Get information from header */
   MsgOpcode = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 >> HMP_WORD0_OPCODE_SHIFT) &
               HMP_WORD0_OPCODE_MASK_AFTER_SHIFT;
   PayLoadSize = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;
   MsgID = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2;

   uc_Length = (uint8)HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord4;

   switch(MsgID)
   {
      //
      // SLOW CMVs
      //

      // SLOW DMT scope msg handling
   case CMD_TEST_AFE_LOOP_CONTROL:
   case CMD_TEST_RX_GAIN_CONTROL:
      if( gsa_IndirectStat0[0] == STAT_TestState )
      {
         if (!gft_CustBlockSlowMsg)
         {
            MsgExecuted = CMV_SLOW_MSG_ACKN;
            HMP_BgRxBuffer = HMP_RxBuffer;
            gft_CustBlockSlowMsg = TRUE;
            AddFunctionToBkgdFifo((PtrToBkgdFunc)Bg_DmtScope_MsgHandler);
         }
         else
         {
            MsgExecuted = CMV_BKGD_TASK_WAITING;
         }
      }
      else
      {
         MsgExecuted = RC_DENIED;
      }
      break;

      //
      // FAST CMVs
      //

      // FAST DMT scope msg handling
   case CMD_TEST_CARRIER_MASKING_TX_SET:
   case CMD_TEST_RX_PSD_CALIBRATE:
   case CMD_TEST_RX_PSD_MEASURE_MODE_SET:
      MsgExecuted = DmtScope_MsgHandler(MsgID, &PayLoadSize, HMP_RxBuffer.usa_HmpPayLoad);
      break;

      /*
      ** Debug
      */
   case CMD_DBG_MEM_MAP_READ:
   case CMD_DBG_MEM_MAP_WRITE:
   case CMD_DBG_AUX_REG_READ:
   case CMD_DBG_AUX_REG_WRITE:
   case CMD_DBG_READ_VDSL_AFE:
   case CMD_DBG_WRITE_VDSL_AFE:
      MsgExecuted = DebugMsgHandler(MsgID, &PayLoadSize, &HMP_RxBuffer);
      break;

   case CMD_VERSION_INFO_GET:
      MsgExecuted = GetVersionInfo(&PayLoadSize, uc_Length, HMP_RxBuffer.usa_HmpPayLoad);
      break;

   default:
      MsgExecuted = CMV_MSG_ID_UNKNOWN;
      break;
   }

   if(!flag_CmvBkgdDirectAcknowledge)
   {
      /* Create message response and set flag for TxMailbox */
      CreateCMVMsgResponse(MsgExecuted, PayLoadSize, MsgID);
   }
}


/*******************************************************************************
*
*   Prototype:
*         void CustomerClearTR1Counters(void);
*         void CustomerCopyTR1Counters(void);
*
*      These functions are called from G997_Clear(Copy)_TR1_Counters(void)
*   to clear(copy) any customer maintained G997 defined TR1 counters.
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/
void CustomerClearTR1Counters(void)
{
}

void CustomerCopyTR1Counters(void)
{
}


/*******************************************************************************
*
*   Prototype:
*      void WatchdogTimerStart( void );
*      void WatchdogTimerStop(void);
*      void WatchdogTimerReset( void );
*
*      These functions support a HW watchdog timer
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*      uint8 gt_WatchdogTimerEnable;
*
*******************************************************************************/

uint8 gt_WatchdogTimerEnable=0;

void WatchdogTimerStart(void)
{}
void WatchdogTimerStop(void)
{}
void WatchdogTimerReset(void)
{}
