/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VRX_AfeCommonConst_H
#define _VRX_AfeCommonConst_H

/****************************************************************************
;
;
;
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: VRX_AfeCommonConst.h
;
;  This file contains constants used by VR9 AFE related files.
;
*****************************************************************************/

#ifndef FALSE
#define FALSE           0
#endif
#ifndef TRUE
#define TRUE            1
#endif

//Line Driver modes
//Low Noise Mode from LD_VL_ADSL to LD_VH_ADSL
//High Speed Mode from LD_VL_VDSL to LD_VH_VDSL
#define  LD_PDN            (0)
#define  LD_VL_ADSL        (1)
#define  LD_L_ADSL         (2)
#define  LD_M_ADSL         (3)
#define  LD_H_ADSL         (4)
#define  LD_VH_ADSL        (5)
#define  LD_VL_VDSL        (6)
#define  LD_L_VDSL         (7)
#define  LD_M_VDSL         (8)
#define  LD_H_VDSL         (9)
#define  LD_VH_VDSL        (10)
#define  LD_AUTOSEL        (11)

#define  SIZE_LD_CTL_DOUT  (22)


//Valid Modes are from (LD_PDN ==> 0) to (LD_VH_VDSL == > 10) as per #define
//Invalid mode is declared only if LD_CTL & LD_DOUT is not met the spec
//as defined in the VR9_LineDriver.doc.
#define  LD_MODE_INVALID      (0xFFFF)


//ADC trimming constants definition - start
#define  NUM_ADC_TRIM_STG                    (2)
#define  NUM_ADC_TRIM_COMP_PER_STG           (16)
#define  NUM_ADC_TRIM_INIT_REG               (24)
#define  VDSL_STG12                          (2) //VDSL30, VDSL17_12 requires stage1 & 2 comp.

//First 32 locations for VDSL30, next 32 locations for VDSL17_12 and last 16
//locations for VDSL05 to store threshold trim values.
//(2*32+16) //80
#define  ADC_THRESH_TRIM_LOC_STG12          \
(VDSL_STG12*(NUM_ADC_TRIM_STG*NUM_ADC_TRIM_COMP_PER_STG)+NUM_ADC_TRIM_COMP_PER_STG)

//First 2 locations(stage 1 & 2) for VDSL30,
//next 2 locations for VDSL17_12 and last 1
//locations for VDSL05 mode to store the full scale trim values.
#define  ADC_FULLSCALE_TRIM_LOC_STG12     (5)
//ADC trimming constants definition - end


// The below defines are combined ADSL and VDSL modes
// If these defines are updated, then we need to update in ADSL branch also.

#define VRX_ANX_A_NUM_HYBS_US0            (VRX518_ANX_A_NUM_HYBS_US0)
#define VRX_ANX_BJ_NUM_HYBS_US0           (VRX518_ANX_ABJ_NUM_HYBS_US0)
#define VRX_ANX_ABJ_NUM_HYBS_8M           (VRX518_ANX_ABJ_NUM_HYBS_8M)         // in genenral used for initialization of hybrid tables
                                                                               // also used during training for all BRCM based DSLAMs
#define VRX_ANX_ABJ_NUM_HYBS_8M_NONBRCM   (VRX518_ANX_ABJ_NUM_HYBS_8M-2)       // for non-BRCM DSLAMs the last two settings are ignored
#define VRX_ANX_ABJ_NUM_HYBS_12M          (VRX518_ANX_ABJ_NUM_HYBS_12M)        // in genenral used for initialization of hybrid tables
                                                                               // also used during training for all BRCM based DSLAMs
#define VRX_ANX_ABJ_NUM_HYBS_12M_NONBRCM  (VRX518_ANX_ABJ_NUM_HYBS_12M-2)      // in genenral used for initialization of hybrid tables
#define VRX_ANX_ABJ_NUM_HYBS_17M          (VRX518_ANX_ABJ_NUM_HYBS_17M)        // in genenral used for initialization of hybrid tables
                                                                               // also used during training for all BRCM based DSLAMs
#define VRX_ANX_ABJ_NUM_HYBS_17M_NONBRCM  (VRX518_ANX_ABJ_NUM_HYBS_17M-2)      // for non-BRCM DSLAMs the last two settings are ignored
#define VRX_ANX_ABJ_NUM_HYBS_30M          (VRX518_ANX_ABJ_NUM_HYBS_30M)
#define VRX_ANX_ABJ_NUM_HYBS_35M          (VRX518_ANX_ABJ_NUM_HYBS_35M)

#define VRX_MAX_NUM_ADAP_HYB_SETTINGS     (VRX518_MAX_NUM_ADAP_HYB_SETTINGS)
#define NUM_ADAP_HYB_SETTINGS             (VRX_MAX_NUM_ADAP_HYB_SETTINGS)

#define VRX_HYB_NUM_SETTINGS              (VRX518_HYB_NUM_SETTINGS)
#define VRX_NUM_CAP_SEARCH                (VRX518_NUM_CAP_SEARCH)

#define VRX_HYBGAIN_IDX                   (VRX518_HYBGAIN_IDX)  // Hybrid gain value index

// XDSLRTFW-3026 (Start_End)
//EFuse in BAR18
#define EFUSE_OFFSET             (0x200)     // EFUSEd registers is located at an address offset of 0x200 in the CHIPID_EFUSE
#define BAR18_REGISTER_OFFSET    (0x18000)   // The BAR19 is configured to point to the CHIPID_EFUSE (see register spec) whose address is 0x18000

#endif /* _VRX_AfeCommonConst_H */

