/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VRX_AfeCommonData_H
#define _VRX_AfeCommonData_H

/****************************************************************************
;
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: VRX_AfeCommonData.h
;
;  This file contains type definitions used by different files.
;
*****************************************************************************/
// ******************************************************************
// VRX_AfeCommonData.h
//
// History
//
//
// 22/01/2013 Kannan: AFE init fail exception code variable declaration
//            Grep for XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication
// 03/02/2014 Fuss: XDSLRTFW-1542 - Low DS-rate on long loops for vectoring compared to non-vectoring
//            Added gusa_HybridSettingV2_8A and gsa_HybridGainV2_8A_AnxA
// ******************************************************************
#include "typedef.h"
#include "VRX_AfeCommonConst.h"
#include "AFED_Constants.h"


extern uint32 gul_ExceptionCode;
//XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START)
extern uint32 gul_GLP_ExceptionCode;
extern uint32 gul_RC_Measure_ExceptionCode;
extern uint32 gul_RC_Calib_ExceptionCode;
//XDSLRTFW-118 VR9_VRX318_AFE_Init_Fail_Indication (START)
extern uint32 gula_DebugVarsPalak[20];

extern uint16 gus_RCtimeConstCNT;

extern int16 gs_PgaHandlerStopAtPga1Pga2;
extern int16 gs_RxStateToStop;
extern int16 gs_RxSubStateToStop;

extern FlagT gft_PowerUpLink;
extern FlagT gft_BondedMode;
extern FlagT gft_AEC_On;
extern uint8  guc_ErrorType;
extern uint8  guc_CalibResult;
extern uint8  guc_MeasResult;
extern uint8 guc_TxModeConfigured;
extern uint8 guc_RxModeConfigured;
extern uint16 gus_AFE_RxMode, gus_AFE_TxMode;
//Flags to overwrite the AFE Rx Mode config settings.
//When set to TRUE, the function VR9_ConfigAFERxPath_Forced is called
extern FlagT gft_AFE_TxMode_Overwrite;
//Flags to overwrite the AFE Tx Mode config settings.
//When set to TRUE, the function VR9_ConfigAFETxPath_Forced is called
extern FlagT gft_AFE_RxMode_Overwrite;
extern FlagT gft_NoVDSLIndication;
extern int16  gs_AGC2_compensation;
extern int16  gs_AGC1_margin;
// Variable to check whether the binary is for ADSL or VDSL
// If ADSL, this variable (gft_Bin_ADSL_VDSL = 0), else
// gft_Bin_ADSL_VDSL = 1 for VDSL binary
extern FlagT gft_Bin_ADSL_VDSL;
extern int16  gs_AGC1_Gain_Set; //PGA gain
extern int16  gs_AGC2_Gain_Set; // PREFI gain

extern int16  gs_Stored_AGC1_Gain_Set; // storing PGA gain to be used later for vectoring signal detection
extern int16  gs_Stored_AGC2_Gain_Set; //storing PREFI gain to be used later for vectoring signal detection



// Common Hybrid variables
//Debug variables for overwriting the hybrid settings
extern uint16 gusa_AfeChipId[2];
extern uint16 gus_BandGapTrimming;
extern uint16_t AFE_DSL_version;

#ifdef VR9_PGA_CALIB_DEBUG
extern int16  gs_Set_Pause;
extern int16  gs_dbg_substate;
extern int16  gs_dbg_type;
#endif //VR9_PGA_CALIB_DEBUG

extern int16 gs_HybTrMaxMetricEcho;
extern int16 gs_HybTrMaxIndexEcho;
extern int16 gs_HybTrMaxIndexEcho_save;

extern int16 gs_AGC1_Gain_Get;    // AGC1 gain
extern int16 gs_AGC2_Gain_Get;    // AGC2 gain
extern int16 gs_AGC_Gain_Get;     // Total AGC gain
extern int16 gs_Hyb_Gain_Get;     // Hybrid gain

// XDSLRTFW-3026 (Start_End)
extern uint32 gula_VRX518_EfuseTable[9];

#endif /* _VRX_AfeCommonData_H */

