/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ***********************************************************************************************************
// VR9_Afedata.c
//
// History
//
// 18/12/2012 Ram: Merged IOP fix corresponding to JIRA XDSLRTFW-458
//            Grep for: "XDSLRTFW-458: IOP_ALL_VDSL2_ALL_TACorrection"
// 22/01/2013 Kannan: variable defintion for AFE init fail indication
//                    Grep for XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication
// 08/01/2014 Fuss: Corrected the number of 30MHz profile hybrids
//            Grep for XDSLRTFW-1465
// 03/02/2014 Fuss: Low DS-rate on long loops for vectoring compared to non-vectoring
//            Grep for XDSLRTFW-1542
// 11/08/2014 Fuss: Hybrid setting Clean-up and integrated HybridGain to the Hybrid setting tables
//            Grep for XDSLRTFW-1488
// 11/03/2015 Fuss: Added 3 new typeA hybrid settings (17profile) for BT50 loops, i.e. 1200ft, 2000ft and 3200ft
//            Grep for XDSLRTFW-2259
// ************************************************************************************************************
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
//#include "typedef.h"
#include "common.h"
#include "data_alloc.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"

#if 1 //COMMON_VRX518
//XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication (START)
uint32 gul_GLP_ExceptionCode;
uint32 gul_RC_Measure_ExceptionCode;
uint32 gul_RC_Calib_ExceptionCode;
//XDSLRTFW-118: VR9_VRX318_AFE_Init_Fail_Indication (END)

uint32 gula_DebugVarsPalak[20];

uint16 gus_RCtimeConstCNT=0;

int16 gs_PgaHandlerStopAtPga1Pga2 = 0;
int16 gs_RxStateToStop = -1;
int16 gs_RxSubStateToStop = -1;

FlagT gft_PowerUpLink;
FlagT gft_BondedMode;
FlagT gft_AEC_On;
// Variable to check whether the binary is for ADSL or VDSL
// If ADSL, this variable (gft_Bin_ADSL_VDSL = 0), else
// gft_Bin_ADSL_VDSL = 1 for VDSL binary
FlagT gft_Bin_ADSL_VDSL = 1; // to have the right POCO settings correspondig to the gain setting.
FlagT gft_NoVDSLIndication = 0;
uint8 guc_ErrorType =0;
uint8 guc_CalibResult;
uint8 guc_MeasResult;

//SMS01369273, Debug - Overwriting the Tx and Rx Mode registers
FlagT gft_AFE_TxMode_Overwrite = 0;
FlagT gft_AFE_RxMode_Overwrite = 0;
//SMS01369273 - End
#endif


DATA_XILVB_B4_SHOW_INIT_BEGIN
//Contains selected profile Hybrid settings
uint16 gusa_HybridsForProfileSelected[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
DATA_MAP_END //DATA_XILVB_B4_SHOW_INIT_BEGIN


#if 1 //OPEN_VRX518
int16  gs_AGC1_Gain_Set = 0; //PGA gain 8.8
int16  gs_AGC2_Gain_Set = 0; //PREFI gain 8.8
int16  gs_AGC2_compensation = 0;
int16  gs_AGC1_margin = 0x00; //8.8
int16  gs_Stored_AGC1_Gain_Set = 0; //storing PGA gain 8.8 to be used later for vectoring signal detection
int16  gs_Stored_AGC2_Gain_Set = 0; //storing PREFI gain 8.8 to be used later for vectoring signal detection

#ifdef VR9_PGA_CALIB_DEBUG
int16  gs_Set_Pause = 0;
int16  gs_dbg_substate = -1;
int16  gs_dbg_type = -1;
#endif //VR9_PGA_CALIB_DEBUG

uint16 *gpus_HybridsForProfileSelected;
uint16 gus_BandGapTrimming = 0;
// AGC Gains
int16 gs_AGC1_Gain_Get = 0;    // AGC1 gain
int16 gs_AGC2_Gain_Get = 0;    // AGC2 gain
int16 gs_AGC_Gain_Get = 0;     // Total AGC gain
int16 gs_Hyb_Gain_Get = 0;     // Hybrid gain
#endif

// XDSLRTFW-3026 (Start_End)
uint32 gula_VRX518_EfuseTable[9];   // XDSLRTFW-3282 (Start_End)
uint16 gusa_AfeChipId[2] = {0, 0}; //gusa_AfeChipId[0] is AFERVERSION_CENTRAL gusa_AfeChipId[1] is AFERVERSION_DSL
// global variable for DSL version
uint16_t AFE_DSL_version = 02;

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

