/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// xTC_VersionInfo_Init.c
//
// History
//
//15/01/2013 Kannan: Send VR9 Platform ID for VRx318 too to support
//                   ReTx and other features.
//Grep for: "XDSLRTFW-659 VRx318_ReTx_Not_Working_In_VDSL_Mode_With_Vinax_Avinax"
//
// 11/07/2013 Vinjam: Added new IOP bit to toggle the Firmware version (first digit, chip ID) string sent in G.Hs
//            CMV allotted: CMV INFO 232 3 Bit#1, default set to "0" (i.e. sends FW version as 7.x.x.x).
//            Reason for this: (i) Old deployed Avinax Firmware supports VDSL2 ReTx for VR9 FW (5.x.x.x.x.x) only. So
//            to bring up VDSL2 ReTx with old Avinax DSLAM, send VRx318 FW version as 5.x.x.x (instead of 7.x.x.x) in G.Hs.
//            (ii) VRx318 FW sends FW version as 7.x.x.x with new Avinax firmware for VDSL2 ReTx.
//            Grep for XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString
// *****************************************************************************

/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "VersionInfo_Init.c"
** CCASE_DATE = "Wed Aug  3 16:16:17 2005"
**
** =============================================================================
**
** Contents:   Inside this file the VersionInfo is implemented.
**
** Functions:
**
**             Init_SystemVendor_VersionInfo()
**          - Init default settings for version numbering.
**
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** 2005-05-03  Wehmann       Creation
** 2009        Tung Le       ported from IFX source to VR9
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "wehmann"
 CCASE_VERSION = "\main\9"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "cmv.h"
#include "typedef.h"
#include "ver_online.h"
#include "xTC_VersionInfo_Init.h"
#include "gdata.h"
#include "eoc.h"


/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/* Default definitions for version numbering and information */
#define VENDOR_ID                    0x4946544E /* IFTN */
#define COUNTRY_CODE                 0xB500   /* USA */

#define DOT    '.'
#define XTRACHAR1        '@'
#define XTRACHAR2        '('
#define XTRACHAR3        '#'
#define XTRACHAR4        ')'
#define XTRACHAR5        'V'
#define XTRACHAR6        '_'
#define XTRACHAR7        '~'
#define XTRACHAR8        '0'
#define XTRACHAR9        'x'
#define LASTCHAR         '\0'
//XDSLRTFW-3364 (Start)
#define UNDERSCORE       '_'


#if (VERSION_REL_STATUS < 3)
   static const unsigned char what[] =
   {
      XTRACHAR1, XTRACHAR2, XTRACHAR3, XTRACHAR4,
      STR_VERSION_PLATFORM_LO, DOT,
      STR_VERSION_FEATURE_LO, DOT,
      STR_VERSION_MAJOR, DOT,
      STR_VERSION_MINOR, DOT,
      STR_VERSION_REL_STATUS, DOT,
      STR_VERSION_APP_NUM_LO, LASTCHAR
   };
#else
   static const unsigned char what[] =
   {
      XTRACHAR1, XTRACHAR2, XTRACHAR3, XTRACHAR4,
      STR_VERSION_PLATFORM_LO, DOT,
      STR_VERSION_FEATURE_LO, DOT,
      STR_VERSION_MAJOR, DOT,
      STR_VERSION_MINOR, DOT,
      STR_VERSION_REL_STATUS, DOT,
      STR_VERSION_APP_NUM_LO, UNDERSCORE,
      //STR_VERSION_TEST_FW_SOURCE_HI, STR_VERSION_TEST_FW_SOURCE_LO, DOT, // !! DO NOT USE THE FIELD VERSION_TEST_FW_SOURCE!! Reserved for future use
      STR_VERSION_TEST_FW_NUM_HI, STR_VERSION_TEST_FW_NUM_LO, LASTCHAR
   };
#endif

static const unsigned char whatext[] =
{
   XTRACHAR1, XTRACHAR2, XTRACHAR7, XTRACHAR4,
   XTRACHAR5, XTRACHAR8, XTRACHAR9, BONDINGSUPPORT
};
//XDSLRTFW-3364 (End)

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/


/*
** =============================================================================
**                           GLOBAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

void FillSystemVendorID(uint32 VendorID, uint16 CountryCode, uint16 VendorSpecific);

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  FillSystemVendorID()
**
** DESCRIPTION:    Fill the array of the SystemVendorID.
**
** PARAMETERS:     VendorID (uint32 / unsigned long)
**             - ID of the producer.
**
**                 CountryCode (uint16 / unsigned short)
**                 - Code of the country, where the producer is registered.
**
**                 VendorSpecific (uint16 / unsigned short)
**                 - Vendor specific field (e.g. version number).
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
**
** NEEDED IN MODEM STATES: RESET (for Init_SystemVendor_VersionInfo)
** =============================================================================
*/
void FillSystemVendorID(uint32 VendorID, uint16 CountryCode, uint16 VendorSpecific)
{

   /* CountryCode */
   guca_ne_SystemVendorID[1] = CountryCode;
   guca_ne_SystemVendorID[0] = CountryCode >> 8;
   /* VendorID */
   guca_ne_SystemVendorID[5] = VendorID;
   guca_ne_SystemVendorID[4] = VendorID >> 8;
   guca_ne_SystemVendorID[3] = VendorID >> 16;
   guca_ne_SystemVendorID[2] = VendorID >> 24;
   /* Vendor Specific Information */
   guca_ne_SystemVendorID[7] = VendorSpecific;
   guca_ne_SystemVendorID[6] = VendorSpecific >> 8;

}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  Init_SystemVendor_VersionInfo()
**
** DESCRIPTION:    Init default settings for version numbering.
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
**
** NEEDED IN MODEM STATES: RESET (for InitCustomer_PowerUp)
** =============================================================================
*/
void Init_SystemVendor_VersionInfo(void)
{


   /*
   ** Set G.994 VendorID's
   */
   gul_ne_G994VendorID = VENDOR_ID;

   gus_ne_CountryCode= COUNTRY_CODE;

   //XDSLRTFW-3364 (Start)
   //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (Start)
   if(gt_CustomerIopBits.us_Generic_IOP_Fixes & GENERIC_TOGGLE_CHIP_ID_IN_GHS_VERSION)
   {
      // The 16 bit version is now formatted in adsl style.   @G.HS version, XDSLRTFW-149 @
      // 4 bits for each field Platform : Feature : Major :Minor
      // XDSLRTFW-659 VRx318_ReTx_Not_Working_In_VDSL_Mode_With_Vinax_Avinax (START)
      // Vinax & Avinax CO's looking for VR9 platform ID to enable certain features
      // like UPBO, ReTx and G.vector etc,
      // Hence by default send VR9 Platform  ID for VRX318 too.
      gus_ne_G994VendorSpecific = (((VR9_PLATFORM_ID & 0xF) << 12) |\
                                   ((VERSION_FEATURE & 0xF) << 8) |\
                                   ((VERSION_MAJOR & 0xF) << 4) |\
                                   (VERSION_MINOR & 0xF));
      // XDSLRTFW-659 VRx318_ReTx_Not_Working_In_VDSL_Mode_With_Vinax_Avinax (END)
   }
   else
   {
      // The 16 bit version is now formatted in adsl style.   @G.HS version, XDSLRTFW-149 @
      // 4 bits for each field Platform : Feature : Major :Minor
      gus_ne_G994VendorSpecific = (((VERSION_PLATFORM & 0xF) << 12) |\
                                   ((VERSION_FEATURE & 0xF) << 8) |\
                                   ((VERSION_MAJOR & 0xF) << 4) |\
                                   (VERSION_MINOR & 0xF));
   }
   //XDSLRTFW-1085 IOP_ALL_ALL_ALL_ToggleChipID_InGHsVersionString (End)

   /* Fill the SystemVendorID with default */
   FillSystemVendorID((uint32)gul_ne_G994VendorID, (uint16)gus_ne_CountryCode,
                      (uint16)gus_ne_G994VendorSpecific);


   //Refer to CMV INFO 54 in Message Catalog ver 2.9 or newer for format
   gusa_FW_version_number[0] = (((VERSION_PLATFORM & 0xF) << 12) |\
                                ((VERSION_FEATURE & 0xF) << 8) |\
                                ((VERSION_MAJOR & 0xF) << 4) |\
                                (VERSION_MINOR & 0xF));

   gusa_FW_version_number[1] = (((VERSION_REL_STATUS & 0x3) << 8) |\
                                (VERSION_APP_NUM & 0x3F));

#if (VERSION_REL_STATUS < 3)
         (0),
   gusa_FW_version_number[2] = (0);
#else
   //gusa_FW_version_number[2] = ((VERSION_TEST_FW_SOURCE << 8) | (VERSION_TEST_FW_NUM)); // !! DO NOT USE THE FIELD VERSION_TEST_FW_SOURCE!! Reserved for future use
   gusa_FW_version_number[2] = (VERSION_TEST_FW_NUM & 0xFF);
#endif

   gusa_FW_version_number[3] = (0); //Value to be over written with 'Rx Microcode version number' at entry to showtime

   gusa_FW_version_number[4] = (0); //Value to be over written with 'Tx Microcode version number' at entry to showtime

   //XDSLRTFW-3364 (End)
}
