/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "DmtScope_MsgHandler.c"
** CCASE_DATE = "Wed Jul 26 09:25:49 2006"
**
** =============================================================================
**
** Contents:   Inside this file the xTC_TestMsgHandler for incoming DMT Scope
**             Test messages is implemented.
**
** Functions:  TestMsgHandler()
**             - This function sends the incoming message to the specific
**               function, where the message will be executed.
**
**             xTC_TestAfeLoopControl()
**             - Read from a address
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** 2005-04-22  Hanzekovic    Creation
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "Bschor"
 CCASE_VERSION = "\main\Rev_1.4\1"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "BaseTypes.h"           /* Type definition IFX */
#include "typedef.h"             /* Type definition Aware */
#include "common.h"
#include "gdata.h"
#include "nmp.h"
#include "hmp_data.h"
#include "xTC_CmvDefinitions.h"
#include "vdsl_const.h"
#include "CustomerTasks.h"
#include "afe.h"
#include "TxPSDControl.h"
#include "LL_IOf.h"
#include "DmtScope_MsgHandler.h"
#include "DmtScope_PsdMeasure.h"


//the following 5 lines are for Rev1.3

#include "IRI_Iof.h"


/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

#define NO_LOOP 0    /* Disables the AFE loopback*/
#define ALOOP   1    /* Enables the AFE loopback*/

#define ALOOP3_MASK 0x0400

#define AGCGAIN_MASK    0x003F
#define PREFIGAIN_MASK  0x0E00
#define ACEGAIN_MASK    0x001F

#define AGCGAIN_MAX     0x0000
#define PREFIGAIN_MAX   0x0E00

#define ACEGAIN_MAX     0x0012

#define AGCGAIN_MIN     0x003F



/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

uint16 maskToneIdxOld = 0xffff;
uint_8 afeLoopClosed;

static uint_16 MailboxCode, HeaderWord0, HeaderWord1, HeaderWord2, HeaderWord3, HeaderWord4;
static AutoMsgPayLoadEntry_t   NFCPayloadStruct;

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
uint_8 TestAfeLoopControl(uint_16 *PayLoadSize, uint_16 PayLoad[]);
uint_8 TestCarrierMaskingSet(uint_16 *PayLoadSize, uint_16 PayLoad[]);
uint_8 TestRxPsdCalibrate(uint_16 *PayLoadSize, uint_16 PayLoad[]);
uint_8 TestRxPsdMeasureModeSet(uint_16 *PayLoadSize, uint_16 PayLoad[]);
uint_8 TestRxGainControl(uint_16 *PayLoadSize, uint_16 PayLoad[]);

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  TestMsgHandler()
**
** DESCRIPTION:    This function executes the incoming DMTscope message.
**
** PARAMETERS:     MsgID (uint_16 / unsigned short)
**                 - MsgID from actual message.
**
**                 *PayLoadSize (uint_16 / unsgned short)
**                 - Pointer to payload size.
**
**                 *HMP_BufferPointer (HerculesMPStruct_t)
**                 - Currently used HMP_Buffer.
**
** RETURN VALUE:   xTCMsgExecuted (uint_8 / unsgned char)
**                 - Value for function code creation.
**
** NOTES:          Under construction!
** =============================================================================
*/
uint_8 DmtScope_MsgHandler(uint_16 MsgID, uint_16 *PayLoadSize, uint_16 PayLoad[])
{

   uint_8   xTCMsgExecuted;
   /*
   ** Switch between different DMTscope messages
   */
   switch(MsgID)
   {

      /*
      ** Enable/Disable the AFE loopback
      */
   case CMD_TEST_AFE_LOOP_CONTROL:

      xTCMsgExecuted = TestAfeLoopControl(&(*PayLoadSize), PayLoad);
      break;

      /*
      ** Mask out every 100th subcarrier
      */
   case CMD_TEST_CARRIER_MASKING_TX_SET:
      xTCMsgExecuted = TestCarrierMaskingSet(&(*PayLoadSize), PayLoad);
      break;

   case CMD_TEST_RX_PSD_CALIBRATE:
      xTCMsgExecuted = TestRxPsdCalibrate(&(*PayLoadSize), PayLoad);
      break;

   case CMD_TEST_RX_PSD_MEASURE_MODE_SET:
      xTCMsgExecuted = TestRxPsdMeasureModeSet(&(*PayLoadSize), PayLoad);
      break;

   case CMD_TEST_RX_GAIN_CONTROL:
      xTCMsgExecuted = TestRxGainControl(&(*PayLoadSize), PayLoad);
      break;
      /*
      ** Default instruction
      */
   default:

      /* Message ID is unknown */
      xTCMsgExecuted = CMV_MSG_ID_UNKNOWN;
   }

   return xTCMsgExecuted;
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  TestAfeLoopControl()
**
** DESCRIPTION:    Enables/Disables AFE loopback
**
** PARAMETERS:     *PayLoadSize (uint_16 / unsigned short)
**                 - Pointer to payload size.
**
**                 PayLoad[] (uint_16 / unsigned short)
**                 - PayLoad in actual message.
**
** RETURN VALUE:   xTCMsgExecuted (uint_8 / unsigned char)
**                 - Value for function code creation.
**
** NOTES:          OK!
** =============================================================================
*/
uint_8 TestAfeLoopControl(uint_16 *PayLoadSize, uint_16 PayLoad[])
{

   uint_8 xTCMsgExecuted = CMV_WITHOUT_ERRORS;

//mei fixme: need VR9 version

   return xTCMsgExecuted;
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  TestCarrierMaskingSet()
**
** DESCRIPTION:    Masks out every 100th subcarrier starting from an index
**                 received as a payload
**
** PARAMETERS:     *PayLoadSize (uint_16 / unsigned short)
**                 - Pointer to payload size.
**
**                 PayLoad[] (uint_16 / unsigned short)
**                 - PayLoad in actual message.
**
** RETURN VALUE:   xTCMsgExecuted (uint_8 / unsigned char)
**                 - Value for function code creation.
**
** NOTES:          OK!
** =============================================================================
*/
uint_8 TestCarrierMaskingSet(uint_16 *PayLoadSize, uint_16 PayLoad[])
{

   uint_8 xTCMsgExecuted = CMV_WITHOUT_ERRORS;
   uint_16 maskToneIdx;
   uint32 ul_data = 0;

   if(*PayLoadSize != 2)
   {
      /* wrong payload size */
      xTCMsgExecuted = RC_PAYLOAD_LEN;
   }
   else if (PayLoad[0] > 99)
   {
      /* parameter out range */
      xTCMsgExecuted = RC_PARAM_RANGE;
   }
   else
   {
      /* payload ok - execute command */
      //maskToneIdx = maskToneIdxOld;
      maskToneIdx = PayLoad[0];

      /* demask allready masked tones */
      if (maskToneIdxOld != 0xffff)
      {
         /* do it for all tones */
         while (maskToneIdxOld < gs_TxNumTones)
         {
            if (*(ghpuca_TxExtGains_Inactive + maskToneIdxOld) & 0x10)
            {
               /* clear blackout flag if is a tx tone */
               *(ghpuca_TxExtGains_Inactive + maskToneIdxOld) &= (~0x8);
            }
            maskToneIdxOld += 100;
         }
      }

      /* mask tones */
      while (maskToneIdx < gs_TxNumTones)
      {
         /* check if direction bit == TX */
         if (*(ghpuca_TxExtGains_Inactive + maskToneIdx) & 0x10)
         {
            /* and set the blackout flag */
            *(ghpuca_TxExtGains_Inactive + maskToneIdx) |= 0x8;
         }
         maskToneIdx += 100;
      }

      /* store the index of the first masked tone */
      maskToneIdxOld = PayLoad[0];

      // load modified extended gains table
#ifdef VDSL_50
      //Set the following bits to 1 in IT_TBLCP register to enable the copying to HW
      //Bit(1:2): disable copying SHIFT bits in EGT table
      //Bit(4):   enable copying
      //Bit(11):  no copy BAT
      //Bit(12):  no copy GST
      //Bit(13):  no copy TRT
      ul_data = (MASK_BIT1|MASK_BIT2|MASK_BIT4|MASK_BIT11|MASK_BIT12|MASK_BIT13);

      WriteCoreReg(IRI_QT_REG_TX_TBLCP_ADDR, ul_data);
#endif //#ifdef VDSL_50

      //It is assumed that InitIridiaQT() has been called (at reset)
      //prior to calling the following function
      SwitchTxPingPongTable();
   }

   return xTCMsgExecuted;
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  TestRxPsdCalibrate()
**
** DESCRIPTION:    Sets the board specific calibration factor necessary to
**                 calculate the absolute psd value per tone
**
** PARAMETERS:     *PayLoadSize (uint_16 / unsigned short)
**                 - Pointer to payload size.
**
**                 PayLoad[] (uint_16 / unsigned short)
**                 - PayLoad in actual message.
**
** RETURN VALUE:   xTCMsgExecuted (uint_8 / unsigned char)
**                 - Value for function code creation.
**
** NOTES:          OK!
** =============================================================================
*/
uint_8 TestRxPsdCalibrate(uint_16 *PayLoadSize, uint_16 PayLoad[])
{
   uint_8 xTCMsgExecuted = CMV_WITHOUT_ERRORS;
   sint_16  calibration;
   sint_32  temp;

   calibration = (sint_16) PayLoad[0];

   if(*PayLoadSize != 2)
   {
      /* wrong payload size */
      xTCMsgExecuted = RC_PAYLOAD_LEN;
   }
   else if (calibration > 1280)
   {
      /* parameter out range */
      xTCMsgExecuted = RC_PARAM_RANGE;
   }
   else if (calibration < (-1280))
   {
      /* parameter out range */
      xTCMsgExecuted = RC_PARAM_RANGE;
   }
   else
   {
      /* payload ok - execute command */
      /* calc calibration/10 and put it to Q9.7 format */
      temp = calibration * 6553;
      temp = (temp >> 9);

      gs_PsdCalValue += temp;
   }



   return(xTCMsgExecuted);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  TestRxPsdMeasureModeSet()
**
** DESCRIPTION:    Sets the mode of PSD measurement (average, peak or bottom hold)
**                 and number of frames
**
** PARAMETERS:     *PayLoadSize (uint_16 / unsigned short)
**                 - Pointer to payload size.
**
**                 PayLoad[] (uint_16 / unsigned short)
**                 - PayLoad in actual message.
**
** RETURN VALUE:   xTCMsgExecuted (uint_8 / unsigned char)
**                 - Value for function code creation.
**
** NOTES:          OK!
** =============================================================================
*/
uint_8 TestRxPsdMeasureModeSet(uint_16 *PayLoadSize, uint_16 PayLoad[])
{
   uint_8 xTCMsgExecuted = CMV_WITHOUT_ERRORS;
   uint_16 temp;

   if(*PayLoadSize != 4)
   {
      /* wrong payload size */
      xTCMsgExecuted = RC_PAYLOAD_LEN;
   }
   else if (PayLoad[0] > 2)
   {
      /* parameter out range */
      xTCMsgExecuted = RC_PARAM_RANGE;
   }
   else if (PayLoad[2] > 2048)
   {
      /* parameter out range */
      xTCMsgExecuted = RC_PARAM_RANGE;
   }
   else
   {
      /* payload ok - execute command */
      PsdMeasMode = PayLoad[0];
      PsdMeasNumOfFrames = PayLoad[2];

      // find the exp(PsdMeasNumOfFrames)
      PsdMeasLog2NumOfFrames = 0;
      temp = PsdMeasNumOfFrames;
      if (PsdMeasNumOfFrames > 1)
      {
         do
         {
            temp >>= 1;
            PsdMeasLog2NumOfFrames++;
         }
         while (temp > 1);
      }
   }

   return(xTCMsgExecuted);
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  TestRxGainControl()
**
** DESCRIPTION:    Sets the AFE rx gains to maximum or 0dB
**
** PARAMETERS:     *PayLoadSize (uint_16 / unsigned short)
**                 - Pointer to payload size.
**
**                 PayLoad[] (uint_16 / unsigned short)
**                 - PayLoad in actual message.
**
** RETURN VALUE:   xTCMsgExecuted (uint_8 / unsigned char)
**                 - Value for function code creation.
**
** NOTES:          OK!
** =============================================================================
*/
uint_8 TestRxGainControl(uint_16 *PayLoadSize, uint_16 PayLoad[])
{

   uint_8 xTCMsgExecuted = CMV_WITHOUT_ERRORS;

//Mei fixme; need a VR9 version

   return xTCMsgExecuted;
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  DmtScopeActionFinished()
**
** DESCRIPTION:    Sends NFC to the host after a DMTscope test is finished
**
** PARAMETERS:     none
**
** RETURN VALUE:   none
**
** NOTES:          OK!
** =============================================================================
*/
void DmtScopeActionFinished()
{
   /* Create MailboxCode */
   MailboxCode = MAILBOX_CODE_NTFC;

   /* Create HeaderWord0 */
   HeaderWord0 = (HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord0 & HMP_WORD0_BITSIZE_MASK_B4_SHIFT) |
                 (D2H_CMV_READ_REPLY << HMP_WORD0_OPCODE_SHIFT);

   /* Create HeaderWord1 */
   HeaderWord1 = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord1;

   /* Create HeaderWord2 */
   HeaderWord2 = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord2;

   /* Create HeaderWord3 */
   HeaderWord3 = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord3;
   //HeaderWord3 = 0;

   /* Create HeaderWord4 */
   HeaderWord4 = HMP_RxBuffer.t_MsgHeader.us_HmpMsgWord4;


   NFCPayloadStruct.pus_PayLoad = &HMP_RxBuffer.usa_HmpPayLoad[0];;
   NFCPayloadStruct.uc_PayLoadLength = (uint_8)(HeaderWord4 & 0xFF);

   /* send message */
   SubmitAutoMsg((AutoMsgPayLoadEntry_t *)(void *)&NFCPayloadStruct.pus_PayLoad, MailboxCode,
                 HeaderWord0, HeaderWord1, HeaderWord2, HeaderWord3, HeaderWord4);

}


extern uint_8  guc_xTCMsgExecuted;
extern uint_16 gus_MailboxCode;
extern HerculesMPStruct_t HMP_BgRxBuffer;
extern uint_8 state_CustBgCmvResponse;

void Bg_DmtScope_MsgHandler(void)
{
   uint_16 PayLoadSize, MsgID;


   /* Get information from header */
   PayLoadSize = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord1 & HMP_WORD1_SIZE_MASK;
   MsgID = HMP_BgRxBuffer.t_MsgHeader.us_HmpMsgWord2;

   guc_xTCMsgExecuted = DmtScope_MsgHandler(MsgID, &PayLoadSize, HMP_BgRxBuffer.usa_HmpPayLoad);

   // create response
   gus_MailboxCode = MAILBOX_CODE_NTFC;
   state_CustBgCmvResponse = CUST_SLOW_CMV_CREATE_AUTO_MSG;
}
