/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "DmtScope_PsdMeasure.c"
** CCASE_DATE = "Wed Jul 26 09:27:30 2006"
**
** =============================================================================
**
** Contents:   Inside this file the xTC_TestMsgHandler for incoming DMT Scope
**             Test messages is implemented.
**
** Functions:  TestMsgHandler()
**             - This function sends the incoming message to the specific
**               function, where the message will be executed.
**
**             xTC_TestAfeLoopControl()
**             - Read from a address
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** 2005-04-22  Hanzekovic    Creation
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "Bschor"
 CCASE_VERSION = "\main\Rev_1.4\1"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "BaseTypes.h"           /* Type definition IFX */
#include "typedef.h"             /* Type definition Aware */
#include "common.h"
#include "gdata.h"
#include "nmp.h"
#include "vdsl_const.h"
#include "DmtScope_PsdMeasure.h"
#include "DmtScope_MsgHandler.h"
#include <memory.h>
#include "common.h"
#include "psd_b.h"
#include "psdhandler.h"
#include "fifo.h"
#include "noiseacc.h"
#include "IRI_Iof.h"
#include "noiseacc.h"

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/
#define RESGAIN_0p4     51       /* =0.4 in format Q9.7 */
#define AGCGAIN_MASK    0x003F
#define PREFIGAIN_MASK  0x0E00
#define ACEGAIN_MASK    0x001F
#define POCOGAIN_MASK   0x001F

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

int32 gs_PsdCalValue = -18944; /* -148 db (Q9.7)*/

uint_16 PsdMeasMode = PSD_AVERAGE;
uint_16 PsdMeasNumOfFrames = 128;
uint_16 PsdMeasLog2NumOfFrames = 7;
/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

sint_16 ResGainGet();
sint_16 AgcGainGet();
sint_16 PrefiGainGet();
sint_16 AceGainGet();
sint_16 PocoGainGet();

void BgPsdMeas(void);
void MemSet32(int32 *pla_dstptr, uint32 ul_Value, int16 s_NumValues);

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  PsdCalibrate
**
** DESCRIPTION:    calculates the absolute psd value per tone
**
** PARAMETERS:     none
**
** RETURN VALUE:   none
**
** NOTES:          Under construction!
** =============================================================================
*/
void PsdCalibrate()
{

//Mei fixme: need a VR9 version
   gs_AlgHandlerState = 1;

}

//Mei fixme: need a VR9 version

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  PsdPeakHold()
**
** DESCRIPTION:
**
** PARAMETERS:     none
**
** RETURN VALUE:
**
** NOTES:          Under construction!
** =============================================================================
*/
void PsdPeakHold(int32 *pla_NoisePowerX, int16 *psa_dataXY, int16 s_num_tones)
{
   PsdPeakHoldLoop(pla_NoisePowerX, psa_dataXY, s_num_tones);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  PsdBottomHold()
**
** DESCRIPTION:
**
** PARAMETERS:     none
**
** RETURN VALUE:   PrefiGain (int_16 / signed int)
**                 - Value of Prefi Gain.
**
** NOTES:          Under construction!
** =============================================================================
*/
void PsdBottomHold(int32 *pla_NoisePowerX, int16 *psa_dataXY, int16 s_num_tones)
{
   PsdBottomHoldLoop(pla_NoisePowerX, psa_dataXY, s_num_tones);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  PsdMeasure()
**
** DESCRIPTION:
**
** PARAMETERS:     none
**
** RETURN VALUE:
**
** NOTES:          Under construction!
** =============================================================================
*/
void PsdMeasure(void)
{
   switch(gs_AlgHandlerState)
   {
      //==============================================================================
      // initialize variables for PSD calculation
      //==============================================================================
   case PSD_INIT:
      gs_AlgLog2NumFramesToAccum = PsdMeasLog2NumOfFrames;
      gs_AlgNumFramesToAccum = (1 << gs_AlgLog2NumFramesToAccum);

      gs_MaxRxTonePwr = (int16)(-100*256);
      gl_Pa  = 0;

      gft_ApplyConstGain = 0;

      // Set RTV flag to read FFT output
      gs_RtvSelect = FFT_OUTPUT;

      gs_AlgHandlerState = PSD_SETUP;

      // start at tone 0.  The PSD will be calculated for all
      // 4096 tones.
      gs_LeftChannel = 0;
      break;

      //==============================================================================
      // set up variables for PSD calculation in each group
      //==============================================================================
   case PSD_SETUP:

      gs_RightChannel = gs_LeftChannel + gs_NumChannelsPerGroup - 1;

      if(gs_RightChannel >= gs_RxNumTones)
      {
         gs_RightChannel = gs_RxNumTones-1;
      }

      gpsa_AlgMsrdBuffer = &gpsa_MeasuredSnrBuf[gs_LeftChannel];
      // Initialize msrd o/p buffer to 0
      memset(gpsa_AlgMsrdBuffer, 0, sizeof(int16)*(gs_RightChannel-gs_LeftChannel+1));

      gs_AlgHandlerCount = 0;

      if (PsdMeasMode == PSD_BOTTOMHOLD)
      {
         // minimal psd is
         MemSet32(gpla_RxAccumBuf, 0x7FFFFFF, (int16)(gs_NumChannelsPerGroup*2));
      }
      else
      {
         //MemSetBuffer((int16 *)gpla_RxAccumBuf, 0, 0, (int16)(sizeof(int32)*gs_NumChannelsPerGroup*2));
         memset(gpla_RxAccumBuf, 0, (sizeof(int32)*gs_NumChannelsPerGroup*2));
      }

      // Set offset for loading gpsa_RxToneBuf from RTV buffer 0 HW
      gs_RxToneOffset = gs_LeftChannel;
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, SetRxToneOffset);

      // Transition to accumulation substate
      gs_AlgHandlerState = PSD_WAIT_FOR_HW_SET;
      break;

      //==============================================================================
      // Wait for RTV buffer 0 HW settings to take effect
      //==============================================================================
   case PSD_WAIT_FOR_HW_SET:

      if (gs_AlgHandlerCount < gs_RTVxCfgLatency)
      {
         gs_AlgHandlerCount++;
      }
      else
      {
         gs_AlgHandlerState = PSD_ACCUM;
         // Clear counter
         gs_AlgHandlerCount = 0;
      }

      break;

      //==============================================================================
      // Accum representative frame for PSD calculation
      //==============================================================================
   case PSD_ACCUM:
      switch (PsdMeasMode)
      {
      case PSD_AVERAGE:
         NoiseAcc(gpla_RxAccumBuf, gpsa_RxToneBuf, gs_NumChannelsPerGroup);
         break;
      case PSD_PEAKHOLD:
         PsdPeakHold(gpla_RxAccumBuf, gpsa_RxToneBuf, gs_NumChannelsPerGroup);
         break;
      case PSD_BOTTOMHOLD:
         PsdBottomHold(gpla_RxAccumBuf, gpsa_RxToneBuf, gs_NumChannelsPerGroup);
         break;
      }
      gs_AlgHandlerCount++;
      if (gs_AlgHandlerCount == gs_AlgNumFramesToAccum)
      {
         // Calculate the PSD in background
         guc_PsdCalcState = TRAINING_IN_PROGRESS;
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgPsdMeas);
         gs_AlgHandlerState = PSD_NEXT_TONEGROUP;
      }
      break;


      //==============================================================================
      // Update for next tonegroup (or goto finish)
      //==============================================================================
   case PSD_NEXT_TONEGROUP:
      if (guc_PsdCalcState == TRAINING_DONE)
      {
         //If all the tones in this symbol has been processed
         if(gs_RightChannel >= (gs_RxNumTones-1))
         {
            gs_AlgHandlerState = PSD_CALC_DONE;
         }
         //Continue to process the remaining tones
         else
         {
            gs_LeftChannel = gs_LeftChannel + gs_NumChannelsPerGroup;
            gs_AlgHandlerState = PSD_SETUP;
         }
      }
      break;
   }

}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  BgPsdMeas()
**
** DESCRIPTION:
**
** PARAMETERS:     none
**
** RETURN VALUE:   none
**
** NOTES:          Under construction!
** =============================================================================
*/
void BgPsdMeas(void)
{
   int32 *pla_SignalPower;

   if (PsdMeasMode == PSD_AVERAGE)
   {
      // convert 48 bits accumulated value to 32 bits;
      pla_SignalPower = gpla_RxAccumBuf; // Overwrite input buffer with 32-bit output.
      RoundNoiseAccum(gpla_RxAccumBuf, pla_SignalPower, gs_LeftChannel,
                      gs_RightChannel, gs_AlgLog2NumFramesToAccum);
   }

   pla_SignalPower = gpla_RxAccumBuf;
   PsdCalc(pla_SignalPower, gpsa_AlgMsrdBuffer, 0, (int16)(gs_RightChannel-gs_LeftChannel));
   guc_PsdCalcState = TRAINING_DONE;
}


void MemSet32(int32 *pla_dstptr, uint32 ul_Value, int16 s_NumValues)
{

   while (s_NumValues > 0)
   {
      *pla_dstptr++ = ul_Value;
      s_NumValues--;
   }
}

