;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        noiseacc_loop.s
;
; DESCRIPTION:     This file contains assembly version of NoiseAccLoop()
;
;*************************************************************************
.include "asm.h"
.include "xy_regs.h"
.text
;-------------| PsdPeakHoldLoop |-------------------
.global  PsdPeakHoldLoop
PsdPeakHoldLoop:     ; r0 = pla_NoisePowerXY (X memory)
                  ; r1 = psa_dataXY
                  ; r2 = s_num_tones

   sub.f 0, %r2, 0        ; if (s_num_tones <= 0) return
   jle   [%blink]
   mov     %lp_count, %r2   ; set up loop counter

   ; set up X unit for computation
   sr  0x1, [aux_mx1]          ; offset = 1, postupdate, linear, 32 bit mode, AM_MODULO
   sr  %r0, [%ax1]          ; ax1 = pla_NoisePowerX

lp 9f                            ; start looping
      ldw.x %r5, [%r1]       ; l_Acc  = (int32) *psa_dataXY
      ldw.x %r6, [%r1, 2]  ; l_Acc1 = (int32) *++psa_dataXY

        add     %r1, %r1, 4      ; psa_dataXY += 2

        mul_op  0, %r5, %r5      ; l_Acc  = l_Acc * l_Acc;
        mac_op  0, %r6, %r6      ; l_Acc += l_Acc1 * l_Acc1;

        lr      %r4, [%AUX_XMAC2]; we are only using channel 2 of dual MAC

      max    aux_x1_u, %r4, %x1_nu;

9:                               ; epilog: just return to the caller
   j  [%blink]         ; if (s_num_tones <= i) return


;-------------| PsdBottomHoldLoop |-------------------
.global  PsdBottomHoldLoop
PsdBottomHoldLoop:   ; r0 = pla_NoisePowerXY (X memory)
                  ; r1 = psa_dataXY
                  ; r2 = s_num_tones

   sub.f 0, %r2, 0        ; if (s_num_tones <= 0) return
   jle   [%blink]
   mov     %lp_count, %r2   ; set up loop counter

   ; set up X unit for computation
   sr  0x1, [aux_mx1]          ; offset = 1, postupdate, linear, 32 bit mode, AM_MODULO
   sr  %r0, [%ax1]          ; ax1 = pla_NoisePowerX

lp 8f                            ; start looping
      ldw.x %r5, [%r1]       ; l_Acc  = (int32) *psa_dataXY
      ldw.x %r6, [%r1, 2]  ; l_Acc1 = (int32) *++psa_dataXY

        add     %r1, %r1, 4      ; psa_dataXY += 2

        mul_op  0, %r5, %r5      ; l_Acc  = l_Acc * l_Acc;
        mac_op  0, %r6, %r6      ; l_Acc += l_Acc1 * l_Acc1;

        lr      %r4, [%AUX_XMAC2]; we are only using channel 2 of dual MAC

      min    aux_x1_u, %r4, %x1_nu;

8:                               ; epilog: just return to the caller
   j  [%blink]         ; if (s_num_tones <= i) return


