/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "CustomerTasks.c"
** CCASE_DATE = "Fri Jun  9 12:14:28 2006"
**
** =============================================================================
**
** Contents:   Inside this file the CustomerTasks for IFX is implemented.
**
** Functions:  CustomerBgTaskManager()
**             - Calls subfunctions for message handling and modem monitoring
**
**             CustomerHandleMessage()
**             - Called for xTC MessageHandling
**
**             InitCustomer_PowerUp()
**             - Function for init calls after modem power up
**
**             InitCustomer_PreHandshake()
**             - Function for init calls (PreHandshake)
**
**             InitCustomer_PostHandshake()
**             - Function for init calls (PostHandshake)
**
**             CustomerRxForeground()
**             - Calls in the RX Foreground
**
**             CustomerTxForeground()
**             - Calls in the TX Foreground
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** 2005-06-08  Wehmann       Creation
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "Kumar"
 CCASE_VERSION = "\main\xtc_codeswap\Watchdog_Timeout\DMTscope_codeswap\5"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "BaseTypes.h"              /* Type definition IFX */
#include "nmp.h"

/* Type definition Aware */
#include "typedef.h"

#include "gdata.h"                  // Newly added by GK 07.09.05
#include "xTC_BackgroundHandlerInit.h"
#include "xTC_BackgroundHandler.h"
#include "xTC_Modules.h"
#include "xTC_ModemMonitor.h"
#include "xTC_ModemMonitorInit.h"
#include "xTC_CmvMessageHandler.h"
#include "xTC_ModemMonitorSystem.h"
#include "xTC_ModemMonitorSystemInit.h"
#include "SwTimer.h"
#include "timer.h"
#include "auxregs.h"
#include "PLL_hw.h"                // Newly added by GK 07.09.05
#include "Status_LED.h"
#include "Status_LED_Init.h"
#include "SubSysHW.h"
#include "xTC_EFM_TC_hw.h"


/* AWARE includes */
#include "CustomerTasks.h"
#include "cmv.h"


#include "profile.h"
#include "cmv_Data.h"



/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           GLOBAL DATA
** =============================================================================
*/

/* Global variable for Alphaeus selection */
FlagT gft_AlphaeusSel;
uint8 gt_WatchdogTimerEnable;

/* Flags for Aware <-> xTC signalisation in case of an OOS defect or failure */
uint8 guca_Customer_g997_TCSync_Flag[NUM_DATA_PATHS];
uint8 guca_Customer_g997_OutOfSync_Failure_NE[NUM_DATA_PATHS];


/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

extern void ATM_TC_CyclicUpdt( uint_16 timerId );
extern void PTM_counter_update( uint_8 LinkNo );

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*******************************************************************************
*
*   Prototype: void Customer_HwSetUp(void)
*
*   This function provides customer access to the initial HW setup.
*   called once at the top of main() function.
*
*   Input Arguments:
*       none
*
*   Output Arguments:
*
*   Returns:
*
*   Global Variables:
*
*******************************************************************************/
void Customer_HwSetUp(void)
{
   /* Check if chip is selected as master */
   if ((_lr(AUX_ARC_XMEM_ARB_REG) & 2) == 0)
   {
      /* Enable internal pull-ups at pins XCSN1, XCSN2 and BRSTN */
      TIMER_OC_MEM_CTRL_SET (
         TIMER_OC_MEM_CTRL_GET    |
         TIMER_OC_MEM_CTRL_CS1PUS |
         TIMER_OC_MEM_CTRL_CS2PUS |
         TIMER_OC_MEM_CTRL_BRPUS
      );
   }
   /* Setting for OC_MEM_CTRL Register for power saving */
   TIMER_OC_MEM_CTRL_SET (TIMER_OC_MEM_CTRL_GET | 0x7F7F0000);

}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  CustomerBgTaskManager()
**
** DESCRIPTION:    The function is called from the Aware method RunModem().
**                 The xTC_ModemMonitorSystem and the xTC_CmvBkgdHandler are
**                 handled from this function.
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
** =============================================================================
*/
void CustomerBgTaskManager( void )
{
   /* For ADSL CO only in showtime available */

   /* Check if timer interrupt occured */
   CheckTimerInt();

   /* Execute BackgroundHandler when a new message is in the queue or a direct
   acknowledge with background execution is needed */
   if( flag_CmvBkgdExecutionNeeded || flag_CmvBkgdDirectAcknowledge )
   {
      xTC_CmvBkgdHandler();
   }

   /* Execute EthernetExtract Indication when new extract data is available */
   if(flag_NewEthernetExtractIndication)
   {
      xTC_EthernetExtractIndicationMachine();
   }

   /* Execute xTC_ModemMonitorSystem */
   xTC_ModemMonitorSys();


}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  CustomerHandleMessage()
**
** DESCRIPTION:    Calls the CustomerHandleMessage function for the xTC
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
** =============================================================================
*/
void CustomerHandleMessage(void)
{
   xTC_CustomerHandleMessage();
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  InitCustomer_PreHandshake()
**
** DESCRIPTION:    Init all IFX Firmware parts at PreHandshake
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
** =============================================================================
*/
void InitCustomer_PreHandshake(void)
{

   /* Reset OOS_Failure_NE flags */
   for(uint_8 i = 0; i < NUM_DATA_PATHS; i++)
   {
      guca_Customer_g997_OutOfSync_Failure_NE[i] = 0;
   }

   /* Init the ModemMonitor */
   xTC_ModemMonitorInitPreHS();

   /* Init the ModemMonitor for System */
   xTC_ModemMonitorSysInitPreHS();

   /* Check if LED functions are active */
   if(ledFunctionActivated == TRUE)
   {
      if((gsa_IndirectStat0[0] == STAT_ResetState) ||
            (gsa_IndirectStat0[0] == STAT_ReadyState))
      {
         setLEDsInReset();
      }
   }

   /* Default init of PMA-REC for acticated TC */
   if (xTCs_UsedPacketTC_Get(0) == EFM_TC)
   {
      EFM_TC_LinkStateSetSyncDetect(0);
   }

}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  InitCustomer_PostHandshake()
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          Not used by IFX!
** =============================================================================
*/
void InitCustomer_PostHandshake(void)
{

}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  CustomerRxForeground()
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          Not used by IFX!
** =============================================================================
*/
void CustomerRxForeground(void)
{
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  CustomerTxForeground()
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          Not used by IFX!
** =============================================================================
*/
void CustomerTxForeground(void)
{
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  CustomerSetSwapEngineType(void)
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          Newly added by GK 07.09.05
** =============================================================================
*/
void CustomerSetSwapEngineType(void)
{

   uint_32 CHIPCFG_Val;
   uint_32 BootMode;

   /* Read content of CHIPCFG register in DFE */
   CHIPCFG_Val = PLL_CHIPCFG_RegRead();
   BootMode    = (CHIPCFG_Val & CHIPCFG_BTCFG_MASK) >> CHIPCFG_BTCFG_SHIFT;

}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  WatchdogTimerReset(void)
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:
** =============================================================================
*/
void WatchdogTimerReset(void)
{
   /* Stop the watchdog timer */
   TIME_TIMCFG_RegWrite(TIME_TIMCFG_RegRead() & ~WATCHDOG_TIMER_START);
   /* Reset the timer value */
   TIME_TIMCNT2_RegWrite(WATCHDOG_RESET_VALUE);
   /* Start the watchdog timer again */
   TIME_TIMCFG_RegWrite(TIME_TIMCFG_RegRead() | WATCHDOG_TIMER_START);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  CustomerSoftReset(void)
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:
** =============================================================================
*/
void CustomerSoftReset(void)
{



}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  Customer_1sec_Task(void)
**
** DESCRIPTION:
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:
** =============================================================================
*/
void Customer_1sec_Task(void)
{
   uint_8 slice = 0;
   /* when ATM_TC is used call function for ATM counter update */
   if (xTCs_UsedPacketTC_Get(slice) == ATM_TC)
   {

      ATM_TC_CyclicUpdt( slice );
   }
   /* when PTM is used call function for PTM counter update */
   if (xTCs_UsedPacketTC_Get(slice) != ATM_TC)
   {

      PTM_counter_update( slice );
   }

}
