/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "xTC_VersionInfo_Init.c"
** CCASE_DATE = "Wed Aug  3 16:16:17 2005"
**
** =============================================================================
**
** Contents:   Inside this file the xTC_VersionInfo is implemented.
**
** Functions:
**
**             Init_VersionInfo()
**          - Init default settings for version numbering.
**
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** 2005-05-03  Wehmann       Creation
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "wehmann"
 CCASE_VERSION = "\main\9"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "BaseTypes.h"

#include "typedef.h"

#include "xTC_VersionInfo_Init.h"
#include "xTC_VersionInfo.h"
#include "eoc.h"


/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/* Default definitions for version numbering and information */
#define VENDOR_ID                    0x4946544E /* IFTN */
#define COUNTRY_CODE                 0xB500   /* USA */

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/


/*
** =============================================================================
**                           GLOBAL DATA
** =============================================================================
*/

/*
** Global variables for G994 VendorID definition
*/
extern uint32 gul_ne_G994VendorID;
extern uint16 gus_ne_CountryCode;
extern uint16 gus_ne_G994VendorSpecific;

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

void FillSystemVendorID(uint_32 VendorID, uint_16 CountryCode, uint_16 VendorSpecific);

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  FillSystemVendorID()
**
** DESCRIPTION:    Fill the array of the SystemVendorID.
**
** PARAMETERS:     VendorID (uint_32 / unsigned long)
**             - ID of the producer.
**
**                 CountryCode (uint_16 / unsigned short)
**                 - Code of the country, where the producer is registered.
**
**                 VendorSpecific (uint_16 / unsigned short)
**                 - Vendor specific field (e.g. version number).
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
**
** NEEDED IN MODEM STATES: RESET (for Init_VersionInfo)
** =============================================================================
*/
void FillSystemVendorID(uint_32 VendorID, uint_16 CountryCode, uint_16 VendorSpecific)
{

   /* CountryCode */
   guca_ne_SystemVendorID[1] = CountryCode;
   guca_ne_SystemVendorID[0] = CountryCode >> 8;
   /* VendorID */
   guca_ne_SystemVendorID[5] = VendorID;
   guca_ne_SystemVendorID[4] = VendorID >> 8;
   guca_ne_SystemVendorID[3] = VendorID >> 16;
   guca_ne_SystemVendorID[2] = VendorID >> 24;
   /* Vendor Specific Information */
   guca_ne_SystemVendorID[7] = VendorSpecific;
   guca_ne_SystemVendorID[6] = VendorSpecific >> 8;

}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  Init_VersionInfo()
**
** DESCRIPTION:    Init default settings for version numbering.
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
**
** NEEDED IN MODEM STATES: RESET (for InitCustomer_PowerUp)
** =============================================================================
*/
void Init_VersionInfo(void)
{

   /*
   ** Set G.994 VendorID's
   */
   gul_ne_G994VendorID = VENDOR_ID;

   gus_ne_CountryCode= COUNTRY_CODE;

   gus_ne_G994VendorSpecific = us_VersionNum_GHS;

   /* Fill the SystemVendorID with default */
   FillSystemVendorID((uint_32)gul_ne_G994VendorID, (uint_16)gus_ne_CountryCode,
                      (uint_16)gus_ne_G994VendorSpecific);
}
