/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_Data.c
*
*   This file contains VRX518 AFE Data
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 AFE related Data variables,Hybrid coefficients
// 28/07/2018 Stefan: Added two new hybrid coefs for 8MHz and 17MHz modes for OTE setup
//            Increase the number of tested hybrid settings from 7 to 9 for BRCM-based DSLAMs
//            Due to missing testing time this fix is enabled only for BRCM
//            The default settings were not matching due to an impedance mismatch of their linesimulator
//            XDSLRTFW-3897 : Low DS rate in OTE Setup due to wrong hybrid selection (600m/900 loops)
// **********************************************************************************************//
#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "delay.h"
#include "vdsl_xception.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

// global variable for RC-measurement
uint16_t RC_meas_done;
uint16_t RC_counter = 319;
int16  gs_Hyb_Hsk_QlnHlog;//gs_Hyb_Hsk_QlnHlog = 1 means HSK hybrid, 2 = QLNHLOG else Special setting
int16  gs_PrefiAceMode_Selected = ACE_OFF;            //Allowed values could be ACE_52p5F(0) ACE_30pF(1) ACE_15pF(2) ACE_7p5F (3) ACE_OFF (4)
uint16 gusa_SwitchingThreshAceMode[ACE_MODE_SWITCH_ARRAY_SIZE];
int16 gs_AceSwitchDownRounding = 0x0008;    // Q8.8format -> 0.03125dB

int16  gs_MaxNomPsdOut_Dbg = 0; //380 means 38dbm SO to make 39 use 100 and to make 37 use -100

FlagT    gft_DfiConfig = 1;
FlagT    gft_EnableDfiReconfigAlways = 0;
FlagT    gft_Debug35bHwConfig17aModeEnable = FALSE;
FlagT    gft_DisableCompensationTable = 0;
FlagT    gft_EnaPrefiAceOffOneStagePga = TRUE; //XDSLRTFW-3613 When True in case of OneStagePga, ACE = OFF


uint32   gul_Afe_flowtest = 0;
uint16   gus_SkipAfeFlow =0;
int16    gs_ForceGainPofi_dB = -1;

int16    gs_Force_AfeDslVersion = -1;     //Allowed values could be 0x00=A11 0x02=A21
int16    gs_Force_AfeCentralVersion = -1; //Allowed values could be 0x00=A11 0x01=A21

int16    gs_Pga1MaxGainForce = -1;
int16    gs_Pga2MaxGainForce = -20;

int16    gs_ForcePga1Gain = -32;
int16    gs_ForcePga2Gain = -32;

//DFE/AFE blocks Gain settings
RxPathGains_t gt_DfeAfeGainSettings;// XDSLRTFW-3441

RxPathDslGainCorrection_t gt_PgaGainCorrectionDslPath;//XDSLRTFW-3596

int16 gsa_PgaTrainDebugVars[10];
int16 gus_DebugControlVRX518 = (PREFI_GAIN_OVERSHOOT_PGA1_SWITCH|PGA1_SWITCH_NO_ACE_SWITCH|TX_US0_POFI_FC_SELECT_EN|PGA_PREFI_FC_REDUCTION_EN|US_NOISE_DETECTION_EN|PGA_OF_CHDISC_FOR_TRANSTRAIN_EN);  //This Debug Variable shall be removed later, used at present enable/disbale
uint8 guca_QlnLevelUS[]={0xFF,0xFF,0xFF,0xFF};

//                               BYPASSED    VDSL35b     VDSL17      VDSL8    ADSL2
//                               0           1           2           3        4
int32_t gla_fc_pga_lp_kHz[5]   ={ 79578,      79578,      79578,      79578,   10000 };
int32_t gla_fc_prefi_lp_kHz[5] ={ 61213,      61213,      61213,      61213,   10000 };
// XDSLRTFW-3746 just following freqs allowed for POFI
// 80MHz, 40MHz, 26.7MHz, 20MHz, 16MHz, 13.4MHz, 11.5MHz, 10MHz
int32_t gla_fc_pofi_lp_kHz[5]  ={ 26700,      26700,      26700,      26700,   320   };

//For 8M   //PGA_fc_lowpass_Hz = 12835e3;  %% instead of 12500e3; to get 31pf @0dB
          //PREFI_fc_lowpass_Hz = 12434e3  %% instead of 12500e3; to get 3.3 pf @0dB
int16_t gsa_gain_pga_dB[]     ={-9,          -9,         -9,         -9,      -9    };
int16_t gsa_gain_prefi_dB[]   ={-8,          -5,         -5,         -5,      -5    };
int16_t gsa_gain_pofi_dB[]    ={ 9,           9,          9,          9,       9    };


// VRX518 Hybrid settings for different profiles with AnxABJ LIF module
//---------------------------------------------------------------------
// ##A21####A21####A21####A21## New LIF Hybrid Table ##A21####A21####A21####A21##  START

//#ifdef ISDN
//uint16 gusa_HybridSettingV2_Handshake_VRX518[VRX518_HYB_NUM_SETTINGS] = {0x0396, 0x3C12, 0x3C18, 0xFD03}; // 4  -2.9914 160 8633  114 off 15p 200 off 15p ETSI #1 (5000m)
//#else
//uint16 gusa_HybridSettingV2_Handshake_VRX518[VRX518_HYB_NUM_SETTINGS] = {0x0375, 0x0013, 0x0410, 0xFD0A};
//#endif
//XDSLRTFW-3463
uint16 gusa_HybridSettingV2_Handshake_VRX518[VRX518_HYB_NUM_SETTINGS] = {
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain //Index  HybGain   Rsa   Rpa Rsb  Rpb  Cpb  Rsc  Rpc  Cpc  Description
        //0x001E,        0x033D,            0x001E,           0xF688};//           -9.4697   800   off   533  2832   0p   800   off   0p  Handshake
      0x0396,        0x3C12,            0x3C18,           0xFD03};  //     4  -2.9914   160  8633   114  off  15p 200   off   15p   ETSI #1 (5000m)

uint16 gusa_HybridSettingV2_Handshake_VRX518_AnnexA[VRX518_HYB_NUM_SETTINGS] = {
      0x0375,           0x0013,        0x0410,     0xFD0A}; //   2   -2.9619   145  4106   123  off   0p   100    off   1p  26AWG (16000ft)

uint16 gusa_HybridSettingV2_QlnHlog_VRX518[VRX518_HYB_NUM_SETTINGS] = {
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain //Index  HybGain   Rsa   Rpa Rsb  Rpb  Cpb  Rsc  Rpc  Cpc  Description
        0x0215,        0x329E,            0x0ADB,           0xF39C};//     1   -12.3923   145    100  800   442  12p   320   929   2p    QLN/HLOG

// ##A21####A21####A21####A21## New LIF Hybrid Table ##A21####A21####A21####A21##  END

// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##  START
uint16 gusa_HybridSettingV2_Handshake_VRX518_A21[VRX518_HYB_NUM_SETTINGS] = {
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain //Index  HybGain   Rsa   Rpa Rsb  Rpb  Cpb  Rsc  Rpc  Cpc  Description
        0x001E,        0x033D,            0x001E,           0xF688};//           -9.4697   800   off   533  2832   0p   800   off   0p  Handshake

uint16 gusa_HybridSettingV2_QlnHlog_VRX518_A21[VRX518_HYB_NUM_SETTINGS] = {
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain //Index  HybGain   Rsa   Rpa Rsb  Rpb  Cpb  Rsc  Rpc  Cpc  Description
        0x0215,        0x329E,            0x0ADB,           0xF39C};//     1   -12.3923   145    100  800   442  12p   320   929   2p    QLN/HLOG
// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##  END

DATA_XILVB_B4_SHOW_INIT_BEGIN

//If there is a change in fc, use the below table after HLOG, because HLOG/QLN already done with above fc
//                                          BYPASSED    VDSL35b     VDSL17      VDSL8    ADSL2
//                                          0           1           2           3        4
int32_t gla_fc_pga_lp_kHz_HybridPga[5]   = { 70000,      70000,      60000,      34000,   10000 };
int32_t gla_fc_prefi_lp_kHz_HybridPga[5] = { 70000,      70000,      60000,      34000,   10000 };


// ##A21####A21####A21####A21## New LIF Hybrid Table ##A21####A21####A21####A21##  START
// ##A21####A21####A21####A21## New LIF Hybrid Table ##A21####A21####A21####A21##

uint16 gusa_SpecialHybSetting[VRX_HYB_NUM_SETTINGS] =
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x023B,      0x0000,            0x073E,           0xF053};  //  1  -15.6759   320    145   off   off   0p    800  2832      1p Null Loop

uint16 gusa_HybridSettingV2_35M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_35M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x0337,      0x0819,            0x0FF4,           0xFC3D},  //  1  -3.7649   178  2832   229  off   2p 133 26319   3p ETSI #1 (200m)
      { 0x03D7,      0x0815,            0x0818,           0xFCD7},  //  2  -3.1620   178 18151   145  off   2p 200   off   2p ETSI #1 (400m)
      { 0x02B0,      0x2010,            0x2010,           0xFC50},  //  3  -3.6894   100  641   100   off   8p 100   off   8p VDSL ETSI #2 (50m)
      { 0x02D7,      0x1B37,            0x27B1,           0xFAED},  //  4  -5.0746   178  929   178   2832   6p   107 12518   9p VDSL ETSI #2 (200m)
      { 0x0338,      0x1C13,            0x1C14,           0xFBDA},  //  5  -4.1511   200  2832   123  off   7p 133   off   7p VDSL ETSI #2 (400m)
      { 0x0378,      0x13F0,            0x1B94,           0xFC16},  //  6  -3.9179   200  4106   100 26319   4p   133  8633   6p 26AWG var length (450ft)
      { 0x02B3,      0x1013,            0x0C19,           0xFB9E},  //  7  -4.3848   123  641   123   off   4p 229   off   3p VDSL2 BT 20ft (300ft)
};

uint16 gusa_HybridSettingV2_30M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_30M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x0337,      0x0819,            0x0FF4,            0xFC3D},  // 1  -3.7649   178  2832   229  off   2p 133 26319   3p ETSI #1 (200m)
      { 0x03D7,      0x0815,            0x0818,            0xFCD7},  // 2  -3.1620   178 18151   145  off   2p 200   off   2p ETSI #1 (400m)
      { 0x02B0,      0x2010,            0x2010,            0xFC50},  // 3  -3.6894   100  641   100   off   8p 100   off   8p VDSL ETSI #2 (50m)
      { 0x02D7,      0x1B37,            0x27B1,            0xFAED},  // 4  -5.0746   178  929   178   2832   6p   107 12518   9p VDSL ETSI #2 (200m)
      { 0x0338,      0x1C13,            0x1C14,            0xFBDA},  // 5  -4.1511   200  2832   123  off   7p 133   off   7p VDSL ETSI #2 (400m)
      { 0x0378,      0x13F0,            0x1B94,            0xFC16},  // 6  -3.9179   200  4106   100 26319   4p   133  8633   6p 26AWG var length (450ft)
      { 0x02B3,      0x1013,            0x0C19,            0xFB9E},  // 7  -4.3848   123  641   123   off   4p 229   off   3p VDSL2 BT 20ft (300ft)
};

// XDSLRTFW-3897(Start)
// For  OTE-Greece- FW#2 8B2D17
uint16 gusa_HybridSettingV2_17M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_17M][VRX518_HYB_NUM_SETTINGS] = {
// PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb     Rsc   Rpc   Cpc   Description
      { 0x02D7,      0x0794,          0x3252,       0xFAED},      //  1     -5.0746   178   929   133  8633   1p  114   210   12p   ETSI #1 (100m)
      { 0x03F5,      0x0C10,          0x0C14,       0xFD68},      //  2     -2.5954   145 26319   100   off   3p  133   off    3p   ETSI #1 (400m)
      { 0x02B7,      0x0E90,          0x3393,       0xFA26},      //  3     -5.8518   178   641   100   442   3p  123  8633   12p   VDSL ETSI #2 (50m)
      { 0x02F7,      0x1018,          0x1816,       0xFB82},      //  4     -4.4942   178  1347   200   off   4p  160   off    6p   VDSL ETSI #2 (400m)
      { 0x03B7,      0x1010,          0x0C18,       0xFCCA},      //  5     -3.2137   178 12518   100   off   4p  200   off    3p   26AWG (1200ft)
      { 0x0313,      0x3C11,          0x07D0,       0xFD0C},      //  6     -2.9554   123  1953   107   off  15p  100 18151    1p   VDSL2 BT 100ft (600ft)
      { 0x02F8,      0x141D,          0x1B33,       0xFB12},      //  7     -4.9326   200  1347   533   off   5p  123  2832    6p   VDSL2 BT 200ft (3200ft)
      { 0x02F7,      0x0018,          0x0816,       0xFB82},      //  4a    -4.4942   178  1347   200   off   0p  160   off    2p   VDSL ETSI #2 (400m) - OTE ISDN board (600m)
      { 0x02F7,      0x0418,          0x0816,       0xFB82},      //  4b    -4.4942   178  1347   200   off   1p  160   off    2p   VDSL ETSI #2 (400m) - OTE ISDN board (600m)
};
// XDSLRTFW-3897(End)

uint16 gusa_HybridSettingV2_12M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_12M][VRX518_HYB_NUM_SETTINGS] = {
// PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa    Rpa   Rsb   Rpb  Cpb Rsc   Rpc  Cpc Description
      { 0x02D7,      0x0794,         0x3252,        0xFAED},  //  1  -5.0746   178  929   133   8633   1p      114   210   12p   ETSI #1 (100m)
      { 0x03F5,      0x0C10,         0x0C14,        0xFD68},  //  2  -2.5954   145  26319   100    off   3p    133   off      3p ETSI #1 (400m)
      { 0x02B7,      0x0E90,         0x3393,        0xFA26},  //  3  -5.8518   178  641   100   442   3p    123  8633   12p   VDSL ETSI #2 (50m)
      { 0x02F7,      0x1018,         0x1816,        0xFB82},  //  4  -4.4942   178  1347   200  off   4p    160   off      6p VDSL ETSI #2 (400m)
      { 0x03B7,      0x1010,         0x0C18,        0xFCCA},  //  5  -3.2137   178  12518   100    off   4p    200   off      3p 26AWG (1200ft)
      { 0x0313,      0x3C11,         0x07D0,        0xFD0C},  //  6  -2.9554   123  1953   107  off  15p    100 18151      1p VDSL2 BT 100ft (600ft)
      { 0x02F8,      0x141D,         0x1B33,        0xFB12},  //  7  -4.9326   200  1347   533  off   5p    123  2832      6p VDSL2 BT 200ft (3200ft)
      { 0x02F7,      0x0018,         0x0816,        0xFB82},  //  4a    -4.4942   178  1347   200   off   0p  160   off    2p   VDSL ETSI #2 (400m) - OTE ISDN board (600m)
      { 0x02F7,      0x0418,         0x0816,        0xFB82},  //  4b    -4.4942   178  1347   200   off   1p  160   off    2p   VDSL ETSI #2 (400m) - OTE ISDN board (600m)
};
// XDSLRTFW-3897(Start)
uint16 gusa_HybridSettingV2_8M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_8M][VRX518_HYB_NUM_SETTINGS] = {
//   PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa    Rpa   Rsb    Rpb  Cpb   Rsc   Rpc  Cpc   Description
      { 0x0371,       0x1410,           0x1010,       0xFDE0},  //   1    -2.1275   107   5954   100    off   5p      100   off      4p   ETSI #1 (1200m)
      { 0x02D2,       0x0C1B,           0x0417,       0xFC7C},  //   2    -3.5177   114    929   267    off   3p      178   off      1p   VDSL ETSI #1 (900m)
      { 0x02B2,       0x1418,           0x1414,       0xFBE2},  //   3    -4.1192   114    641   200    off   5p      133   off      5p   VDSL ETSI #2 (750m)
      { 0x0290,       0x3810,           0x0811,       0xFB91},  //   4    -4.4344   100    442   100    off  14p      107   off      2p   VDSL ETSI #4 (900m)
      { 0x023B,       0x0AFE,           0x1A5F,       0xF053},  //   5   -15.6759   320    145   800   1347   2p     1600   210   6p   26AWG (150ft)
      { 0x0312,       0x2C12,           0x1815,       0xFD3E},  //   6    -2.7586   114   1953   114    off   7p      145   off      2p   26AWG (3600ft)
      { 0x02F7,       0x1F9C,           0x3F71,       0xFB82},  //   7    -4.4942   178   1347   400   8633   7p      107  5954     15p   VDSL2 BT 100ft (2800ft)
      { 0x03F8,       0x0B57,           0x4194,       0xFC8A},  //   8   (ETSI 900m loop - OTE lab - Vers. 0xE0)
      { 0x0017,       0x0014,           0x03D0,       0xFCA0},  //   9   (ETSI 900m loop - OTE lab - Vers. 0xE1)
};
// XDSLRTFW-3897(End)





uint16 gusa_HybridSettingV2_US0_VRX518[VRX518_ANX_ABJ_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS] =  {
// PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa    Rpa   Rsb   Rpb  Cpb Rsc   Rpc  Cpc Description
      { 0x0250,       0x0EBE,             0x23D4,        0xF957},  //   1   -6.6632   100    210   800   641   3p 133 18151   8p ETSI #1 (1000m)
      { 0x0373,       0x3010,             0x1010,        0xFD92},  //   2   -2.4298   123   5954   100   off  12p 100   off   4p ETSI #1 (2000m)
      { 0x0395,       0x3C10,             0x3C16,        0xFD44},  //   3   -2.7360   145   8633   100   off  15p 160   off   15p   ETSI #1 (3500m)
      { 0x0396,       0x3C12,             0x3C18,        0xFD03},  //   4   -2.9914   160   8633   114   off  15p 200   off   15p   ETSI #1 (5000m)
      { 0x03F6,       0x3C10,             0x3C11,        0xFD29},  //   5   -2.8406   160  26319   100   off  15p 107   off   15p   ETSI #2 (3500m)
      { 0x03D6,       0x3010,             0x3810,        0xFD21},  //   6   -2.8740   160  18151   100   off  12p 100   off   14p   ETSI #2 (5000m)
      { 0x0016,       0x3410,             0x1412,        0xFD3C},  //   7   -2.7661   160    off   100   off  13p 114   off   5p ETSI #6 (750m)
      { 0x0396,       0x0BF0,             0x0010,        0xFD03},  //   8   -2.9914   160   8633   100   26319  2p   100   off   0p ETSI #7 (200m)
      { 0x0376,       0x3413,             0x3813,        0xFCE9},  //   9   -3.0909   160   5954   123   off  13p 123   off   14p   26AWG var length (16000ft)
      { 0x0250,       0x1733,             0x0000,        0xF957},  //  10   -6.6632   100    210   123   2832   5p      off   off      0p TR-100 Bridge Tap 3kft (100ft)
      { 0x0298,       0x1C12,             0x0000,        0xF88E},  //  11   -7.4485   200    442   114   off   7p       off   off      0p TR-100 Bridge Tap 7kft (200ft)
      { 0x0275,       0x1410,             0x0000,        0xF8E7},  //  12   -7.0996   145    305   100   off   5p       off   off      0p TR-100 Bridge Tap 9kft (200ft)
      { 0x02D0,       0x3F70,             0x3C1C,        0xFCDE},  //  13   -3.1365   100    929   100   5954  15p   400   off   15p   TR-100 Bridge Tap 11kft (100ft)
      { 0x02D0,       0x17F4,             0x3EFE,        0xFCDE},  //  14   -3.1365   100    929   133   26319  5p   800  1347   15p   TR-100 Bridge Tap 15kft (1500ft)
      { 0x0290,       0x2F77,             0x3F3D,        0xFB91},  //  15   -4.4344   100    442   178   5954  11p   533  2832   15p   TR-100 Bridge Tap 17.5kft (150ft)
      { 0x0316,       0x0B30,             0x0810,        0xFC48},  //  16   -3.7208   160   1953   100   2832   2p   100   off   2p DTAG_04mm (2500m)
      { 0x02D8,       0x06FB,             0x0810,        0xFA73},  //  17   -5.5513   200    929   320   1347   1p   100   off   2p DTAG_04mm (3500m)
      // Only taken 17 settings from Frank table remaining are for with splitter which are not but added as we the option
      { 0x0231,        0x3314,            0x027F,        0xF76F},  //  18    -8.5674   107   145   133  1953  12p  1600   305   0p  ETSI #1 (500m) w Splitter
      { 0x02B0,        0x17D0,            0x33DC,        0xFC50},  //  19    -3.6894   100   641   100 18151   5p   400 18151  12p  ETSI #1 (1000m) w Splitter
      { 0x02B0,        0x1C10,            0x3C1C,        0xFC50},  //  20    -3.6894   100   641   100   off   7p   400   off  15p  ETSI #1 (4000m) w Splitter
      { 0x0250,        0x3E5B,            0x1415,        0xF957},  //  21    -6.6632   100   210   267   210  15p   145   off   5p  ETSI #1 (500m) w Splitter+ISDN
      { 0x02B0,        0x1BFB,            0x3FDB,        0xFC50},  //  22    -3.6894   100   641   267 26319   6p   267 18151  15p  ETSI #1 (1000m) w Splitter+ISDN
      { 0x02D0,        0x3411,            0x3819,        0xFCDE},  //  23    -3.1365   100   929   107   off  13p   229   off  14p  ETSI #1 (4000m) w Splitter+ISDN
      { 0x03D9,        0x2016,            0x381D,        0xFC13},  //  24 // Hand tuned Hybrid from ADSL FW

};
//US0 Annex A
uint16 gusa_HybridSettingV2_US0_A_VRX518[VRX518_ANX_A_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS] =  {
// PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa    Rpa   Rsb   Rpb  Cpb Rsc   Rpc  Cpc Description
      { 0x02F0,   0x1BF3,            0x0410,            0xFD45},  //   1    -2.7329    100  1347   123 26319   6p   100 off   1p  26AWG (6000ft)
      { 0x0375,   0x0013,            0x0410,            0xFD0A},  //   2    -2.9619    145  4106   123   off   0p   100 off   1p  26AWG (16000ft)
      { 0x0270,   0x13D0,            0x0000,            0xFA97},  //   3    -5.4105   100    305   100   18151   4p  off   off      0p TR-100 Bridge Tap 3kft (200ft)
      { 0x02F0,   0x3FD9,            0x3C1E,            0xFD45},  //   4    -2.7329    100  1347   229 18151   15p   800   off  15p  TR-100 Bridge Tap 7kft (100ft)
      { 0x0310,   0x0412,            0x001E,            0xFD8F},  //   5    -2.4433    100  1953   114   off   1p   800 off   0p  TR-100 Bridge Tap 9kft (200ft)
      { 0x0312,   0x3C10,            0x381C,            0xFD3E},  //   6    -2.7586    114  1953   100   off   15p   400   off  14p  TR-100 Bridge Tap 11kft (100ft)
      { 0x02F2,   0x1C10,            0x301E,            0xFCED},  //   7    -3.0765    114  1347   100   off   7p   800 off  12p  TR-100 Bridge Tap 12kft (250ft)
      { 0x0293,   0x201D,            0x3F7F,            0xFAC7},  //   8    -5.2260    123   442   533   off   8p  1600  4106  15p  TR-100 Bridge Tap 12kft (750ft)
      { 0x0290,   0x37F6,            0x3F7F,            0xFB91},  //   9    -4.4344    100   442   160 26319   13p  1600  4106  15p  TR-100 Bridge Tap 15kft (400ft)
      { 0x0275,   0x101D,            0x0000,            0xF8E7},  //  10    -7.0996   145    305   533   off   4p    off   off      0p TR-100 Bridge Tap 15kft (1000ft)
      { 0x02B2,   0x2C1D,            0x02BE,            0xFBE2},  //  11    -4.1192    114   641   533   off   11p   800   641   0p  TR-100 Bridge Tap 15kft (1500ft)
      { 0x0299,   0x001D,            0x0000,            0xF7D8},  //  12    -8.1573   229    442   533   off   0p    off   off      0p TR-100 Bridge Tap 17.5kft (800ft)
      { 0x0330,   0x1410,            0x2410,            0xFDC4},  //  13    -2.2377    100  2832   100   off   5p   100 off   9p  ETSI #1 (2500m)
      { 0x03B5,   0x0810,            0x2410,            0xFD55},  //  14    -2.6713    145 12518   100   off   2p   100 off   9p  ETSI #2 (5000m)
      { 0x02D0,   0x0F92,            0x0410,            0xFCDE},  //  15    -3.1365    100   929   114  8633   3p   100 off   1p  DTAG_04mm (1500m)
      { 0x0399,   0x0C10,            0x3817,            0xFBEC},  //  16    -4.0782    229  8633   100   off   3p   178 off  14p  DTAG_04mm (5000m)
      { 0x0377,   0x201B,            0x0810,            0xFC9B},  //  17    -3.3952    178  5954   267   off   8p   100 off   2p  ANSI #1
      { 0x02D0,   0x081D,            0x0EFD,            0xFCDE},  //  18    -3.1365    100   929   533   off   2p   533  1347   3p  ANSI #2
      { 0x0275,   0x001D,            0x0000,            0xF8E7},  //  19    -7.0996   145    305   533   off   0p    off   off      0p ANSI #8
      { 0x0391,   0x001D,            0x141E,            0xFDF3},  //  20    -2.0533    107  8633   533   off   0p   800 off   5p  ANSI #11
      { 0x0374,   0x1810,            0x1410,            0xFD43},  //  21    -2.7386    133  4106   100   off   6p   100 off   5p  ANSI #15
      { 0x02D0,   0x081C,            0x141E,            0xFCDE},  //  22    -3.1365    100   929   400   off   2p   800 off   5p  CSA #2
      { 0x0019,   0x1778,            0x0410,            0xFC36},  //  23    -3.7926    229   off   200  4106   5p   100 off   1p  CSA #4
      { 0x0310,   0x3011,            0x0810,            0xFD8F},  //  24    -2.4433    100  1953   107   off   12p   100   off   2p  CSA #5
};

// ##A21####A21####A21####A21## New LIF Hybrid Table ##A21####A21####A21####A21## END


// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##  START
// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##

uint16 gusa_SpecialHybSetting_A21[VRX_HYB_NUM_SETTINGS] =
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x0256,        0x0AFE,            0x0B9C,        0xF6DF};  //   1    -9.1295   160   210   800  1347   2p   400  8633   2p  Null Loop


uint16 gusa_HybridSettingV2_35M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_35M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x0318,        0x1BF1,            0x081B,        0xFB86},  //   1    -4.4787   200  1953   107 26319   6p   320   off   2p  ETSI #1 (200m)
      { 0x0317,        0x1015,            0x081B,        0xFBEF},  //   2    -4.0700   178  1953   145   off   4p   320   off   2p  ETSI #1 (400m)
      { 0x0299,        0x2BF1,            0x26BB,        0xF7D8},  //   3    -8.1573   229   442   107 26319  10p   320   641   9p  VDSL ETSI #2 (50m)
      { 0x02D7,        0x2812,            0x2414,        0xFAED},  //   4    -5.0746   178   929   114   off  10p   133   off   9p  VDSL ETSI #2 (200m)
      { 0x02F9,        0x2015,            0x101B,        0xFA86},  //   5    -5.4786   229  1347   145   off   8p   320   off   4p  VDSL ETSI #2 (400m)
      { 0x02D7,        0x1416,            0x1BF5,        0xFAED},  //   6    -5.0746   178   929   160   off   5p   145 26319   6p  26AWG (450ft)
      { 0x0295,        0x3711,            0x07FD,        0xFA15},  //   7    -5.9210   145   442   107  1953  13p   533 26319   1p  VDSL2 BT 20ft (300ft)
};

uint16 gusa_HybridSettingV2_30M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_30M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x0318,        0x1BF1,            0x081B,        0xFB86},  //   1    -4.4787   200  1953   107 26319   6p   320   off   2p  ETSI #1 (200m)
      { 0x0317,        0x1015,            0x081B,        0xFBEF},  //   2    -4.0700   178  1953   145   off   4p   320   off   2p  ETSI #1 (400m)
      { 0x0299,        0x2BF1,            0x26BB,        0xF7D8},  //   3    -8.1573   229   442   107 26319  10p   320   641   9p  VDSL ETSI #2 (50m)
      { 0x02D7,        0x2812,            0x2414,        0xFAED},  //   4    -5.0746   178   929   114   off  10p   133   off   9p  VDSL ETSI #2 (200m)
      { 0x02F9,        0x2015,            0x101B,        0xFA86},  //   5    -5.4786   229  1347   145   off   8p   320   off   4p  VDSL ETSI #2 (400m)
      { 0x02D7,        0x1416,            0x1BF5,        0xFAED},  //   6    -5.0746   178   929   160   off   5p   145 26319   6p  26AWG (450ft)
      { 0x0295,        0x3711,            0x07FD,        0xFA15},  //   7    -5.9210   145   442   107  1953  13p   533 26319   1p  VDSL2 BT 20ft (300ft)
};

uint16 gusa_HybridSettingV2_17M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_17M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x02D8,        0x1AD6,            0x33F8,        0xFA73},  //   1    -5.5513   200   929   160   929   6p   200 26319  12p  ETSI #1 (100m)
      { 0x0336,        0x1412,            0x1018,        0xFC91},  //   2    -3.4355   160  2832   114   off   5p   200   off   4p  ETSI #1 (400m)
      { 0x0299,        0x1ED9,            0x241B,        0xF7D8},  //   3    -8.1573   229   442   229   929   7p   320   off   9p  VDSL ETSI #2 (50m)
      { 0x02D7,        0x2413,            0x141B,        0xFAED},  //   4    -5.0746   178   929   123   off   9p   267   off   5p  VDSL ETSI #2 (400m)
      { 0x0338,        0x2410,            0x081B,        0xFBDA},  //   5    -4.1511   200  2832   100   off   9p   320   off   2p  26AWG var length (1200ft)
      { 0x02D7,        0x277B,            0x07FB,        0xFAED},  //   6    -5.0746   178   929   267  4106   9p   267 26319   1p  VDSL2 BT 100ft (600ft)
      { 0x027B,        0x3EDF,            0x37BB,        0xF581},  //   7   -10.4997   267   305  1600   929  15p   267 12518  13p  VDSL2 BT 200ft (3200ft)
      { 0x02D7,        0x277B,            0x07FB,        0xFAED},  //   6    XDSLRTFW-3897 Dummy fill
      { 0x027B,        0x3EDF,            0x37BB,        0xF581},  //   7    XDSLRTFW-3897 Dummy fill
};

uint16 gusa_HybridSettingV2_12M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_12M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x02D8,        0x1AD6,            0x33F8,        0xFA73},  //   1    -5.5513   200   929   160   929   6p   200 26319  12p  ETSI #1 (100m)
      { 0x0336,        0x1412,            0x1018,        0xFC91},  //   2    -3.4355   160  2832   114   off   5p   200   off   4p  ETSI #1 (400m)
      { 0x0299,        0x1ED9,            0x241B,        0xF7D8},  //   3    -8.1573   229   442   229   929   7p   320   off   9p  VDSL ETSI #2 (50m)
      { 0x02D7,        0x2413,            0x141B,        0xFAED},  //   4    -5.0746   178   929   123   off   9p   267   off   5p  VDSL ETSI #2 (400m)
      { 0x0338,        0x2410,            0x081B,        0xFBDA},  //   5    -4.1511   200  2832   100   off   9p   320   off   2p  26AWG var length (1200ft)
      { 0x02D7,        0x277B,            0x07FB,        0xFAED},  //   6    -5.0746   178   929   267  4106   9p   267 26319   1p  VDSL2 BT 100ft (600ft)
      { 0x027B,        0x3EDF,            0x37BB,        0xF581},  //   7   -10.4997   267   305  1600   929  15p   267 12518  13p  VDSL2 BT 200ft (3200ft)
      { 0x02D7,        0x277B,            0x07FB,        0xFAED},  //   6    XDSLRTFW-3897 Dummy fill
      { 0x027B,        0x3EDF,            0x37BB,        0xF581},  //   7    XDSLRTFW-3897 Dummy fill
};

uint16 gusa_HybridSettingV2_8M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_8M][VRX518_HYB_NUM_SETTINGS] = {
  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
      { 0x02D8,        0x1AD6,            0x33F8,        0xFA73},  //   1    -5.5513   200   929   160   929   6p   200 26319  12p  ETSI #1 (100m)
      { 0x0336,        0x1412,            0x1018,        0xFC91},  //   2    -3.4355   160  2832   114   off   5p   200   off   4p  ETSI #1 (400m)
      { 0x0299,        0x1ED9,            0x241B,        0xF7D8},  //   3    -8.1573   229   442   229   929   7p   320   off   9p  VDSL ETSI #2 (50m)
      { 0x02D7,        0x2413,            0x141B,        0xFAED},  //   4    -5.0746   178   929   123   off   9p   267   off   5p  VDSL ETSI #2 (400m)
      { 0x0338,        0x2410,            0x081B,        0xFBDA},  //   5    -4.1511   200  2832   100   off   9p   320   off   2p  26AWG var length (1200ft)
      { 0x02D7,        0x277B,            0x07FB,        0xFAED},  //   6    -5.0746   178   929   267  4106   9p   267 26319   1p  VDSL2 BT 100ft (600ft)
      { 0x027B,        0x3EDF,            0x37BB,        0xF581},  //   7   -10.4997   267   305  1600   929  15p   267 12518  13p  VDSL2 BT 200ft (3200ft)
      { 0x02D7,        0x277B,            0x07FB,        0xFAED},  //   6    XDSLRTFW-3897 Dummy fill
      { 0x027B,        0x3EDF,            0x37BB,        0xF581},  //   7    XDSLRTFW-3897 Dummy fill
};

uint16 gusa_HybridSettingV2_US0_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS] =  {
//  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa Rpa Rsb Rpb  Cpb  Rsc   Rpc  Cpc  Description
      {  0x0210,        0x0ADF,        0x33BD  ,   0xF5F8  },  //  1   -10.0349     100   100 1600  929  2p     533   12518  12p ETSI #1 (500m)
      {  0x0232,        0x1ADF,        0x381B  ,   0xF715  },  //  2   -8.9217      114   145 1600  929  6p     320   off   14p  ETSI #1 (1000m)
      {  0x027B,        0x169F,        0x3C1D  ,   0xF45C  },  //  3   -11.6433     320   305 1600  442  5p     533   off   15p  ETSI #1 (1500m)
      {  0x029C,        0x3A5D,        0x0C1E  ,   0xF48C  },  //  4   -11.4567     400   442 533   210  14p    800   off   3p   ETSI #1 (2000m)
      {  0x029D,        0x3A9F,        0x281E  ,   0xF2A3  },  //  5   -13.3658     533   442 1600  442  14p    800  off    10p  ETSI #1 (3000m)
      {  0x02BE,        0x2E9F,        0x3FFE  ,   0xF157  },  //  6   -14.6619     800   641 1600  442  11p   800  26319   15p  ETSI #1 (4000m)

//Repeated above settings for filling the array size #define VRX518_ANX_ABJ_NUM_HYBS_US0       (24)
      {  0x0210,        0x0ADF,        0x33BD  ,   0xF5F8  },  //  1   -10.0349     100   100 1600  929  2p     533   12518  12p ETSI #1 (500m)
      {  0x0232,        0x1ADF,        0x381B  ,   0xF715  },  //  2   -8.9217      114   145 1600  929  6p     320   off   14p  ETSI #1 (1000m)
      {  0x027B,        0x169F,        0x3C1D  ,   0xF45C  },  //  3   -11.6433     320   305 1600  442  5p     533   off   15p  ETSI #1 (1500m)
      {  0x029C,        0x3A5D,        0x0C1E  ,   0xF48C  },  //  4   -11.4567     400   442 533   210  14p    800   off   3p   ETSI #1 (2000m)
      {  0x029D,        0x3A9F,        0x281E  ,   0xF2A3  },  //  5   -13.3658     533   442 1600  442  14p    800  off    10p  ETSI #1 (3000m)
      {  0x02BE,        0x2E9F,        0x3FFE  ,   0xF157  },  //  6   -14.6619     800   641 1600  442  11p   800  26319   15p  ETSI #1 (4000m)

      {  0x0210,        0x0ADF,        0x33BD  ,   0xF5F8  },  //  1   -10.0349     100   100 1600  929  2p     533   12518  12p ETSI #1 (500m)
      {  0x0232,        0x1ADF,        0x381B  ,   0xF715  },  //  2   -8.9217      114   145 1600  929  6p     320   off   14p  ETSI #1 (1000m)
      {  0x027B,        0x169F,        0x3C1D  ,   0xF45C  },  //  3   -11.6433     320   305 1600  442  5p     533   off   15p  ETSI #1 (1500m)
      {  0x029C,        0x3A5D,        0x0C1E  ,   0xF48C  },  //  4   -11.4567     400   442 533   210  14p    800   off   3p   ETSI #1 (2000m)
      {  0x029D,        0x3A9F,        0x281E  ,   0xF2A3  },  //  5   -13.3658     533   442 1600  442  14p    800  off    10p  ETSI #1 (3000m)
      {  0x02BE,        0x2E9F,        0x3FFE  ,   0xF157  },  //  6   -14.6619     800   641 1600  442  11p   800  26319   15p  ETSI #1 (4000m)

      {  0x0210,     0x0ADF,     0x33BD   ,  0xF5F8   }, // 1  -10.0349    100   100 1600  929  2p    533   12518  12p ETSI #1 (500m)
      {  0x0232,     0x1ADF,     0x381B   ,  0xF715   }, // 2  -8.9217     114   145 1600  929  6p    320   off   14p  ETSI #1 (1000m)
      {  0x027B,     0x169F,     0x3C1D   ,  0xF45C   }, // 3  -11.6433    320   305 1600  442  5p    533   off   15p  ETSI #1 (1500m)
      {  0x029C,     0x3A5D,     0x0C1E   ,  0xF48C   }, // 4  -11.4567    400   442 533   210  14p   800   off   3p   ETSI #1 (2000m)
      {  0x029D,     0x3A9F,     0x281E   ,  0xF2A3   }, // 5  -13.3658    533   442 1600  442  14p   800  off    10p  ETSI #1 (3000m)
      {  0x02BE,     0x2E9F,     0x3FFE   ,  0xF157   }, // 6  -14.6619    800   641 1600  442  11p   800  26319   15p  ETSI #1 (4000m)
};
// ##A21####A21####A21####A21## OLD LIF Hybrid Table ##A21####A21####A21####A21##  END



DATA_MAP_END;

