/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

   No license under any patent, copyright, trade secret or other
   intellectual property right is granted to or conferred upon you by
   disclosure or delivery of the Materials, either expressly, by
   implication, inducement, estoppel or otherwise. Any license under
   such intellectual property rights must be express and approved by
   Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*  file name: AFED_EfuseCopy.c
*
*  This file contains VRX518 AFE Efuse copy functions
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added initial VRX518 AFE Efuse copy functions
//
// **********************************************************************************************//

//===========================INCLUDE FILES ========================================

#include <stdio.h>
#include <string.h>
#include "common.h"
#include "typedef.h"
#include "cmv_data.h"
#include "cmv.h"
#include "Cnfg_task.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "codeswap.h"
#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

#include "ConvertToDB.h"

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  vrx5afe_softfuse
**
** DESCRIPTION:    This routine shall be part of the power up
**                 initialization sequence of the firmware.
**
** PARAMETERS:     None.
**
** RETURN VALUE:
**
**
** NOTES:
**
** =============================================================================
*/
uint16 gus_fuse_read_ok = 0; //Debug

//=======================
// Read EFuse contents
//======================
// XDSLRTFW-3026 (Start)
void vrx518_ReadEFuseArray (void)
{
   // Before reading the data from EFUSEd registers, we check for the configuration of the BAR registers.
   CheckBARConfiguration();

   uint32* ul_addr_pointer = NULL;
   // The contents of EFuse are stored in BAR18 memory space.
   // BAR18 is obtained as following:
   // BAR18 = 0x100000 + (16*64*1024) + (512*1024) + (1*64*1024) = 0x290000
   // We have configured the BAR register to point to the address 0x18000
   // And the EFuse registers are present from the address 0x18200 to 0x18220
   // Hence we need to have an offset of 0x200 from the start of the BAR18 address space.

   // The EFuse register description is as following:
   // gula_VRX518_EfuseTable[0] --> 0x18200 --> AFE_BBVT_EFUSE
   // gula_VRX518_EfuseTable[1] --> 0x18204 --> AFE_TXDAC_DSL_EFUSE
   // gula_VRX518_EfuseTable[2] --> 0x18208 --> AFE_LDO_EFUSE
   // gula_VRX518_EfuseTable[4] --> 0x18210 --> AFE_ADCDSL_EFUSE //RX_IN_IMP<21:16>  RX_GAIN_ERR<28:24> //XDSLRTFW-3596
   // gula_VRX518_EfuseTable[5] --> 0x18214 --> AFE_RC_TIME_EFUSE
   // gula_VRX518_EfuseTable[6] --> 0x18218 --> AFE_XO_EFUSE
   // gula_VRX518_EfuseTable[7] --> 0x1821C --> AFE_VEGA_EFUSE
   // gula_VRX518_EfuseTable[8] --> 0x18220 --> AFE_DSM_EFUSE
   // XDSLRTFW-3567 (Start_End)
   ul_addr_pointer = (uint32 *)((uint32)&__StartOfSramBAR18 + EFUSE_OFFSET);  // BAR18 + Offset

   gula_VRX518_EfuseTable[0] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[1] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[2] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[3] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[4] = *ul_addr_pointer++;//RX_IN_IMP<21:16>  RX_GAIN_ERR<28:24> //XDSLRTFW-3596
   gula_VRX518_EfuseTable[5] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[6] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[7] = *ul_addr_pointer++;
   gula_VRX518_EfuseTable[8] = *ul_addr_pointer++;

}
// XDSLRTFW-3026 (End)

//-----------
// Soft-fuse
//-----------
uint16 vrx5afe_softfuse(uint32 *fuse_table)  //VRX518AFE_OPEN
{
   // get fuse-table (complete one) => address = 200h
   // set fusedone_bit = 1 if fusing information are found

   // tbd
   uint32_t fuse_reg;
   uint16_t fuse_reg_prog;
//-------------------------------------------
   //check if AFE fusing is done

   fuse_reg = fuse_table[0x1C/4]; //AFE_VEGA_EFUSE => 21Ch
   if ((fuse_reg & 0x0001) == 0)
   {
      return 1; // it has been changed to "1"= not fused
   }

   fuse_reg = fuse_table[0x00/4]; //AFE_BBVT_EFUSE => 200h

   //LDOCLKD => fusing not used, maybe in future
/* fuse_reg_prog = (fuse_reg & VRX5AFE_CENTRAL_FCSI_LDOCLKD_PROGLDOCLKD__MSK) << VRX5AFE_CENTRAL_FCSI_LDOCLKD_PROGLDOCLKD__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_LDOCLKD), \
   VRX5AFE_CENTRAL_FCSI_LDOCLKD_PROGLDOCLKD__ISMSK, \
   fuse_reg_prog);
*/

   //BIAS
   fuse_reg_prog = ((fuse_reg >> 4) & VRX5AFE_CENTRAL_FCSI_BIASTRIM_RBIASCONF__MSK) << VRX5AFE_CENTRAL_FCSI_BIASTRIM_RBIASCONF__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_BIASTRIM), \
         VRX5AFE_CENTRAL_FCSI_BIASTRIM_RBIASCONF__ISMSK, \
         fuse_reg_prog);

   //BGP
   fuse_reg_prog = ((fuse_reg >> 8) & VRX5AFE_CENTRAL_FCSI_BIASBGP_VREFCONF__MSK) << VRX5AFE_CENTRAL_FCSI_BIASBGP_VREFCONF__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_BIASBGP), \
         VRX5AFE_CENTRAL_FCSI_BIASBGP_VREFCONF__ISMSK, \
         fuse_reg_prog);

//----------------------------------------------
   fuse_reg = fuse_table[0x08/4]; //AFE_LDO_EFUSE => 208h

   //RXLDO1V1
   fuse_reg_prog = (fuse_reg & VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PROGLDO1V1RX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PROGLDO1V1RX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1RX), \
         VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PROGLDO1V1RX__ISMSK, \
         fuse_reg_prog);


   //RXLDO2V6
   fuse_reg_prog = ((fuse_reg >> 4) & VRX5AFE_DSL_FCSI_DSLLDO2V6RX_PRGFBLDO2V6RX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO2V6RX_PRGFBLDO2V6RX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO2V6RX), \
         VRX5AFE_DSL_FCSI_DSLLDO2V6RX_PRGFBLDO2V6RX__ISMSK, \
         fuse_reg_prog);

   //-----
   fuse_reg = fuse_table[0x20/4]; // AFE_DSM_EFUSE => 220h

//LDOPREFI1V1
   fuse_reg_prog = ((fuse_reg >> 16) & VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PROGLDO1V1PREFI__MSK) << VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PROGLDO1V1PREFI__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI), \
         VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PROGLDO1V1PREFI__ISMSK, \
         fuse_reg_prog);

//----------------------------------------------


   fuse_reg = fuse_table[0x08/4]; //AFE_LDO_EFUSE => 208h

   //TXLDO1V1
   fuse_reg_prog = ((fuse_reg >> 16) &  VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PROGLDO1V1TX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PROGLDO1V1TX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1TX), \
         VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PROGLDO1V1TX__ISMSK, \
         fuse_reg_prog);

   //TXLDO2V6
   fuse_reg_prog = ((fuse_reg >> 20) &  VRX5AFE_DSL_FCSI_DSLLDO2V6TX_PRGFBLDO2V6TX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO2V6TX_PRGFBLDO2V6TX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO2V6TX), \
         VRX5AFE_DSL_FCSI_DSLLDO2V6TX_PRGFBLDO2V6TX__ISMSK, \
         fuse_reg_prog);

//----------------------------------------------

   fuse_reg = fuse_table[0x04/4]; //AFE_TXDAC_DSL_EFUSE => 204h

   //TXDAC gain
   fuse_reg_prog = (fuse_reg & VRX5AFE_DSL_FCSI_CSDAC0_TRIM__MSK) << VRX5AFE_DSL_FCSI_CSDAC0_TRIM__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC0), \
         VRX5AFE_DSL_FCSI_CSDAC0_TRIM__ISMSK, \
         fuse_reg_prog);

//----------------------------------------------

   fuse_reg = fuse_table[0x010/4]; //AFE_ADCDSL_EFUSE => 210h
   //adc clk invert
   fuse_reg_prog = (fuse_reg & VRX5AFE_DSL_FCSI_SDADC4_PROGCLKINV__MSK) << VRX5AFE_DSL_FCSI_SDADC4_PROGCLKINV__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
         VRX5AFE_DSL_FCSI_SDADC4_PROGCLKINV__ISMSK, \
         fuse_reg_prog);

   //progLDO1v8
   fuse_reg_prog = ((fuse_reg >> 4) & VRX5AFE_DSL_FCSI_SDADC5_PROGLDOFB__MSK) << VRX5AFE_DSL_FCSI_SDADC5_PROGLDOFB__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC5), \
         VRX5AFE_DSL_FCSI_SDADC5_PROGLDOFB__ISMSK, \
         fuse_reg_prog);

//----------------------------------------------

   fuse_reg = fuse_table[0x14/4]; //AFE_RC_TIME_EFUSE => 214h

   //rc count
   fuse_reg_prog = (fuse_reg & VRX5AFE_CENTRAL_FCSI_RCMEAS1_RCCOUNT__MSK);
   vrx5afe_set_rc_count(fuse_reg_prog);

//----------------------------------------------
//no fusing of XO amplitude but it's possible to enable it fot future.

/* fuse_reg = fuse_table[0x18/4]; //AFE_XO_EFUSE => 218h

   //xo bias trim
   fuse_reg_prog = (fuse_reg & VRX5AFE_CENTRAL_FCSI_XOPOC4_CFGBIASREG__MSK) << VRX5AFE_CENTRAL_FCSI_XOPOC4_CFGBIASREG__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_XOPOC4), \
      VRX5AFE_CENTRAL_FCSI_XOPOC4_CFGBIASREG__ISMSK, \
      fuse_reg_prog);
*/

   return(0);
} //end of function

void ConfigVrx518Afe_VersionSpecific(void)
{

   // Update of AFE_CENTRAL Version already done in AFED_AnalogRegistersInit
   //gusa_AfeChipId[0] = VRX5AFE_FCSI_READ(VRX5AFE_CENTRAL, DSL_FCSI(VRX5AFE_CENTRAL_FCSI_VERSION), &ReadDataDummy);
   // Update of AFE_DSL Version
   //gusa_AfeChipId[1] = VRX5AFE_FCSI_READ(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_VERSIONDSL), &ReadDataDummy);

   // Update of AFE_CENTRAL Version
   if (gs_Force_AfeCentralVersion != - 1)
   {
      gusa_AfeChipId[0] = (uint16) (void*) gs_Force_AfeCentralVersion;
   }

   // Update of AFE_DSL Version
   if (gs_Force_AfeDslVersion != - 1)
   {
      gusa_AfeChipId[1] = (uint16) (void*) gs_Force_AfeDslVersion;
   }

   if(TESTArray[TEST_Control3] & TEST_Control3_Ena_A21OldLifHyb)
   {
      //Prototype of memcpy(pHybRegDest, pHybRegSrc, sizeof(uint16)*VRX_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_Handshake_VRX518_A21[VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_Handshake_VRX518, gusa_HybridSettingV2_Handshake_VRX518_A21, sizeof(uint16)*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_QlnHlog_VRX518_A21[VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_QlnHlog_VRX518, gusa_HybridSettingV2_QlnHlog_VRX518_A21, sizeof(uint16)*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_SpecialHybSetting_A21[VRX_HYB_NUM_SETTINGS] = {
      memcpy(gusa_SpecialHybSetting, gusa_SpecialHybSetting_A21, sizeof(uint16)*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_35M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_35M][VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_35M_VRX518, gusa_HybridSettingV2_35M_VRX518_A21, sizeof(uint16)*VRX518_ANX_ABJ_NUM_HYBS_35M*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_30M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_30M][VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_30M_VRX518, gusa_HybridSettingV2_30M_VRX518_A21, sizeof(uint16)*VRX518_ANX_ABJ_NUM_HYBS_30M*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_17M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_17M][VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_17M_VRX518, gusa_HybridSettingV2_17M_VRX518_A21, sizeof(uint16)*VRX518_ANX_ABJ_NUM_HYBS_17M*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_12M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_12M][VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_12M_VRX518, gusa_HybridSettingV2_12M_VRX518_A21, sizeof(uint16)*VRX518_ANX_ABJ_NUM_HYBS_12M*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_8M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_8M][VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_8M_VRX518, gusa_HybridSettingV2_8M_VRX518_A21, sizeof(uint16)*VRX518_ANX_ABJ_NUM_HYBS_8M*VRX518_HYB_NUM_SETTINGS);

      //uint16 gusa_HybridSettingV2_US0_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS] = {
      memcpy(gusa_HybridSettingV2_US0_VRX518, gusa_HybridSettingV2_US0_VRX518_A21, sizeof(uint16)*VRX518_ANX_ABJ_NUM_HYBS_US0*VRX518_HYB_NUM_SETTINGS);
   }

}

// ---------------------------------------------------
// Set and get of global variables for chip version check
// ---------------------------------------------------

void vrx5afe_set_dsl_version(uint16_t set_val)
{
   AFE_DSL_version = set_val;
}

uint16_t vrx5afe_get_dsl_version(void)
{
   return AFE_DSL_version;
}

//XDSLRTFW-3596 Start
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : VRX518_RxPathDslGainCorrection()
 *
 *  Description:
 *
 *    This function calculates the  Rx gain correction for input RXA "corr_gain_rxa"(RX absolute gain error and input impedance variation correction)
 *    The calculation is based on inputs
 *       (i)RX input impedance variation "var": This will come as part of efuse data "<bits[21:16] of AFE_ADCDSL_EFUSE>"
 *       This value will be a number which denoted percent
 *          //000000               -0.32  (-32%)
 *          //000001               -0.31  (-31%)
 *          //   ...
 *          //111111               +0.31  (+31%)
 *          imp_error_rx(var) = 20*log( ( (1/Rsa_ext)+ (1/Rsa) + (2/Rpa) ) / ( (1/Rsa_ext) + (/(1+var)*Rsa) + (2/(1+var)Rpa) ) )
 *
 *       (ii)absolute gain error in RX path(abs_error_rx): This will come as part of efuse data <bits[28:24] of AFE_ADCDSL_EFUSE>
 *          //00000                -1.6dB
 *          //00001                -1.5dB
 *          //..
 *          //11111                +1.5dB
 *
 *   The output equation will be :"corr_gain_rxa (Rx gain correction for input RXA)=  -abs_error_rx -imp_error_rx (var) in dB"
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void VRX518_RxPathDslGainCorrection(void)
{
   //uint16 gusa_HybridSettingV2_QlnHlog_VRX518[VRX518_HYB_NUM_SETTINGS] = {
   //PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   Rsa Rpa Rsb  Rpb  Cpb  Rsc  Rpc  Cpc  Description
   //0x0215,        0x329E,            0x0ADB,           -12.3923   145 100 800  442  12p 320  929   2p    QLN/HLOG

   int16_t  Rsa_ext = 390;
   int16_t  Rsa = 145;
   int16_t  Rpa = 100;
   int16_t s_variance =0;

   //Floating point code for reference
   #ifdef TEST_FLOAT_VRX518
      float    var_F;
      float    imp_error_rx_NUMERATOR_F;
      float    imp_error_rx_DENOMINATOR_F;
      float    imp_error_rx_DENOMINATOR_F1, imp_error_rx_DENOMINATOR_F2, imp_error_rx_DENOMINATOR_F3, imp_error_rx_DENOMINATOR_F123;
      double   imp_error_rx_LOG10_F, imp_error_rx_F;
   #endif

   //Fixed Point handling handling
   int32_t  l_var, l_1PlusVar;
   int32_t  l_temp1, l_temp2;
   int32_t  l_imp_error_rx_nr;
   int32_t  l_imp_error_rx_dr_1, l_imp_error_rx_dr_23, l_imp_error_rx_dr_123;
   int32_t  l_imp_error_rx_i;
   int16_t  s_imp_error_rx_dB, s_Offset10log10_2_14,s_temp1;

   //s_RX_IN_IMP_in;            //bits[21:16] RX_IN_IMP of AFE_ADCDSL_EFUSE;Range:-32% to +31% in 1% steps
   s_temp1 = (int16_t) ((gula_VRX518_EfuseTable[4] >> 16) & 0x3F);
   gt_PgaGainCorrectionDslPath.s_RX_IN_IMP_in = s_temp1;
   //RX input impedance variation:  range from -32% to +31% in 1% steps
   //fuse_rx_rin[5:0]      var
   //000000               -0.32  (-32%)
   //000001               -0.31  (-31%)
   //   ...
   //111111               +0.31  (+31%)
   s_variance =(int16_t) (-32 + s_temp1);//convert to real percentage 000000 = -32%;010000 = 0%;111111=+31%

   //s_RX_GAIN_ERR_in;          //bits[28:24]abs_error_rx of AFE_ADCDSL_EFUSE;RX absolute gain error in RX path.Range:-1.6dB to +1.5dB in 0.1dB steps
   s_temp1 = (int16_t) ((gula_VRX518_EfuseTable[4] >> 24) & 0x1F);
   gt_PgaGainCorrectionDslPath.s_RX_GAIN_ERR_in = s_temp1;
   //RX absolute gain error in RX path:range from -1.6dB to +1.5dB in 0.1dB steps
   //fuse_ae_rx[4:0]      abs_error_rx
   //00000                -1.6dB
   //00001                -1.5dB
   //11111                +1.5dB
   s_temp1 = -13107 +(s_temp1*819);//0.1=819 in Q13 -1.6=-13107 in Q13  rep number to suitable format

   if ((s_temp1 < 0) && (s_temp1 >= -32))
   {
      s_temp1 = 0; // It is because when nimbers from -1 to -32 wgen right shifted by 5 always results in -1
   }
   else
   {
      s_temp1 = s_temp1>> 5;
   }
   gt_PgaGainCorrectionDslPath.s_RX_GAIN_ERR_dB_Out =s_temp1;//0.1=819 in Q13 -1.6=-13107 in Q13  Q13-5= Q8

   #ifdef TEST_FLOAT_VRX518
      var_F = (float) s_variance / 100;
      //imp_error_rx(var) = 20 * log("Hpga_var(var)" / "Hpga_nom")//DC gain error caused by impedance mismatch
      //imp_error_rx(var) = 20*log( ( (1/Rsa_ext)+ (1/Rsa) + (2/Rpa) ) / ( (1/Rsa_ext) + (/(1+var)*Rsa) + (2/(1+var)Rpa) ) )
      //imp_error_rx_nr = (1/Rsa_ext)+ (1/Rsa) + (2/Rpa)
      //imp_error_rx_dr = ( (1/Rsa_ext) + (1/(1+var)Rsa) + (2/(1+var)Rpa) )

      //imp_error_rx_nr = (1/Rsa_ext)+ (1/Rsa) + (2/Rpa)
      imp_error_rx_NUMERATOR_F = ((float) 1.0 / Rsa_ext) + ((float) 1.0 / Rsa) + ((float) 2.0/ Rpa);
      imp_error_rx_DENOMINATOR_F = ((float) 1.0 / Rsa_ext) + ((float) 1.0 / ((1 + var_F)*Rsa)) + ((float) 2.0 / ((1 + var_F)*Rpa));

      //imp_error_rx_dr = ( (1.0/Rsa_ext) + (1.0/(1+var)*Rsa) + (2.0/(1+var)*Rpa)
      imp_error_rx_DENOMINATOR_F1 = ((float) 1.0) / Rsa_ext; //Precalculate
      imp_error_rx_DENOMINATOR_F2 = ((float) 1.0 / Rsa)/(1 + var_F);
      imp_error_rx_DENOMINATOR_F3 = ((float) 2.0 / Rpa)/(1 + var_F);
      imp_error_rx_DENOMINATOR_F123 = imp_error_rx_DENOMINATOR_F1 + imp_error_rx_DENOMINATOR_F2 + imp_error_rx_DENOMINATOR_F3;

      imp_error_rx_F = (float)imp_error_rx_NUMERATOR_F / imp_error_rx_DENOMINATOR_F123;
      imp_error_rx_LOG10_F = 20 * log10(imp_error_rx_F);
   #endif
   //Fixed Point handling handling
   l_var = ((int32_t) (s_variance << 15))/100; //Q15 Convert fixed number which is percentage to decimal and fixed point
   l_1PlusVar = ((1 << 15) + l_var); //Q15

   //Rsa = 145 Rpa = 100 Rsa_ext = 390;
   // imp_error_rx_nr   = (1.0/Rsa_ext)+ (1.0 / Rsa) + ( 2.0 / Rpa) //PreCalculate
   //( (1.0/390)+ (1.0 / 145) + ( 2.0 / 100) ) * 64 * 2^30 =0x78ABBC2A
   l_imp_error_rx_nr = 0x78ABBC2A;//Q30

   //imp_error_rx_dr = ( (1.0/Rsa_ext) + (1.0/(1+var)*Rsa) + (2.0/(1+var)*Rpa) )
   //imp_error_rx_dr_1 = (1.0/Rsa_ext);
   //imp_error_rx_dr_2 = (1.0/(1 + var)*Rsa) = (1.0/Rsa)/(1+s_var)
   //imp_error_rx_dr_3 = (2.0/(1 + var)*Rpa) = (2.0/Rpa)/(1+s_var)
   //imp_error_rx_dr_23= ( (1.0/Rsa)+(2.0/Rpa) )/ (1 + s_var)

   ////imp_error_rx_dr_1 = (1.0/Rsa_ext); //(1.0/390) * 32 *2^30 =0x05405405
   l_imp_error_rx_dr_1 = 0x05405405;//Q30 //Precalculate

   ////imp_error_rx_dr_2 = (1 / Rsa) / (1 + s_var);
   //l_temp1 = (1/Rsa)=(1/145) * 32* 2^30 = 0x0E1FC780
   l_temp1 = 0x0E1FC780; //Q30

   ////imp_error_rx_dr_3 = (2.0/(1 + var)*Rpa) = (2.0/Rpa)/(1+s_var)
   //l_temp2 = (2.0/Rpa)= (2.0/100)*32* 2^30 =0x28F5C28F
   l_temp2 = 0x28F5C28F; // Q30

   //( (1/Rsa)+(2.0/Rpa) )/ (1 + s_var)= (l_temp1 + l_temp2)/s_1PlusVar
   l_imp_error_rx_dr_23 = (l_temp1 + l_temp2)/l_1PlusVar; // Q30/Q15 = Q15

   l_imp_error_rx_dr_123 = l_imp_error_rx_dr_1 + (l_imp_error_rx_dr_23 << 15); //Q30

   l_imp_error_rx_dr_123 = l_imp_error_rx_dr_123 >> 14; //Q30-14=Q16
   //l_imp_error_rx_nr scaled by x64  l_imp_error_rx_dr_123 scaled by x32
   l_imp_error_rx_i = (l_imp_error_rx_nr) / l_imp_error_rx_dr_123; //Q30/Q16=Q14-1=Q15
      //s_imp_error_rx_dB = ConvertToDB(imp_error_rx_i);
   //ConvertToDB  does 10*log10(l_xin) (in Q8.8 format)
   //l_xin = Num1 * 2^14 = 10*log10(Num1) - 10*log10(2^14);
   //10*log(2^14) = 11559 in 8.8=45.1545 dB
   //imp_error_rx_LOG10 = 2* log10(imp_error_rx_l);
   if (l_imp_error_rx_i == 0)
   {
      s_Offset10log10_2_14 = 0;
   }
   else
   {
      s_Offset10log10_2_14 = 11559;//10*log(2^14) = 11559 in 8.8=45.1545 dB
   }
   //
   s_imp_error_rx_dB = (ConvertToDB(l_imp_error_rx_i) - s_Offset10log10_2_14) << 1;//in 8.8 //imp_error_rx_LOG10_F and s_imp_error_rx_dB should be same

   gt_PgaGainCorrectionDslPath.s_imp_error_rx_dB_out = s_imp_error_rx_dB;

   if (TESTArray[TEST_TX_PSD_CONTROL] & TEST_ENA_RXGAIN_IMPEDANCEVAR_CORRECTION) //Test 52 0 0x4000
   {
      //The way we use the Total RxGain correction for input RXA in the FW, the following equation shall be used
      //corr_gain_rxa =  abs_error_rx + imp_error_rx (var)
      //e.g. abs_error_rx =-0.7 imp_error_rx = +0.52
      //corr_gain_rxa = (-0.70) + (+0.52) = - 0.17dB  //XDSLRTFW-3894
      gt_PgaGainCorrectionDslPath.s_corr_gain_rxa_dB_out = gt_PgaGainCorrectionDslPath.s_RX_GAIN_ERR_dB_Out + gt_PgaGainCorrectionDslPath.s_imp_error_rx_dB_out;
   }
   gula_DebugVarsPalak[5] = s_variance; //Percentage
   gula_DebugVarsPalak[6] = l_imp_error_rx_i;
}

//XDSLRTFW-3596 End



