/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_PofiPocoConfg.c
*
*   This file contains VRX518 AFE Filter tuning formula implementation routines
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 Filter tune routines
//
// **********************************************************************************************//

//===========================INCLUDE FILES ========================================
#include "typedef.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "Decimalgain.h"
#include "ll_iof.h"

#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL
#include "Gdata.h"

# define END_BIN_US1 (812)
# define END_BIN_US2 (1600)
# define END_BIN_US3 (3250)


void vrx5afe_dsl_dac_conf(uint16_t mode_set)
{
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
               VRX5AFE_DSL_FCSI_CSDAC1_NOCAL__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC1_NOCAL_0__SVAL);

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
               VRX5AFE_DSL_FCSI_CSDAC1_NOCALLSBAQ__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC1_NOCALLSBAQ_1__SVAL);

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
               VRX5AFE_DSL_FCSI_CSDAC1_SELCALLSB__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC1_SELCALLSB_1__SVAL);

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC3), \
               VRX5AFE_DSL_FCSI_CSDAC3_RANDOMOFF__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC3_RANDOMOFF_0__SVAL);  //vrx5afe_24July2017_ChangeList269687

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC3), \
               VRX5AFE_DSL_FCSI_CSDAC3_DEMMODEMSB__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC3_DEMMODEMSB_NODEM__SVAL);

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC3), \
               VRX5AFE_DSL_FCSI_CSDAC3_DEMMODELSB__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC3_DEMMODELSB_NODEM__SVAL);

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC4), \
               VRX5AFE_DSL_FCSI_CSDAC4_CALNFIX__ISMSK, \
               2037);
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC5), \
               VRX5AFE_DSL_FCSI_CSDAC5_CALNVAR__ISMSK, \
               2047);

   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC6), \
               VRX5AFE_DSL_FCSI_CSDAC6_CLKOUTENABLE__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC6_CLKOUTENABLE_OFF__SVAL);


   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
               VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL_1__SVAL);
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
               VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL__ISMSK, \
               VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL_0__SVAL);

   if ( (mode_set == VDSL35b_CPE) || (mode_set == VDSL17_CPE) || (mode_set == BYPASSED) || (mode_set == VDSL8_CPE) )
   {
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC2), \
            VRX5AFE_DSL_FCSI_CSDAC2_DATAMODE__ISMSK, \
            VRX5AFE_DSL_FCSI_CSDAC2_DATAMODE_1__SVAL);
   }

   //if ( (mode_set == ADSL2_CPE) || (mode_set == VDSL8_CPE) )
   if (mode_set == ADSL2_CPE) //VRX518AFE_CHECK VDSL8 DAC 288MHz
   {
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC2), \
            VRX5AFE_DSL_FCSI_CSDAC2_DATAMODE__ISMSK, \
            VRX5AFE_DSL_FCSI_CSDAC2_DATAMODE_0__SVAL);
   }
}

//XDSLRTFW-3746 Start
uint16_t vrx5afe_dsl_pofi_gainfc_set(uint16_t mode_set, int16_t gain_pofi_dB, int32_t fc_pofi_lp_kHz)
{
   //--------------------------------------------------------------------------
   // e.g. for passing parameters
   // vrx5afe_dsl_pofi_gainfc_set(VDSL2_CPE, 0, 80000);
   // mode, gain [dB], fc_lp [kHz]
   //--------------------------------------------------------------------------


#ifdef TEST_FLOAT_VRX518
   double weight_c2;            // 'LSB' in [pF]
   double Rpoco, C2, C2_pF_weighted;
   double C21e12, V_1e9By2piFcKhzByR;
   uint16_t C2_bin_Float;
#endif
   int16_t R1 = 320;
   int16_t R2 = 0;
   int16_t gain_bin=0, gain_bin_shift;
   uint16_t C2_bin, C2_bin_shift;
   uint16_t error_out = 0;

   //Fixed point function related variables
   int16_t Rohm;           // Q0
   int16_t WeightCap = 0;           // Q13
   int16_t GaindB;            // Q8
   uint8_t ChooseFilter = 1;   // Q0  - 0=PGA, 1=POFI, 2=PREFI
   int32_t Const1e9By2PiX;
   int32_t Value1e9By2piFcKhz; // Q20

   // //*********(1e9/ (2.0 * 3.1415* fc_pofi_lp_kHz * 512) )   // Scale by value 512 (9 bits) to reduce the range of number *********//
   // //1e9/ (2.0 * 3.1415 * 512 * fc_pofi_lp_kHz) )  = (1e9/ (2.0 * 3.1415 * 512)) / fc_pofi_lp_kHz
   //((1e9 / (2.0 * 3.1415 * 512 * 256)) * 2 ^ 20) = 0x4BE4AAA9  Q20

   // Here scale factor 256(8bits) is used later, 512(9 bits) is  used later
   Const1e9By2PiX     = ((int32_t) NUM_Q20_1E9BY2PIX512X256) / fc_pofi_lp_kHz;   // Q20/Q0 = Q0
   // assuming fc_pofi_lp_kHz in value of 256, which means division will give 8 more bits
   Value1e9By2piFcKhz = (int32_t) (Const1e9By2PiX << SCALE_1E9BY2PIX512X256BY8); // Q20  Scale back again with scale factor 256(8bits). 9 bit scale factor will be taken later

   if (gs_TxPathAfeDfeCustomSettings & AFE_POFI_MODE_ADSL2_CPE)
   {
      mode_set = ADSL2_CPE;
      //gla_fc_pofi_lp_kHz[mode_set] = 80;
      //gla_fc_pofi_lp_kHz[mode_set] = 320;
   }

   if (mode_set == ADSL2_CPE)
   {
      R2 = 4800;
      #ifdef TEST_FLOAT_VRX518
      weight_c2 = 3.125;  // 200pF/2^6=3.125pF - 'LSB' in [pF]
      #endif
      WeightCap = 25600;  // weight_c2 = 3.125 is Q13 = 3.125 *2^13 = 12697
   }
   else // if ( (mode_set == VDSL35b_CPE) || (mode_set == VDSL17_CPE) || (mode_set == VDSL8_CPE) || (mode_set == BYPASSED))
   {
      R2 = 320;
#ifdef TEST_FLOAT_VRX518
   weight_c2 = 1.55;   // 12.4pF/8=1.55pF - linear spaced C2-values, 'LSB' in [pF]
#endif
      WeightCap = 12697;  // weight_c2 = 1.55 is Q13 = 1.55 *2^13 = 12697
   }

   //------
   // gain
   //------
   if (mode_set == BYPASSED)
   {
      gain_pofi_dB = 0;
   }

   if (gain_pofi_dB >= -10 && gain_pofi_dB <= 9) // saturation of gain added 30.9.2016
   {
      gain_bin = -gain_pofi_dB + 9; // -10dB ... +9dB, 1dB step
      error_out = 0;
   }
   else if (gain_pofi_dB < -10)
   {
      gain_bin = 19;
      error_out = 1;
   }
   else if (gain_pofi_dB > 9)
   {
      gain_bin = 0;
      error_out = 1;
   }


   gain_bin_shift = gain_bin & VRX5AFE_DSL_FCSI_POCO1_PRGGAIN__MSK;         // guarantee data bit-range
   gain_bin_shift = gain_bin_shift << VRX5AFE_DSL_FCSI_POCO1_PRGGAIN__POS;  // shift to correct position for "write"

   // Register POCO1
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO1),
      VRX5AFE_DSL_FCSI_POCO1_PRGGAIN__ISMSK,
      gain_bin_shift);


   //----
   // C2
   //----

   Rohm = (int16_t)(R1 + R2);

#ifdef TEST_FLOAT_VRX518
   Rpoco = pow(10.0, gain_pofi_dB/20.0) * (R1 + R2);

   C2 = 1.0 / (2.0 * 3.1415 * fc_pofi_lp_kHz * 1e3 * Rpoco);   // in [F]

   //Debugging
   C21e12 = C2*1e12;
   V_1e9By2piFcKhzByR = (1e9) / (2.0 * 3.1415* fc_pofi_lp_kHz * Rohm);
#endif
   //int16_t Rohm             // Q0
   //int16_t WeightCap        // Q13
   //int16_t GaindB        // Q8
   //uint32_t Value1e9By2piFcKhz // Q20
   //uint8 ChooseFilter          // Q0 - 0=PGA, 1=POFI, 2=PREFI

   GaindB = gain_pofi_dB << 8;      // Q8

   if (mode_set == ADSL2_CPE)
   {
      if (fc_pofi_lp_kHz < 120)
      {
         C2_bin = 7;
      }
      else if (fc_pofi_lp_kHz < 240)
      {
         C2_bin = 6;
      }
      else if (fc_pofi_lp_kHz < 480)
      {
         C2_bin = 5;
      }
      else if (fc_pofi_lp_kHz < 960)
      {
         C2_bin = 4;
      }
      else if (fc_pofi_lp_kHz < 1920)
      {
         C2_bin = 3;
      }
      else if (fc_pofi_lp_kHz < 3840)
      {
         C2_bin = 2;
      }
      else
      {
         C2_bin = 1;
      }

      /*
         #ifdef TEST_FLOAT_VRX518
         //C2_pF_weighted = C2*1e12 / weight_c2 + 0.5; //old equation
         C2_pF_weighted = ((log(C2*1e12)/log(2)) - (log(weight_c2)/log(2)))+1;//new equation
         C2_bin_Float   = (uint16_t)C2_pF_weighted;                          // round(x) = truncate(x+0.5)
         if (C2_bin_Float > VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__MSK)             // saturate to max. value
         {
            C2_bin_Float = VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__MSK;
         }
         #endif

         C2_bin       = Calc_PgaClp1PrefiClp2PocoC2(Rohm, WeightCap, GaindB, Value1e9By2piFcKhz, ChooseFilter);
      */
      if (C2_bin > VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__MSK)             // saturate to max. value
      {
         C2_bin = VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__MSK;
      }

      C2_bin_shift = C2_bin & VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__MSK;        // guarante's data bit-range
      C2_bin_shift = C2_bin_shift << VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__POS; // shift to correct position for "write"

      // Register POCO0
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0),
            VRX5AFE_DSL_FCSI_POCO0_ADSLVDSLSEL__ISMSK & \
            VRX5AFE_DSL_FCSI_POCO0_FC2ADSL__ISMSK,
            VRX5AFE_DSL_FCSI_POCO0_ADSLVDSLSEL_ADSL__SVAL | \
            C2_bin_shift);

   }
   else // if ( (mode_set == VDSL35b_CPE) || (mode_set == VDSL17_CPE) || (mode_set == VDSL8_CPE) || (mode_set == BYPASSED))
   {
      // just following freqs allowed
      // 80MHz, 40MHz, 26.7MHz, 20MHz, 16MHz, 13.4MHz, 11.5MHz, 10MHz
      //
      if ((fc_pofi_lp_kHz == 80000) || (fc_pofi_lp_kHz == 40000) ||
      (fc_pofi_lp_kHz == 26700) || (fc_pofi_lp_kHz == 20000) ||
      (fc_pofi_lp_kHz == 16000) || (fc_pofi_lp_kHz == 13400) ||
      (fc_pofi_lp_kHz == 11500) || (fc_pofi_lp_kHz == 10000))
      {
         error_out |= 0;
      }
      else
      {
         error_out |= 2;
      }

      // map given freq to possible freqs
      if (fc_pofi_lp_kHz >= 80000)
      {
         fc_pofi_lp_kHz = 80000;
         C2_bin = 0;
      }
      else if (fc_pofi_lp_kHz >= 40000)
      {
         fc_pofi_lp_kHz = 40000;
         C2_bin = 1;
      }
      else if (fc_pofi_lp_kHz >= 26700)
      {
         fc_pofi_lp_kHz = 26700;
         C2_bin = 2;
      }
      else if (fc_pofi_lp_kHz >= 20000)
      {
         fc_pofi_lp_kHz = 20000;
         C2_bin = 3;
      }
      else if (fc_pofi_lp_kHz >= 16000)
      {
         fc_pofi_lp_kHz = 16000;
         C2_bin = 4;
      }
      else if (fc_pofi_lp_kHz >= 13400)
      {
         fc_pofi_lp_kHz = 13400;
         C2_bin = 5;
      }
      else if (fc_pofi_lp_kHz >= 11500)
      {
         fc_pofi_lp_kHz = 11500;
         C2_bin = 6;
      }
      else
      {
         fc_pofi_lp_kHz = 10000;
         C2_bin = 7;
      }
         /*
         #ifdef TEST_FLOAT_VRX518
            if (C2*1e12 < weight_c2)   // [pF]
            {
            C2 = weight_c2 / 1e12; // [F}
            }
            C2_pF_weighted = C2*1e12 / weight_c2;                               // linear spaced C2-values
            C2_bin_Float = ((uint16_t)C2_pF_weighted) - 1;                      // truncate

            if (C2_bin_Float > VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__MSK)             // saturate to max. value
            {
            C2_bin_Float = VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__MSK;
            }
         #endif
            C2_bin = Calc_PgaClp1PrefiClp2PocoC2(Rohm, WeightCap, GaindB, Value1e9By2piFcKhz, ChooseFilter);
         */
      if (C2_bin > VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__MSK)             // saturate to max. value
      {
         C2_bin = VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__MSK;
      }

      C2_bin_shift = C2_bin & VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__MSK;        // guarante's data bit-range
      C2_bin_shift = C2_bin_shift << VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__POS; // shift to correct position for "write"

      // Register POCO0
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0),
               VRX5AFE_DSL_FCSI_POCO0_ADSLVDSLSEL__ISMSK & \
               VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__ISMSK,
               VRX5AFE_DSL_FCSI_POCO0_ADSLVDSLSEL_VDSL__SVAL | \
               C2_bin_shift);
   }

#ifdef TEST_FLOAT_VRX518
   debug_printf("\nPofiGain=%3d fc_pofi_lp_kHz=%5d V1e9By2piFcKhz=%8x Rohm=%4d ", gain_pofi_dB, fc_pofi_lp_kHz, Value1e9By2piFcKhz, Rohm);
   debug_printf("\n >>C2*1e12 =%f C2_wt=%f  ######C2_bin=%4x %4x Diff=%4d ", C21e12, C2_pF_weighted, C2_bin_Float, C2_bin, C2_bin_Float - C2_bin);
#endif

   //---------------
   // C1 (2nd pole)
   //---------------
   if (mode_set == ADSL2_CPE)
   {
   // 10pF programmed automatically
   }
   else // if ( (mode_set == VDSL35b_CPE) || (mode_set == VDSL17_CPE) || (mode_set == VDSL8_CPE) || (mode_set == BYPASSED))
   {
      vrx5afe_dsl_pofi_2ndpole_set(0); // parameter in [pF] - 0, 5 and 10 are allowed
   }


   return error_out;
}
//XDSLRTFW-3746 End

void vrx5afe_dsl_pofi_2ndpole_set(uint16_t C1)
{
   // VDSL only - in ADSL 10pF are set automatically
   // 2nd pole C1 - default 0pF -> @ inf
   if (C1 == 0)
   {
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0), \
            VRX5AFE_DSL_FCSI_POCO0_FC1VDSL__ISMSK, \
            VRX5AFE_DSL_FCSI_POCO0_FC1VDSL_NOCAP1__SVAL);
   }

   if (C1 == 5)
   {
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0), \
            VRX5AFE_DSL_FCSI_POCO0_FC1VDSL__ISMSK, \
            VRX5AFE_DSL_FCSI_POCO0_FC1VDSL_5P__SVAL);
   }

   if (C1 == 10)
   {
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0), \
            VRX5AFE_DSL_FCSI_POCO0_FC1VDSL__ISMSK, \
            VRX5AFE_DSL_FCSI_POCO0_FC1VDSL_10P__SVAL);
   }
}


/*
** =============================================================================
**
** FUNCTION-NAME:  AFED_SetAfeTxGain
**
** DESCRIPTION:   This function sets the AFE Tx Power Control (POCO). The calling
**                should take care about the fractional gains.
**
** PARAMETERS:     int16 s_gain (in dB)
**
** RETURN VALUE:   actual gain applied (in dB)
**
** NOTES:        Reference: (1) XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                            SMS00920543
**
** =============================================================================
*/
int16 AFED_SetAfeTxGain(int16 s_gain)//OPEN_VRX518AFE
{

   uint16 us_ErrorCodeAfe;

   //configure pofi gain and linked C2 value
   us_ErrorCodeAfe = vrx5afe_dsl_pofi_gainfc_set(gus_AFE_TxMode, s_gain, gla_fc_pofi_lp_kHz[gus_AFE_TxMode]);
   if ( us_ErrorCodeAfe != 0 ) //VRX518 AFE Error code
   {
      EnterFailStates(E_CODE_AFE_EXCEPTION);   // XDSLRTFW-1628
   }

   // Line driver mode configuration
   {
      uint16 us_LD_Mode;

      us_LD_Mode = gus_LD_Mode;

      // XDSLRTFW-3611
      // Note: When LD mode is FW aouto select then do the FW auto switching!
      if (us_LD_Mode == LD_AUTOSEL)
      {
         // XDSLRTFW-2943(Start_End)
         if (gft_Debug35bHwConfig17aModeEnable == TRUE)
         {
            us_LD_Mode = LD_VH_VDSL;
         }
         else if(gus_UseUS0OnlyCntrl & TX_US0_ONLY_CONF_POFIPOCO_LD)  // XDSLRTFW-3627
         {
            us_LD_Mode = LD_M_ADSL;
         }
         else if (gus_AFE_RxMode == VDSL35b_CPE)
         {
            us_LD_Mode = LD_VH_VDSL;
         }
         else
         {
            us_LD_Mode = LD_M_VDSL;
         }
      }

      // Setting LD mode
      // Note: The Line Driver mode gets only be changed, if it differs from
      // the previous mode read out of the HW!
      AFED_SetLdMode(us_LD_Mode); //XDSLRTFW-3361
   }

   //This return Value isn't used by the caller
   return (s_gain);
}

/*
** =============================================================================
**
** FUNCTION-NAME:  AFED_SetAFEAnalogCutback
**
** DESCRIPTION: To reduce the quantization error the POCO gain of the AFE is used
**             rather than the digital gain in the Zephyr block for suppressing
**             qualtization errors.
**
** PARAMETERS: uint16 us_cutbacks (in units of 1dB)
**
** RETURN VALUE:   Actual cutback applied (in dB)
**
** NOTES:
**
** =============================================================================
*/
uint16 AFED_SetAFEAnalogCutback(uint16 cutbacks)  //OPEN_VRX518AFE
{

   uint16 us_act_cutback_appl=0;
   us_act_cutback_appl=cutbacks;

   return (us_act_cutback_appl);
}







