/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/////******************************************************************************************
//
//
//    File Nanme: AFED_ReadWriteModify.c
//
//    History
//
// 17/04/2016 Palaksha: Added VR518 AFE FCSI Access primitives for: ReadAfe, WriteAfe and ReadModifyAfe
// Grep for:
//
/////******************************************************************************************
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "delay.h"
#include "vdsl_xception.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/
#define AFE_RD_WR_TIMEOUT              (5000)   //TBD

extern uint16 gus_wrfail_done;
extern uint16 gus_wrfail_busy;
extern uint16 gus_rdfail_done;
extern uint16 gus_rdfail_busy;
extern FlagT gft_ByPassAfe;


/**============================================================================
**
** FUNCTION-NAME:  AFED_ReadAfeRegister
**
** DESCRIPTION:   It performs the read operation from the AFE register
**                if both AFE done bit and AFE busy bit are "0" in the
**                Register V_AFE_SERIAL_CFG.
**
** INPUT PARAMETERS:
**       uint8 FcsiInterface     : FCSI interface address space DSL/CENTRAL
**    uint16 AfeRegAddress : AFE Register Address
**
** RETURN VALUE:
**              If success, 16 bit AFE register value
**              If Fail, Error code
**
** NOTES:
**
** =============================================================================
*/
//uint16 AFED_ReadAfeRegister(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 *rdata));
uint16 VRX5AFE_FCSI_READ(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 *rdata)
{
   uint32 Cfg = 0;
   uint32 RegData =0;
   uint32 FcsiIrnicrAddr; //V_FCSI_IRNICR_C_35B_ADDR  or V_FCSI_IRNICR_D_35B_ADDR
   uint32 FcsiCmdAddr;    //V_FCSI_CMD_C_35B_ADDR     or V_FCSI_CMD_D_35B_ADDR
   uint32 FcsiRbufAddr;   //V_FCSI_RBUF_C_35B_ADDR    or V_FCSI_RBUF_D_35B_ADDR

   // this check is for VRx518 bring-up only
   if (gft_ByPassAfe)
   {
      return(0);
   }

   if (FcsiInterface == (uint16)FCSI_DSL )
   {
      FcsiIrnicrAddr = (uint32) V_FCSI_IRNICR_D_35B_ADDR;
      FcsiCmdAddr    = (uint32) V_FCSI_CMD_D_35B_ADDR;
      FcsiRbufAddr   = (uint32) V_FCSI_RBUF_D_35B_ADDR;
   }
   else
   {
      FcsiIrnicrAddr = (uint32) V_FCSI_IRNICR_C_35B_ADDR;
      FcsiCmdAddr    = (uint32) V_FCSI_CMD_C_35B_ADDR;
      FcsiRbufAddr   = (uint32) V_FCSI_RBUF_C_35B_ADDR;
   }
   //RR bit field(bit#2) of register V_FCSI_IRNICR_D_35B,indicates that at least one data word is available in the RBUF
   ReadCoreReg((uint32)(FcsiIrnicrAddr), &Cfg);

   if ( (Cfg & FCSI_RR_BIT_STATUS) == 0)
   {
      // Write to FCSI_CMD register to read from addr //_out(V_FCSI_CMD_C/D, ((addr&0x00FF)|0x2000));
      WriteCoreReg((uint32)(FcsiCmdAddr), (AfeRegAddress | FCSI_BUS_READ_ACCESS ) );
        //Check RR bit field(bit#2) of register V_FCSI_IRNICR_C/D
         AFED_FcsiIrnicrRrPoll((uint16) FcsiInterface);
        //Read from FCSI_RDATA register //data = _in(V_FCSI_RBUF_C/D);
      ReadCoreReg((uint32)(FcsiRbufAddr), &RegData);
   }
   else
   {
      //Error Code
      if (gul_ExceptionCode == E_CODE_NO_ERROR)
      {
         gul_ExceptionCode = E_CODE_AFE_READ_EXCEPTION_ERROR;
      }
      gus_rdfail_busy++;
   }

   *rdata = (uint16) RegData;
   return( (uint16) RegData);
}

//FUNCTION-NAME:  AFED_FcsiIrnicrRrPoll
//For FCSI_DSL,    RR bit field(bi#2) of register V_FCSI_IRNICR_D_35B,indicates that at least one data word is available in the RBUF
//For FCSI_CENTRAL,RR bit field(bi#2) of register V_FCSI_IRNICR_C_35B,indicates that at least one data word is available in the RBUF
void AFED_FcsiIrnicrRrPoll(uint16 FcsiInterface)
{
   uint32 FcsiIrnicrAddr;
   uint32 Cfg = 0;
   uint16 timeout = 0;

   if (FcsiInterface == (uint16)FCSI_DSL )
   {
   FcsiIrnicrAddr = (uint32)(V_FCSI_IRNICR_D_35B_ADDR);
   }
   else
   {
   FcsiIrnicrAddr = (uint32)(V_FCSI_IRNICR_C_35B_ADDR);
   }

   //Debug code to verify whether XE bit status is set or not
   ReadCoreReg(FcsiIrnicrAddr, &Cfg);

   //Wait in a loop as long as RR(bit#2) is "1" and time out < threshold
   do
   {
   delay(1);  //1*10 = 10 cycles delay
   ReadCoreReg(FcsiIrnicrAddr, &Cfg);
   timeout++;
   }
   while( (!(Cfg & FCSI_RR_BIT_STATUS)) && (timeout < FCSI_AFE_RD_TIMEOUT) );

   if (timeout >= FCSI_AFE_RD_TIMEOUT)
   {
      //Error Code
      if (gul_ExceptionCode == E_CODE_NO_ERROR)
      {
         gul_ExceptionCode = E_CODE_AFE_NOT_READY;
      }
      gus_rdfail_done++;
   }
}

/**============================================================================
**
** FUNCTION-NAME:  AFED_WriteAfeRegister
**
**    DESCRIPTION:
**    This function does the Write operation only into the AFE
**      registers. It can be used where read-modify is not
**      required into the AFE registers.
**      Does the write operation only if the AFE is not busy.
**
**    INPUT PARAMETERS:
**       uint8 FcsiInterface     : FCSI interface address space DSL/CENTRAL
**    uint16 AfeRegAddress : AFE Register Address
**       uint16 AfeRegData    : The Value to be written to AFE register
**
**    RETURN VALUE:
**    None
**
**    NOTES:
**
** =============================================================================
*/
//void   AFED_WriteAfeRegister (uint16  FcsiInterface,uint16 AfeRegAddress, uint16 AfeRegData);
void VRX5AFE_FCSI_WRITE(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 AfeRegData)
{
   uint32 Cfg = 0;
   uint32 FcsiIrnicrAddr; //V_FCSI_IRNICR_C_35B_ADDR  or V_FCSI_IRNICR_D_35B_ADDR
   uint32 FcsiCmdAddr;    //V_FCSI_CMD_C_35B_ADDR     or V_FCSI_CMD_D_35B_ADDR
   uint32 FcsiXbufAddr;   //V_FCSI_XBUF_C_35B_ADDR    or V_FCSI_XBUF_D_35B_ADDR

   // this check is for VRx518 bring-up only
   if (gft_ByPassAfe)
   {
      return;
   }

   if (FcsiInterface == (uint16)FCSI_DSL )
   {
      FcsiIrnicrAddr = (uint32) V_FCSI_IRNICR_D_35B_ADDR;
      FcsiCmdAddr    = (uint32) V_FCSI_CMD_D_35B_ADDR;
      FcsiXbufAddr   = (uint32) V_FCSI_XBUF_D_35B_ADDR;
   }
   else
   {
      FcsiIrnicrAddr = (uint32) V_FCSI_IRNICR_C_35B_ADDR;
      FcsiCmdAddr    = (uint32) V_FCSI_CMD_C_35B_ADDR;
      FcsiXbufAddr   = (uint32) V_FCSI_XBUF_C_35B_ADDR;
   }
   //XE bit field(bit#1) of register V_FCSI_IRNICR_C_35B,indicates that the Transmit-FIFO is empty.
   ReadCoreReg((uint32)(FcsiIrnicrAddr), &Cfg);

   if ( (Cfg & FCSI_XR_BIT_STATUS) != 0)
   {
      // Write to FCSI_CMD register to Write to AFE addr //_out(V_FCSI_CMD_C/D, ((addr&0x00FF)|0x2000));
      WriteCoreReg((uint32)(FcsiCmdAddr), (AfeRegAddress | FCSI_BUS_WRITE_ACCESS ) );
      // Write to FCSI Transmit Buffer register
      WriteCoreReg( (uint32)(FcsiXbufAddr),(uint32) AfeRegData);

      ReadCoreReg((uint32)(FcsiIrnicrAddr), &Cfg);
   }
   else
   {
      //Error Code
      if (gul_ExceptionCode == E_CODE_NO_ERROR)
      {
         gul_ExceptionCode = E_CODE_AFE_WRITE_EXCEPTION_ERROR;
      }
      gus_wrfail_busy++;
   }

}

/**============================================================================
**
** FUNCTION-NAME:  VRX5AFE_FCSI_RMW
**
**    DESCRIPTION:
**    This function does the Read Modify Write operation if
**       the mask is != 0x0000. Otherwise it does write operation.
**       Does the write operation only if the AFE is not busy.
**     NewDataToBeWritten = (ReadRegData & Mask) | (RegValueFiledTobeWritten & ~Mask);
**
**    INPUT PARAMETERS:
**       uint8 FcsiInterface     : FCSI interface address space DSL/CENTRAL
**    uint16 AfeRegAddress : AFE Register Address
**       uint16 AfeRegData    : The Value to be written to AFE register
**
**    RETURN VALUE:
**    None
**
**    NOTES:
**
** =============================================================================
*/
//void   AFED_ReadModifyAfeRegister (uint16 FcsiInterface,uint16 AfeRegAddress,uint16 mask, uint16 AfeRegData);
void VRX5AFE_FCSI_RMW(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 mask, uint16 AfeRegData)
{
   uint16 ReadData = 0;
   uint16 NewData = 0;
   uint16 ReadDataDummy;

   // this check is for VRx518 bring-up only
   if (gft_ByPassAfe)
   {
      return;
   }

   if (mask != 0x0000)
   {
   //Read
   //uint16_t VRX5AFE_FCSI_READ(uint16_t block, uint16_t address, uint16_t *rdata)
   ReadData = VRX5AFE_FCSI_READ(FcsiInterface, AfeRegAddress, &ReadDataDummy);
   }

   //NewData = (ReadData & ~mask) | (AfeRegData & mask); VR9 type
   NewData = (ReadData &  mask) | (AfeRegData & ~mask);   //VRX518 as per API
   //Write
   ////void    VRX5AFE_FCSI_WRITE(uint16_t block, uint16_t address, uint16_t value)
   VRX5AFE_FCSI_WRITE (FcsiInterface,AfeRegAddress,  NewData);
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   wait_ms(uint16 msec)
**
** DESCRIPTION:  It was intended to wait mseconds but I assume that this function is not correct
**
**
** PARAMETERS:     NONE
**
** RETURN VALUE:   NONE
**
** NOTES:          OK!
**                 Reference: Vinax code
** =============================================================================
*/
void wait_ms(uint16 msec)
{
   uint32 NumberOfCycles;
   uint32 NopCount;

   // Calculate the clock cycles assuming a clock speed of 288 MHz and one instruction per loop circle
   // but is that true??
   NumberOfCycles = 288000 * msec;
   for(NopCount = 0; NopCount <= NumberOfCycles-1; NopCount++)
   {
      _nop();
   }
}



