/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AFED_CONSTANTS_H
#define _AFED_CONSTANTS_H
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_AfeConstants.h
*
*   This file contains VRX518 AFE Data
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 AFE data
//
// **********************************************************************************************//

#include "common.h"
#include "vrx5afe_mode_defines.h"


//VRX518_AFE
#define  FCSI_CENTRAL           (VRX5AFE_CENTRAL)
#define  FCSI_DSL               (VRX5AFE_DSL)


#define VERSIONAFE_CENTRAL_A11   (0x00)  //0000 0000b Version A11 CENTRAL
#define VERSIONAFE_CENTRAL_A21   (0x01)  //0000 0001b Version A21 CENTRAL

#define  VERSIONAFE_DSL_A11      (0x00)  // 0000 0000b Version A11 DSL
#define  VERSIONAFE_DSL_A21      (0x02)  // 0000 0010b Version A21 DSL

//V_FCSI_CMD_C_35B / V_FCSI_CMD_D_35B  "CMD" field
#define  FCSI_CMD_RST_BUSREGS               0x6000  //Reset FCSI-Bus registers. The Command is queued into the Transmit-FIFO.
#define  FCSI_CMD_RST_CONTROLLER_BUSREGS    0x4000  //Reset the FCSI Controller and the FCSI-Bus registers. The Command is executed immediately.
#define  FCSI_BUS_READ_ACCESS               0x2000 //FCSI-Bus read access. The Command is queued into the Transmit-FIFO. After Command execution the read data is stored in the Receive-FIFO.
               //The queued data can be fetched with a read access to the RBUF register. The Command execution is stalled when the Receive-FIFO is full.
#define  FCSI_BUS_WRITE_ACCESS              0x0000 //FCSI-Bus write access. A following data write to the XBUF register is required and queues the Command together with the FCSI write data into the Transmit-FIFO

#define  FCSI_RR_BIT_STATUS         (0x0004) //Bit#2 Mask
#define  FCSI_XE_BIT_STATUS         (0x0002) //Bit#1 Mask
#define  FCSI_XR_BIT_STATUS         (0x0001) //Bit#0 Mask


#define FCSI_AFE_RD_TIMEOUT         (5000)   //TBD
#define FCSI_AFE_WR_TIMEOUT         (5000)   //TBD

//PGA1
#define  AFED_AGC1_MIN_PGA          (-9)    //in dB
#define  AFED_AGC1_PGA_MINUS_6DB    (-6)    //in dB

#define  AFED_AGC1_MAX_PGA          (21)    //in dB
#define  AFED_AGC1_MAX_PGA_8K       (15)    //in dB

//PGA2
#define  AFED_AGC2_MIN_PGA          (-16)  //in dB
#define  AFED_AGC2_MAX_PGA          (0)    //in dB

#define  AFED_MAX_PGA_GAIN          (21)   //in dB // // XDSLRTFW-4236 VRX518: CTLK: Modify/Improve Single Stage PGA Training algorithm

// if (mode_set == ADSL2_CPE) if (gain_prefi_dB >= -8 && gain_prefi_dB <= 12) ADSL
#define  AFED_AGC2_MIN_PGA_ADSL       (-8)  //in dB
#define  AFED_AGC2_MAX_PGA_ADSL       (12)  //in dB

//
#define  AFE_POFI_MODE_ADSL2_CPE          (0x0001)
#define  DFE_TX_IIR_LOWPASS_FILTER        (0x0002)
#define  DFE_TX_NS_ADSL_MODE              (0x0004)
#define  DFE_TX_NS_VDSL_MODE              (0x0008)
#define  AFE_TX_LD_MODE_CHANGE            (0x0010)

//------------------------------------------------start
// In VRX518 CPC and CPB capacitor values to be changed
// with x = b or c, i.e. for Cpb= -4, -2, +2, +4, +5, -5; Cpc=-5, -4, -2, +2, +4, +5, -5
//       0-loop: Cpb= -4, -2, +2, +4, +5, -5; Cpc= -4, -2, +2, +4, +5, -5
//    all other: Cpb= -4, -2, +2, +4;         Cpc= -4, -2, +2, +4
#define  VRX_NUM_CAP_START_SEARCH           (1)
#define  VRX_NUM_CAP_CPB_SEARCH_NOZEROLOOP  (4)
#define  VRX_NUM_CAP_CPC_SEARCH_NOZEROLOOP  (4)
#define  VRX_NUM_CAP_CPB_SEARCH_ZEROLOOP    (6)
#define  VRX_NUM_CAP_CPC_SEARCH_ZEROLOOP    (6)
#define  VRX_NUM_CAP_CPB_SEARCH \
         ((VRX_NUM_CAP_CPB_SEARCH_NOZEROLOOP) < (VRX_NUM_CAP_CPB_SEARCH_ZEROLOOP) ? (VRX_NUM_CAP_CPB_SEARCH_ZEROLOOP) : (VRX_NUM_CAP_CPB_SEARCH_NOZEROLOOP))
#define  VRX_NUM_CAP_CPC_SEARCH \
         ((VRX_NUM_CAP_CPC_SEARCH_NOZEROLOOP) < (VRX_NUM_CAP_CPC_SEARCH_ZEROLOOP) ? (VRX_NUM_CAP_CPC_SEARCH_ZEROLOOP) : (VRX_NUM_CAP_CPC_SEARCH_NOZEROLOOP))

#define  VRX518_NUM_CAP_SEARCH            (VRX_NUM_CAP_START_SEARCH+VRX_NUM_CAP_CPB_SEARCH+VRX_NUM_CAP_CPC_SEARCH)
#define  VRX_NUM_CAP_CPB_NOZEROLOOP_WRAP_ADD (9)
#define  VRX_NUM_CAP_CPC_NOZEROLOOP_WRAP_ADD (9)
#define  VRX_NUM_CAP_CPB_ZEROLOOP_WRAP_ADD  (11)
#define  VRX_NUM_CAP_CPC_ZEROLOOP_WRAP_ADD  (11)

// XDSLRTFW-3897(start)
#define VRX518_ANX_ABJ_NUM_HYBS_35M       (7)
#define VRX518_ANX_ABJ_NUM_HYBS_30M       (7)
#define VRX518_ANX_ABJ_NUM_HYBS_17M       (9)
#define VRX518_ANX_ABJ_NUM_HYBS_12M       (9)
#define VRX518_ANX_ABJ_NUM_HYBS_8M        (9)
// XDSLRTFW-3897(End)
#define VRX518_ANX_ABJ_NUM_HYBS_US0       (24)
#define VRX518_ANX_A_NUM_HYBS_US0         (24)

// Note: This max define "VRX518_ANX_ABJ_NUM_HYBS_MAX" must be set to one of the above defines,
//       which has the max value!!
#define VRX518_ANX_ABJ_NUM_HYBS_MAX       (VRX518_ANX_ABJ_NUM_HYBS_US0)

// Use the Max Hyb settings which will be used to declare arrays sizes, since the type
// of hybrid will be known only during run time.
#define VRX518_MAX_NUM_ADAP_HYB_SETTINGS  \
      ((VRX518_ANX_ABJ_NUM_HYBS_MAX) < (VRX518_NUM_CAP_SEARCH) ? (VRX518_NUM_CAP_SEARCH) : (VRX518_ANX_ABJ_NUM_HYBS_MAX))

// Hybrid register to be stored in a table, i.e. table elements
#define VRX518_HYB_NUM_GAIN_VALUES        (1)
#define VRX518_HYB_NUM_AFE_REGS           (3)
#define VRX518_HYB_NUM_SETTINGS           (VRX518_HYB_NUM_AFE_REGS+VRX518_HYB_NUM_GAIN_VALUES)
// Hybrid table indexes
#define VRX518_PGA0_IDX                   (0)
#define VRX518_PGA1_IDX                   (1)
#define VRX518_PGA2_IDX                   (2)
#define VRX518_HYBGAIN_IDX                (3)  // Hybrid gain value index
//------------------------------------------------end

// DAC Rate
#define  VRX518_DAC_RATE_144MHZ         (0)
#define  VRX518_DAC_RATE_288MHZ         (1)

// ADC Rate
#define  VRX518_ADC_RATE_576MHZ         (0)
#define  VRX518_ADC_RATE_1152MHZ        (1)

//
#define  VRX518_SRC_INRATE_35MHZ         (35) //35MHZ
#define  VRX518_SRC_INRATE_70MHZ         (70) //70MHZ

//
#define  VRX518_SRC_OUTRATE_70MHZ         (70) //70MHZ
#define  VRX518_SRC_OUTRATE_144MHZ        (140) //140MHZ
//
#define  V_LBK_35B_ADCADJ_SEL_RXWDF2      (0 << 8)  //Rx ADC Adjust input taken from Rx WDF2 decimator
#define  V_LBK_35B_ADCADJ_SEL_CIC         (1 << 8)  //Rx ADC Adjust input taken from Rx CIC

#define  V_LBK_35B_NS_SEL_TXWDF2          (0 << 7)  //Tx Noise Shaper input taken from Tx WDF2 interpolator
#define  V_LBK_35B_NS_SEL_DFI             (1 << 7)  //Tx Noise Shaper input taken from input to the DFI

#define  V_LBK_35B_SRC_SEL_FIRDECIM1      (0 << 6)  //Rx SRC input taken from Rx FIR Decim1
#define  V_LBK_35B_SRC_SEL_RXWDF1         (1 << 6)  //Rx SRC input taken from RxWDF1

#define  V_LBK_35B_DFI_SEL_TXHB           (0 << 5)  //Tx Interp HB Filter. Tx DFI input taken from Tx Interp HB Filter
#define  V_LBK_35B_DFI_SEL_TXWDF1         (1 << 5)  //Tx DFI input taken from Tx WDF1

#endif /* _AFED_CONSTANTS_H */

