/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AFED_DATA_H
#define _AFED_DATA_H
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_Data.h
*
*   This file contains VRX518 AFE Data
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 AFE data
//
// **********************************************************************************************//

#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "Data_alloc.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

// global variable for RC-measurement
extern RxPathGains_t gt_DfeAfeGainSettings;
extern RxPathDslGainCorrection_t gt_PgaGainCorrectionDslPath;
extern uint16_t RC_meas_done;
extern uint16_t RC_counter;
extern uint32   gul_Afe_flowtest;
extern uint16  gus_SkipAfeFlow;
extern int16_t gs_ForceGainPofi_dB;
extern int16 gs_ForcePga1Gain;
extern int16 gs_ForcePga2Gain;
extern int16 gs_Hyb_Hsk_QlnHlog;
extern int16 gs_PrefiAceMode_Selected;
extern uint16 gusa_SwitchingThreshAceMode[ACE_MODE_SWITCH_ARRAY_SIZE];
extern int16 gs_AceSwitchDownRounding;
extern int16 gs_MaxNomPsdOut_Dbg;
extern int16 gsa_PgaTrainDebugVars[10];
extern int16 gus_DebugControlVRX518;
extern uint8 guca_QlnLevelUS[];

extern FlagT   gft_DfiConfig;
extern FlagT   gft_EnableDfiReconfigAlways;
extern FlagT   gft_Debug35bHwConfig17aModeEnable;
extern FlagT   gft_EnaPrefiAceOffOneStagePga;

extern FlagT gft_DisableCompensationTable;
extern int16 gs_Force_AfeDslVersion;      //Allowed values could be 0x00=A11 0x02=A21
extern int16 gs_Force_AfeCentralVersion;  //Allowed values could be 0x00=A11 0x01=A21

extern int16 gs_Pga1MaxGainForce;
extern int16 gs_Pga2MaxGainForce;

extern int32_t gla_fc_pga_lp_kHz[5];
extern int32_t gla_fc_prefi_lp_kHz[5];
extern int32_t gla_fc_pofi_lp_kHz[5];

extern int32_t gla_fc_pga_lp_kHz_HybridPga[5];
extern int32_t gla_fc_prefi_lp_kHz_HybridPga[5];

extern int16_t gsa_gain_pga_dB[];
extern int16_t gsa_gain_prefi_dB[];
extern int16_t gsa_gain_pofi_dB[];

extern uint16 gusa_HybridSettingV2_Handshake_VRX518[];
extern uint16 gusa_HybridSettingV2_Handshake_VRX518_AnnexA[];

extern uint16 gusa_HybridSettingV2_QlnHlog_VRX518[];
extern uint16 gusa_SpecialHybSetting[];

extern uint16 gusa_HybridSettingV2_35M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_35M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_30M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_30M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_17M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_17M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_US0_VRX518[VRX518_ANX_ABJ_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_8M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_8M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_12M_VRX518[VRX518_ANX_ABJ_NUM_HYBS_12M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_US0_A_VRX518[VRX518_ANX_A_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS];

extern uint16 gusa_HybridSettingV2_Handshake_VRX518_A21[];
extern uint16 gusa_HybridSettingV2_QlnHlog_VRX518_A21[];
extern uint16 gusa_SpecialHybSetting_A21[];

extern uint16 gusa_HybridSettingV2_35M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_35M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_30M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_30M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_17M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_17M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_US0_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_US0][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_8M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_8M][VRX518_HYB_NUM_SETTINGS];
extern uint16 gusa_HybridSettingV2_12M_VRX518_A21[VRX518_ANX_ABJ_NUM_HYBS_12M][VRX518_HYB_NUM_SETTINGS];


#endif /* _AFED_DATA_H */

