/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AFED_Functions_H
#define _AFED_Functions_H
/////******************************************************************************************
//
//
//    File Nanme: AFED_ReadWriteRmw.h
//
//    History
//
// 17/04/2016 Palaksha: Added VR518 AFE FCSI Access primitives for: ReadAfe, WriteAfe and ReadModifyAfe
// Grep for:
//
/////******************************************************************************************

#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "vdsl_xception.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL


//LLAPIs

void vrx5afe_set_rc_meas_done(uint16_t set_val);

uint16_t vrx5afe_get_rc_meas_done(void);


void vrx5afe_set_rc_count(uint16_t rc_count_val);

uint16_t vrx5afe_get_rc_count(void);



//---------------
// Mode settings
//---------------
// Tx path
void vrx5afe_txpath_set(uint16_t DslMode);
uint16_t vrx5afe_dsl_pofi_gainfc_set(uint16_t DslMode, int16_t gain, int32_t fc_lp);
void vrx5afe_dsl_pofi_2ndpole_set(uint16_t C1);
void vrx5afe_dsl_dac_conf(uint16_t DslMode);

// Rx path
void vrx5afe_rxpath_set(uint16_t DslMode);
void vrx5afe_dsl_pga_hybrid_set(uint16_t hybrid_set); // LA
uint16_t vrx5afe_dsl_pga_gainfc_set(uint16_t DslMode, int16_t gain, int32_t fc_lp); // no RC tuning
void vrx5afe_dsl_prefi_ace_set(uint16_t ace_set);  // HP
uint16_t vrx5afe_dsl_prefi_gainfc_set(uint16_t DslMode, int16_t gain, int32_t fc_lp);
void vrx5afe_dsl_adc_conf(uint16_t DslMode);
void vrx5afe_dsl_adc_reset(uint16_t DslMode);


//----------------
// Initialization
//----------------
//
//----------------
// Initialization
//----------------
void AFED_AnalogRegistersInit(void);
void vrx5afe_init();

void vrx5afe_central_init();

void vrx5afe_dsl_init();
void VRX518_PowerOnOnlyAfeRegisterInit(void);

//---------------
// Configuration
//---------------
//
void AFED_ModeConfig(void);
void AFED_ConfigAfeTxPath(uint16 AfeTxMode);
void AFED_ConfigAnalogTxPath(uint16 AfeTxMode);
void AFED_ConfigDigitalTxPath(void);
void AFED_ConfigAfeRxPath(uint16 AfeRxMode);
void AFED_ConfigAnalogRxPath(uint16 AfeRxMode);
void AFED_ConfigDigitalRxPath(void);

void AFED_GetProfileSelected(uint16 us_ProfileSelected);

void AFED_ResetAfeDslOnly(void);
//------------
//-----------
// Soft-fuse
//-----------
void AFED_EfuseCopy(void);
void vrx518_ReadEFuseArray (void);
uint16 vrx5afe_softfuse(uint32 *fuse_table);
void ConfigVrx518Afe_VersionSpecific(void);
void vrx5afe_set_dsl_version(uint16_t set_val);
uint16_t vrx5afe_get_dsl_version(void);


//---------
// RC-meas
//---------
//int16_t vrx5afe_rc_meas(uint16_t *rccount); // use pointer to pass val1, val2 and <val>
//int16_t vrx5afe_rc_meas(void);
void vrx5afe_rc_meas(void);

//void vrx5afe_rc_tune(int16_t RC_count);
void vrx5afe_rc_tune(void);

// Dying gasp
//------------
void vrx5afe_dg_init(uint16_t dg_set);



//-------------------------------
// float2int subroutines
// Fixed point implementation FW
//-------------------------------

uint16_t Calc_PgaClp1PrefiClp2PocoC2(int16_t Rsa, int16_t weight_clp1, int16_t  gain_pga_dB, uint32_t Value1e9By2piFcKhz, uint8_t IsPocoFilter);
void VRX518_RxPathDslGainCorrection(void);

//
void AFED_BgSetHybrid(void);
void AFED_SetHybrid(void);
void AFED_HskQlnHlogSetHybrid(void);

void AFED_UpdateHybridBuffer(void);
void AFED_SearchGoodHybridCap(void);
void AFED_BgHybTrCalcMetric(void);
void AFED_ToggleHybridCap(int16 s_StopIdx, int16 s_WrapAdder, int16 *ps_cap_delta,
                          uint16 *pHybRegSrc, int16 s_HybridTableIdx, int16 s_DestOffset);
//
void AFED_BgSingleStagePGASetting(void);
void AFED_SetPga1();
void AFED_SetPga();
void AFED_BgGetPga(void);
void AFED_GetPgaGains(void);
void AFED_CalcAGC1(int16 PGA_required);
void AFED_CalcAGC2(int16 PGA_required);
void AFED_InitAFE_RegsPGA(void);
void AFED_RestoreAFE_RegsforAGC2(void);
void AFED_BgSetNmsPGAMedley(void);
void AFED_ReUsePgaPrefiGains(int16 _sHybGainDiff);
//
int16 AFED_SetAfeTxGain(int16 gain);
uint16 AFED_SetAFEAnalogCutback(uint16 cutbacks);

uint16 AFED_GetLdMode();
void AFED_SetLdMode(uint16 RequiredLDMode);
FlagT AFED_RcMeasure(void);


//DFI function prototypes
void VRX518_DfiConfig_Common(void);
void VRX518_DfiConfig_TxPath(void);
void VRX518_DfiConfig_RxPath(void);

//Debug functions for overwriting the AFE Tx and Rx Mode settings.
void AFED_ConfigAfeRxPathForced(void);
void AFED_ConfigAfeTxPathForced(void);
void AFED_InitAnalogRegsTxForced(void);
void AFED_InitAnalogRegsRxForced(void);
void AFED_FilterConfigRegsTxForced(void);
void AFED_FilterConfigRegsRxForced(void);


#endif   // _AFED_Functions_H
