/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef VRX5AFE_MODE_DEFINES_H
#define VRX5AFE_MODE_DEFINES_H


// Defines for Port Access
#define VRX5AFE_CENTRAL 1 //00001
#define VRX5AFE_DSL     2 //00010

// number of FCSI ports
#define FCSI_PORTS  2

// RC-tuning
#define RC_nom 319 //Whenever RC_nom  values changes, then variable RC_nomxK in function vrx5afe_rc_tune()

// Enable floating point code for testing
//#define TEST_FLOAT_VRX518

// Factors for Fixed-Point calculations
//*********(1e9/ (2.0 * 3.1415* fc_pofi_lp_KHz * 512) ) //Scale by value 512 (9 bits) to reduce the range of number *********//
// rearrange constants and do offline float compute
//1e9/ (2.0 * 3.1415 * 512 * fc_pofi_lp_KHz) )  = (1e9/ (2.0 * 3.1415 * 512)) / fc_pofi_lp_KHz
//Const1e9By2pix = ((1e9 / (2.0 * 3.1415 * 512 * 256)) * 2 ^ 20) = 0x4BE4AAA9  Q20
               //Here scale factor 256(8bits) are used later 512(9 bits) are used
//Const1e9By2PiX = ((int32_t)0x4BE4AAA9) / fc_pga_lp_KHz; //Q20/Q0 = Q0
#define NUM_Q20_1E9BY2PIX512X256    (0x4BE4AAA9) //((1e9 / (2.0 * 3.1415 * 512 * 256)) * 2 ^ 20) = 0x4BE4AAA9  Q20
#define SCALE_1E9BY2PIX512X256BY8   (8)
#define SCALE_1E9BY2PIX512X256BY9   (9)

// Modes
#define BYPASSED           (0)
#define VDSL35b_CPE        (1)
#define VDSL17_CPE         (2)
#define VDSL8_CPE          (3)
#define ADSL2_CPE          (4)
#define ADSL2_CPE_LL       (5)

//ACE
#define ACE_MODE_MASK      (0xF)
#define ACE_52p5F          (0)
#define ACE_30pF           (1)
#define ACE_15pF           (2)
#define ACE_7p5F           (3)
#define ACE_OFF            (4)


//A11 definitions
/// --------------------------------------------
/// -- PGA5 - PREFI 0
/// -- Fields: 5
/// --------------------------------------------
// PREFI35ENCAP
// tuning of compensation cap
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__INIT                                    0x0
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__POS                                     2  // (rw)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__MSK                                     (0x0003)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__SMSK                                    (0x000C)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__ISMSK                                   (0xFFF3)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__GET(RegVal)                             (((RegVal)>>2)&0x0003)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__PUT(FldVal,RegVal)                      ((((FldVal)&0x0003)<<2)|((RegVal)&0xFFF3))
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_0__VAL                                   (0x0000)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_0__SVAL                                  (0x0000)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_1__VAL                                   (0x0001)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_1__SVAL                                  (0x0004)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_2__VAL                                   (0x0002)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_2__SVAL                                  (0x0008)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_3__VAL                                   (0x0003)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_3__SVAL                                  (0x000C)
// PREFI35IOUT
// tuning of current
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__INIT                                     0x0
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__POS                                      4  // (rw)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__MSK                                      (0x0007)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__SMSK                                     (0x0070)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__ISMSK                                    (0xFF8F)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__GET(RegVal)                              (((RegVal)>>4)&0x0007)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__PUT(FldVal,RegVal)                       ((((FldVal)&0x0007)<<4)|((RegVal)&0xFF8F))
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_0__VAL                                    (0x0000)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_0__SVAL                                   (0x0000)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_1__VAL                                    (0x0001)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_1__SVAL                                   (0x0010)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_2__VAL                                    (0x0002)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_2__SVAL                                   (0x0020)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_3__VAL                                    (0x0003)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_3__SVAL                                   (0x0030)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_4__VAL                                    (0x0004)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_4__SVAL                                   (0x0040)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_5__VAL                                    (0x0005)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_5__SVAL                                   (0x0050)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_6__VAL                                    (0x0006)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_6__SVAL                                   (0x0060)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_7__VAL                                    (0x0007)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_7__SVAL                                   (0x0070)
// PREFI35ACESRES
// ACE serial resistor R1 selection
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__INIT                                  0x1
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__POS                                   7  // (rw)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__MSK                                   (0x0007)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__SMSK                                  (0x0380)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__ISMSK                                 (0xFC7F)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__GET(RegVal)                           (((RegVal)>>7)&0x0007)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES__PUT(FldVal,RegVal)                    ((((FldVal)&0x0007)<<7)|((RegVal)&0xFC7F))
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R900__VAL                              (0x0000)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R900__SVAL                             (0x0000)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R1900__VAL                             (0x0001)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R1900__SVAL                            (0x0080)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R2400__VAL                             (0x0002)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R2400__SVAL                            (0x0100)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R4900__VAL                             (0x0003)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R4900__SVAL                            (0x0180)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R9900__VAL                             (0x0004)
#define VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ACESRES_R9900__SVAL                            (0x0200)

#endif
