;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C) 2002 ARC International
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
   .file   "startup.s"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Startup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

   .extern boot
   .text
   .weak   _SDA_BASE_

   .global _start
   .type   _start, @function

_start:

   ; Initialize the register file.  This is necessary because
   ; of an idiosyncracy of the register file implementation.
   ; Compiled code may generate sub  r0, r1, r1, expecting to
   ; load 0 into r0, but the individual reads of r1 for the two source
   ; operands may return different (garbage) values if r1 had never
   ; been written to since reset.
   ; NOTE: This initialization is required ONLY for Tangent ARC4 builds.
   ;       You may comment it out if not using an ARC4 build.

   .irep num, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25
           mov     r\&num, 0
   .endr

   mov     sp, _estack     ; initialize stack pointer
   sub     sp, sp, 16      ; allocate expected call frame
   mov     gp, _SDA_BASE_  ; initialize small-data base register
   bl.d    main            ; go to main function
   mov     fp, 0           ; initialize frame pointer
   b       _exit_halt


   .global _exit_halt
   .type   _exit_halt, @function

_exit_halt:

   flag    0x01            ; halt ARC
   nop                     ; clean pipe after halt
   nop                     ; clean pipe after halt
   nop                     ; clean pipe after halt
   b       _exit_halt      ; and halt it again
   nop                     ; branch delay slot

   ; weak versions of small data symbols normally defined by the linker.
   .weak   _fsbss
   .weak   _esbss
   .set    _fsbss,0
   .set    _esbss,0

   .section .vectors, text

   j.f     _start    ; reset

   .end
