/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2009 - Lantiq
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
**
** This file contains the version information used for firmware compilation.
** The file is updated automatically by the release script.
** It should be edited manually only for building test FW binaries.
**
*******************************************************************************/

#ifndef __VER_ONLINE_H
#define __VER_ONLINE_H


//XDSLRTFW-3364 (Start)

#define VRX518_PLATFORM_ID       (8)
#define VRX318_PLATFORM_ID       (7)
#define VR9_PLATFORM_ID          (5)


#define BND_ENABLE               '1'
#define BND_DISABLE              '0'
#define BONDINGSUPPORT           BND_ENABLE // set to  BND_DISABLE if bonding is not supported


#define VERSION_PLATFORM         (VRX518_PLATFORM_ID)   //Platform Number; 8-bits width, Valid values 1 to 15 ONLY

#define VERSION_FEATURE          (12)  //Feature Set Number; 8-bits width, Valid values 1 to 15 ONLY

#define VERSION_MAJOR            (2)   //Major Version Number; 4-bits width; First version = 0, Last version = 15

#define VERSION_MINOR            (12)   //Minor Version Number; 4-bits width; First version = 0; Last version = 15

#define VERSION_REL_STATUS       (1)   //Release status; 2-bits width
                                       // 0: Release Version i.e. Released after IQ/FW testing to external customers
                                       // 1: Pre-Release Version i.e. IQ/FW testing going on
                                       // 2: Reserved
                                       // 3: Development version i.e. Test firmware release.


//XDSLRTFW-696 Feature_ALL_VDSL2_ALL_SpecialFirmwareForVector (Start)
#define STANDARD_APPLICATION     (6)
#define VECTORING_APPLICATION    (7)

#if defined (VECTORING_BUILD)
// Vectoring Code, supports, (i) Standard, (ii) Vector Friendly & (iii) Vectoring
#define VERSION_APP_NUM          (VECTORING_APPLICATION)    //Application Number; 6-bits width
#else
// Standard Code, supports, (i) Standard & Vector Friendly
#define VERSION_APP_NUM          (STANDARD_APPLICATION)     //Application Number; 6-bits width
#endif
//XDSLRTFW-696 Feature_ALL_VDSL2_ALL_SpecialFirmwareForVector (End)


// If the RELEASE_STATE == 3, then you need to define the following test firmware version
// which will be sent along with the EOC/Overhead Messages
#define VERSION_TEST_FW_SOURCE   (0)   // !! DO NOT USE THIS FIELD !! Reserved for future use

#define VERSION_TEST_FW_NUM      (0x03) //Test FW release Nos. must start from 1 and up to a maximum of 255 (1,2,3,4 ..9,A,B,C,D,E,F,10,11...,FF)

#define ASCII_MAP_FOR_0 (0x30)
#define ASCII_MAP_FOR_7 (0x37)

#if (((VERSION_PLATFORM & 0XF0)>>4) < 10)
#define STR_VERSION_PLATFORM_HI (ASCII_MAP_FOR_0 + ((VERSION_PLATFORM & 0XF0) >> 4))
#else
#define STR_VERSION_PLATFORM_HI (ASCII_MAP_FOR_7 + ((VERSION_PLATFORM & 0XF0) >> 4))
#endif

#if ((VERSION_PLATFORM & 0XF) < 10)
#define STR_VERSION_PLATFORM_LO (ASCII_MAP_FOR_0 + (VERSION_PLATFORM & 0XF))
#else
#define STR_VERSION_PLATFORM_LO (ASCII_MAP_FOR_7 + (VERSION_PLATFORM & 0XF))
#endif

#if (((VERSION_FEATURE & 0XF0)>>4) < 10)
#define STR_VERSION_FEATURE_HI (ASCII_MAP_FOR_0 + ((VERSION_FEATURE & 0XF0) >> 4))
#else
#define STR_VERSION_FEATURE_HI (ASCII_MAP_FOR_7 + ((VERSION_FEATURE & 0XF0) >> 4))
#endif

#if ((VERSION_FEATURE & 0XF) < 10)
#define STR_VERSION_FEATURE_LO (ASCII_MAP_FOR_0 + (VERSION_FEATURE & 0XF))
#else
#define STR_VERSION_FEATURE_LO (ASCII_MAP_FOR_7 + (VERSION_FEATURE & 0XF))
#endif

#if (VERSION_MAJOR < 10)
#define STR_VERSION_MAJOR    (ASCII_MAP_FOR_0 + (VERSION_MAJOR & 0xF))
#else
#define STR_VERSION_MAJOR    (ASCII_MAP_FOR_7 + (VERSION_MAJOR & 0xF))
#endif

#if (VERSION_MINOR < 10)
#define STR_VERSION_MINOR    (ASCII_MAP_FOR_0 + (VERSION_MINOR & 0xF))
#else
#define STR_VERSION_MINOR    (ASCII_MAP_FOR_7 + (VERSION_MINOR & 0xF))
#endif

#if (VERSION_REL_STATUS < 10)
#define STR_VERSION_REL_STATUS (ASCII_MAP_FOR_0 + (VERSION_REL_STATUS & 0xF))
#else
#define STR_VERSION_REL_STATUS (ASCII_MAP_FOR_7 + (VERSION_REL_STATUS & 0xF))
#endif

#if (((VERSION_APP_NUM & 0X30)>>4) < 10)
#define STR_VERSION_APP_NUM_HI (ASCII_MAP_FOR_0 + ((VERSION_APP_NUM & 0X30) >> 4))
#else
#define STR_VERSION_APP_NUM_HI (ASCII_MAP_FOR_7 + ((VERSION_APP_NUM & 0X30) >> 4))
#endif

#if ((VERSION_APP_NUM & 0XF) < 10)
#define STR_VERSION_APP_NUM_LO (ASCII_MAP_FOR_0 + (VERSION_APP_NUM & 0XF))
#else
#define STR_VERSION_APP_NUM_LO (ASCII_MAP_FOR_7 + (VERSION_APP_NUM & 0XF))
#endif

#if (((VERSION_TEST_FW_SOURCE & 0XF0)>>4) < 10)
#define STR_VERSION_TEST_FW_SOURCE_HI (ASCII_MAP_FOR_0 + ((VERSION_TEST_FW_SOURCE & 0XF0) >> 4))
#else
#define STR_VERSION_TEST_FW_SOURCE_HI (ASCII_MAP_FOR_7 + ((VERSION_TEST_FW_SOURCE & 0XF0) >> 4))
#endif

#if ((VERSION_TEST_FW_SOURCE & 0XF) < 10)
#define STR_VERSION_TEST_FW_SOURCE_LO (ASCII_MAP_FOR_0 + (VERSION_TEST_FW_SOURCE & 0XF))
#else
#define STR_VERSION_TEST_FW_SOURCE_LO (ASCII_MAP_FOR_7 + (VERSION_TEST_FW_SOURCE & 0XF))
#endif

#if (((VERSION_TEST_FW_NUM & 0XF0)>>4) < 10)
#define STR_VERSION_TEST_FW_NUM_HI (ASCII_MAP_FOR_0 + ((VERSION_TEST_FW_NUM & 0XF0) >> 4))
#else
#define STR_VERSION_TEST_FW_NUM_HI (ASCII_MAP_FOR_7 + ((VERSION_TEST_FW_NUM & 0XF0) >> 4))
#endif

#if ((VERSION_TEST_FW_NUM & 0XF) < 10)
#define STR_VERSION_TEST_FW_NUM_LO (ASCII_MAP_FOR_0 + (VERSION_TEST_FW_NUM & 0XF))
#else
#define STR_VERSION_TEST_FW_NUM_LO (ASCII_MAP_FOR_7 + (VERSION_TEST_FW_NUM & 0XF))
#endif

//XDSLRTFW-3364 (End)


#endif  /* __VER_ONLINE_H */
