/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2004 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "PLL_hw.h"
** CCASE_DATE = "Thu Apr 14 09:41:54 2005"
**
** =============================================================================
**
** Project:    <project/component name>
** Block:      <block/module name>
**
** =============================================================================
**
** Contents:   <short description of what is in the file>
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date         Author        Comment
** YYYY-MM-DD   <name>        <reason for change>
** =============================================================================
Additional version control information
********************************************************************************
 CCASE_USER    = "Kumar"
 CCASE_VERSION = "\main\5"
***C*E*************************************************************************/


#ifndef PLL_HW_H  /* protect */
#define PLL_HW_H

/*
** =============================================================================
**                           DEFINITIONS
** =============================================================================
*/

#define  PLL_OSCCFG_REG    (PLL_MEMORY_MAP + 0x00)    // Oscillator Configuration register

#define  PLL_OSCCFG_RegRead()       *((volatile uint_32 *)(PLL_OSCCFG_REG))
#define  PLL_OSCCFG_RegWrite(VAL)   *((volatile uint_32 *)(PLL_OSCCFG_REG)) = VAL

#define  PLL_PLLACFG_REG   (PLL_MEMORY_MAP + 0x04)    // PLL A Configuration register

#define  PLL_PLLACFG_RegRead()       *((volatile uint_32 *)(PLL_PLLACFG_REG))
#define  PLL_PLLACFG_RegWrite(VAL)   *((volatile uint_32 *)(PLL_PLLACFG_REG)) = VAL

   #define  PLLACFG_N_M_VALUE       (0x00000500)      // N = 5, M = 0
   #define  PLLACFG_LOCKED          (0x00000002)
   #define  PLLACFG_SWCK_MASK       (0x0000000C)
   #define  PLLACFG_SWCK_SHIFT      (2)
   #define  SWCK_IP                 (0x0)
   #define  SWCK_FOUT               (0x1)
   #define  SWCK_FOSC               (0x2)
   #define  PLLACFG_PU_MASK         (0x00000001)

#define  PLL_PLLBCFG1_REG  (PLL_MEMORY_MAP + 0x08)    // PLL B Configuration register 1

#define  PLL_PLLBCFG1_RegRead()       *((volatile uint_32 *)(PLL_PLLBCFG1_REG))
#define  PLL_PLLBCFG1_RegWrite(VAL)   *((volatile uint_32 *)(PLL_PLLBCFG1_REG)) = VAL

   #define  PLLBCFG1_DIV_SETUP      (0x00510000)
   #define  PLLBCFG1_N_M_VALUE      (0x000032B0)
   #define  PLLBCFG1_LOCKED         (0x00000002)
   #define  PLLBCFG1_SWCK_MASK      (0x0000000C)
   #define  PLLBCFG1_SWCK_SHIFT     (2)
   #define  SWCK_IP                 (0x0)
   #define  SWCK_FOUT               (0x1)
   #define  SWCK_FOSC               (0x2)
   #define  PLLBCFG1_PU_MASK        (0x00000001)


#define  PLL_PLLBCFG2_REG  (PLL_MEMORY_MAP + 0x0C)    // PLL B Configuration register 2

#define  PLL_PLLBCFG2_RegRead()       *((volatile uint_32 *)(PLL_PLLBCFG2_REG))
#define  PLL_PLLBCFG2_RegWrite(VAL)   *((volatile uint_32 *)(PLL_PLLBCFG2_REG)) = VAL

   #define  PLLBCFG2_FRACEN         (0x00000001)
   #define  PLLBCFG2_SWEN           (0x00000002)
   #define  PLLBCFG2_AMPEN          (0x00000004)
   #define  PLLBCFG2_PHDIVEN        (0x00000008)
   #define  PLLBCFG2_MSCSSEL        (0x00000100)
   #define  PLLBCFG2_VCOSEL         (0x00000200)
   #define  PLLBCFG2_PLLADJ         (0x00000000)
   #define  PLLB_CFG_K_VALUE        (0x01380000)


#define  PLL_PDLLSTA_REG   (PLL_MEMORY_MAP + 0x10)    // PLLs Unlock Status register

#define  PLL_CHIPCFG_REG   (PLL_MEMORY_MAP + 0x40)    // Chip Configuration register

#define  PLL_CHIPCFG_RegRead()      *((volatile uint_32 *)(PLL_CHIPCFG_REG))
#define  PLL_CHIPCFG_RegWrite(VAL)  *((volatile uint_32 *)(PLL_CHIPCFG_REG)) = VAL

   #define  CHIPCFG_TEST_MASK       (0x80000000)
   #define  CHIPCFG_RDI_MASK        (0x40000000)
   #define  CHIPCFG_JTSEL_MASK      (0x01000000)
   #define  CHIPCFG_MEMODE_MASK     (0x00300000)
   #define  CHIPCFG_HW_VER_MASK     (0x00070000)
   #define  CHIPCFG_CHIP_ID_MASK    (0x0000F800)
   #define  CHIPCFG_CHIP_ID_SHIFT   (11)
   #define  CHIPCFG_CHIPMST_MASK    (0x00000400)
   #define  CHIPCFG_CHIPMST_SHIFT   (10)
   #define  CHIPCFG_BTCFG_MASK      (0x000001E0)
   #define  CHIPCFG_BTCFG_SHIFT     (5)
   #define  CHIPCFG_VPHYMAC_MASK    (0x00000010)
   #define  CHIPCFG_PHYMAC_MASK     (0x00000008)
   #define  CHIPCFG_TCCONF_MASK     (0x00000007)

   #define  CHIP_ID_MSTRBIT         (0x00000001)

#define  PLL_XTCCFG_REG    (PLL_MEMORY_MAP + 0x80)    // XTC Configuration register

#define  PLL_PPCR1_REG     (PLL_MEMORY_MAP + 0x84)    // POSPHY Pad Configuration register 1
#define  PLL_PPCR1_RegRead()      *((volatile uint_32 *)(PLL_PPCR1_REG))
#define  PLL_PPCR1_RegWrite(VAL)  *((volatile uint_32 *)(PLL_PPCR1_REG)) = VAL

#define  PLL_PPCR2_REG     (PLL_MEMORY_MAP + 0x88)    // POSPHY Pad Configuration register 2
#define  PLL_PPCR2_RegRead()      *((volatile uint_32 *)(PLL_PPCR2_REG))
#define  PLL_PPCR2_RegWrite(VAL)  *((volatile uint_32 *)(PLL_PPCR2_REG)) = VAL

#define  PLL_PDSCR_REG     (PLL_MEMORY_MAP + 0x8C)    // Pad Drive Slope Configuration register
#define  PLL_PDSCR_RegRead()      *((volatile uint_32 *)(PLL_PDSCR_REG))
#define  PLL_PDSCR_RegWrite(VAL)  *((volatile uint_32 *)(PLL_PDSCR_REG)) = VAL

   #define  VALID_SRAM_FLAG        (0x10000000)

/*
** =============================================================================
**                           TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  <function_name>
**
** DESCRIPTION:    <description of what the function does>
**
** PARAMETERS:     <par_name_1>    [IN]|[OUT] <description of par_1>
**                 ...
**                 <par_name_n>    [IN]|[OUT] <description of par_n>
**
** RETURN VALUE:   <description of the return value if any>
**
** NOTES:          <any special information>
** =============================================================================
*/


#endif /* protect */
