/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2004 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "VDSL2_MemoryMap.h"
** CCASE_DATE = "Fri Jan 21 15:15:59 2005"
**
** =============================================================================
**
** Project:    <project/component name>
** Block:      <block/module name>
**
** =============================================================================
**
** Contents:   <short description of what is in the file>
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date         Author        Comment
** YYYY-MM-DD   <name>        <reason for change>
** =============================================================================
Additional version control information
********************************************************************************
 CCASE_USER    = "wood"
 CCASE_VERSION = "\main\1"
***C*E*************************************************************************/


#ifndef VDSL2_MEMORYMAP_H  /* protect */
#define VDSL2_MEMORYMAP_H

/*
** =============================================================================
**                           DEFINITIONS
** =============================================================================
*/

   #define  INST_MEM_BEGIN                   (0x00000000)
   #define  INST_MEM_END                     (0x0001BFFF)

   #define  INST_BULK_MEM_BEGIN              (0x0001C000)
   #define  INST_BULK_MEM_END                (0x0001FFFF)

   #define  BULK_DATA_MEM_BEGIN              (0x00020000)
   #define  BULK_DATA_MEM_END                (0x00025FFF)

   #define  X_MEM_BEGIN                      (0x0002A000)
   #define  X_MEM_END                        (0x0002BFFF)

   #define  Y_MEM_BEGIN                      (0x0002C000)
   #define  Y_MEM_END                        (0x0002DFFF)

   #define  DMT_ENGINE_MEM_BEGIN             (0x00030000)
   #define  DMT_ENGINE_MEM_END               (0x000B6FFF)

   #define  XTC_REG_BEGIN                    (0x000C0000)
   #define  XTC_REG_END                      (0x000DBFFF)

   #define  IFX_PER_MOD_REG_BEGIN            (0x000E0000)
   #define  IFX_PER_MOD_REG_END              (0x000EFFFF)

   #define  INST_ROM_BEGIN                   (0x000F0000)
   #define  INST_ROM_END                     (0x000F3FFF)

   #define  LOCAL_LD_ST_MEM_BEGIN            (0x000FE000)
   #define  LOCAL_LD_ST_MEM_END              (0x000FFFFF)

   /*
    * The following defines are for the MEI mailboxes, the defines were
    * taken from the hercules_memrymap.h which does not match the HW
    * design spec (address mapping) and the system spec (mailbox size).
    *
    * These defines need to be modified when the information about the
    * mailbox size and location are available.
    */

   // NEWMP_MBOX_SIZE is in 16-bit words.
#if 1
   #define  NEWMP_MBOX_SIZE                  (32)
   #define  MAILBOX_CODE_OFFSET              (44)
#else
   #define  NEWMP_MBOX_SIZE                  (16)
   #define  MAILBOX_CODE_OFFSET              (28)
#endif

   #define  MEI_TO_ARC_MAILBOX_LOC_0_ADDR    (BULK_DATA_MEM_BEGIN)
   #define  MEI_TO_ARC_MAILBOX_CODE_ADDR     (MEI_TO_ARC_MAILBOX_LOC_0_ADDR + MAILBOX_CODE_OFFSET)
   #define  ARC_TO_MEI_MAILBOX_LOC_0_ADDR    (BULK_DATA_MEM_BEGIN + 2*NEWMP_MBOX_SIZE)
   #define  ARC_TO_MEI_MAILBOX_CODE_ADDR     (ARC_TO_MEI_MAILBOX_LOC_0_ADDR + MAILBOX_CODE_OFFSET)

   #define  BULK_DATA_MEM_FREE               (BULK_DATA_MEM_BEGIN + 2*2*NEWMP_MBOX_SIZE)

    // will used a small block at the end of BULK for MEI mailboxes.


   /*
    * IFX Peripheral memory map (0x000E0000 - 0x000EFFFF)
    */
   #define  PLL_MEMORY_MAP                   (IFX_PER_MOD_REG_BEGIN + 0x2000)
   #define  LVDS_MEMORY_MAP                  (IFX_PER_MOD_REG_BEGIN + 0x4000)
   #define  SPI_MEMORY_MAP                   (IFX_PER_MOD_REG_BEGIN + 0x6000)
   #define  TIME_MEMORY_MAP                  (IFX_PER_MOD_REG_BEGIN + 0x8000)
   #define  GPIO_MEMORY_MAP                  (IFX_PER_MOD_REG_BEGIN + 0xA000)

/*
** =============================================================================
**                           TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  <function_name>
**
** DESCRIPTION:    <description of what the function does>
**
** PARAMETERS:     <par_name_1>    [IN]|[OUT] <description of par_1>
**                 ...
**                 <par_name_n>    [IN]|[OUT] <description of par_n>
**
** RETURN VALUE:   <description of the return value if any>
**
** NOTES:          <any special information>
** =============================================================================
*/


#endif /* protect */
