/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2004 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "aux_regs.h"
** CCASE_DATE = "Fri Mar  4 19:46:17 2005"
**
** =============================================================================
**
** Project:    <project/component name>
** Block:      <block/module name>
**
** =============================================================================
**
** Contents:   <short description of what is in the file>
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date         Author        Comment
** YYYY-MM-DD   <name>        <reason for change>
** =============================================================================
Additional version control information
********************************************************************************
 CCASE_USER    = "Kumar"
 CCASE_VERSION = "\main\5"
***C*E*************************************************************************/


#ifndef AUX_REGS_H  /* protect */
#define AUX_REGS_H

/*
** =============================================================================
**                           DEFINITIONS
** =============================================================================
*/

#define  AUX_STATUS_REG                   0x0000
#define  AUX_STATUS_PC_MASK               0x00FFFFFF

#define  AUX_SEMAPHORE_REG                0x0001
#define  AUX_LP_START_REG                 0x0002
#define  AUX_LP_END_REG                   0x0003
#define  AUX_IDENTITY_REG                 0x0004
#define  AUX_DEBUG_REG                    0x0005

/*
 * Extended Auxiliary Registers
 */

#define  AUX_ARC_ADMA_CTRL_REG            0x0100   // ARC4 DMA Control

#define  AUX_ARC_ADMA_CTRL_RegRead()      _lr(AUX_ARC_ADMA_CTRL_REG)
#define  AUX_ARC_ADMA_CTRL_RegWrite(VAL)  _sr(VAL, AUX_ARC_ADMA_CTRL_REG)

   #define  ARC_ADMA_CTRL_FILL_MASK       (0x00000004)
   #define  ARC_ADMA_CTRL_STOP_MASK       (0x00000002)
   #define  ARC_ADMA_CTRL_START_MASK      (0x00000001)

#define  AUX_ARC_ADMA_STAT_REG            0x0101   // ARC4 DMA Status

#define  AUX_ARC_ADMA_STAT_RegRead()      _lr(AUX_ARC_ADMA_STAT_REG)
#define  AUX_ARC_ADMA_STAT_RegWrite(VAL)  _sr(VAL, AUX_ARC_ADMA_STAT_REG)

   #define  ARC_ADMA_STAT_DONE_MASK       (0x00000004)
   #define  ARC_ADMA_STAT_ERR_MASK        (0x00000002)
   #define  ARC_ADMA_STAT_PROC_MASK       (0x00000001)

#define  AUX_ARC_ADMA_SAD_S_REG           0x0102   // ARC4 DMA Source Start Address

#define  AUX_ARC_ADMA_SAD_S_RegRead()     _lr(AUX_ARC_ADMA_SAD_S_REG)
#define  AUX_ARC_ADMA_SAD_S_RegWrite(VAL) _sr(VAL, AUX_ARC_ADMA_SAD_S_REG)

#define  AUX_ARC_ADMA_DAD_S_REG           0x0103   // ARC4 DMA Destination Start Address

#define  AUX_ARC_ADMA_DAD_S_RegRead()     _lr(AUX_ARC_ADMA_DAD_S_REG)
#define  AUX_ARC_ADMA_DAD_S_RegWrite(VAL) _sr(VAL, AUX_ARC_ADMA_DAD_S_REG)

#define  AUX_ARC_ADMA_SAD_E_REG           0x0104   // ARC4 DMA Source End Address

#define  AUX_ARC_ADMA_SAD_E_RegRead()     _lr(AUX_ARC_ADMA_SAD_E_REG)
#define  AUX_ARC_ADMA_SAD_E_RegWrite(VAL) _sr(VAL, AUX_ARC_ADMA_SAD_E_REG)

#define  AUX_ARC_ADMA_FILL_REG            0x0105   // ARC4 DMA Programmable Fill Value

#define  AUX_ARC_ADMA_FILL_RegRead()      _lr(AUX_ARC_ADMA_FILL_REG)
#define  AUX_ARC_ADMA_FILL_RegWrite(VAL)  _sr(VAL, AUX_ARC_ADMA_FILL_REG)

#define  AUX_ARC_ARC2ME_INT_REG           0x0106   // MEI Control Interrupt from the ARC4 to the MEI

#define  AUX_ARC_ARC2ME_INT_RegRead()     _lr(AUX_ARC_ARC2ME_INT_REG)
#define  AUX_ARC_ARC2ME_INT_RegWrite(VAL) _sr(VAL, AUX_ARC_ARC2ME_INT_REG)

#define  AUX_ARC_ARC2ME_STAT_REG          0x0107   // MEI Control Status from the ARC4 to the MEI

#define  AUX_ARC_ARC2ME_STAT_RegRead()     _lr(AUX_ARC_ARC2ME_STAT_REG)
#define  AUX_ARC_ARC2ME_STAT_RegWrite(VAL) _sr(VAL, AUX_ARC_ARC2ME_STAT_REG)

   #define  ARC_ARC2ME_MSGAV_MASK         (0x00000001)    // bit-0
   #define  ARC_ARC2ME_GPINT0_MASK        (0x00000002)    // bit-1
   #define  ARC_ARC2ME_GPINT1_MASK        (0x00000004)    // bit-2
   #define  ARC_ARC2ME_VALID_MASK         (0x00000007)    // bits 0-2

#define  AUX_ARC_INT_MASK_REG             0x0108   // ARC4 General Interrupt Mask Register

#define  AUX_ARC_INT_MASK_RegRead()       _lr(AUX_ARC_INT_MASK_REG)
#define  AUX_ARC_INT_MASK_RegWrite(VAL)   _sr(VAL, AUX_ARC_INT_MASK_REG)

#define  AUX_ARC_INT_STAT_REG             0x0109   // ARC4 General Interrupt Status Register

#define  AUX_ARC_INT_STAT_RegRead()       _lr(AUX_ARC_INT_STAT_REG)
#define  AUX_ARC_INT_STAT_RegWrite(VAL)   _sr(VAL, AUX_ARC_INT_STAT_REG)

   #define  ARC_INT_MSGAV_MASK            (0x00000004)    // bit-2
   #define  ARC_INT_GP_INT_MASK           (0x00000008)    // bit-3
   #define  ARC_INT_CS_DONE_MASK          (0x00000010)    // bit-4
   #define  ARC_INT_XDSL1_MASK            (0x00000020)    // bit-5
   #define  ARC_INT_XDSL2_MASK            (0x00000040)    // bit-6
   #define  ARC_INT_XDSLx_MASK            (0x00000060)    // bit-5 and bit-6
   #define  ARC_INT_PERI_MASK             (0x00000080)    // bit- 7
   #define  ARC_INT_ALL_MASK              (0x000000FF)    // bit-0 to bit-10
   #define  ARC_INT_VALID_MASK            (0x000003FF)    // bit-0 to bit-10

#define  AUX_ARC_XMEM_INT_MASK_REG        0x010a   // ARC4 External Memory Interrupt Mask Register

#define  AUX_ARC_XMEM_INT_MASK_RegRead()       _lr(AUX_ARC_XMEM_INT_MASK_REG)
#define  AUX_ARC_XMEM_INT_MASK_RegWrite(VAL)   _sr(VAL, AUX_ARC_XMEM_INT_MASK_REG)

#define  AUX_ARC_XMEM_INT_STAT_REG        0x010b   // ARC4 External Memory Interrupt Status Register

#define  AUX_ARC_XMEM_INT_STAT_RegRead()       _lr(AUX_ARC_XMEM_INT_STAT_REG)
#define  AUX_ARC_XMEM_INT_STAT_RegWrite(VAL)   _sr(VAL, AUX_ARC_XMEM_INT_STAT_REG)

   #define  ARC_XMEM_INT_XMA_MASK         (0x00000001)   // XMA interrupt
   #define  ARC_XMEM_INT_WDOG_MASK        (0x00000002)   // Watchdog Timer interrupt
   #define  ARC_XMEM_INT_XDMA_MASK        (0x00000004)   // XDMA complete interrupt
   #define  ARC_XMEM_INT_VALID_MASK       (0x00000007)

#define  AUX_ARC_GPIO_CTRL_REG            0x010c   // General Purpose I/O Control Register

#define  AUX_ARC_GPIO_CTRL_RegRead()      _lr(AUX_ARC_GPIO_CTRL_REG)
#define  AUX_ARC_GPIO_CTRL_RegWrite(VAL)  _sr(VAL, AUX_ARC_GPIO_CTRL_REG)

#define  AUX_ARC_GPIO_DATA_REG            0x010d   // General Purpose I/O Data Register

#define  AUX_ARC_GPIO_DATA_RegRead()      _lr(AUX_ARC_GPIO_DATA_REG)
#define  AUX_ARC_GPIO_DATA_RegWrite(VAL)  _sr(VAL, AUX_ARC_GPIO_DATA_REG)

/*
 * The General purpose status register fields are
 * to be defined (check with AWARE which bits are
 * used) for IFX purposes. Only bits 0 - 15 can
 * be used.
 */
#define  AUX_ARC_GP_STAT_REG              0x010e   // ARC4 General Purpose Status to MEI

#define  AUX_ARC_GP_STAT_RegRead()        _lr(AUX_ARC_GP_STAT_REG)
#define  AUX_ARC_GP_STAT_RegWrite(VAL)    _sr(VAL, AUX_ARC_GP_STAT_REG)

#define  AUX_ARC_ME_CONFIG_REG            0x010f   // Read-only configuration register from MEI

#define  AUX_ARC_ME_CONFIG_RegRead()      _lr(AUX_ARC_ME_CONFIG_REG)
#define  AUX_ARC_ME_CONFIG_RegWrite(VAL)  _sr(VAL, AUX_ARC_ME_CONFIG_REG)

   #define  ARC_ME_CONFIG_INT_LEVEL_MASK  (0x00000001)
   #define  ARC_ME_CONFIG_BMSTR_MASK      (0x00000002)
   #define  ARC_ME_CONFIG_CHIP_ID_MASK    (0x0000007C)
   #define  ARC_ME_CONFIG_CHIP_ID_SHIFT   (2)
   #define  ARC_ME_CONFIG_NO_DX_ACC_MASK  (0x00000080)

#define  AUX_ARC_XMEM_ARB_REG             0x0110   // Memory Arbitration Parameter Control Register

#define  AUX_ARC_XMEM_ARB_RegRead()       _lr(AUX_ARC_XMEM_ARB_REG)
#define  AUX_ARC_XMEM_ARB_RegWrite(VAL)   _sr(VAL, AUX_ARC_XMEM_ARB_REG)

   #define  ARC_XMEM_ARB_ARB_EN_MASK      (0x00000001)
   #define  ARC_XMEM_ARB_BMSTR_STAT_MASK  (0x00000002)
   #define  ARC_XMEM_ARB_MLOCK_MASK       (0x00000004)
   #define  ARC_XMEM_ARB_DNP_BG_MASK      (0x00000008)
   #define  ARC_XMEM_ARB_ASSERT_BGO_MASK  (0x00000010)

#define  AUX_ARC_XMEM_AP_MAX_REG          0x0111   // Memory Access Period Maximum Count Register

#define  AUX_ARC_AP_MAX_RegRead()         _lr(AUX_ARC_XMEM_AP_MAX_REG)
#define  AUX_ARC_AP_MAX_RegWrite(VAL)     _sr(VAL, AUX_ARC_XMEM_AP_MAX_REG)

#define  AUX_ARC_XMEM_AP_CUR_REG          0x0112   // Memory Access Period Current Count Register

#define  AUX_ARC_XMEM_AP_CUR_RegRead()      _lr(AUX_ARC_XMEM_AP_CUR_REG)
#define  AUX_ARC_XMEM_AP_CUR_RegWrite(VAL)  _sr(VAL, AUX_ARC_XMEM_AP_CUR_REG)

   #define  ARC_XMEM_AP_CUR_CNT_MASK      (0x0003FFFF)
   #define  ARC_XMEM_AP_CUR_OWNER_MASK    (0x00040000)

#define  AUX_ARC_XMEM_CTL_REG             0x0113   // Memory Configuration Control Register

#define  AUX_ARC_XMEM_CTL_RegRead()       _lr(AUX_ARC_XMEM_CTL_REG)
#define  AUX_ARC_XMEM_CTL_RegWrite(VAL)   _sr(VAL, AUX_ARC_XMEM_CTL_REG)

   #define  ARC_XMEM_CTL_WS2_MASK         (0x0000001F)
   #define  ARC_XMEM_CTL_WS2_SHIFT        (0)
   #define  ARC_XMEM_CTL_DW_MASK          (0x00000020)
   #define  ARC_XMEM_CTL_AW_MASK          (0x000000C0)
      #define  AW_18_BIT_WIDE             (0x00)
      #define  AW_19_BIT_WIDE             (0x40)
      #define  AW_20_BIT_WIDE             (0x80)
     #define  AW_21_BIT_WIDE             (0xC0)
   #define  ARC_XMEM_CTL_WS1_MASK         (0x00001F00)
   #define  ARC_XMEM_CTL_WS1_SHIFT        (8)

#define  AUX_ARC_XMEM_WDOG_REG            0x0114   // Memory Watchdog Timer Control Register

#define  AUX_ARC_XMEM_WDOG_RegRead()      _lr(AUX_ARC_XMEM_WDOG_REG)
#define  AUX_ARC_XMEM_WDOG_RegWrite(VAL)  _sr(VAL, AUX_ARC_XMEM_WDOG_REG)

   #define  ARC_XMEM_WDOG_WD_MAX_MASK     (0x003FFFFF)
   #define  ARC_XMEM_WDOG_WD_EN_MASK      (0x00400000)

#define  AUX_ARC_XMEM_WTMR_REG            0x0115   // Memory Watchdog Timer Value Register

#define  AUX_ARC_XMEM_WTMR_RegRead()      _lr(AUX_ARC_XMEM_WTMR_REG)
#define  AUX_ARC_XMEM_WTMR_RegWrite(VAL)  _sr(VAL, AUX_ARC_XMEM_WTMR_REG)

   #define  ARC_XMEM_WTMR_WD_CNT_MASK     (0x003FFFFF)

#define  AUX_ARC_XMEM_BUS_RST_REG         0x0116   // Memory Arbitrated Bus Reset Register

#define  AUX_ARC_XMEM_BUS_RST_RegRead()      _lr(AUX_ARC_XMEM_BUS_RST_REG)
#define  AUX_ARC_XMEM_BUS_RST_RegWrite(VAL)  _sr(VAL, AUX_ARC_XMEM_BUS_RST_REG)

   #define  ARC_XMEM_BUS_RST_BG_SRST_MASK (0x00000001)

#define  AUX_ARC_XMEM_XCTRL_REG           0x0117   // XDMA Control Register

#define  AUX_ARC_XMEM_XCTRL_RegRead()     _lr(AUX_ARC_XMEM_XCTRL_REG)
#define  AUX_ARC_XMEM_XCTRL_RegWrite(VAL) _sr(VAL, AUX_ARC_XMEM_XCTRL_REG)

   #define  ARC_XMEM_XCTRL_EN_MASK        (0x00000001)
   #define  ARC_XMEM_XCTRL_DIR_MASK       (0x00000002)
   #define  ARC_XMEM_XCTRL_AP_HOLD_MASK   (0x00000004)
   #define  ARC_XMEM_XCTRL_LOCK_MASK      (0x00000FF0)

#define  AUX_ARC_XMEM_XSTAT_REG           0x0118   // XDMA Status Register

#define  AUX_ARC_XMEM_XSTAT_RegRead()     _lr(AUX_ARC_XMEM_XSTAT_REG)
#define  AUX_ARC_XMEM_XSTAT_RegWrite(VAL) _sr(VAL, AUX_ARC_XMEM_XSTAT_REG)

   #define  ARC_XMEM_XSTAT_DONE_MASK      (0x00000001)
   #define  ARC_XMEM_XSTAT_ACT_MASK       (0x00000002)
   #define  ARC_XMEM_XSTAT_XERR_MASK      (0x00000004)
   #define  ARC_XMEM_XSTAT_LKERR_MASK     (0x00000008)
   #define  ARC_XMEM_XSTAT_APH_MASK       (0x00000010)
   #define  ARC_XMEM_XSTAT_BRDET_MASK     (0x00000020)

#define  AUX_ARC_XMEM_SSADR_REG           0x0119   // XDMA Source Start Address Register

#define  AUX_ARC_XMEM_SSADR_RegRead()     _lr(AUX_ARC_XMEM_SSADR_REG)
#define  AUX_ARC_XMEM_SSADR_RegWrite(VAL) _sr(VAL, AUX_ARC_XMEM_SSADR_REG)

#define  AUX_ARC_XMEM_SEADR_REG           0x011a   // XDMA Source End Address Register

#define  AUX_ARC_XMEM_SEADR_RegRead()     _lr(AUX_ARC_XMEM_SEADR_REG)
#define  AUX_ARC_XMEM_SEADR_RegWrite(VAL) _sr(VAL, AUX_ARC_XMEM_SEADR_REG)

#define  AUX_ARC_XMEM_DSADR_REG           0x011b   // XDMA Destination Start Address Register

#define  AUX_ARC_XMEM_DSADR_RegRead()     _lr(AUX_ARC_XMEM_DSADR_REG)
#define  AUX_ARC_XMEM_DSADR_RegWrite(VAL) _sr(VAL, AUX_ARC_XMEM_DSADR_REG)

#define  AUX_ARC_PER_ENA_REG              0x011c   // Peripheral Bus Enable

#define  AUX_ARC_PER_ENA_RegRead()        _lr(AUX_ARC_PER_ENA_REG)
#define  AUX_ARC_PER_ENA_RegWrite(VAL)    _sr(VAL, AUX_ARC_PER_ENA_REG)

   #define  ARC_PER_ENABLE_MASK           (0x00000001)

#define  AUX_ARC_XMEM_MODE_REG            0x011d   // External Memory Mode

#define  AUX_ARC_XMEM_MODE_RegRead()      _lr(AUX_ARC_XMEM_MODE_REG)
#define  AUX_ARC_XMEM_MODE_RegWrite(VAL)  _sr(VAL, AUX_ARC_XMEM_MODE_REG)

   #define  ARC_XMEM_MODE_FD_MASK            (0x00000001)
   #define  ARC_XMEM_MODE_EXT_SRAM_MASK      (0x00000002)
   #define  ARC_XMEM_MODE_NO_GRANT_ACC_MASK  (0x00000004)

#define  AUX_ARC_XDSL_MTM_REG             0x011e   // XDSL Memory Test Mode

#define  AUX_ARC_XDSL_MTM_RegRead()       _lr(AUX_ARC_XDSL_MTM_REG)
#define  AUX_ARC_XDSL_MTM_RegWrite(VAL)   _sr(VAL, AUX_ARC_XDSL_MTM_REG)

/*
** =============================================================================
**                           TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  <function_name>
**
** DESCRIPTION:    <description of what the function does>
**
** PARAMETERS:     <par_name_1>    [IN]|[OUT] <description of par_1>
**                 ...
**                 <par_name_n>    [IN]|[OUT] <description of par_n>
**
** RETURN VALUE:   <description of the return value if any>
**
** NOTES:          <any special information>
** =============================================================================
*/


#endif /* protect */
