/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2000 Infineon Technologies AG.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/* =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies AG. Passing on and copying of this document, and communication
** of its contents is not permitted without prior written authorisation.
**
** =============================================================================
*/

/* =============================================================================
**
** Revision Information :
** CCASE_FILE    = "xdma_io.h"
** CCASE_VERSION = "\main\11"
** CCASE_DATE    = "Fri Mar 11 12:00:17 2005"
** CCASE_USER    = "Kumar"
**
** =============================================================================
**
** CCASE_HWPROJECT = ""
** Block           = <block/module name>
**
** =============================================================================
** Contents: <Short but complete description of what is in the file.>
**
** <e.g.:
** This file contains all SDL-operators (= C-functions). List of functions
** (in order of their appearance in the file):>
**
** =============================================================================
** References: <List of design documents covering this file.>
**
** =============================================================================
** History:
**
** Date        Author    Comment
** YYYY-MM-DD  <author>  reason for new version
** =============================================================================
*/

#ifndef __XDMA_IO_H
#define __XDMA_IO_H

/*
** =============================================================================
**                           DEFINITIONS
** =============================================================================
*/

/* SRAM Adresses */
#define SRAM_START           (0x00000000)
#define SRAM_MEMCFG_START    (0x00000004)


/* Boot flag */
#define BOOT_FLAG       (0x80000000)
#define BOOT_FLAG_MASK     (0x7FFFFFFF)

/* Defines to identify data or program */
#define GET_DATA        1
#define GET_PROGRAM        0

/* Maximum size of a download page */
#define MAX_ARC_PAGE_SIZE     (7 * 4 * 1024 * sizeof(sint_32))
#define XDMA_TRUE            1
#define XDMA_FALSE           0

/* XDMA transfer direction */
#define BM_TO_SRAM           (ARC_XMEM_XCTRL_DIR_MASK)
#define SRAM_TO_BM           (0x00000000)

/* No of wait states for on chip SRAM */
#define WAIT_STATES_OCRAM    (0)

/* Invalidate pattern */
#define INVALIDATE_PATTERN   (0xFFFFFFFF)

/* Valid patterns */
#define VALID_8BIT_PATTERN   (0x76543210)
#define VALID_16BIT_PATTERN  (0x76540123)

/*
** =============================================================================
**                           TYPES
** =============================================================================
*/

/* Page Structure Type*/
typedef struct _codepage
{
   uint_32  p_offset;   // Offset from beginning of file for program segment
   uint_32  p_dest;  // Socrates load address for program segment
   uint_32  p_size;  // Size in bytes of program segment
   uint_32  d_offset;   // Ditto for data segment
   uint_32  d_dest;  // "
   uint_32  d_size;  // "
}CodePage_t;

/* FW Image header structure Type */
typedef struct _fw_image
{
   uint_32 size;
   uint_32 checksum;
   uint_32 count;    // Count of pages in binary images
}FW_ImageHdr_t;

/* memory configuration structure Type */
typedef struct _memcfg
{
   uint_8  xMEM_AddrWidth;
   uint_8  xMEM_DataWidth;
   uint_8  xMEM_WaitStates;
   uint_8  rsvd;
   uint_32 AccessPeriodLength;
   uint_32 WDOG_TimerMaster;
   uint_32 WDOG_TimerSlave;
}MemConfig_t;


/*
** =============================================================================
**                           FUNCTION PROTOTYPES
** =============================================================================
*/

void XDMA_SRAM_Init(uint_8 DataWidth, uint_8 NoWaitStates);
void XDMA_SRAM_Transfer(uint_32 SourceStartAddr, uint_32 Size, uint_32 DestAddr, uint_32 XMEM_DIR);
bool XDMA_TransferComplete();


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  <function_name>
**
** DESCRIPTION:    <description of what the function does>
**
** PARAMETERS:     <par_name_1>    [IN]|[OUT] <description of par_1>
**                 ...
**                 <par_name_n>    [IN]|[OUT] <description of par_n>
**
** RETURN VALUE:   <description of the return value if any>
**
** NOTES:          <any special information>
** =============================================================================
*/

#endif
