/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2004 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "test.c"
** CCASE_DATE = "Wed Jan 26 15:00:44 2005"
**
** =============================================================================
**
** Contents:   <short description of what is in the file>
**
** Functions:  <function name> - <short description>
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** YYY-MM-DD   <name>        <reason for change>
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "schmidch"
 CCASE_VERSION = "\main\3"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "BaseTypes.h"
#include "VDSL2_MemoryMap.h"
#include "aux_regs.h"
#include "ocmem_regs.h"
#include "xdma_io.h"
#include "PLL_hw.h"
#include "sram_test.h"


/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/
/* Default paramters for memory access*/
#define TEST_ACCESS_PERIOD         (0x0000FFFF)
#define TEST_WD_TIMER_SLAVE        (0x003FFFFF)
#define EXT_SRAM_MAX_ADDR          (0x003FFFFC)
/* For 8 DFE's */
#define INT_SRAM_MAX_ADDR          (0x001BFFFE)
//#define INT_SRAM_MAX_ADDR          (0x0006FFFE)
/* For 1 DFE */
//#define INT_SRAM_MAX_ADDR          (0x00037FFE)
/* For 4 DFE's */
//#define INT_SRAM_MAX_ADDR          (0x000DFFFE)
#define EXT_SRAM                   (0x00000001)
#define INT_SRAM                   (0x00000000)
#define PASS                       (0x600D)
#define FAIL                       (0x0BAD)

/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           GLOBAL DATA
** =============================================================================
*/

uint_32      SRAM_ReadData_1;
uint_32      SRAM_ReadData_2;

uint_32      SRAM_WriteData_1;
uint_32      SRAM_WriteData_2;

uint_32      SRAM_Addr;

uint_32      gt_ExtSRAM_WrData;
uint_32      gt_IntSRAM_WrData;
uint_32      gt_ExtSRAM_RdData;
uint_32      gt_IntSRAM_RdData;

sint_32      gt_ExtSRAM_Addr;
sint_32      gt_IntSRAM_Addr;

SRAM_test_t  SRAM_Test;
uint_16      SRAM_TestResult;

static bool    ModemMaster;
static uint_32 ModemID;
static uint_32 SRAM_MaxAddr;

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  sint_16 SRAM_IntExtTest(uint_32 Type_of_SRAM)
**
** DESCRIPTION:    Complete SRAM test with bus arbitration
**                 Type_of_SRAM : To choose the type of SRAM -INT_SRAM/EXT_SRAM
**
** PROCESSING:     <brief description of the function's algorithm or logic
**                  if required. The description should not re-state code.
**                  If no added value then drop the description>
**
** RETURN VALUE:   returns 0 if all memory locations are rightly accessable (read/write)
**                 else returns -1
**
** NOTES:          <any special information>
** =============================================================================
*/
sint_16 SRAM_IntExtTest(uint_32 Type_of_SRAM)
{

   bool status;
   uint_32  CHIPCFG_Val;

   /* Initialise the address and write data to 0 */
   SRAM_WriteData_1 = 0;
   SRAM_WriteData_2 = 0;
   SRAM_Addr =  0;

   CHIPCFG_Val = PLL_CHIPCFG_RegRead();

   /* Determine the chip ID */
   ModemID = (CHIPCFG_Val & CHIPCFG_CHIP_ID_MASK) >> CHIPCFG_CHIP_ID_SHIFT;

   /* Determine the master bit */
   ModemMaster = (CHIPCFG_Val & CHIPCFG_CHIPMST_MASK) ? FALSE : TRUE;


   /* Selection of Master or slave depending on the chip id and master bit*/
   if ((ModemMaster == TRUE) && ((ModemID & CHIP_ID_MSTRBIT) == 0))
   {
      AUX_ARC_ME_CONFIG_RegWrite(AUX_ARC_ME_CONFIG_RegRead()  | ARC_ME_CONFIG_BMSTR_MASK);
   }
   else
   {
      AUX_ARC_ME_CONFIG_RegWrite(AUX_ARC_ME_CONFIG_RegRead() & ~ARC_ME_CONFIG_BMSTR_MASK);
   }

   /* Initialisation of Memory chip controller */
   OCMEM_Init();

   if (Type_of_SRAM == EXT_SRAM)
   {
      /* Select external SRAM */
      OCMEM_SelectExtSRAM();
      SRAM_MaxAddr = EXT_SRAM_MAX_ADDR;
   }
   else
   {
      /* Select internal SRAM */
      OCMEM_SelectIntSRAM();
      SRAM_MaxAddr = INT_SRAM_MAX_ADDR;
   }

   /* Configure the default parameters (16 bit data, waitstates to 8) for memory controller for first access */
   XDMA_SRAM_Init(16,8);

   /* Set the default access period duration */
   AUX_ARC_AP_MAX_RegWrite(TEST_ACCESS_PERIOD);

   /* If MASTER */
   if ((AUX_ARC_ME_CONFIG_RegRead() & ARC_ME_CONFIG_BMSTR_MASK) == ARC_ME_CONFIG_BMSTR_MASK)
   {
      /* Start the bus arbitration and give the bus grant. */
      AUX_ARC_XMEM_ARB_RegWrite(AUX_ARC_XMEM_ARB_RegRead() | ARC_XMEM_ARB_ARB_EN_MASK
                                | ARC_XMEM_ARB_ASSERT_BGO_MASK);
   }
   else
   {
      /* Enable the arbitration and wait for the bus grant */
      AUX_ARC_XMEM_ARB_RegWrite(AUX_ARC_XMEM_ARB_RegRead() | ARC_XMEM_ARB_ARB_EN_MASK);
   }

   while (SRAM_Addr <= SRAM_MaxAddr-3)
   {
      SRAM_WriteData_1 = 0xAAAAAAAA;
      /* Write a pattern into SRAM */
      XDMA_SRAM_Transfer((uint_32)&SRAM_WriteData_1,(uint_32)4, (uint_32) SRAM_Addr, BM_TO_SRAM);
      do
      {
         status = XDMA_TransferComplete();
      }
      while (status == FALSE);

      /* Read a pattern from SRAM*/
      XDMA_SRAM_Transfer((uint_32)SRAM_Addr,(uint_32)4, (uint_32) &SRAM_ReadData_1, SRAM_TO_BM);
      do
      {
         status = XDMA_TransferComplete();
      }
      while (status == FALSE);

      /* Compare the two patterns */
      if (SRAM_ReadData_1 != SRAM_WriteData_1)
      {
         if (Type_of_SRAM == EXT_SRAM)
         {
            /* write the address not writable into global variable */
            gt_ExtSRAM_Addr = (sint_32)SRAM_Addr;
            gt_ExtSRAM_WrData = SRAM_WriteData_1;
            gt_ExtSRAM_RdData = SRAM_ReadData_1;
         }
         else
         {
            /* write the address not writable into global variable */
            gt_IntSRAM_Addr = (sint_32)SRAM_Addr;
            gt_IntSRAM_WrData = SRAM_WriteData_1;
            gt_IntSRAM_RdData = SRAM_ReadData_1;
         }
         return(-1);
      }

      SRAM_WriteData_2 = 0x55555555;
      /* Write a pattern into SRAM */
      XDMA_SRAM_Transfer((uint_32)&SRAM_WriteData_2,(uint_32)4, (uint_32) SRAM_Addr, BM_TO_SRAM);
      do
      {
         status = XDMA_TransferComplete();
      }
      while (status == FALSE);

      /* Read a pattern from SRAM*/
      XDMA_SRAM_Transfer((uint_32)SRAM_Addr,(uint_32)4, (uint_32) &SRAM_ReadData_2, SRAM_TO_BM);
      do
      {
         status = XDMA_TransferComplete();
      }
      while (status == FALSE);

      /* Compare the two patterns */
      if (SRAM_ReadData_2 != SRAM_WriteData_2)
      {
         if (Type_of_SRAM == EXT_SRAM)
         {
            /* write the address not writable into global variable */
            gt_ExtSRAM_Addr = (sint_32)SRAM_Addr;
            gt_ExtSRAM_WrData = SRAM_WriteData_2;
            gt_ExtSRAM_RdData = SRAM_ReadData_2;
         }
         else
         {
            /* write the address not writable into global variable */
            gt_IntSRAM_Addr = (sint_32)SRAM_Addr;
            gt_IntSRAM_WrData = SRAM_WriteData_1;
            gt_IntSRAM_RdData = SRAM_ReadData_1;
         }
         return(-1);
      }


      SRAM_Addr+= 4;
   }

   return(0);
}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  uint_16 SRAM_ArbitrationTest(uint_32 Type_of_SRAM)
**
** DESCRIPTION:    SRAM Arbitration Test routine for internal SRAM or External SRAM
**                 Type_of_SRAM : INT_SRAM
**                                EXT_SRAM
**
** PROCESSING:
**
**
**
** RETURN VALUE:   Returns the test result : Good(0x600D) or Bad(0x0bad)
**
** NOTES:          <any special information>
** =============================================================================
*/

uint_16 SRAM_ArbitrationTest(uint_32 Type_of_SRAM)
{

   uint_16 TestResult;
   uint_32  CHIPCFG_Val;
   uint_32  PLLACFG_Val;

   /* Initialise the global variables */
   TestResult = PASS;

   SRAM_Test.Ext_SRAM_Result = PASS;
   SRAM_Test.Ext_SRAM_AddrFail = -1;
   SRAM_Test.Int_SRAM_Result = PASS;
   SRAM_Test.Int_SRAM_AddrFail = -1;

   /*
    * Before anything can start the RDI bit in the CHIPCFG register
    * must be monitored until set (1) - indicates that the HW is ready.
    */
   do
   {
      CHIPCFG_Val = PLL_CHIPCFG_RegRead();
   }
   while ( (CHIPCFG_Val & CHIPCFG_RDI_MASK) == 0 );

   /*
    * HW initialized
    *
    * The PLL A must be programmed before proceeding.
    */
   PLL_PLLACFG_RegWrite(PLLACFG_N_M_VALUE | PLLACFG_PU_MASK);

   /*
    * Wait for the PLL locked this should be done in 200us.
    */

   do
   {
      PLLACFG_Val = PLL_PLLACFG_RegRead();
   }
   while ((PLLACFG_Val & PLLACFG_LOCKED) == 0);

   if ((PLL_PLLACFG_RegRead() & PLLACFG_LOCKED) == PLLACFG_LOCKED)
   {
      /*
      * Setup the PLL A clock selection - Fout is selected as output.
      */
      PLLACFG_Val  = PLL_PLLACFG_RegRead();
      PLLACFG_Val |= (SWCK_FOUT << PLLACFG_SWCK_SHIFT);
      PLL_PLLACFG_RegWrite( PLLACFG_Val );
   }


   if (Type_of_SRAM == INT_SRAM)   /* Internal SRAM test */
   {
      if (SRAM_IntExtTest(Type_of_SRAM) < 0)
      {
         SRAM_Test.Int_SRAM_Result = FAIL;
         SRAM_Test.Int_SRAM_AddrFail = gt_IntSRAM_Addr;
         TestResult = FAIL;
      }
   }
   else
   {
      if (SRAM_IntExtTest(Type_of_SRAM) < 0)   /* External SRAM Test */
      {
         SRAM_Test.Ext_SRAM_Result = FAIL;
         SRAM_Test.Ext_SRAM_AddrFail = gt_IntSRAM_Addr;
         TestResult = FAIL;
      }
   }

   return (TestResult);

}



void main(void)
{

   /* Run internal SRAM test */
   SRAM_TestResult = SRAM_ArbitrationTest(INT_SRAM);

}
