/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2004 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "xdma_io.c"
** CCASE_DATE = "Tue Apr 19 17:44:12 2005"
**
** =============================================================================
**
** Contents:   This file includes all the necessary XDMA transfer functions
**
** Functions:
** XDMA_SRAM_Init       : Initialises XDMA with data width and wait states
** XDMA_SRAM_Transfer   : Makes an XDMA transfer either from SRAM to bulk memory
**                        or vice versa
** XDMA_TransferComplete: This function checks for completion of XDMA transfer
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author              Comment
** 2005-01-01  Gaurav Kumar        <reason for change>
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "Kumar"
 CCASE_VERSION = "\main\21"
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "BaseTypes.h"
#include "VDSL2_MemoryMap.h"
#include "rom.h"
#include "aux_regs.h"
#include "ocmem_regs.h"
#include "xdma_io.h"
//#include "ME_Interface.h"
//#include "boot_messages.h"


/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           GLOBAL DATA
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   XDMA_SRAM_Init
**
** DESCRIPTION:    This function initialises the XDMA (data width and waitstates)
**
** PROCESSING:
**
** RETURN VALUE:   none
**
** NOTES:
** =============================================================================
*/
void XDMA_SRAM_Init(uint_8 DataWidth, uint_8 NoWaitStates)

{

   /* Configure the Data bitwidth waitstates according to the input parameters and address width to 21 bits*/
   if (DataWidth == 16)
   {
      AUX_ARC_XMEM_CTL_RegWrite(ARC_XMEM_CTL_DW_MASK
                                | (uint_32) AW_21_BIT_WIDE
                                | (uint_32) (NoWaitStates << ARC_XMEM_CTL_WS2_SHIFT)
                                | (uint_32) (NoWaitStates << ARC_XMEM_CTL_WS1_SHIFT));

   }
   else /* Default data Width set to 8 */
   {
      AUX_ARC_XMEM_CTL_RegWrite((uint_32) AW_21_BIT_WIDE
                                | (uint_32) (NoWaitStates << ARC_XMEM_CTL_WS2_SHIFT)
                                | (uint_32) (NoWaitStates << ARC_XMEM_CTL_WS1_SHIFT));
   }

}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   XDMA_SRAM_Transfer
**
** DESCRIPTION:    This intiates an XDMA transfer depending on the following input
**                 parameters
**                 SourceStartAddr : Source Start Address
**                 Size            : Size in bytes
**                 DestAddr        : Destination Address
**                 XMEM_DIR        : Transfer Direction
**                                   BM_TO_SRAM if data is to be transferred to SRAM
**                                   SRAM_TO BM id data is to be read from SRAM
**
** PROCESSING:     <brief description of the function's algorithm or logic
**                  if required. The description should not re-state code.
**                  If no added value then drop the description>
**
** RETURN VALUE:   <description of the return value if any>
**
** NOTES:          <any special information>
** =============================================================================
*/
void XDMA_SRAM_Transfer(uint_32 SourceStartAddr, uint_32 Size, uint_32 DestAddr, uint_32 XMEM_DIR)
{
   uint_32 SourceEndAddr;
   uint_32 ul_lockValue;

   if ((AUX_ARC_XMEM_XSTAT_RegRead() & ARC_XMEM_XSTAT_ACT_MASK) == 0) /* If XDMA is not active */
   {
      // setup the source start and end address, destination address, and start
      // the transfer.
      SourceEndAddr = SourceStartAddr + Size - 1;

      AUX_ARC_XMEM_SSADR_RegWrite(SourceStartAddr);
      AUX_ARC_XMEM_SEADR_RegWrite(SourceEndAddr);
      AUX_ARC_XMEM_DSADR_RegWrite(DestAddr);

   }

   /* To unlock the access to the XDMA control register */
   ul_lockValue = (~(AUX_ARC_XMEM_SEADR_RegRead()) & 0xFF) << 4;

   /* Enable the XDMA interrupt */
   AUX_ARC_XMEM_INT_MASK_RegWrite(ARC_XMEM_INT_XDMA_MASK);
   /* Enable the XDMA */
   AUX_ARC_XMEM_XCTRL_RegWrite(ul_lockValue | ARC_XMEM_XCTRL_EN_MASK | XMEM_DIR);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   XDMA_TransferComplete
**
** DESCRIPTION:    This function checks if the XDMA transfer is a success or fail
**
** PROCESSING:
**
** RETURN VALUE:   Returns TRUE if XDMA transfer is successful else returns FALSE
**
** NOTES:
** =============================================================================
*/

bool XDMA_TransferComplete()
{
   uint_32 ul_status;

   ul_status = AUX_ARC_XMEM_XSTAT_RegRead();

   /* If XDMA is ongoing */
   if ((ul_status & ARC_XMEM_XSTAT_ACT_MASK) == ARC_XMEM_XSTAT_ACT_MASK)

   {
      return(XDMA_FALSE);
   }

   /* If XDMA is stopped and completed succesfully */
   else if (((ul_status & ARC_XMEM_XSTAT_XERR_MASK) == 0) &&
            ((ul_status & ARC_XMEM_XSTAT_BRDET_MASK) == 0) &&
            ((ul_status & ARC_XMEM_XSTAT_DONE_MASK) == ARC_XMEM_XSTAT_DONE_MASK))
   {
      /* Clear the status register */
      AUX_ARC_XMEM_INT_STAT_RegWrite(ARC_XMEM_INT_XDMA_MASK);
      AUX_ARC_XMEM_XSTAT_RegWrite(AUX_ARC_XMEM_XSTAT_RegRead() | ARC_XMEM_XSTAT_DONE_MASK);

      return(XDMA_TRUE);
   }
   /* If XDMA is stopped and there was an XDMA error */
   else if (((ul_status & ARC_XMEM_XSTAT_XERR_MASK) == ARC_XMEM_XSTAT_XERR_MASK) &&
            ((ul_status & ARC_XMEM_XSTAT_DONE_MASK) == ARC_XMEM_XSTAT_DONE_MASK))
   {
      /* Clear the status register, DONE bit and ERR bit */
      AUX_ARC_XMEM_INT_STAT_RegWrite(ARC_XMEM_INT_XDMA_MASK);
      AUX_ARC_XMEM_XSTAT_RegWrite(AUX_ARC_XMEM_XSTAT_RegRead() | ARC_XMEM_XSTAT_DONE_MASK);

      /* stop the processor */
      _ASM("flag 1");
      _nop();
      _nop();

   }
   /* If bus reset occured when XDMA was not active */
   else if ((ul_status & ARC_XMEM_XSTAT_BRDET_MASK) == ARC_XMEM_XSTAT_BRDET_MASK)
   {
      /* stop the processor */
      _ASM("flag 1");
      _nop();
      _nop();
   }
   /* If XDMA was never started */
   else
   {
      return(XDMA_FALSE);
   }

}








