/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ComplexMult.c
*
*   This file contains function to calculate complex scalar multiplication.
*
*-------------------------------------------------------------------------------
*/

#include "common.h"
#include "gdata.h"
#include "dsp_op.h"

/*
*-------------------------------------------------------------------------------
*
*   Prototype: void ComplexMult(int32 *pla_Z, int16 *psa_X, int16 *psa_Y,
*      FlagT ft_conj_Y, int16 s_shift)
*
*   This function calculates complex multiplication.
*      Zr+jZi = (Xr+jXi)*(Yr+jYi)
*
*   Input Arguments:
*      psa_X: pointer to complex input 1
*      psa_Y: pointer to complex input 2
*      ft_conj_Y: apply conjugate on Y if 1
*      s_shift: scalar shift to be applied to result
*
*   Output Arguments:
*      pla_Z: pointer to complex output
*
*   Returns:
*
*   Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ComplexMult(int32 *pla_Z, int16 *psa_X, int16 *psa_Y, FlagT ft_conj_Y, int16 s_shift)
{
   int16 s_x_r, s_x_i, s_y_r, s_y_i;
   int32 l_z_r, l_z_i;

   s_x_r = psa_X[0];
   s_x_i = psa_X[1];
   s_y_r = psa_Y[0];
   s_y_i = psa_Y[1];

   if (ft_conj_Y)
   {
      s_y_i = -s_y_i;
   }

   l_z_r = (int32)s_x_r * (int32)s_y_r;
   l_z_r -= (int32)s_x_i * (int32)s_y_i;

   l_z_i = (int32)s_x_i * (int32)s_y_r;
   l_z_i += (int32)s_x_r * (int32)s_y_i;

   // round & shift
   pla_Z[0] = round(l_z_r, s_shift);
   pla_Z[1] = round(l_z_i, s_shift);
}
