/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   LeaveStatesTrail.c
*
*   This file contains the functions for capturing the EOC trail.
*
*-------------------------------------------------------------------------
*/

#ifdef DEBUG_TRAIL

#include "common.h"
#include "gdata.h"
#include "LeaveStatesTrail.h"
#include "PrintTrail.h"
#include "profile.h"


/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveEOCOvhdMsgTrail(uint16 us_Marker, uint8 uc_Octet)
*
*   Description:
*
*   Arguments:
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveEOCOvhdMsgTrail(uint16 us_Marker, uint8 uc_Octet)
{
   static int32 l_prev_symCnt=-2;
   static uint16 us_prev_marker=0;

   if (!(gt_debugTrailControl.s_ShowtimeEventControl & DEBUG_TRAIL_SHOW_EVENTS_EOC_HEADER_ENABLE))
   {
      if (uc_Octet != HDLC_FLAG)
      {
         // Put a marker when the non-hdlc octest are not in consecutive symbols
         // OR if previous marker is different from current marker
         if (gl_TxSymbolCount > (l_prev_symCnt+1) ||
               us_prev_marker != us_Marker)
         {
            // Add Marker
            DebugTrail1(2, DEBUG_TRAIL_EOC_ENABLE, 0x0000,
                        us_Marker,
                        (int16)(gl_TxSymbolCount & 0xFFFF));
         }

         DebugTrail1(1, DEBUG_TRAIL_EOC_ENABLE, 0x0000, uc_Octet);

         l_prev_symCnt = gl_TxSymbolCount;
         us_prev_marker = us_Marker;
      }
   }
}
#else // DEBUG_TRAIL
/*Suppress compiler warning:
*"A program must contain at least one external-declaration (X3.159-1989 p.82,L3)"
*by adding a dummy function declaration
*/
void DummyFunctionLeaveGhsTrail( void )
{
}

#endif //DEBUG_TRAIL
