/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   LeaveStatesTrail.c
*
*   This file contains the functions used to generate the GHS trail.
*
*-------------------------------------------------------------------------
*/


#ifdef DEBUG_TRAIL

#include "common.h"
#include "gdata.h"
#include "LeaveStatesTrail.h"
#include "PrintTrail.h"
#include "profile.h"


/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveGhsStatesTrail(int16 s_State, int16 s_NextState, int16 s_SymbolCount, int16 s_TxRxId, uint8 uc_MsgType);
*
*   This function, at Handshake Message Echange state transitions, write
*   out current state and next state.
*
*   Input Arguments:
*      s_State         -- current state
*      s_NextState      -- current next state
*       s_SymbolCount   -- no of symbols in this state
*      s_TxRxId      -- indicate if this message is for TX or RX
*      uc_MsgTpye      -- message type
*
*   Output Arguments: none
*
*   Global Variables:
*      gs_GhsStateTrailEnableFlag  -- (I) flag to control if the state trail should be saved or not
*      gsa_StatesTrail[] -- (O) state trail buffer
*      gsa_StatesTrailIndex -- (I/O) index of current location in state trail to save next datum
*-------------------------------------------------------------------
*^^^
*/
void LeaveGhsStatesTrail(int16 s_State, int16 s_NextState, int16 s_SymbolCnt, uint8 uc_TxRxId, uint8 uc_MsgType)
{
   DebugTrail1(4,DEBUG_TRAIL_STATES_ENABLE,0x0000,
               (int16)0xDDDD,
               ((s_NextState&0xFF)<<8) | (s_State&0xFF),
               s_SymbolCnt,
               (uc_TxRxId<<8) | (uc_MsgType));



}
#else // DEBUG_TRAIL
/*Suppress compiler warning:
*"A program must contain at least one external-declaration (X3.159-1989 p.82,L3)"
*by adding a dummy function declaration
*/
void DummyFunctionLeaveGhsTrail( void )
{
}
#endif // DEBUG_TRAIL
