/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   LeaveSocTrail.c
*
*   This file contains the minimum required functions for maintaining
*   the Tx and Rx SOC messages during VDSL training.
*
*-------------------------------------------------------------------------
*/

#ifdef DEBUG_TRAIL

#include "common.h"
#include "gdata.h"
#include "LeaveStatesTrail.h"
#include "PrintTrail.h"
#include "profile.h"


/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveRxSOCTrail(uint8 uc_RxMsgCode, int16 s_RxMsgErrorCode, int16 s_MsgReceiveFlag);
*
*   Description:
*      This function, on reception of a Rx SOC message, logs information into
*      the gsa_StatesTrail buffer.
*
*   Arguments:
*      uc_RxMsgCode         -- Receive message code, e.g. SOC_MSG_R_ACK
*      s_RxMsgErrorCode      -- Error code for received message (0 if message OK)
*      s_MsgReceiveFlag      -- Set to true if the message is received correctly and expected.
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
extern int16 gs_dbgLogSocMsg;
extern int16 gs_dbgLogSocMsgPause;      //used to pause logging during AutoRepeat messages

void LeaveRxSOCTrail(uint8 uc_RxMsgCode, int16 s_RxMsgErrorCode, int16 s_MsgReceiveFlag)
{

   if (gs_dbgLogSocMsg < STATES_TRAIL_LENGTH-3)
   {
      //and insert delimeter
      gsa_StatesTrail[gs_dbgLogSocMsg++] = (int16)0xEEEE;
   }

   DebugTrail1(5,DEBUG_TRAIL_STATES_ENABLE,0x0000,
               (int16)0xFF00,
               (int16)uc_RxMsgCode,
               s_RxMsgErrorCode,
               s_MsgReceiveFlag,
               (int16)gl_RxSymbolCount);

}

/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveTxSOCTrail(uint8 uc_TxMsgCode);
*
*   Description:
*      This function, on transmission of Tx SOC message, logs information into
*      the gsa_StatesTrail buffer.
*
*   Arguments:
*      uc_TxMsgCode         -- Transmit message code, e.g. SOC_MSG_R_ACK
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveTxSOCTrail(uint8 uc_TxMsgCode)
{
   static int8 uc_PrevTxMsgCode = -1;

   if ((uc_TxMsgCode != uc_PrevTxMsgCode) &&
         (gs_dbgLogSocMsg < STATES_TRAIL_LENGTH-3))
   {
      //re-enable tx HDLC byte logging for repeated messages
      gs_dbgLogSocMsgPause = 0;

      //and insert delimeter
      gsa_StatesTrail[gs_dbgLogSocMsg++] = (int16)0xFFFF;
   }
   else
   {
      //pause tx HDLC byte logging for repeated messages
      gs_dbgLogSocMsgPause = 1;
   }

   // If the message code has changed, then log
   // Tx SOC message info into the States Trail.
   // Qualification of PrevTxMsgCode prevents
   // the Auto Repeat messages from filling buffer.
   if (uc_TxMsgCode != uc_PrevTxMsgCode)
   {
      DebugTrail1(3,DEBUG_TRAIL_STATES_ENABLE,0x0000,
                  (int16)0xFF01,
                  (int16)uc_TxMsgCode,
                  (int16)gl_TxSymbolCount);
   }

   uc_PrevTxMsgCode = uc_TxMsgCode;


}


/*^^^
*-------------------------------------------------------------------
*   Prototype:
*   void LeaveHDLCOctetTrail(uint16 us_logType, uint8 uc_Octet1, uint8 uc_Octet2, int16 s_NumOctets)
*
*   Description:
*
*   Arguments:
*
*   Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void LeaveHDLCOctetTrail(uint16 us_logType, uint8 uc_Octet1, uint8 uc_Octet2, int16 s_NumOctets)
{
   static int32 l_prev_symCnt=-2;
   static uint16 us_prev_marker=0;
   uint16 us_Marker=0;

   if (gt_debugTrailControl.ft_RxStateTrigger)
   {
      if (gt_debugTrailControl.s_logType[0] & us_logType)
      {
         if ((uc_Octet1 != HDLC_FLAG) || (s_NumOctets == 2 && uc_Octet2 != HDLC_FLAG))
         {
            if (s_NumOctets == 1)
            {
               uc_Octet2 = 0;
            }

            if (us_logType == DEBUG_TRAIL_TXHDLC_ENABLE)
            {
               us_Marker = 0xABBA;
            }
            else if (us_logType == DEBUG_TRAIL_RXHDLC_ENABLE)
            {
               us_Marker = 0xBAAB;
            }

            // Put a marker when the non-hdlc octest are not in consecutive symbols
            // OR if previous marker is different from current marker
            if ((gl_TotalTxSymbolCount-gl_DiscoveryPhaseSymCnt_start) != (l_prev_symCnt+1) ||
                  us_prev_marker != us_Marker)
            {
               // Add Marker
               DebugTrail1(2, us_logType, 0x0000,
                           us_Marker,
                           (int16)((gl_TotalTxSymbolCount-gl_DiscoveryPhaseSymCnt_start) & 0xFFFF));
            }

            DebugTrail1(1, us_logType, 0x0000,
                        ((uint16)uc_Octet2 << 8) | uc_Octet1);

            l_prev_symCnt = (gl_TotalTxSymbolCount-gl_DiscoveryPhaseSymCnt_start);
            us_prev_marker = us_Marker;
         }
      }
   }
}
#else //DEBUG_TRAIL
/*Suppress compiler warning:
*"A program must contain at least one external-declaration (X3.159-1989 p.82,L3)"
*by adding a dummy function declaration
*/
void DummyFunctionLeaveSocTrail( void )
{
}
#endif //DEBUG_TRAIL
